/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.env;

import com.caucho.quercus.Location;
import com.caucho.quercus.QuercusException;
import com.caucho.quercus.QuercusRuntimeException;
import com.caucho.quercus.env.ArrayValue;
import com.caucho.quercus.env.ArrayValueImpl;
import com.caucho.quercus.env.BinaryBuilderValue;
import com.caucho.quercus.env.BooleanValue;
import com.caucho.quercus.env.CompiledObjectValue;
import com.caucho.quercus.env.DoubleValue;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.LongValue;
import com.caucho.quercus.env.MethodMap;
import com.caucho.quercus.env.NullValue;
import com.caucho.quercus.env.NumberValue;
import com.caucho.quercus.env.ObjectValue;
import com.caucho.quercus.env.QuercusLanguageException;
import com.caucho.quercus.env.ResourceValue;
import com.caucho.quercus.env.StringBuilderValue;
import com.caucho.quercus.env.StringInputStream;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.env.UnicodeBuilderValue;
import com.caucho.quercus.env.UnsetValue;
import com.caucho.quercus.env.ValueType;
import com.caucho.quercus.env.Var;
import com.caucho.quercus.expr.Expr;
import com.caucho.quercus.program.AbstractFunction;
import com.caucho.util.L10N;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Value
implements Serializable {
    protected static final L10N L = new L10N(Value.class);
    public static final StringValue SCALAR_V = new StringBuilderValue("scalar");
    public static final Value[] NULL_VALUE_ARRAY = new Value[0];
    public static final Value[] NULL_ARGS = new Value[0];

    public String getClassName() {
        return this.getType();
    }

    public boolean isA(String name) {
        return false;
    }

    public ValueType getValueType() {
        return ValueType.VALUE;
    }

    public boolean isArray() {
        return false;
    }

    public boolean isDoubleConvertible() {
        return false;
    }

    public boolean isLongConvertible() {
        return false;
    }

    public boolean isNull() {
        return false;
    }

    public boolean isNumberConvertible() {
        return this.isLongConvertible() || this.isDoubleConvertible();
    }

    public boolean isNumeric() {
        return false;
    }

    public boolean isObject() {
        return false;
    }

    public boolean isset() {
        return true;
    }

    public boolean isString() {
        return false;
    }

    public boolean isBinary() {
        return false;
    }

    public boolean isUnicode() {
        return false;
    }

    public boolean isBoolean() {
        return false;
    }

    public boolean isDefault() {
        return false;
    }

    public boolean hasCurrent() {
        return false;
    }

    public Value eqValue(Value rValue) {
        return this.eq(rValue) ? BooleanValue.TRUE : BooleanValue.FALSE;
    }

    public boolean eq(Value rValue) {
        if (rValue instanceof BooleanValue) {
            return this.toBoolean() == rValue.toBoolean();
        }
        if (this.isLongConvertible() && rValue.isLongConvertible()) {
            return this.toLong() == rValue.toLong();
        }
        if (this.isNumberConvertible() || rValue.isNumberConvertible()) {
            return this.toDouble() == rValue.toDouble();
        }
        return this.toString().equals(rValue.toString());
    }

    public boolean eql(Value rValue) {
        return this == rValue.toValue();
    }

    public int cmp(Value rValue) {
        Value lVal = this.toValue();
        Value rVal = rValue.toValue();
        if (lVal instanceof StringValue && rVal instanceof NullValue) {
            return ((StringValue)lVal).cmpString(StringValue.EMPTY);
        }
        if (lVal instanceof NullValue && rVal instanceof StringValue) {
            return StringValue.EMPTY.cmpString((StringValue)rVal);
        }
        if (lVal instanceof StringValue && rVal instanceof StringValue) {
            return ((StringValue)lVal).cmpString((StringValue)rVal);
        }
        if (lVal instanceof NullValue || lVal instanceof BooleanValue || rVal instanceof NullValue || rVal instanceof BooleanValue) {
            boolean lBool = this.toBoolean();
            boolean rBool = rValue.toBoolean();
            if (!lBool && rBool) {
                return -1;
            }
            if (lBool && !rBool) {
                return 1;
            }
            return 0;
        }
        if (lVal.isObject() && rVal.isObject()) {
            return ((ObjectValue)lVal).cmpObject((ObjectValue)rVal);
        }
        if ((lVal instanceof StringValue || lVal instanceof NumberValue || lVal instanceof ResourceValue) && (rVal instanceof StringValue || rVal instanceof NumberValue || rVal instanceof ResourceValue)) {
            return NumberValue.compareNum(lVal, rVal);
        }
        if (lVal instanceof ArrayValue) {
            return 1;
        }
        if (rVal instanceof ArrayValue) {
            return -1;
        }
        if (lVal instanceof ObjectValue) {
            return 1;
        }
        if (rVal instanceof ObjectValue) {
            return -1;
        }
        throw new RuntimeException("values are incomparable: " + lVal + " <=> " + rVal);
    }

    public boolean lt(Value rValue) {
        return this.cmp(rValue) < 0;
    }

    public boolean leq(Value rValue) {
        return this.cmp(rValue) <= 0;
    }

    public boolean gt(Value rValue) {
        return this.cmp(rValue) > 0;
    }

    public boolean geq(Value rValue) {
        return this.cmp(rValue) >= 0;
    }

    public boolean toBoolean() {
        return true;
    }

    public long toLong() {
        return this.toBoolean() ? 1L : 0L;
    }

    public int toInt() {
        return (int)this.toLong();
    }

    public double toDouble() {
        return 0.0;
    }

    public char toChar() {
        String s = this.toString();
        if (s == null || s.length() < 1) {
            return '\u0000';
        }
        return s.charAt(0);
    }

    public StringValue toString(Env env) {
        return this.toStringValue();
    }

    public Value toArray() {
        return new ArrayValueImpl().append(this);
    }

    public Value toAutoArray() {
        return this;
    }

    public ArrayValue toArrayValue(Env env) {
        env.warning(L.l("'{0}' ({1}) is not assignable to ArrayValue", (Object)this, (Object)this.getType()));
        return null;
    }

    public Value toAutoObject(Env env) {
        return this;
    }

    public Value toObject(Env env) {
        ObjectValue obj = env.createObject();
        obj.putField(env, "scalar", this);
        return obj;
    }

    public CompiledObjectValue toObjectValue() {
        return null;
    }

    public Object toJavaObject() {
        return null;
    }

    public Object toJavaObject(Env env, Class type) {
        env.warning(L.l("Can't convert {0} to Java {1}", (Object)this.getClass().getName(), (Object)type.getName()));
        return null;
    }

    public Object toJavaObjectNotNull(Env env, Class type) {
        env.warning(L.l("Can't convert {0} to Java {1}", (Object)this.getClass().getName(), (Object)type.getName()));
        return null;
    }

    public Boolean toJavaBoolean() {
        return this.toBoolean() ? Boolean.TRUE : Boolean.FALSE;
    }

    public Byte toJavaByte() {
        return new Byte((byte)this.toLong());
    }

    public Short toJavaShort() {
        return new Short((short)this.toLong());
    }

    public Integer toJavaInteger() {
        return new Integer((int)this.toLong());
    }

    public Long toJavaLong() {
        return new Long((int)this.toLong());
    }

    public Float toJavaFloat() {
        return new Float((float)this.toDouble());
    }

    public Double toJavaDouble() {
        return new Double(this.toDouble());
    }

    public Character toJavaCharacter() {
        return new Character(this.toChar());
    }

    public String toJavaString() {
        return this.toString();
    }

    public Collection toJavaCollection(Env env, Class type) {
        env.warning(L.l("Can't convert {0} to Java {1}", (Object)this.getClass().getName(), (Object)type.getName()));
        return null;
    }

    public List toJavaList(Env env, Class type) {
        env.warning(L.l("Can't convert {0} to Java {1}", (Object)this.getClass().getName(), (Object)type.getName()));
        return null;
    }

    public Map toJavaMap(Env env, Class type) {
        env.warning(L.l("Can't convert {0} to Java {1}", (Object)this.getClass().getName(), (Object)type.getName()));
        return null;
    }

    public Calendar toJavaCalendar() {
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(this.toLong());
        return cal;
    }

    public Date toJavaDate() {
        return new Date(this.toLong());
    }

    public URL toJavaURL(Env env) {
        try {
            return new URL(this.toString());
        }
        catch (MalformedURLException e) {
            env.warning(L.l(e.getMessage()));
            return null;
        }
    }

    public QuercusException toException(Env env, String file, int line) {
        this.putField(env, "file", env.createString(file));
        this.putField(env, "line", LongValue.create(line));
        return new QuercusLanguageException(this);
    }

    public Value toValue() {
        return this;
    }

    public Value toKey() {
        throw new QuercusRuntimeException(L.l("{0} is not a valid key", (Object)this));
    }

    public Value toRef() {
        return this;
    }

    public Value toArgValueReadOnly() {
        return this;
    }

    public Value toArgValue() {
        return this;
    }

    public Value toRefValue() {
        return this;
    }

    public Var toVar() {
        return new Var(this.toArgValue());
    }

    public Var toRefVar() {
        return new Var(this);
    }

    public StringValue toStringValue() {
        return Env.getInstance().createString(this.toString());
    }

    public StringValue toUnicodeValue() {
        return this.toUnicodeValue(Env.getInstance());
    }

    public StringValue toUnicodeValue(Env env) {
        return env.createString(this.toString());
    }

    public StringValue toBinaryValue() {
        return this.toUnicodeValue(Env.getInstance());
    }

    public StringValue toBinaryValue(Env env) {
        StringValue bb = env.createBinaryBuilder();
        bb.append(this);
        return bb;
    }

    public InputStream toInputStream() {
        return new StringInputStream(this.toString());
    }

    public StringValue toStringBuilder() {
        return new UnicodeBuilderValue(this.toString(), 32);
    }

    public StringValue toStringBuilder(Env env) {
        return env.createUnicodeBuilder().appendUnicode(this);
    }

    public LongValue toLongValue() {
        return new LongValue(this.toLong());
    }

    public DoubleValue toDoubleValue() {
        return new DoubleValue(this.toDouble());
    }

    public StringValue appendTo(UnicodeBuilderValue sb) {
        return sb.append(this.toString());
    }

    public StringValue appendTo(StringBuilderValue sb) {
        return sb.append(this.toString());
    }

    public StringValue appendTo(BinaryBuilderValue sb) {
        return sb.appendBytes(this.toString());
    }

    public Value copy() {
        return this;
    }

    public Value copyArrayItem() {
        return this.copy();
    }

    public Value copyReturn() {
        return this;
    }

    public final Value copy(Env env) {
        return this.copy(env, new IdentityHashMap<Value, Value>());
    }

    public Value copy(Env env, IdentityHashMap<Value, Value> map) {
        return this;
    }

    public Value clone() {
        return this;
    }

    public String getType() {
        return "value";
    }

    public Value key() {
        return NullValue.NULL;
    }

    public Value current() {
        return NullValue.NULL;
    }

    public Value next() {
        return BooleanValue.FALSE;
    }

    public AbstractFunction findFunction(String methodName) {
        return null;
    }

    public Value callMethod(Env env, int hash, char[] name, int nameLen, Expr[] args) {
        Value[] value = new Value[args.length];
        for (int i = 0; i < args.length; ++i) {
            value[i] = args[i].eval(env);
        }
        return this.callMethod(env, hash, name, nameLen, value);
    }

    public Value callMethod(Env env, int hash, char[] name, int nameLen, Value[] args) {
        switch (args.length) {
            case 0: {
                return this.callMethod(env, hash, name, nameLen);
            }
            case 1: {
                return this.callMethod(env, hash, name, nameLen, args[0]);
            }
            case 2: {
                return this.callMethod(env, hash, name, nameLen, args[0], args[1]);
            }
            case 3: {
                return this.callMethod(env, hash, name, nameLen, args[0], args[1], args[2]);
            }
            case 4: {
                return this.callMethod(env, hash, name, nameLen, args[0], args[1], args[2], args[3]);
            }
            case 5: {
                return this.callMethod(env, hash, name, nameLen, args[0], args[1], args[2], args[3], args[4]);
            }
        }
        return this.errorNoMethod(env, name, nameLen);
    }

    public Value callMethod(Env env, int hash, char[] name, int nameLen) {
        return this.errorNoMethod(env, name, nameLen);
    }

    public Value callMethod(Env env, int hash, char[] name, int nameLen, Value a0) {
        return this.errorNoMethod(env, name, nameLen);
    }

    public Value callMethod(Env env, int hash, char[] name, int nameLen, Value a0, Value a1) {
        return this.errorNoMethod(env, name, nameLen);
    }

    public Value callMethod(Env env, int hash, char[] name, int nameLen, Value a0, Value a1, Value a2) {
        return this.errorNoMethod(env, name, nameLen);
    }

    public Value callMethod(Env env, int hash, char[] name, int nameLen, Value a0, Value a1, Value a2, Value a3) {
        return this.errorNoMethod(env, name, nameLen);
    }

    public Value callMethod(Env env, int hash, char[] name, int nameLen, Value a0, Value a1, Value a2, Value a3, Value a5) {
        return this.errorNoMethod(env, name, nameLen);
    }

    public Value callMethodRef(Env env, int hash, char[] name, int nameLen, Expr[] args) {
        Value[] value = new Value[args.length];
        for (int i = 0; i < args.length; ++i) {
            value[i] = args[i].eval(env);
        }
        return this.callMethodRef(env, hash, name, nameLen, value);
    }

    public Value callMethodRef(Env env, int hash, char[] name, int nameLen, Value[] args) {
        switch (args.length) {
            case 0: {
                return this.callMethodRef(env, hash, name, nameLen);
            }
            case 1: {
                return this.callMethodRef(env, hash, name, nameLen, args[0]);
            }
            case 2: {
                return this.callMethodRef(env, hash, name, nameLen, args[0], args[1]);
            }
            case 3: {
                return this.callMethodRef(env, hash, name, nameLen, args[0], args[1], args[2]);
            }
            case 4: {
                return this.callMethodRef(env, hash, name, nameLen, args[0], args[1], args[2], args[3]);
            }
            case 5: {
                return this.callMethodRef(env, hash, name, nameLen, args[0], args[1], args[2], args[3], args[4]);
            }
        }
        return this.errorNoMethod(env, name, nameLen);
    }

    public Value callMethodRef(Env env, int hash, char[] name, int nameLen) {
        return this.errorNoMethod(env, name, nameLen);
    }

    public Value callMethodRef(Env env, int hash, char[] name, int nameLen, Value a0) {
        return this.errorNoMethod(env, name, nameLen);
    }

    public Value callMethodRef(Env env, int hash, char[] name, int nameLen, Value a0, Value a1) {
        return this.errorNoMethod(env, name, nameLen);
    }

    public Value callMethodRef(Env env, int hash, char[] name, int nameLen, Value a0, Value a1, Value a2) {
        return this.errorNoMethod(env, name, nameLen);
    }

    public Value callMethodRef(Env env, int hash, char[] name, int nameLen, Value a0, Value a1, Value a2, Value a3) {
        return this.errorNoMethod(env, name, nameLen);
    }

    public Value callMethodRef(Env env, int hash, char[] name, int nameLen, Value a0, Value a1, Value a2, Value a3, Value a5) {
        return this.errorNoMethod(env, name, nameLen);
    }

    public Value callMethod(Env env, StringValue nameValue, Expr[] args) {
        Value[] value = new Value[args.length];
        for (int i = 0; i < args.length; ++i) {
            value[i] = args[i].eval(env);
        }
        char[] name = nameValue.getRawCharArray();
        int nameLen = nameValue.length();
        int hash = MethodMap.hash(name, nameLen);
        return this.callMethod(env, hash, name, nameLen, value);
    }

    public Value callMethod(Env env, StringValue nameValue, Value[] args) {
        char[] name = nameValue.getRawCharArray();
        int nameLen = nameValue.length();
        int hash = MethodMap.hash(name, nameLen);
        switch (args.length) {
            case 0: {
                return this.callMethod(env, hash, name, nameLen);
            }
            case 1: {
                return this.callMethod(env, hash, name, nameLen, args[0]);
            }
            case 2: {
                return this.callMethod(env, hash, name, nameLen, args[0], args[1]);
            }
            case 3: {
                return this.callMethod(env, hash, name, nameLen, args[0], args[1], args[2]);
            }
            case 4: {
                return this.callMethod(env, hash, name, nameLen, args[0], args[1], args[2], args[3]);
            }
            case 5: {
                return this.callMethod(env, hash, name, nameLen, args[0], args[1], args[2], args[3], args[4]);
            }
        }
        return this.errorNoMethod(env, name, nameLen);
    }

    public Value callMethod(Env env, StringValue nameValue) {
        char[] name = nameValue.getRawCharArray();
        int nameLen = nameValue.length();
        int hash = MethodMap.hash(name, nameLen);
        return this.callMethod(env, hash, name, nameLen);
    }

    public Value callMethod(Env env, StringValue nameValue, Value a0) {
        char[] name = nameValue.getRawCharArray();
        int nameLen = nameValue.length();
        int hash = MethodMap.hash(name, nameLen);
        return this.callMethod(env, hash, name, nameLen, a0);
    }

    public Value callMethod(Env env, StringValue nameValue, Value a0, Value a1) {
        char[] name = nameValue.getRawCharArray();
        int nameLen = nameValue.length();
        int hash = MethodMap.hash(name, nameLen);
        return this.callMethod(env, hash, name, nameLen, a0, a1);
    }

    public Value callMethod(Env env, StringValue nameValue, Value a0, Value a1, Value a2) {
        char[] name = nameValue.getRawCharArray();
        int nameLen = nameValue.length();
        int hash = MethodMap.hash(name, nameLen);
        return this.callMethod(env, hash, name, nameLen, a0, a1, a2);
    }

    public Value callMethod(Env env, StringValue nameValue, Value a0, Value a1, Value a2, Value a3) {
        char[] name = nameValue.getRawCharArray();
        int nameLen = nameValue.length();
        int hash = MethodMap.hash(name, nameLen);
        return this.callMethod(env, hash, name, nameLen, a0, a1, a2, a3);
    }

    public Value callMethod(Env env, StringValue nameValue, Value a0, Value a1, Value a2, Value a3, Value a4) {
        char[] name = nameValue.getRawCharArray();
        int nameLen = nameValue.length();
        int hash = MethodMap.hash(name, nameLen);
        return this.callMethod(env, hash, name, nameLen, a0, a1, a2, a3, a4);
    }

    public Value callMethodRef(Env env, StringValue nameValue, Expr[] args) {
        Value[] value = new Value[args.length];
        for (int i = 0; i < args.length; ++i) {
            value[i] = args[i].eval(env);
        }
        char[] name = nameValue.getRawCharArray();
        int nameLen = nameValue.length();
        int hash = MethodMap.hash(name, nameLen);
        return this.callMethodRef(env, hash, name, nameLen, value);
    }

    public Value callMethodRef(Env env, StringValue nameValue, Value[] args) {
        char[] name = nameValue.getRawCharArray();
        int nameLen = nameValue.length();
        int hash = MethodMap.hash(name, nameLen);
        switch (args.length) {
            case 0: {
                return this.callMethodRef(env, hash, name, nameLen);
            }
            case 1: {
                return this.callMethodRef(env, hash, name, nameLen, args[0]);
            }
            case 2: {
                return this.callMethodRef(env, hash, name, nameLen, args[0], args[1]);
            }
            case 3: {
                return this.callMethodRef(env, hash, name, nameLen, args[0], args[1], args[2]);
            }
            case 4: {
                return this.callMethodRef(env, hash, name, nameLen, args[0], args[1], args[2], args[3]);
            }
            case 5: {
                return this.callMethodRef(env, hash, name, nameLen, args[0], args[1], args[2], args[3], args[4]);
            }
        }
        return this.errorNoMethod(env, name, nameLen);
    }

    public Value callMethodRef(Env env, StringValue nameValue) {
        char[] name = nameValue.getRawCharArray();
        int nameLen = nameValue.length();
        int hash = MethodMap.hash(name, nameLen);
        return this.callMethodRef(env, hash, name, nameLen);
    }

    public Value callMethodRef(Env env, StringValue nameValue, Value a0) {
        char[] name = nameValue.getRawCharArray();
        int nameLen = nameValue.length();
        int hash = MethodMap.hash(name, nameLen);
        return this.callMethodRef(env, hash, name, nameLen, a0);
    }

    public Value callMethodRef(Env env, StringValue nameValue, Value a0, Value a1) {
        char[] name = nameValue.getRawCharArray();
        int nameLen = nameValue.length();
        int hash = MethodMap.hash(name, nameLen);
        return this.callMethodRef(env, hash, name, nameLen, a0, a1);
    }

    public Value callMethodRef(Env env, StringValue nameValue, Value a0, Value a1, Value a2) {
        char[] name = nameValue.getRawCharArray();
        int nameLen = nameValue.length();
        int hash = MethodMap.hash(name, nameLen);
        return this.callMethodRef(env, hash, name, nameLen, a0, a1, a2);
    }

    public Value callMethodRef(Env env, StringValue nameValue, Value a0, Value a1, Value a2, Value a3) {
        char[] name = nameValue.getRawCharArray();
        int nameLen = nameValue.length();
        int hash = MethodMap.hash(name, nameLen);
        return this.callMethodRef(env, hash, name, nameLen, a0, a1, a2, a3);
    }

    public Value callMethodRef(Env env, StringValue nameValue, Value a0, Value a1, Value a2, Value a3, Value a4) {
        char[] name = nameValue.getRawCharArray();
        int nameLen = nameValue.length();
        int hash = MethodMap.hash(name, nameLen);
        return this.callMethodRef(env, hash, name, nameLen, a0, a1, a2, a3, a4);
    }

    public Value callClassMethod(Env env, AbstractFunction fun, Value[] args) {
        return NullValue.NULL;
    }

    private Value errorNoMethod(Env env, char[] name, int nameLen) {
        String methodName = new String(name, 0, nameLen);
        if (this.isNull()) {
            return env.error(L.l("Method call '{0}' is not allowed for a null value.", (Object)methodName));
        }
        return env.error(L.l("'{0}' is an unknown method of {1}.", (Object)methodName, (Object)this.toDebugString()));
    }

    public Value neg() {
        return new LongValue(-this.toLong());
    }

    public Value pos() {
        return new LongValue(this.toLong());
    }

    public Value add(Value rValue) {
        if (this.getValueType().isLongAdd() && rValue.getValueType().isLongAdd()) {
            return LongValue.create(this.toLong() + rValue.toLong());
        }
        return DoubleValue.create(this.toDouble() + rValue.toDouble());
    }

    public Value add(long lLong) {
        return new DoubleValue((double)lLong + this.toDouble());
    }

    public Value preincr(int incr) {
        long lValue = this.toLong();
        return new LongValue(lValue + (long)incr);
    }

    public Value postincr(int incr) {
        long lValue = this.toLong();
        return new LongValue(lValue + (long)incr);
    }

    public Value sub(Value rValue) {
        if (this.getValueType().isLongAdd() && rValue.getValueType().isLongAdd()) {
            return LongValue.create(this.toLong() - rValue.toLong());
        }
        return DoubleValue.create(this.toDouble() - rValue.toDouble());
    }

    public Value sub(long rLong) {
        return new DoubleValue(this.toDouble() - (double)rLong);
    }

    public Value sub_rev(long lLong) {
        if (this.getValueType().isLongAdd()) {
            return LongValue.create(lLong - this.toLong());
        }
        return new DoubleValue((double)lLong - this.toDouble());
    }

    public Value mul(Value rValue) {
        if (this.getValueType().isLongAdd() && rValue.getValueType().isLongAdd()) {
            return LongValue.create(this.toLong() * rValue.toLong());
        }
        return new DoubleValue(this.toDouble() * rValue.toDouble());
    }

    public Value mul(long r) {
        if (this.isDoubleConvertible()) {
            return new DoubleValue(this.toDouble() * (double)r);
        }
        return LongValue.create(this.toLong() * r);
    }

    public Value div(Value rValue) {
        if (this.getValueType().isLongAdd() && rValue.getValueType().isLongAdd()) {
            long r;
            long l = this.toLong();
            if (l % (r = rValue.toLong()) == 0L) {
                return LongValue.create(l / r);
            }
            return new DoubleValue(this.toDouble() / rValue.toDouble());
        }
        return new DoubleValue(this.toDouble() / rValue.toDouble());
    }

    public Value div(long r) {
        long l = this.toLong();
        if (l % r == 0L) {
            return LongValue.create(l / r);
        }
        return new DoubleValue(this.toDouble() / (double)r);
    }

    public Value mod(Value rValue) {
        double lDouble = this.toDouble();
        double rDouble = rValue.toDouble();
        return LongValue.create((double)((long)lDouble) % rDouble);
    }

    public Value lshift(Value rValue) {
        long lLong = this.toLong();
        long rLong = rValue.toLong();
        return new LongValue(lLong << (int)rLong);
    }

    public Value rshift(Value rValue) {
        long lLong = this.toLong();
        long rLong = rValue.toLong();
        return new LongValue(lLong >> (int)rLong);
    }

    public long nextIndex(long oldIndex) {
        return oldIndex;
    }

    public int length() {
        return this.toString().length();
    }

    public int getSize() {
        return 1;
    }

    public int getCount(Env env) {
        return 1;
    }

    public int getCountRecursive(Env env) {
        return this.getCount(env);
    }

    public Iterator<Map.Entry<Value, Value>> getIterator(Env env) {
        Set emptySet = Collections.emptySet();
        return emptySet.iterator();
    }

    public Iterator<Value> getKeyIterator(Env env) {
        final Iterator<Map.Entry<Value, Value>> iter = this.getIterator(env);
        return new Iterator<Value>(){

            @Override
            public boolean hasNext() {
                return iter.hasNext();
            }

            @Override
            public Value next() {
                return (Value)((Map.Entry)iter.next()).getKey();
            }

            @Override
            public void remove() {
                iter.remove();
            }
        };
    }

    public Value[] getKeyArray(Env env) {
        return NULL_VALUE_ARRAY;
    }

    public Value[] getValueArray(Env env) {
        return NULL_VALUE_ARRAY;
    }

    public Iterator<Value> getValueIterator(Env env) {
        final Iterator<Map.Entry<Value, Value>> iter = this.getIterator(env);
        return new Iterator<Value>(){

            @Override
            public boolean hasNext() {
                return iter.hasNext();
            }

            @Override
            public Value next() {
                return (Value)((Map.Entry)iter.next()).getValue();
            }

            @Override
            public void remove() {
                iter.remove();
            }
        };
    }

    public Value get(Value index) {
        return UnsetValue.UNSET;
    }

    public Value get(Env env, Location location, Value index) {
        return this.get(index);
    }

    public Value getRef(Value index) {
        return NullValue.NULL;
    }

    public Value getArg(Value index) {
        return NullValue.NULL;
    }

    public Value getDirty(Value index) {
        return NullValue.NULL;
    }

    public Value getArray() {
        return this;
    }

    public Value getArray(Value index) {
        return NullValue.NULL;
    }

    public final Value getField(Env env, String index) {
        return this.getField(env, index, false);
    }

    public Value getField(Env env, String index, boolean create) {
        return NullValue.NULL;
    }

    public Value getFieldRef(Env env, String index) {
        return this.getField(env, index);
    }

    public Value getFieldArg(Env env, String index) {
        return this.getFieldRef(env, index);
    }

    public Value getFieldArgRef(Env env, String index) {
        return this.getFieldRef(env, index);
    }

    public Value getFieldObject(Env env, String index) {
        Value v = this.getField(env, index);
        if (!v.isset()) {
            v = env.createObject();
            this.putField(env, index, v);
        }
        return v;
    }

    public Value getFieldArray(Env env, String index) {
        Value array;
        Value v = this.getField(env, index);
        if (v == (array = v.toAutoArray())) {
            return v;
        }
        this.putField(env, index, array);
        return array;
    }

    public Value putThisField(Env env, String index, Value object) {
        return NullValue.NULL;
    }

    public Value putField(Env env, String index, Value object) {
        return NullValue.NULL;
    }

    public void removeField(String index) {
    }

    public Value getObject(Env env) {
        return NullValue.NULL;
    }

    public Value getObject(Env env, Value index) {
        return NullValue.NULL;
    }

    public Value getObject(Env env, Location location, Value index) {
        return this.getObject(env, index);
    }

    public Value set(Value value) {
        return value;
    }

    public Value put(Value index, Value value) {
        return value;
    }

    public Value put(Env env, Location location, Value index, Value value) {
        return this.put(index, value);
    }

    public Value put(Value value) {
        return value;
    }

    public Value put(Env env, Location location, Value value) {
        return this.put(value);
    }

    public Value putRef() {
        return NullValue.NULL;
    }

    public Value putArray() {
        ArrayValueImpl value = new ArrayValueImpl();
        this.put(value);
        return value;
    }

    public Value putObject(Env env) {
        ObjectValue value = env.createObject();
        this.put(value);
        return value;
    }

    public Value remove(Value index) {
        return UnsetValue.UNSET;
    }

    public Object valuesToArray(Env env, Class elementType) {
        env.error(L.l("Can't assign {0} with type {1} to {2}[]", (Object)this, this.getClass(), (Object)elementType));
        return null;
    }

    public Value charValueAt(long index) {
        return NullValue.NULL;
    }

    public Value setCharValueAt(long index, String value) {
        return NullValue.NULL;
    }

    public void print(Env env) {
        env.print(this.toString(env));
    }

    public void serialize(StringBuilder sb) {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public void varExport(StringBuilder sb) {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public void generate(PrintWriter out) throws IOException {
    }

    protected void printJavaString(PrintWriter out, StringValue s) {
        if (s == null) {
            out.print("");
            return;
        }
        int len = s.length();
        block7: for (int i = 0; i < len; ++i) {
            char ch = s.charAt(i);
            switch (ch) {
                case '\r': {
                    out.print("\\r");
                    continue block7;
                }
                case '\n': {
                    out.print("\\n");
                    continue block7;
                }
                case '\"': {
                    out.print("\\\"");
                    continue block7;
                }
                case '\'': {
                    out.print("\\'");
                    continue block7;
                }
                case '\\': {
                    out.print("\\\\");
                    continue block7;
                }
                default: {
                    out.print(ch);
                }
            }
        }
    }

    public String toInternString() {
        return this.toString().intern();
    }

    public String toDebugString() {
        return this.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void varDump(Env env, WriteStream out, int depth, IdentityHashMap<Value, String> valueSet) throws IOException {
        if (valueSet.get(this) != null) {
            out.print("#recursion#");
            return;
        }
        valueSet.put(this, "printing");
        try {
            this.varDumpImpl(env, out, depth, valueSet);
        }
        finally {
            valueSet.remove(this);
        }
    }

    protected void varDumpImpl(Env env, WriteStream out, int depth, IdentityHashMap<Value, String> valueSet) throws IOException {
        out.print("resource(" + this.toString() + ")");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void printR(Env env, WriteStream out, int depth, IdentityHashMap<Value, String> valueSet) throws IOException {
        if (valueSet.get(this) != null) {
            out.print("#recursion#");
            return;
        }
        valueSet.put(this, "printing");
        try {
            this.printRImpl(env, out, depth, valueSet);
        }
        finally {
            valueSet.remove(this);
        }
    }

    protected void printRImpl(Env env, WriteStream out, int depth, IdentityHashMap<Value, String> valueSet) throws IOException {
        out.print(this.toString());
    }

    protected void printDepth(WriteStream out, int depth) throws IOException {
        for (int i = 0; i < depth; ++i) {
            out.print(' ');
        }
    }
}

