/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.expr;

import com.caucho.quercus.Location;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.NullValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.expr.AbstractVarExpr;
import com.caucho.quercus.expr.Expr;

public class ArrayGetExpr
extends AbstractVarExpr {
    protected final Expr _expr;
    protected final Expr _index;

    public ArrayGetExpr(Location location, Expr expr, Expr index) {
        super(location);
        this._expr = expr;
        this._index = index;
    }

    public ArrayGetExpr(Expr expr, Expr index) {
        this._expr = expr;
        this._index = index;
    }

    public Expr getExpr() {
        return this._expr;
    }

    public Expr getIndex() {
        return this._index;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Value eval(Env env) {
        try {
            Value array = this._expr.eval(env);
            if (array.isObject()) {
                env.pushCall(this, array);
            } else {
                env.pushCall(this, NullValue.NULL);
            }
            Value index = this._index.eval(env);
            Value value = array.get(env, this.getLocation(), index);
            return value;
        }
        finally {
            env.popCall();
        }
    }

    public Value evalCopy(Env env) {
        Value array = this._expr.eval(env);
        Value index = this._index.eval(env);
        return array.get(env, this.getLocation(), index).copy();
    }

    public Value evalArray(Env env) {
        Value array = this._expr.evalArray(env);
        Value index = this._index.eval(env);
        return array.getArray(index);
    }

    public Value evalDirty(Env env) {
        Value array = this._expr.eval(env);
        Value index = this._index.eval(env);
        return array.getDirty(index);
    }

    public Value evalObject(Env env) {
        Value array = this._expr.evalArray(env);
        Value index = this._index.eval(env);
        return array.getObject(env, this.getLocation(), index);
    }

    public Value evalArg(Env env) {
        Value value = this._expr.evalArg(env);
        return value.getArg(this._index.eval(env));
    }

    public Value evalRef(Env env) {
        Value value = this._expr.evalArray(env);
        return value.getRef(this._index.eval(env));
    }

    public void evalAssign(Env env, Value value) {
        Value array = this._expr.evalArray(env);
        Value index = this._index.eval(env);
        array.put(env, this.getLocation(), index, value);
    }

    public void evalUnset(Env env) {
        Value array = this._expr.evalDirty(env);
        Value index = this._index.eval(env);
        array.remove(index);
    }

    public String toString() {
        return this._expr + "[" + this._index + "]";
    }
}

