/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.expr;

import com.caucho.quercus.Location;
import com.caucho.quercus.env.ArrayValue;
import com.caucho.quercus.env.ArrayValueImpl;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.NullValue;
import com.caucho.quercus.env.ObjectValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.expr.AbstractVarExpr;
import com.caucho.quercus.expr.Expr;

public class ArrayTailExpr
extends AbstractVarExpr {
    protected final Expr _expr;

    public ArrayTailExpr(Location location, Expr expr) {
        super(location);
        this._expr = expr;
    }

    public ArrayTailExpr(Expr expr) {
        this._expr = expr;
    }

    public boolean canRead() {
        return false;
    }

    public Expr getExpr() {
        return this._expr;
    }

    public Value eval(Env env) {
        return env.error(this.getLocation(), "Cannot use [] as a read-value.");
    }

    public Value evalArg(Env env) {
        return this.evalRef(env);
    }

    public Value evalRef(Env env) {
        Value obj = this._expr.evalArray(env);
        if (obj instanceof ArrayValue) {
            ArrayValue array = (ArrayValue)obj;
            Value key = array.createTailKey();
            return array.getRef(key);
        }
        return NullValue.NULL;
    }

    public Value evalArray(Env env) {
        Value obj = this._expr.evalArray(env);
        ArrayValueImpl array = new ArrayValueImpl();
        obj.put(env, this.getLocation(), array);
        return array;
    }

    public Value evalObject(Env env) {
        Value array = this._expr.evalArray(env);
        ObjectValue value = env.createObject();
        array.put(env, this.getLocation(), value);
        return value;
    }

    public void evalAssign(Env env, Value value) {
        Value array = this._expr.evalArray(env);
        array.put(env, this.getLocation(), value);
    }

    public void evalUnset(Env env) {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        return this._expr + "[]";
    }
}

