/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.expr;

import com.caucho.quercus.Location;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.QuercusClass;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.expr.Expr;
import com.caucho.quercus.program.AbstractFunction;
import com.caucho.util.L10N;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassMethodExpr
extends Expr {
    private static final L10N L = new L10N(ClassMethodExpr.class);
    protected final String _className;
    protected final String _name;
    protected final Expr[] _args;
    protected boolean _isMethod;

    public ClassMethodExpr(Location location, String className, String name, ArrayList<Expr> args) {
        super(location);
        this._className = className.intern();
        this._name = name.intern();
        this._args = new Expr[args.size()];
        args.toArray(this._args);
    }

    public ClassMethodExpr(Location location, String className, String name, Expr[] args) {
        super(location);
        this._className = className.intern();
        this._name = name.intern();
        this._args = args;
    }

    public ClassMethodExpr(String className, String name, ArrayList<Expr> args) {
        this(Location.UNKNOWN, className, name, args);
    }

    public ClassMethodExpr(String className, String name, Expr[] args) {
        this(Location.UNKNOWN, className, name, args);
    }

    @Override
    public Value eval(Env env) {
        QuercusClass cl = env.findClass(this._className);
        if (cl == null) {
            throw env.createErrorException(L.l("{0} is an unknown class", (Object)this._className));
        }
        AbstractFunction fun = cl.findFunction(this._name);
        if (fun == null) {
            throw env.createErrorException(L.l("{0}::{1} is an unknown method", (Object)this._className, (Object)this._name));
        }
        Value[] values = new Value[this._args.length];
        for (int i = 0; i < values.length; ++i) {
            values[i] = this._args[i].eval(env);
        }
        return fun.callMethod(env, env.getThis(), values);
    }

    @Override
    public String toString() {
        return this._className + "::" + this._name + "()";
    }
}

