/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.expr;

import com.caucho.quercus.Location;
import com.caucho.quercus.env.BooleanValue;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.expr.Expr;

public final class CmpExpr
extends Expr {
    private final Expr _left;
    private final Expr _right;

    public CmpExpr(Location location, int code, Expr left, Expr right) {
        super(location);
        this._left = left;
        this._right = right;
    }

    public CmpExpr(int code, Expr left, Expr right) {
        this._left = left;
        this._right = right;
    }

    public Value eval(Env env) {
        return this.evalBoolean(env) ? BooleanValue.TRUE : BooleanValue.FALSE;
    }

    public boolean evalBoolean(Env env) {
        Value lValue = this._left.eval(env);
        Value rValue = this._right.eval(env);
        return lValue.toDouble() < rValue.toDouble();
    }

    public String toString() {
        return "(" + this._left + " + " + this._right + ")";
    }
}

