/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.expr;

import com.caucho.quercus.Location;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.expr.ExprFactory;
import com.caucho.quercus.parser.QuercusParser;
import com.caucho.quercus.program.Statement;
import com.caucho.util.L10N;
import java.io.IOException;
import java.util.logging.Logger;

public abstract class Expr {
    private static final L10N L = new L10N(Expr.class);
    private static final Logger log = Logger.getLogger(Expr.class.getName());
    public static final int COMPILE_ARG_MAX = 5;
    private final Location _location;

    public Expr(Location location) {
        this._location = location;
    }

    public Expr() {
        this._location = Location.UNKNOWN;
    }

    public final Location getLocation() {
        return this._location;
    }

    public String getFileName() {
        if (this._location != Location.UNKNOWN) {
            return this._location.getFileName();
        }
        return null;
    }

    public int getLine() {
        return this._location.getLineNumber();
    }

    public String getFunctionLocation() {
        return "";
    }

    public String getLocationLine() {
        if (this._location != Location.UNKNOWN) {
            return this._location.getFileName() + ":" + this.getLine() + ": ";
        }
        return "";
    }

    public boolean isRef() {
        return false;
    }

    public boolean isConstant() {
        return this.isLiteral();
    }

    public boolean isLiteral() {
        return false;
    }

    public boolean isTrue() {
        return false;
    }

    public boolean isFalse() {
        return false;
    }

    public boolean isAssign() {
        return false;
    }

    public boolean canRead() {
        return true;
    }

    public Expr createAssign(QuercusParser parser, Expr value) throws IOException {
        String msg = L.l("{0} is an invalid left-hand side of an assignment.", (Object)this);
        if (parser != null) {
            throw parser.error(msg);
        }
        throw new IOException(msg);
    }

    public void assign(QuercusParser parser) throws IOException {
        String msg = L.l("{0} is an invalid left-hand side of an assignment.", (Object)this);
        if (parser != null) {
            throw parser.error(msg);
        }
        throw new IOException(msg);
    }

    public Expr createAssignRef(QuercusParser parser, Expr value) throws IOException {
        String msg = L.l("{0} is an invalid left-hand side of an assignment.", (Object)this);
        if (parser != null) {
            throw parser.error(msg);
        }
        throw new IOException(msg);
    }

    public Expr createRef(QuercusParser parser) throws IOException {
        return this;
    }

    public Expr createDeref(ExprFactory factory) throws IOException {
        return this;
    }

    public Expr createCopy(ExprFactory factory) {
        return this;
    }

    public Expr createFieldGet(ExprFactory factory, Location location, String name) {
        return factory.createFieldGet(location, this, name);
    }

    public Expr createFieldGet(ExprFactory factory, Location location, Expr name) {
        return factory.createFieldVarGet(location, this, name);
    }

    public Statement createUnset(ExprFactory factory, Location location) throws IOException {
        throw new IOException(L.l("{0} is an illegal value to unset", (Object)this));
    }

    public Expr createIsset(ExprFactory factory) throws IOException {
        throw new IOException(L.l("{0} is an illegal value to isset", (Object)this));
    }

    public boolean isBoolean() {
        return false;
    }

    public boolean isLong() {
        return false;
    }

    public boolean isDouble() {
        return false;
    }

    public boolean isNumber() {
        return this.isLong() || this.isDouble();
    }

    public boolean isString() {
        return false;
    }

    public Value evalConstant() throws IOException {
        throw new IOException(L.l("{0} is not a constant expression", (Object)this));
    }

    public abstract Value eval(Env var1);

    public Value evalDirty(Env env) {
        return this.eval(env);
    }

    public Value evalArray(Env env) {
        return this.eval(env);
    }

    public Value evalObject(Env env) {
        return this.eval(env);
    }

    public Value evalRef(Env env) {
        return this.eval(env);
    }

    public Value evalCopy(Env env) {
        return this.eval(env);
    }

    public Value evalArg(Env env) {
        return this.eval(env);
    }

    public void evalAssign(Env env, Value value) {
        throw new RuntimeException(L.l("{0} is an invalid left-hand side of an assignment.", (Object)this));
    }

    public String evalString(Env env) {
        return this.eval(env).toString();
    }

    public char evalChar(Env env) {
        return this.eval(env).toChar();
    }

    public boolean evalBoolean(Env env) {
        return this.eval(env).toBoolean();
    }

    public long evalLong(Env env) {
        return this.eval(env).toLong();
    }

    public double evalDouble(Env env) {
        return this.eval(env).toDouble();
    }

    public void print(Env env) throws IOException {
        this.eval(env).print(env);
    }

    public String toString() {
        return "Expr[]";
    }
}

