/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.expr;

import com.caucho.quercus.Location;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.expr.AbstractVarExpr;
import com.caucho.quercus.expr.AddExpr;
import com.caucho.quercus.expr.AndExpr;
import com.caucho.quercus.expr.AppendExpr;
import com.caucho.quercus.expr.ArrayFunExpr;
import com.caucho.quercus.expr.ArrayGetExpr;
import com.caucho.quercus.expr.ArrayTailExpr;
import com.caucho.quercus.expr.AssignExpr;
import com.caucho.quercus.expr.AssignRefExpr;
import com.caucho.quercus.expr.BinaryLiteralExpr;
import com.caucho.quercus.expr.BitAndExpr;
import com.caucho.quercus.expr.BitNotExpr;
import com.caucho.quercus.expr.BitOrExpr;
import com.caucho.quercus.expr.BitXorExpr;
import com.caucho.quercus.expr.CharAtExpr;
import com.caucho.quercus.expr.ClassConstExpr;
import com.caucho.quercus.expr.ClassMethodExpr;
import com.caucho.quercus.expr.CloneExpr;
import com.caucho.quercus.expr.CommaExpr;
import com.caucho.quercus.expr.ConditionalExpr;
import com.caucho.quercus.expr.ConstExpr;
import com.caucho.quercus.expr.CopyExpr;
import com.caucho.quercus.expr.DefaultExpr;
import com.caucho.quercus.expr.DieExpr;
import com.caucho.quercus.expr.DivExpr;
import com.caucho.quercus.expr.EachExpr;
import com.caucho.quercus.expr.EqExpr;
import com.caucho.quercus.expr.EqualsExpr;
import com.caucho.quercus.expr.ExitExpr;
import com.caucho.quercus.expr.Expr;
import com.caucho.quercus.expr.FieldGetExpr;
import com.caucho.quercus.expr.FieldVarGetExpr;
import com.caucho.quercus.expr.FunctionExpr;
import com.caucho.quercus.expr.GeqExpr;
import com.caucho.quercus.expr.GtExpr;
import com.caucho.quercus.expr.ImportExpr;
import com.caucho.quercus.expr.IncludeExpr;
import com.caucho.quercus.expr.IncludeOnceExpr;
import com.caucho.quercus.expr.InstanceOfExpr;
import com.caucho.quercus.expr.InstanceOfVarExpr;
import com.caucho.quercus.expr.LeftShiftExpr;
import com.caucho.quercus.expr.LeqExpr;
import com.caucho.quercus.expr.ListEachExpr;
import com.caucho.quercus.expr.ListExpr;
import com.caucho.quercus.expr.ListHeadExpr;
import com.caucho.quercus.expr.LiteralExpr;
import com.caucho.quercus.expr.LongLiteralExpr;
import com.caucho.quercus.expr.LtExpr;
import com.caucho.quercus.expr.MethodCallExpr;
import com.caucho.quercus.expr.MinusExpr;
import com.caucho.quercus.expr.ModExpr;
import com.caucho.quercus.expr.MulExpr;
import com.caucho.quercus.expr.NeqExpr;
import com.caucho.quercus.expr.NewExpr;
import com.caucho.quercus.expr.NotExpr;
import com.caucho.quercus.expr.NullLiteralExpr;
import com.caucho.quercus.expr.OrExpr;
import com.caucho.quercus.expr.PlusExpr;
import com.caucho.quercus.expr.PostIncrementExpr;
import com.caucho.quercus.expr.PreIncrementExpr;
import com.caucho.quercus.expr.RefExpr;
import com.caucho.quercus.expr.RequiredExpr;
import com.caucho.quercus.expr.RightShiftExpr;
import com.caucho.quercus.expr.StaticFieldGetExpr;
import com.caucho.quercus.expr.StaticMethodExpr;
import com.caucho.quercus.expr.StringLiteralExpr;
import com.caucho.quercus.expr.SubExpr;
import com.caucho.quercus.expr.SuppressErrorExpr;
import com.caucho.quercus.expr.ThisExpr;
import com.caucho.quercus.expr.ToArrayExpr;
import com.caucho.quercus.expr.ToBinaryExpr;
import com.caucho.quercus.expr.ToBooleanExpr;
import com.caucho.quercus.expr.ToDoubleExpr;
import com.caucho.quercus.expr.ToLongExpr;
import com.caucho.quercus.expr.ToObjectExpr;
import com.caucho.quercus.expr.ToStringExpr;
import com.caucho.quercus.expr.ToUnicodeExpr;
import com.caucho.quercus.expr.UnicodeLiteralExpr;
import com.caucho.quercus.expr.UnsetVarExpr;
import com.caucho.quercus.expr.VarExpr;
import com.caucho.quercus.expr.VarFunctionExpr;
import com.caucho.quercus.expr.VarInfo;
import com.caucho.quercus.expr.VarMethodCallExpr;
import com.caucho.quercus.expr.VarNewExpr;
import com.caucho.quercus.expr.VarVarExpr;
import com.caucho.quercus.expr.XorExpr;
import com.caucho.quercus.parser.QuercusParser;
import com.caucho.quercus.program.Arg;
import com.caucho.quercus.program.BlockStatement;
import com.caucho.quercus.program.BreakStatement;
import com.caucho.quercus.program.ClassDefStatement;
import com.caucho.quercus.program.ContinueStatement;
import com.caucho.quercus.program.DoStatement;
import com.caucho.quercus.program.EchoStatement;
import com.caucho.quercus.program.ExprStatement;
import com.caucho.quercus.program.ForStatement;
import com.caucho.quercus.program.ForeachStatement;
import com.caucho.quercus.program.Function;
import com.caucho.quercus.program.FunctionDefStatement;
import com.caucho.quercus.program.FunctionInfo;
import com.caucho.quercus.program.GlobalStatement;
import com.caucho.quercus.program.IfStatement;
import com.caucho.quercus.program.InterpretedClassDef;
import com.caucho.quercus.program.MethodDeclaration;
import com.caucho.quercus.program.NullStatement;
import com.caucho.quercus.program.ObjectMethod;
import com.caucho.quercus.program.ReturnRefStatement;
import com.caucho.quercus.program.ReturnStatement;
import com.caucho.quercus.program.Statement;
import com.caucho.quercus.program.StaticStatement;
import com.caucho.quercus.program.SwitchStatement;
import com.caucho.quercus.program.TextStatement;
import com.caucho.quercus.program.ThrowStatement;
import com.caucho.quercus.program.TryStatement;
import com.caucho.quercus.program.VarGlobalStatement;
import com.caucho.quercus.program.WhileStatement;
import com.caucho.util.L10N;
import com.caucho.vfs.Path;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExprFactory {
    private static final L10N L = new L10N(ExprFactory.class);
    private static final Logger log = Logger.getLogger(ExprFactory.class.getName());

    public static ExprFactory create() {
        try {
            Class<?> cl = Class.forName("com.caucho.quercus.expr.ProExprFactory");
            return (ExprFactory)cl.newInstance();
        }
        catch (Exception e) {
            log.log(Level.FINEST, e.toString(), e);
            return new ExprFactory();
        }
    }

    public Expr createNull() {
        return NullLiteralExpr.NULL;
    }

    public Expr createString(String lexeme) {
        return new StringLiteralExpr(lexeme);
    }

    public Expr createUnicode(String lexeme) {
        return new UnicodeLiteralExpr(lexeme);
    }

    public Expr createBinary(byte[] bytes) {
        return new BinaryLiteralExpr(bytes);
    }

    public Expr createBinary(String bytes, String encoding) {
        return new BinaryLiteralExpr(bytes, encoding);
    }

    public Expr createLong(long value) {
        return new LongLiteralExpr(value);
    }

    public Expr createLiteral(Value literal) {
        return new LiteralExpr(literal);
    }

    public VarExpr createVar(VarInfo var) {
        return new VarExpr(var);
    }

    public VarVarExpr createVarVar(Expr var) {
        return new VarVarExpr(var);
    }

    public ConstExpr createConst(String name) {
        return new ConstExpr(name);
    }

    public ClassConstExpr createClassConst(String className, String name) {
        return new ClassConstExpr(className, name);
    }

    public ThisExpr createThis(Location location, InterpretedClassDef cl) {
        return new ThisExpr(location, cl);
    }

    public ArrayGetExpr createArrayGet(Location location, Expr base, Expr index) {
        return new ArrayGetExpr(location, base, index);
    }

    public ArrayTailExpr createArrayTail(Location location, Expr base) {
        return new ArrayTailExpr(location, base);
    }

    public Expr createFieldGet(Location location, Expr base, String name) {
        return new FieldGetExpr(location, base, name);
    }

    public Expr createFieldVarGet(Location location, Expr base, Expr name) {
        return new FieldVarGetExpr(location, base, name);
    }

    public Expr createStaticFieldGet(Location location, String className, String name) {
        return new StaticFieldGetExpr(location, className, name);
    }

    public Expr createUnsetVar(AbstractVarExpr var) {
        return new UnsetVarExpr(var);
    }

    public CharAtExpr createCharAt(Expr base, Expr index) {
        return new CharAtExpr(base, index);
    }

    public PostIncrementExpr createPostIncrement(Expr expr, int incr) {
        return new PostIncrementExpr(expr, incr);
    }

    public PreIncrementExpr createPreIncrement(Expr expr, int incr) {
        return new PreIncrementExpr(expr, incr);
    }

    public Expr createMinus(Expr expr) {
        return new MinusExpr(expr);
    }

    public Expr createPlus(Expr expr) {
        return new PlusExpr(expr);
    }

    public Expr createNot(Expr expr) {
        return new NotExpr(expr);
    }

    public Expr createBitNot(Expr expr) {
        return new BitNotExpr(expr);
    }

    public Expr createClone(Expr expr) {
        return new CloneExpr(expr);
    }

    public Expr createCopy(Expr expr) {
        return new CopyExpr(expr);
    }

    public Expr createSuppress(Expr expr) {
        return new SuppressErrorExpr(expr);
    }

    public Expr createToBoolean(Expr expr) {
        return new ToBooleanExpr(expr);
    }

    public Expr createToLong(Expr expr) {
        return new ToLongExpr(expr);
    }

    public Expr createToDouble(Expr expr) {
        return new ToDoubleExpr(expr);
    }

    public Expr createToString(Expr expr) {
        return new ToStringExpr(expr);
    }

    public Expr createToUnicode(Expr expr) {
        return new ToUnicodeExpr(expr);
    }

    public Expr createToBinary(Expr expr) {
        return new ToBinaryExpr(expr);
    }

    public Expr createToObject(Expr expr) {
        return new ToObjectExpr(expr);
    }

    public Expr createToArray(Expr expr) {
        return new ToArrayExpr(expr);
    }

    public Expr createDie(Expr expr) {
        return new DieExpr(expr);
    }

    public Expr createExit(Expr expr) {
        return new ExitExpr(expr);
    }

    public Expr createRequired() {
        return new RequiredExpr();
    }

    public Expr createDefault() {
        return new DefaultExpr();
    }

    public Expr createAdd(Expr left, Expr right) {
        return new AddExpr(left, right);
    }

    public Expr createSub(Expr left, Expr right) {
        return new SubExpr(left, right);
    }

    public Expr createMul(Expr left, Expr right) {
        return new MulExpr(left, right);
    }

    public Expr createDiv(Expr left, Expr right) {
        return new DivExpr(left, right);
    }

    public Expr createMod(Expr left, Expr right) {
        return new ModExpr(left, right);
    }

    public Expr createLeftShift(Expr left, Expr right) {
        return new LeftShiftExpr(left, right);
    }

    public Expr createRightShift(Expr left, Expr right) {
        return new RightShiftExpr(left, right);
    }

    public Expr createBitAnd(Expr left, Expr right) {
        return new BitAndExpr(left, right);
    }

    public Expr createBitOr(Expr left, Expr right) {
        return new BitOrExpr(left, right);
    }

    public Expr createBitXor(Expr left, Expr right) {
        return new BitXorExpr(left, right);
    }

    public final Expr createAppend(Expr left, Expr right) {
        AppendExpr next;
        AppendExpr leftAppend = left instanceof AppendExpr ? (AppendExpr)left : this.createAppendImpl(left, null);
        AppendExpr result = this.append(leftAppend, next = right instanceof AppendExpr ? (AppendExpr)right : this.createAppendImpl(right, null));
        if (result.getNext() != null) {
            return result;
        }
        return result.getValue();
    }

    private AppendExpr append(AppendExpr left, AppendExpr tail) {
        if (left == null) {
            return tail;
        }
        tail = this.append(left.getNext(), tail);
        if (left.getValue() instanceof BinaryLiteralExpr && tail.getValue() instanceof BinaryLiteralExpr) {
            BinaryLiteralExpr leftString = (BinaryLiteralExpr)left.getValue();
            BinaryLiteralExpr rightString = (BinaryLiteralExpr)tail.getValue();
            try {
                byte[] bytes = (leftString.evalConstant().toString() + rightString.evalConstant().toString()).getBytes("ISO-8859-1");
                Expr value = this.createBinary(bytes);
                return this.createAppendImpl(value, tail.getNext());
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (left.getValue() instanceof BinaryLiteralExpr || tail.getValue() instanceof BinaryLiteralExpr) {
            left.setNext(tail);
            return left;
        }
        if (left.getValue() instanceof StringLiteralExpr && tail.getValue() instanceof StringLiteralExpr) {
            StringLiteralExpr leftString = (StringLiteralExpr)left.getValue();
            StringLiteralExpr rightString = (StringLiteralExpr)tail.getValue();
            Expr value = this.createString(leftString.evalConstant().toString() + rightString.evalConstant().toString());
            return this.createAppendImpl(value, tail.getNext());
        }
        if (left.getValue() instanceof UnicodeLiteralExpr && tail.getValue() instanceof UnicodeLiteralExpr) {
            UnicodeLiteralExpr leftString = (UnicodeLiteralExpr)left.getValue();
            UnicodeLiteralExpr rightString = (UnicodeLiteralExpr)tail.getValue();
            Expr value = this.createUnicode(leftString.evalConstant().toString() + rightString.evalConstant().toString());
            return this.createAppendImpl(value, tail.getNext());
        }
        left.setNext(tail);
        return left;
    }

    protected AppendExpr createAppendImpl(Expr left, AppendExpr right) {
        return new AppendExpr(left, right);
    }

    public Expr createLt(Expr left, Expr right) {
        return new LtExpr(left, right);
    }

    public Expr createLeq(Expr left, Expr right) {
        return new LeqExpr(left, right);
    }

    public Expr createGt(Expr left, Expr right) {
        return new GtExpr(left, right);
    }

    public Expr createGeq(Expr left, Expr right) {
        return new GeqExpr(left, right);
    }

    public Expr createEq(Expr left, Expr right) {
        return new EqExpr(left, right);
    }

    public Expr createNeq(Expr left, Expr right) {
        return new NeqExpr(left, right);
    }

    public Expr createEquals(Expr left, Expr right) {
        return new EqualsExpr(left, right);
    }

    public Expr createAssign(AbstractVarExpr left, Expr right) {
        return new AssignExpr(left, right);
    }

    public Expr createAssignRef(AbstractVarExpr left, Expr right) {
        return new AssignRefExpr(left, right);
    }

    public RefExpr createRef(Expr base) {
        return new RefExpr(base);
    }

    public Expr createAnd(Expr left, Expr right) {
        return new AndExpr(left, right);
    }

    public Expr createOr(Expr left, Expr right) {
        return new OrExpr(left, right);
    }

    public Expr createXor(Expr left, Expr right) {
        return new XorExpr(left, right);
    }

    public Expr createComma(Expr left, Expr right) {
        return new CommaExpr(left, right);
    }

    public Expr createInstanceOf(Expr expr, String name) {
        return new InstanceOfExpr(expr, name);
    }

    public Expr createInstanceOfVar(Expr expr, Expr name) {
        return new InstanceOfVarExpr(expr, name);
    }

    public Expr createEach(Expr expr) {
        return new EachExpr(expr);
    }

    public final Expr createList(QuercusParser parser, ListHeadExpr head, Expr value) {
        boolean isSuppress = value instanceof SuppressErrorExpr;
        if (isSuppress) {
            SuppressErrorExpr suppressExpr = (SuppressErrorExpr)value;
            value = suppressExpr.getExpr();
        }
        Expr expr = value instanceof EachExpr ? this.createListEach(head.getVarList(), (EachExpr)value) : this.createList(head, value);
        if (isSuppress) {
            return this.createSuppress(expr);
        }
        return expr;
    }

    public ListHeadExpr createListHead(ArrayList<Expr> keys) {
        return new ListHeadExpr(keys);
    }

    public Expr createList(ListHeadExpr head, Expr value) {
        return new ListExpr(head, value);
    }

    public Expr createListEach(Expr[] varList, EachExpr value) {
        return new ListEachExpr(varList, value);
    }

    public Expr createConditional(Expr test, Expr left, Expr right) {
        return new ConditionalExpr(test, left, right);
    }

    public Expr createArrayFun(ArrayList<Expr> keys, ArrayList<Expr> values) {
        return new ArrayFunExpr(keys, values);
    }

    public FunctionExpr createFunction(Location loc, String name, ArrayList<Expr> args) {
        return new FunctionExpr(loc, name, args);
    }

    public VarFunctionExpr createVarFunction(Location loc, Expr name, ArrayList<Expr> args) {
        return new VarFunctionExpr(loc, name, args);
    }

    public Expr createClassMethod(Location loc, String className, String name, ArrayList<Expr> args) {
        return new ClassMethodExpr(loc, className, name, args);
    }

    public Expr createStaticMethod(Location loc, String className, String name, ArrayList<Expr> args) {
        return new StaticMethodExpr(loc, className, name, args);
    }

    public Expr createMethodCall(Location loc, Expr objExpr, String name, ArrayList<Expr> args) {
        return new MethodCallExpr(loc, objExpr, name, args);
    }

    public Expr createVarMethodCall(Location loc, Expr objExpr, Expr name, ArrayList<Expr> args) {
        return new VarMethodCallExpr(loc, objExpr, name, args);
    }

    public NewExpr createNew(Location loc, String name, ArrayList<Expr> args) {
        return new NewExpr(loc, name, args);
    }

    public VarNewExpr createVarNew(Location loc, Expr name, ArrayList<Expr> args) {
        return new VarNewExpr(loc, name, args);
    }

    public Expr createInclude(Location loc, Path source, Expr expr) {
        return new IncludeExpr(loc, source, expr, false);
    }

    public Expr createRequire(Location loc, Path source, Expr expr) {
        return new IncludeExpr(loc, source, expr, true);
    }

    public Expr createIncludeOnce(Location loc, Path source, Expr expr) {
        return new IncludeOnceExpr(loc, source, expr, false);
    }

    public Expr createRequireOnce(Location loc, Path source, Expr expr) {
        return new IncludeOnceExpr(loc, source, expr, true);
    }

    public Expr createImport(Location loc, String name, boolean isWildcard) {
        return new ImportExpr(loc, name, isWildcard);
    }

    public Statement createNullStatement() {
        return NullStatement.NULL;
    }

    public Statement createEcho(Location loc, Expr expr) {
        return new EchoStatement(loc, expr);
    }

    public Statement createExpr(Location loc, Expr expr) {
        return new ExprStatement(loc, expr);
    }

    public final Statement createBlock(Location loc, ArrayList<Statement> statementList) {
        if (statementList.size() == 1) {
            return statementList.get(0);
        }
        Statement[] statements = new Statement[statementList.size()];
        statementList.toArray(statements);
        return this.createBlockImpl(loc, statements);
    }

    public final Statement createBlock(Location loc, Statement[] statementList) {
        if (statementList.length == 1) {
            return statementList[0];
        }
        Statement[] statements = new Statement[statementList.length];
        System.arraycopy(statementList, 0, statements, 0, statementList.length);
        return this.createBlockImpl(loc, statements);
    }

    public final BlockStatement createBlockImpl(Location loc, ArrayList<Statement> statementList) {
        Statement[] statements = new Statement[statementList.size()];
        statementList.toArray(statements);
        return this.createBlockImpl(loc, statements);
    }

    public BlockStatement createBlockImpl(Location loc, Statement[] statements) {
        return new BlockStatement(loc, statements);
    }

    public Statement createText(Location loc, String text) {
        return new TextStatement(loc, text);
    }

    public Statement createIf(Location loc, Expr test, Statement trueBlock, Statement falseBlock) {
        return new IfStatement(loc, test, trueBlock, falseBlock);
    }

    public Statement createSwitch(Location loc, Expr value, ArrayList<Expr[]> caseList, ArrayList<BlockStatement> blockList, Statement defaultBlock) {
        return new SwitchStatement(loc, value, caseList, blockList, defaultBlock);
    }

    public Statement createFor(Location loc, Expr init, Expr test, Expr incr, Statement block) {
        return new ForStatement(loc, init, test, incr, block);
    }

    public Statement createForeach(Location loc, Expr objExpr, AbstractVarExpr key, AbstractVarExpr value, boolean isRef, Statement block) {
        return new ForeachStatement(loc, objExpr, key, value, isRef, block);
    }

    public Statement createWhile(Location loc, Expr test, Statement block) {
        return new WhileStatement(loc, test, block);
    }

    public Statement createDo(Location loc, Expr test, Statement block) {
        return new DoStatement(loc, test, block);
    }

    public BreakStatement createBreak() {
        return BreakStatement.BREAK;
    }

    public ContinueStatement createContinue() {
        return ContinueStatement.CONTINUE;
    }

    public Statement createGlobal(Location loc, VarExpr var) {
        return new GlobalStatement(loc, var);
    }

    public Statement createVarGlobal(Location loc, VarVarExpr var) {
        return new VarGlobalStatement(loc, var);
    }

    public Statement createStatic(Location loc, VarExpr var, Expr value) {
        return new StaticStatement(loc, var, value);
    }

    public Statement createThrow(Location loc, Expr value) {
        return new ThrowStatement(loc, value);
    }

    public TryStatement createTry(Location loc, Statement block) {
        return new TryStatement(loc, block);
    }

    public Statement createReturn(Location loc, Expr value) {
        return new ReturnStatement(loc, value);
    }

    public Statement createReturnRef(Location loc, Expr value) {
        return new ReturnRefStatement(loc, value);
    }

    public Statement createFunctionDef(Location loc, Function fun) {
        return new FunctionDefStatement(loc, fun);
    }

    public Statement createClassDef(Location loc, InterpretedClassDef cl) {
        return new ClassDefStatement(loc, cl);
    }

    public Function createFunction(Location loc, String name, FunctionInfo info, ArrayList<Arg> argList, ArrayList<Statement> statementList) {
        return new Function(this, loc, name, info, argList, statementList);
    }

    public Function createObjectMethod(Location loc, InterpretedClassDef cl, String name, FunctionInfo info, ArrayList<Arg> argList, ArrayList<Statement> statementList) {
        return new ObjectMethod(this, loc, cl, name, info, argList, statementList);
    }

    public Function createMethodDeclaration(Location loc, InterpretedClassDef cl, String name, FunctionInfo info, ArrayList<Arg> argList) {
        return new MethodDeclaration(this, loc, cl, name, info, argList);
    }

    public InterpretedClassDef createClassDef(Location location, String name, String parentName, String[] ifaceList) {
        return new InterpretedClassDef(location, name, parentName, ifaceList);
    }
}

