/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.expr;

import com.caucho.quercus.Location;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.NullValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.expr.Expr;
import com.caucho.quercus.expr.ExprFactory;
import com.caucho.quercus.parser.QuercusParser;
import com.caucho.quercus.program.AbstractFunction;
import com.caucho.util.L10N;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FunctionExpr
extends Expr {
    private static final L10N L = new L10N(FunctionExpr.class);
    protected final String _name;
    protected final Expr[] _args;

    public FunctionExpr(Location location, String name, ArrayList<Expr> args) {
        super(location);
        this._name = name.intern();
        this._args = new Expr[args.size()];
        args.toArray(this._args);
    }

    public FunctionExpr(Location location, String name, Expr[] args) {
        super(location);
        this._name = name.intern();
        this._args = args;
    }

    public FunctionExpr(String name, ArrayList<Expr> args) {
        this(Location.UNKNOWN, name, args);
    }

    public FunctionExpr(String name, Expr[] args) {
        this(Location.UNKNOWN, name, args);
    }

    public String getName() {
        return this._name;
    }

    @Override
    public String getFunctionLocation() {
        return " [" + this._name + "]";
    }

    @Override
    public Expr createRef(QuercusParser parser) {
        return parser.getFactory().createRef(this);
    }

    @Override
    public Expr createCopy(ExprFactory factory) {
        return this;
    }

    @Override
    public Value eval(Env env) {
        return this.evalImpl(env, false, false);
    }

    @Override
    public Value evalRef(Env env) {
        return this.evalImpl(env, true, false);
    }

    @Override
    public Value evalCopy(Env env) {
        return this.evalImpl(env, false, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Value evalImpl(Env env, boolean isRef, boolean isCopy) {
        AbstractFunction fun = env.findFunction(this._name);
        if (fun == null) {
            env.error(this.getLocationLine(), L.l("'{0}' is an unknown function.", (Object)this._name));
            return NullValue.NULL;
        }
        Value[] args = fun.evalArguments(env, this, this._args);
        env.pushCall(this, NullValue.NULL);
        try {
            env.checkTimeout();
            if (isRef) {
                Value value = fun.callRef(env, args);
                return value;
            }
            if (isCopy) {
                Value value = fun.callCopy(env, args);
                return value;
            }
            Value value = fun.call(env, args);
            return value;
        }
        finally {
            env.popCall();
        }
    }

    @Override
    public String toString() {
        return this._name + "()";
    }
}

