/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.expr;

import com.caucho.quercus.Location;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.expr.Expr;
import com.caucho.quercus.expr.UnaryExpr;
import com.caucho.vfs.Path;

public class IncludeOnceExpr
extends UnaryExpr {
    protected Path _dir;
    protected boolean _isRequire;

    public IncludeOnceExpr(Location location, Path sourceFile, Expr expr) {
        super(location, expr);
        if (!sourceFile.getScheme().equals("string")) {
            this._dir = sourceFile.getParent();
        }
    }

    public IncludeOnceExpr(Location location, Path sourceFile, Expr expr, boolean isRequire) {
        this(location, sourceFile, expr);
        this._isRequire = isRequire;
    }

    public IncludeOnceExpr(Path sourceFile, Expr expr) {
        this(Location.UNKNOWN, sourceFile, expr);
    }

    public IncludeOnceExpr(Path sourceFile, Expr expr, boolean isRequire) {
        this(Location.UNKNOWN, sourceFile, expr, isRequire);
    }

    public Value eval(Env env) {
        String name = this._expr.evalString(env);
        if (this._dir != null) {
            return env.include(this._dir, name, this._isRequire, true);
        }
        if (this._isRequire) {
            return env.require_once(name);
        }
        return env.include_once(name);
    }

    public String toString() {
        return this._expr.toString();
    }
}

