/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.expr;

import com.caucho.quercus.Location;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.expr.AbstractVarExpr;
import com.caucho.quercus.program.InterpretedClassDef;
import com.caucho.util.L10N;

public class ThisFieldExpr
extends AbstractVarExpr {
    private static final L10N L = new L10N(ThisFieldExpr.class);
    protected final InterpretedClassDef _quercusClass;
    protected final String _name;

    public ThisFieldExpr(Location location, InterpretedClassDef quercusClass, String name) {
        super(location);
        this._quercusClass = quercusClass;
        this._name = name.intern();
    }

    public ThisFieldExpr(InterpretedClassDef quercusClass, String name) {
        this._quercusClass = quercusClass;
        this._name = name.intern();
    }

    private Value cannotUseThisError(Env env) {
        return env.error(this.getLocation(), "Cannot use '$this' when not in object context.");
    }

    public Value eval(Env env) {
        Value obj = env.getThis();
        if (obj.isNull()) {
            return this.cannotUseThisError(env);
        }
        return obj.getField(env, this._name);
    }

    public Value evalCopy(Env env) {
        Value obj = env.getThis();
        if (obj.isNull()) {
            return this.cannotUseThisError(env);
        }
        return obj.getField(env, this._name).copy();
    }

    public Value evalRef(Env env) {
        Value obj = env.getThis();
        if (obj.isNull()) {
            return this.cannotUseThisError(env);
        }
        return obj.getFieldRef(env, this._name);
    }

    public Value evalArg(Env env) {
        Value obj = env.getThis();
        if (obj.isNull()) {
            return this.cannotUseThisError(env);
        }
        return obj.getFieldArg(env, this._name);
    }

    public void evalAssign(Env env, Value value) {
        Value obj = env.getThis();
        if (obj.isNull()) {
            this.cannotUseThisError(env);
        }
        obj.putField(env, this._name, value);
    }

    public Value evalArray(Env env) {
        Value obj = env.getThis();
        if (obj.isNull()) {
            return this.cannotUseThisError(env);
        }
        return obj.getFieldArray(env, this._name);
    }

    public Value evalObject(Env env) {
        Value obj = env.getThis();
        if (obj.isNull()) {
            return this.cannotUseThisError(env);
        }
        return obj.getFieldObject(env, this._name);
    }

    public void evalUnset(Env env) {
        Value obj = env.getThis();
        if (obj.isNull()) {
            this.cannotUseThisError(env);
        }
        obj.removeField(this._name);
    }

    public String toString() {
        return "$this->" + this._name;
    }
}

