/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.expr;

import com.caucho.quercus.program.FunctionInfo;

public class VarInfo {
    private final FunctionInfo _function;
    private final String _name;
    private boolean _isGlobal;
    private boolean _isArgument;
    private boolean _isRefArgument;
    private boolean _isAssigned;
    private boolean _isReference;
    private int _argumentIndex;

    public VarInfo(String name, FunctionInfo function) {
        this._name = name.intern();
        this._function = function;
        if (function != null && function.isPageMain()) {
            this._isReference = true;
        }
    }

    public String getName() {
        return this._name;
    }

    public FunctionInfo getFunction() {
        return this._function;
    }

    public boolean isGlobal() {
        return this._isGlobal;
    }

    public void setGlobal() {
        this._isGlobal = true;
    }

    public boolean isVariable() {
        return this._function != null && (this._function.isUsesSymbolTable() || this._function.isVariableVar());
    }

    public boolean isArgument() {
        return this._isArgument;
    }

    public void setArgument(boolean isArgument) {
        this._isArgument = isArgument;
    }

    public void setArgumentIndex(int index) {
        this._argumentIndex = index;
    }

    public int getArgumentIndex() {
        return this._argumentIndex;
    }

    public boolean isRefArgument() {
        return this._isRefArgument;
    }

    public void setRefArgument() {
        this._isRefArgument = true;
        this.setReference();
    }

    public boolean isAssigned() {
        return this._isAssigned;
    }

    public void setAssigned() {
        this._isAssigned = true;
        if (this.isReference()) {
            this.setModified();
        }
    }

    public boolean isValue() {
        return !this._isArgument && !this._isReference && !this.isGlobal() && !this.isVariable();
    }

    public boolean isReference() {
        return this._isReference || this.isGlobal() || this.isArgument() || this.isVariable();
    }

    public void setReference() {
        this._isReference = true;
        if (this._isAssigned) {
            this.setModified();
        }
    }

    public boolean isReadOnly() {
        return this._function.isReadOnly();
    }

    public void setModified() {
        this._function.setModified();
    }

    public String toString() {
        return "VarInfo[" + this._name + "]";
    }
}

