/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.expr;

import com.caucho.quercus.Location;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.expr.Expr;
import com.caucho.quercus.program.AbstractFunction;
import com.caucho.util.L10N;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VarMethodCallExpr
extends Expr {
    private static final L10N L = new L10N(VarMethodCallExpr.class);
    protected final Expr _objExpr;
    protected final Expr _name;
    protected final Expr[] _args;
    protected Expr[] _fullArgs;
    private AbstractFunction _fun;

    public VarMethodCallExpr(Location location, Expr objExpr, Expr name, ArrayList<Expr> args) {
        super(location);
        this._objExpr = objExpr;
        this._name = name;
        this._args = new Expr[args.size()];
        args.toArray(this._args);
    }

    public VarMethodCallExpr(Location location, Expr objExpr, Expr name, Expr[] args) {
        super(location);
        this._objExpr = objExpr;
        this._name = name;
        this._args = args;
    }

    public VarMethodCallExpr(Expr objExpr, Expr name, ArrayList<Expr> args) {
        this(Location.UNKNOWN, objExpr, name, args);
    }

    public VarMethodCallExpr(Expr objExpr, Expr name, Expr[] args) {
        this(Location.UNKNOWN, objExpr, name, args);
    }

    @Override
    public Value eval(Env env) {
        Value[] values = new Value[this._args.length];
        for (int i = 0; i < values.length; ++i) {
            values[i] = this._args[i].evalArg(env);
        }
        StringValue methodName = this._name.eval(env).toStringValue();
        return this._objExpr.eval(env).callMethod(env, methodName, values);
    }

    @Override
    public String toString() {
        return this._objExpr + "->" + this._name + "()";
    }
}

