/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.expr;

import com.caucho.quercus.Location;
import com.caucho.quercus.QuercusException;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.QuercusClass;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.expr.Expr;
import com.caucho.quercus.expr.NewExpr;
import com.caucho.util.L10N;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VarNewExpr
extends Expr {
    private static final L10N L = new L10N(NewExpr.class);
    protected final Expr _name;
    protected final Expr[] _args;
    protected Expr[] _fullArgs;

    public VarNewExpr(Location location, Expr name, ArrayList<Expr> args) {
        super(location);
        this._name = name;
        this._args = new Expr[args.size()];
        args.toArray(this._args);
    }

    public VarNewExpr(Location location, Expr name, Expr[] args) {
        super(location);
        this._name = name;
        this._args = args;
    }

    public VarNewExpr(Expr name, ArrayList<Expr> args) {
        this(Location.UNKNOWN, name, args);
    }

    public VarNewExpr(Expr name, Expr[] args) {
        this(Location.UNKNOWN, name, args);
    }

    @Override
    public Value eval(Env env) {
        String name = this._name.evalString(env).intern();
        QuercusClass cl = env.findClass(name);
        if (cl == null) {
            throw new QuercusException(L.l("no matching class {0}", (Object)name));
        }
        this._fullArgs = this._args;
        return cl.callNew(env, this._args);
    }

    @Override
    public String toString() {
        return this._name + "()";
    }
}

