/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.function;

import com.caucho.quercus.env.BytesValue;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.expr.Expr;
import com.caucho.quercus.function.Marshal;

public class BinaryValueMarshal
extends Marshal {
    public static final Marshal MARSHAL = new BinaryValueMarshal();

    public boolean isReadOnly() {
        return true;
    }

    public boolean isValue() {
        return true;
    }

    public Object marshal(Env env, Expr expr, Class expectedClass) {
        return expr.eval(env).toBinaryValue(env);
    }

    public Object marshal(Env env, Value value, Class expectedClass) {
        return value.toBinaryValue(env);
    }

    public Value unmarshal(Env env, Object value) {
        if (value instanceof BytesValue) {
            return (BytesValue)value;
        }
        if (value instanceof Value) {
            return ((Value)value).toBinaryValue(env);
        }
        return env.createString(String.valueOf(value));
    }

    protected int getMarshalingCostImpl(Value argValue) {
        if (argValue.isBinary()) {
            return 0;
        }
        if (argValue.isString()) {
            return 200;
        }
        if (!argValue.isArray() && !argValue.isObject()) {
            return 300;
        }
        return 400;
    }

    public Class getExpectedClass() {
        return BytesValue.class;
    }
}

