/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.function;

import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.expr.Expr;
import com.caucho.quercus.function.Marshal;

public class ExtValueMarshal
extends Marshal {
    private Class _expectedClass;

    public ExtValueMarshal(Class expectedClass) {
        this._expectedClass = expectedClass;
    }

    public boolean isReadOnly() {
        return false;
    }

    public boolean isValue() {
        return true;
    }

    public Object marshal(Env env, Expr expr, Class expectedClass) {
        return this.marshal(env, expr.eval(env), expectedClass);
    }

    public Object marshal(Env env, Value value, Class expectedClass) {
        if (value == null || !value.isset()) {
            return null;
        }
        if (expectedClass.isAssignableFrom((value = value.toValue()).getClass())) {
            return value;
        }
        String className = expectedClass.getName();
        int p = className.lastIndexOf(46);
        className = className.substring(p + 1);
        String valueClassName = value.getClass().getName();
        p = valueClassName.lastIndexOf(46);
        valueClassName = valueClassName.substring(p + 1);
        env.warning(L.l("'{0}' of type `{1}' is an unexpected argument, expected {2}", (Object)value, (Object)valueClassName, (Object)className));
        return null;
    }

    public Value unmarshal(Env env, Object value) {
        return (Value)value;
    }

    protected int getMarshalingCostImpl(Value argValue) {
        if (this._expectedClass.isAssignableFrom(argValue.getClass())) {
            return 100;
        }
        return 400;
    }

    public Class getExpectedClass() {
        return this._expectedClass;
    }
}

