/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.function;

import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.expr.Expr;
import com.caucho.util.L10N;

public abstract class Marshal {
    protected static final L10N L = new L10N(Marshal.class);
    public static final int SAME = 0;
    public static final int EQUIVALENT = 100;
    public static final int SIMILAR = 200;
    public static final int MARSHALABLE = 300;
    public static final int DUBIOUS = 400;
    public static final int INCOMPATIBLE = Integer.MAX_VALUE;

    public boolean isBoolean() {
        return false;
    }

    public boolean isString() {
        return false;
    }

    public boolean isLong() {
        return false;
    }

    public boolean isDouble() {
        return false;
    }

    public boolean isReadOnly() {
        return true;
    }

    public boolean isReference() {
        return false;
    }

    public boolean isValue() {
        return false;
    }

    public abstract Object marshal(Env var1, Expr var2, Class var3);

    public Object marshal(Env env, Value value, Class argClass) {
        return value;
    }

    public Value unmarshal(Env env, Object value) {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public final int getMarshalingCost(Value value) {
        Class expectedClass = this.getExpectedClass();
        if (expectedClass.equals(value.getClass())) {
            return 0;
        }
        return this.getMarshalingCostImpl(value);
    }

    protected int getMarshalingCostImpl(Value value) {
        throw new UnsupportedOperationException(this.getClass().toString());
    }

    public Class getExpectedClass() {
        throw new UnsupportedOperationException(this.getClass().toString());
    }
}

