/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.function;

import com.caucho.quercus.env.ArrayValue;
import com.caucho.quercus.env.BytesValue;
import com.caucho.quercus.env.Callback;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.env.UnicodeValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.function.ArrayValueMarshal;
import com.caucho.quercus.function.BinaryInputMarshal;
import com.caucho.quercus.function.BinaryValueMarshal;
import com.caucho.quercus.function.BooleanMarshal;
import com.caucho.quercus.function.BooleanObjectMarshal;
import com.caucho.quercus.function.ByteMarshal;
import com.caucho.quercus.function.ByteObjectMarshal;
import com.caucho.quercus.function.CalendarMarshal;
import com.caucho.quercus.function.CallbackMarshal;
import com.caucho.quercus.function.CharacterMarshal;
import com.caucho.quercus.function.CharacterObjectMarshal;
import com.caucho.quercus.function.DateMarshal;
import com.caucho.quercus.function.DoubleMarshal;
import com.caucho.quercus.function.DoubleObjectMarshal;
import com.caucho.quercus.function.ExtValueMarshal;
import com.caucho.quercus.function.FloatMarshal;
import com.caucho.quercus.function.FloatObjectMarshal;
import com.caucho.quercus.function.InputStreamMarshal;
import com.caucho.quercus.function.IntegerMarshal;
import com.caucho.quercus.function.IntegerObjectMarshal;
import com.caucho.quercus.function.JavaArrayMarshal;
import com.caucho.quercus.function.JavaByteArrayMarshal;
import com.caucho.quercus.function.JavaByteObjectArrayMarshal;
import com.caucho.quercus.function.JavaCharacterArrayMarshal;
import com.caucho.quercus.function.JavaCharacterObjectArrayMarshal;
import com.caucho.quercus.function.JavaCollectionMarshal;
import com.caucho.quercus.function.JavaListMarshal;
import com.caucho.quercus.function.JavaMapMarshal;
import com.caucho.quercus.function.JavaMarshal;
import com.caucho.quercus.function.LongMarshal;
import com.caucho.quercus.function.LongObjectMarshal;
import com.caucho.quercus.function.Marshal;
import com.caucho.quercus.function.NullAsFalseMarshal;
import com.caucho.quercus.function.PathMarshal;
import com.caucho.quercus.function.ReferenceMarshal;
import com.caucho.quercus.function.ShortMarshal;
import com.caucho.quercus.function.ShortObjectMarshal;
import com.caucho.quercus.function.StringMarshal;
import com.caucho.quercus.function.StringValueMarshal;
import com.caucho.quercus.function.URLMarshal;
import com.caucho.quercus.function.UnicodeValueMarshal;
import com.caucho.quercus.function.ValueMarshal;
import com.caucho.quercus.function.VoidMarshal;
import com.caucho.quercus.lib.file.BinaryInput;
import com.caucho.quercus.module.ModuleContext;
import com.caucho.quercus.program.JavaClassDef;
import com.caucho.util.L10N;
import com.caucho.vfs.Path;
import java.io.InputStream;
import java.net.URL;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class MarshalFactory {
    private static final L10N L = new L10N(MarshalFactory.class);
    protected ModuleContext _moduleContext;

    public MarshalFactory(ModuleContext moduleContext) {
        this._moduleContext = moduleContext;
    }

    public Marshal create(Class argType) {
        return this.create(argType, false);
    }

    public Marshal create(Class argType, boolean isNotNull) {
        return this.create(argType, isNotNull, false);
    }

    public Marshal create(Class argType, boolean isNotNull, boolean isNullAsFalse) {
        String typeName;
        Marshal marshal;
        if (String.class.equals((Object)argType)) {
            marshal = StringMarshal.MARSHAL;
        } else if (Boolean.TYPE.equals(argType)) {
            marshal = BooleanMarshal.MARSHAL;
        } else if (Boolean.class.equals((Object)argType)) {
            marshal = BooleanObjectMarshal.MARSHAL;
        } else if (Byte.TYPE.equals(argType)) {
            marshal = ByteMarshal.MARSHAL;
        } else if (Byte.class.equals((Object)argType)) {
            marshal = ByteObjectMarshal.MARSHAL;
        } else if (Short.TYPE.equals(argType)) {
            marshal = ShortMarshal.MARSHAL;
        } else if (Short.class.equals((Object)argType)) {
            marshal = ShortObjectMarshal.MARSHAL;
        } else if (Integer.TYPE.equals(argType)) {
            marshal = IntegerMarshal.MARSHAL;
        } else if (Integer.class.equals((Object)argType)) {
            marshal = IntegerObjectMarshal.MARSHAL;
        } else if (Long.TYPE.equals(argType)) {
            marshal = LongMarshal.MARSHAL;
        } else if (Long.class.equals((Object)argType)) {
            marshal = LongObjectMarshal.MARSHAL;
        } else if (Float.TYPE.equals(argType)) {
            marshal = FloatMarshal.MARSHAL;
        } else if (Float.class.equals((Object)argType)) {
            marshal = FloatObjectMarshal.MARSHAL;
        } else if (Double.TYPE.equals(argType)) {
            marshal = DoubleMarshal.MARSHAL;
        } else if (Double.class.equals((Object)argType)) {
            marshal = DoubleObjectMarshal.MARSHAL;
        } else if (Character.TYPE.equals(argType)) {
            marshal = CharacterMarshal.MARSHAL;
        } else if (Character.class.equals((Object)argType)) {
            marshal = CharacterObjectMarshal.MARSHAL;
        } else if (Path.class.equals((Object)argType)) {
            marshal = PathMarshal.MARSHAL;
        } else if (Callback.class.equals((Object)argType)) {
            marshal = CallbackMarshal.MARSHAL;
        } else if (StringValue.class.equals((Object)argType)) {
            marshal = StringValueMarshal.MARSHAL;
        } else if (UnicodeValue.class.equals((Object)argType)) {
            marshal = UnicodeValueMarshal.MARSHAL;
        } else if (BytesValue.class.equals((Object)argType)) {
            marshal = BinaryValueMarshal.MARSHAL;
        } else if (InputStream.class.equals((Object)argType)) {
            marshal = InputStreamMarshal.MARSHAL;
        } else if (BinaryInput.class.equals((Object)argType)) {
            marshal = BinaryInputMarshal.MARSHAL;
        } else if (ArrayValue.class.equals((Object)argType)) {
            marshal = ArrayValueMarshal.MARSHAL;
        } else if (Value.class.equals((Object)argType)) {
            marshal = ValueMarshal.MARSHAL;
        } else if (Value.class.isAssignableFrom(argType)) {
            marshal = new ExtValueMarshal(argType);
        } else if (Void.TYPE.equals(argType)) {
            marshal = VoidMarshal.MARSHAL;
        } else if (Calendar.class.equals((Object)argType)) {
            marshal = CalendarMarshal.MARSHAL;
        } else if (Date.class.equals((Object)argType)) {
            marshal = DateMarshal.MARSHAL;
        } else if (URL.class.equals((Object)argType)) {
            marshal = URLMarshal.MARSHAL;
        } else if (byte[].class.equals((Object)argType)) {
            marshal = JavaByteArrayMarshal.MARSHAL;
        } else if (Byte[].class.equals((Object)argType)) {
            marshal = JavaByteObjectArrayMarshal.MARSHAL;
        } else if (char[].class.equals((Object)argType)) {
            marshal = JavaCharacterArrayMarshal.MARSHAL;
        } else if (Character[].class.equals((Object)argType)) {
            marshal = JavaCharacterObjectArrayMarshal.MARSHAL;
        } else if (argType.isArray()) {
            marshal = new JavaArrayMarshal(argType);
        } else if (Map.class.isAssignableFrom(argType)) {
            typeName = argType.getName();
            JavaClassDef javaDef = this._moduleContext.getJavaClassDefinition(typeName);
            marshal = new JavaMapMarshal(javaDef, isNotNull, isNullAsFalse);
        } else if (List.class.isAssignableFrom(argType)) {
            typeName = argType.getName();
            JavaClassDef javaDef = this._moduleContext.getJavaClassDefinition(typeName);
            marshal = new JavaListMarshal(javaDef, isNotNull, isNullAsFalse);
        } else if (Collection.class.isAssignableFrom(argType)) {
            typeName = argType.getName();
            JavaClassDef javaDef = this._moduleContext.getJavaClassDefinition(typeName);
            marshal = new JavaCollectionMarshal(javaDef, isNotNull, isNullAsFalse);
        } else {
            typeName = argType.getName();
            JavaClassDef javaDef = this._moduleContext.getJavaClassDefinition(typeName);
            marshal = new JavaMarshal(javaDef, isNotNull, isNullAsFalse);
        }
        if (!isNullAsFalse) {
            return marshal;
        }
        if (Value.class.equals((Object)argType) || Boolean.class.equals((Object)argType) || Byte.class.equals((Object)argType) || Short.class.equals((Object)argType) || Integer.class.equals((Object)argType) || Long.class.equals((Object)argType) || Float.class.equals((Object)argType) || Double.class.equals((Object)argType) || Character.class.equals((Object)argType)) {
            String shortName = argType.getSimpleName();
            throw new UnsupportedOperationException("@ReturnNullAsFalse cannot be used with return type `" + shortName + "'");
        }
        return new NullAsFalseMarshal(marshal);
    }

    public Marshal createReference() {
        return ReferenceMarshal.MARSHAL;
    }
}

