/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.lib;

import com.caucho.quercus.annotation.Optional;
import com.caucho.quercus.env.ArrayValue;
import com.caucho.quercus.env.ArrayValueImpl;
import com.caucho.quercus.env.BooleanValue;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.module.AbstractQuercusModule;
import com.caucho.quercus.module.IniDefinition;
import com.caucho.quercus.module.IniDefinitions;
import com.caucho.util.Alarm;
import com.caucho.util.L10N;
import com.caucho.util.LruCache;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;

public class ApcModule
extends AbstractQuercusModule {
    private static final Logger log = Logger.getLogger(ApcModule.class.getName());
    private static final L10N L = new L10N(ApcModule.class);
    private static final IniDefinitions _iniDefinitions = new IniDefinitions();
    private LruCache<String, Entry> _cache = new LruCache(4096);
    private HashMap<String, Value> _constMap = new HashMap();
    static final IniDefinition INI_APC_ENABLED = _iniDefinitions.add("apc.enabled", true, 7);
    static final IniDefinition INI_APC_SHM_SEGMENTS = _iniDefinitions.add("apc.shm_segments", 1L, 4);
    static final IniDefinition INI_APC_SHM_SIZE = _iniDefinitions.add("apc.shm_size", 30L, 4);
    static final IniDefinition INI_APC_OPTIMIZATION = _iniDefinitions.add("apc.optimization", false, 7);
    static final IniDefinition INI_APC_NUM_FILES_HINT = _iniDefinitions.add("apc.num_files_hint", 1000L, 4);
    static final IniDefinition INI_APC_TTL = _iniDefinitions.add("apc.ttl", 0L, 4);
    static final IniDefinition INI_APC_GC_TTL = _iniDefinitions.add("apc.gc_ttl", "3600", 4);
    static final IniDefinition INI_APC_CACHE_BY_DEFAULT = _iniDefinitions.add("apc.cache_by_default", true, 4);
    static final IniDefinition INI_APC_FILTERS = _iniDefinitions.add("apc.filters", "", 4);
    static final IniDefinition INI_APC_MMAP_FILE_MASK = _iniDefinitions.add("apc.mmap_file_mask", "", 4);
    static final IniDefinition INI_APC_SLAM_DEFENSE = _iniDefinitions.add("apc.slam_defense", false, 4);
    static final IniDefinition INI_APC_FILE_UPDATE_PROTECTION = _iniDefinitions.add("apc.file_update_protection", "2", 4);
    static final IniDefinition INI_APC_ENABLE_CLI = _iniDefinitions.add("apc.enable_cli", false, 4);

    public String[] getLoadedExtensions() {
        return new String[]{"apc"};
    }

    public IniDefinitions getIniDefinitions() {
        return _iniDefinitions;
    }

    public Value apc_cache_info(Env env, @Optional String type) {
        ArrayValueImpl value = new ArrayValueImpl();
        value.put("num_slots", 1000L);
        value.put("ttl", 0L);
        value.put("num_hits", 0L);
        value.put("num_misses", 0L);
        value.put("start_time", 0L);
        ((ArrayValue)value).put(env.createString("cache_list"), new ArrayValueImpl());
        return value;
    }

    public boolean apc_clear_cache(Env env, @Optional String type) {
        this._cache.clear();
        return true;
    }

    public boolean apc_define_constants(Env env, String key, ArrayValue values, @Optional(value="true") boolean caseSensitive) {
        this._constMap.put(key, values.copy(env));
        return true;
    }

    public boolean apc_delete(Env env, String key) {
        return this._cache.remove((Object)key) != null;
    }

    public Value apc_fetch(Env env, String key) {
        Entry entry = (Entry)this._cache.get((Object)key);
        if (entry == null) {
            return BooleanValue.FALSE;
        }
        Value value = entry.getValue();
        if (entry.isValid() && value != null) {
            return value.copy(env);
        }
        return BooleanValue.FALSE;
    }

    public boolean apc_load_constants(Env env, String key, @Optional(value="true") boolean caseSensitive) {
        ArrayValue array = (ArrayValue)this._constMap.get(key);
        if (array == null) {
            return false;
        }
        for (Map.Entry<Value, Value> entry : array.entrySet()) {
            env.addConstant(entry.getKey().toString(), entry.getValue().copy(env), !caseSensitive);
        }
        return true;
    }

    public Value apc_sma_info(Env env, @Optional String type) {
        ArrayValueImpl value = new ArrayValueImpl();
        value.put("num_seg", 1L);
        value.put("seg_size", 0x100000L);
        value.put("avail_mem", 0x100000L);
        ((ArrayValue)value).put(env.createString("block_lists"), new ArrayValueImpl());
        return value;
    }

    public Value apc_store(Env env, String key, Value value, @Optional(value="0") int ttl) {
        this._cache.put((Object)key, (Object)new Entry(value.copy(env), ttl));
        return BooleanValue.TRUE;
    }

    static class Entry {
        private Value _value;
        private long _expire;

        Entry(Value value, int ttl) {
            this._value = value;
            this._expire = ttl <= 0 ? Long.MAX_VALUE : Alarm.getCurrentTime() + (long)ttl * 1000L;
        }

        public boolean isValid() {
            if (Alarm.getCurrentTime() <= this._expire) {
                return true;
            }
            this._value = null;
            return false;
        }

        public Value getValue() {
            return this._value;
        }
    }
}

