/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.lib;

import com.caucho.quercus.QuercusModuleException;
import com.caucho.quercus.annotation.NotNull;
import com.caucho.quercus.annotation.Optional;
import com.caucho.quercus.annotation.ReadOnly;
import com.caucho.quercus.annotation.Reference;
import com.caucho.quercus.annotation.UsesSymbolTable;
import com.caucho.quercus.env.ArrayValue;
import com.caucho.quercus.env.ArrayValueImpl;
import com.caucho.quercus.env.BooleanValue;
import com.caucho.quercus.env.Callback;
import com.caucho.quercus.env.CallbackFunction;
import com.caucho.quercus.env.DefaultValue;
import com.caucho.quercus.env.DoubleValue;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.LongValue;
import com.caucho.quercus.env.NullValue;
import com.caucho.quercus.env.NumberValue;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.env.Var;
import com.caucho.quercus.module.AbstractQuercusModule;
import com.caucho.quercus.program.AbstractFunction;
import com.caucho.util.L10N;
import com.caucho.util.RandomUtil;
import java.text.Collator;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ArrayModule
extends AbstractQuercusModule {
    private static final L10N L = new L10N(ArrayModule.class);
    private static final Logger log = Logger.getLogger(ArrayModule.class.getName());
    public static final int CASE_UPPER = 2;
    public static final int CASE_LOWER = 1;
    public static final int SORT_REGULAR = 0;
    public static final int SORT_NUMERIC = 1;
    public static final int SORT_STRING = 2;
    public static final int SORT_LOCALE_STRING = 5;
    public static final int SORT_NORMAL = 1;
    public static final int SORT_REVERSE = -1;
    public static final int SORT_DESC = 3;
    public static final int SORT_ASC = 4;
    public static final int EXTR_OVERWRITE = 0;
    public static final int EXTR_SKIP = 1;
    public static final int EXTR_PREFIX_SAME = 2;
    public static final int EXTR_PREFIX_ALL = 3;
    public static final int EXTR_PREFIX_INVALID = 4;
    public static final int EXTR_IF_EXISTS = 6;
    public static final int EXTR_PREFIX_IF_EXISTS = 5;
    public static final int EXTR_REFS = 256;
    public static final boolean CASE_SENSITIVE = true;
    public static final boolean CASE_INSENSITIVE = false;
    public static final boolean KEY_RESET = true;
    public static final boolean NO_KEY_RESET = false;
    public static final boolean STRICT = true;
    public static final boolean NOT_STRICT = false;
    private static final CompareString CS_VALUE_NORMAL = new CompareString(ArrayValue.GET_VALUE, 1);
    private static final CompareString CS_VALUE_REVERSE = new CompareString(ArrayValue.GET_VALUE, -1);
    private static final CompareString CS_KEY_NORMAL = new CompareString(ArrayValue.GET_KEY, 1);
    private static final CompareString CS_KEY_REVERSE = new CompareString(ArrayValue.GET_KEY, -1);
    private static final CompareNumeric CN_VALUE_NORMAL = new CompareNumeric(ArrayValue.GET_VALUE, 1);
    private static final CompareNumeric CN_VALUE_REVERSE = new CompareNumeric(ArrayValue.GET_VALUE, -1);
    private static final CompareNumeric CN_KEY_NORMAL = new CompareNumeric(ArrayValue.GET_KEY, 1);
    private static final CompareNumeric CN_KEY_REVERSE = new CompareNumeric(ArrayValue.GET_KEY, -1);
    private static final CompareNormal CNO_VALUE_NORMAL = new CompareNormal(ArrayValue.GET_VALUE, 1);
    private static final CompareNormal CNO_VALUE_REVERSE = new CompareNormal(ArrayValue.GET_VALUE, -1);
    private static final CompareNormal CNO_KEY_NORMAL = new CompareNormal(ArrayValue.GET_KEY, 1);
    private static final CompareNormal CNO_KEY_REVERSE = new CompareNormal(ArrayValue.GET_KEY, -1);
    private static final CompareNatural CNA_VALUE_NORMAL_SENSITIVE = new CompareNatural(ArrayValue.GET_VALUE, 1, true);
    private static final CompareNatural CNA_VALUE_NORMAL_INSENSITIVE = new CompareNatural(ArrayValue.GET_VALUE, 1, false);

    public String[] getLoadedExtensions() {
        return new String[]{"standard"};
    }

    public Value array_change_key_case(Env env, ArrayValue array, @Optional(value="CASE_LOWER") int toCase) {
        if (array == null) {
            return BooleanValue.FALSE;
        }
        ArrayValueImpl newArray = new ArrayValueImpl();
        for (Map.Entry<Value, Value> entry : array.entrySet()) {
            Value keyValue = entry.getKey();
            if (keyValue instanceof StringValue) {
                String key = keyValue.toString();
                key = toCase == 2 ? key.toUpperCase() : key.toLowerCase();
                ((ArrayValue)newArray).put(env.createString(key), entry.getValue());
                continue;
            }
            ((ArrayValue)newArray).put(keyValue, entry.getValue());
        }
        return newArray;
    }

    public Value array_chunk(Env env, ArrayValue array, int size, @Optional boolean preserveKeys) {
        if (array == null) {
            return NullValue.NULL;
        }
        ArrayValueImpl newArray = new ArrayValueImpl();
        ArrayValueImpl currentArray = null;
        if (size < 1) {
            env.warning("Size parameter expected to be greater than 0");
            return NullValue.NULL;
        }
        int i = 0;
        for (Map.Entry<Value, Value> entry : array.entrySet()) {
            Value key = entry.getKey();
            Value value = entry.getKey();
            if (i % size == 0) {
                currentArray = new ArrayValueImpl();
                ((ArrayValue)newArray).put(currentArray);
            }
            if (preserveKeys) {
                ((ArrayValue)currentArray).put(key, value);
            } else {
                ((ArrayValue)currentArray).put(new LongValue(i % size), value);
            }
            ++i;
        }
        return newArray;
    }

    public Value array_combine(Env env, ArrayValue keys, ArrayValue values) {
        if (keys == null || values == null) {
            return BooleanValue.FALSE;
        }
        if (keys.getSize() < 1 || values.getSize() < 1) {
            env.warning("Both parameters should have at least 1 element");
            return BooleanValue.FALSE;
        }
        if (keys.getSize() != values.getSize()) {
            env.warning("Both parameters should have equal number of elements");
            return BooleanValue.FALSE;
        }
        Iterator<Value> keyIter = keys.values().iterator();
        Iterator<Value> valueIter = values.values().iterator();
        ArrayValueImpl array = new ArrayValueImpl();
        while (keyIter.hasNext() && valueIter.hasNext()) {
            ((ArrayValue)array).put(keyIter.next(), valueIter.next());
        }
        return array;
    }

    public Value array_count_values(Env env, ArrayValue array) {
        if (array == null) {
            return NullValue.NULL;
        }
        ArrayValueImpl result = new ArrayValueImpl();
        for (Value value : array.values()) {
            if (!value.isLongConvertible() && !(value instanceof StringValue)) {
                env.warning("Can only count STRING and INTEGER values!");
                continue;
            }
            Value count = ((ArrayValue)result).get(value);
            count = count == null ? new LongValue(1L) : count.add(1L);
            ((ArrayValue)result).put(value, count);
        }
        return result;
    }

    public Value array_pop(Value value) {
        if (value instanceof ArrayValue) {
            ArrayValue array = (ArrayValue)value;
            return array.pop();
        }
        return BooleanValue.FALSE;
    }

    public static Value count(Env env, @ReadOnly Value value, @Optional(value="false") boolean recursive) {
        if (!recursive) {
            return LongValue.create(value.getCount(env));
        }
        return LongValue.create(value.getCountRecursive(env));
    }

    public static Value current(@ReadOnly Value value) {
        if (value instanceof ArrayValue) {
            ArrayValue array = (ArrayValue)value;
            return array.current();
        }
        return BooleanValue.FALSE;
    }

    public static Value key(@ReadOnly Value value) {
        if (value instanceof ArrayValue) {
            ArrayValue array = (ArrayValue)value;
            return array.key();
        }
        return BooleanValue.FALSE;
    }

    public static Value pos(@ReadOnly Value value) {
        return ArrayModule.current(value);
    }

    public static Value next(Value value) {
        if (value instanceof ArrayValue) {
            ArrayValue array = (ArrayValue)value;
            return array.next();
        }
        return BooleanValue.FALSE;
    }

    public static Value each(Env env, @Reference Value value) {
        if (value instanceof Var) {
            if ((value = value.toValue()).isArray()) {
                return value.toArrayValue(env).each();
            }
            L.l("each() requires argument to be an array");
            env.warning("each() requires argument to be an array");
            return NullValue.NULL;
        }
        L.l("each() argument must be a variable");
        return env.error("each() argument must be a variable");
    }

    public static Value prev(Value value) {
        if (value instanceof ArrayValue) {
            ArrayValue array = (ArrayValue)value;
            return array.prev();
        }
        return BooleanValue.FALSE;
    }

    public static Value reset(Value value) {
        if (value instanceof ArrayValue) {
            ArrayValue array = (ArrayValue)value;
            return array.reset();
        }
        return BooleanValue.FALSE;
    }

    public static Value shuffle(ArrayValue array) {
        if (array == null) {
            return BooleanValue.FALSE;
        }
        array.shuffle();
        return BooleanValue.TRUE;
    }

    public static Value end(Value value) {
        if (value instanceof ArrayValue) {
            ArrayValue array = (ArrayValue)value;
            return array.end();
        }
        return BooleanValue.FALSE;
    }

    public static boolean array_key_exists(Env env, @ReadOnly Value key, @ReadOnly Value searchArray) {
        if (!searchArray.isset() || !key.isset()) {
            return false;
        }
        if (!searchArray.isArray() && !searchArray.isObject()) {
            env.warning(L.l("'" + searchArray.toString() + "' is an unexpected argument, expected ArrayValue or ObjectValue"));
            return false;
        }
        if (!key.isString() && !key.isLongConvertible()) {
            env.warning(L.l("The first argument (a '{0}') should be either a string or an integer", (Object)key.getType()));
            return false;
        }
        if (searchArray instanceof ArrayValue) {
            return ((ArrayValue)searchArray).containsKey(key) != null;
        }
        return !searchArray.getField(env, key.toString()).isNull();
    }

    public static boolean key_exists(Env env, @ReadOnly Value key, @ReadOnly Value searchArray) {
        return ArrayModule.array_key_exists(env, key, searchArray);
    }

    public Value array_keys(Env env, @ReadOnly ArrayValue array, @Optional @ReadOnly Value searchValue, @Optional boolean isStrict) {
        if (array == null) {
            return NullValue.NULL;
        }
        ArrayValueImpl newArray = new ArrayValueImpl(array.getSize());
        for (Map.Entry<Value, Value> entry : array.entrySet()) {
            Value entryValue = entry.getValue();
            Value entryKey = entry.getKey();
            if (searchValue == null || searchValue instanceof DefaultValue) {
                ((ArrayValue)newArray).put(entryKey);
                continue;
            }
            if (!entryValue.eq(searchValue)) continue;
            ((ArrayValue)newArray).put(entryKey);
        }
        return newArray;
    }

    public Value array_fill(Env env, long start, long num, Value value) {
        if (num < 0L) {
            env.warning("Number of elements must be positive");
            return BooleanValue.FALSE;
        }
        ArrayValueImpl array = new ArrayValueImpl();
        for (long k = start; k < num + start; ++k) {
            ((ArrayValue)array).put(LongValue.create(k), value);
        }
        return array;
    }

    public Value array_flip(Env env, ArrayValue array) {
        if (array == null) {
            return BooleanValue.FALSE;
        }
        ArrayValueImpl newArray = new ArrayValueImpl();
        for (Map.Entry<Value, Value> entry : array.entrySet()) {
            Value entryValue = entry.getValue();
            if (entryValue.isLongConvertible() || entryValue instanceof StringValue) {
                ((ArrayValue)newArray).put(entryValue, entry.getKey());
                continue;
            }
            env.warning("Can only flip STRING and INTEGER values!");
        }
        return newArray;
    }

    public Value array_pad(Env env, ArrayValue input, long padSize, Value padValue) {
        if (input == null) {
            return NullValue.NULL;
        }
        long inputSize = input.getSize();
        long size = Math.abs(padSize);
        if ((long)input.getSize() >= size) {
            return input;
        }
        if (size - inputSize > 0x100000L) {
            env.warning("You may only pad up to 1048576 elements at a time");
            return BooleanValue.FALSE;
        }
        ArrayValueImpl paddedArray = new ArrayValueImpl();
        boolean padFront = padSize < 0L;
        Iterator<Value> keyIterator = input.keySet().iterator();
        for (long ctr = 0L; ctr < size; ++ctr) {
            Value newValue = padFront && ctr < size - inputSize ? padValue : (!padFront && ctr >= inputSize ? padValue : input.get(keyIterator.next()));
            ((ArrayValue)paddedArray).put(LongValue.create(ctr), newValue);
        }
        return paddedArray;
    }

    public Value array_filter(Env env, ArrayValue array, @Optional Callback callback) {
        if (array == null) {
            return NullValue.NULL;
        }
        ArrayValueImpl filteredArray = new ArrayValueImpl();
        if (callback != null) {
            if (!callback.isValid()) {
                env.warning("The second argument, '" + ((CallbackFunction)callback).getFunctionName() + "', should be a valid callback");
                return NullValue.NULL;
            }
            try {
                Iterator<Value> iter = array.getKeyIterator(env);
                while (iter.hasNext()) {
                    Value val;
                    Value key = iter.next();
                    boolean isMatch = callback.call(env, array, key, val = array.getRaw(key)).toBoolean();
                    if (!isMatch) continue;
                    ((ArrayValue)filteredArray).put(key, val);
                }
            }
            catch (Throwable t) {
                log.log(Level.WARNING, t.toString(), t);
                env.warning("An error occurred while invoking the filter callback");
                return NullValue.NULL;
            }
        } else {
            for (Map.Entry<Value, Value> entry : array.entrySet()) {
                if (!entry.getValue().toBoolean()) continue;
                ((ArrayValue)filteredArray).put(entry.getKey(), entry.getValue());
            }
        }
        return filteredArray;
    }

    public Value array_product(Env env, ArrayValue array) {
        if (array == null) {
            return NullValue.NULL;
        }
        if (array.getSize() == 0) {
            return DoubleValue.create(0.0);
        }
        double product = 1.0;
        for (Map.Entry<Value, Value> entry : array.entrySet()) {
            product *= entry.getValue().toDouble();
        }
        return DoubleValue.create(product);
    }

    public int array_push(Env env, ArrayValue array, Value[] values) {
        for (Value value : values) {
            array.put(value);
        }
        return array.getSize();
    }

    public Value array_rand(Env env, ArrayValue array, @Optional(value="1") long num) {
        if (array == null) {
            return NullValue.NULL;
        }
        if (array.getSize() == 0) {
            return NullValue.NULL;
        }
        if (num < 1L || (long)array.getSize() < num) {
            env.warning("Second argument has to be between 1 and the number of elements in the array");
            return NullValue.NULL;
        }
        long arraySize = array.getSize();
        Value[] keys = new Value[(int)arraySize];
        array.keySet().toArray(keys);
        if (num == 1L) {
            int index = (int)(RandomUtil.getRandomLong() % arraySize);
            if (index < 0) {
                index *= -1;
            }
            return keys[index];
        }
        int length = keys.length;
        for (int i = 0; i < length; ++i) {
            int rand = RandomUtil.nextInt((int)length);
            Value temp = keys[rand];
            keys[rand] = keys[i];
            keys[i] = temp;
        }
        ArrayValueImpl randArray = new ArrayValueImpl();
        int i = 0;
        while ((long)i < num) {
            ((ArrayValue)randArray).put(keys[i]);
            ++i;
        }
        return randArray;
    }

    public Value array_reduce(Env env, ArrayValue array, Callback callback, @Optional(value="NULL") Value initialValue) {
        if (array == null) {
            return NullValue.NULL;
        }
        if (callback == null || !callback.isValid()) {
            env.warning("The second argument, '" + callback + "', should be a valid callback");
            return NullValue.NULL;
        }
        Value result = initialValue;
        for (Map.Entry<Value, Value> entry : array.entrySet()) {
            try {
                result = callback.call(env, result, entry.getValue());
            }
            catch (Throwable t) {
                log.log(Level.WARNING, t.toString(), t);
                env.warning("An error occurred while invoking the reduction callback");
                return NullValue.NULL;
            }
        }
        return result;
    }

    public Value array_reverse(Env env, ArrayValue inputArray, @Optional(value="false") boolean keyed) {
        if (inputArray == null) {
            return NullValue.NULL;
        }
        Map.Entry[] entryArray = new Map.Entry[inputArray.getSize()];
        inputArray.entrySet().toArray(entryArray);
        ArrayValueImpl newArray = new ArrayValueImpl();
        int newIndex = 0;
        for (int index = entryArray.length - 1; index > -1; --index) {
            Value currentKey = (Value)entryArray[index].getKey();
            Value currentValue = (Value)entryArray[index].getValue();
            if (keyed || currentKey instanceof StringValue) {
                ((ArrayValue)newArray).put(currentKey, currentValue);
                continue;
            }
            ((ArrayValue)newArray).put(LongValue.create(newIndex), currentValue);
            ++newIndex;
        }
        return newArray;
    }

    public Value array_search(Env env, @ReadOnly Value needle, @ReadOnly ArrayValue array, @Optional(value="false") boolean strict) {
        if (array == null) {
            return BooleanValue.FALSE;
        }
        Iterator<Map.Entry<Value, Value>> iterator = array.getIterator(env);
        while (iterator.hasNext()) {
            Map.Entry<Value, Value> entry = iterator.next();
            Value entryValue = entry.getValue();
            Value entryKey = entry.getKey();
            if (!needle.eq(entryValue)) continue;
            if (strict) {
                if (!entryValue.getType().equals(needle.getType())) continue;
                return entryKey;
            }
            return entryKey;
        }
        return BooleanValue.FALSE;
    }

    public Value array_shift(Env env, ArrayValue array) {
        if (array == null) {
            return NullValue.NULL;
        }
        if (array.getSize() < 1) {
            return NullValue.NULL;
        }
        Iterator<Value> iterator = array.keySet().iterator();
        Value firstValue = array.remove(iterator.next());
        array.keyReset(0L, false);
        return firstValue;
    }

    public Value array_slice(Env env, ArrayValue array, long offset, @Optional(value="NULL") Value elements, @Optional(value="false") boolean presKeys) {
        if (array == null) {
            return NullValue.NULL;
        }
        long size = array.getSize();
        long startIndex = offset;
        if (offset < 0L) {
            startIndex = size + offset;
        }
        long endIndex = size;
        if (elements != NullValue.NULL) {
            endIndex = elements.toLong();
            endIndex = endIndex < 0L ? (endIndex += size) : (endIndex += startIndex);
        }
        Iterator<Map.Entry<Value, Value>> iterator = array.entrySet().iterator();
        ArrayValueImpl slicedArray = new ArrayValueImpl();
        int k = 0;
        while ((long)k < endIndex && iterator.hasNext()) {
            Map.Entry<Value, Value> entry = iterator.next();
            if ((long)k >= startIndex) {
                Value entryKey = entry.getKey();
                Value entryValue = entry.getValue();
                if (entryKey instanceof StringValue || presKeys) {
                    ((ArrayValue)slicedArray).put(entryKey, entryValue);
                } else {
                    ((ArrayValue)slicedArray).put(entryValue);
                }
            }
            ++k;
        }
        return slicedArray;
    }

    public Value array_splice(Env env, @Reference Value arrayVar, int offset, @Optional(value="NULL") Value length, @Optional Value replace) {
        if (!arrayVar.isset()) {
            return NullValue.NULL;
        }
        ArrayValue array = arrayVar.toArrayValue(env);
        if (array == null) {
            return NullValue.NULL;
        }
        int size = array.getSize();
        int startIndex = offset;
        if (startIndex < 0) {
            startIndex += size;
        }
        int endIndex = size;
        if (length != NullValue.NULL) {
            endIndex = length.toInt();
            endIndex = endIndex < 0 ? (endIndex += size) : (endIndex += startIndex);
        }
        return this.spliceImpl(arrayVar, array, startIndex, endIndex, (ArrayValue)replace.toArray());
    }

    public Value spliceImpl(Value var, ArrayValue array, int start, int end, ArrayValue replace) {
        int index = 0;
        ArrayValueImpl newArray = new ArrayValueImpl();
        ArrayValueImpl result = new ArrayValueImpl();
        var.set(newArray);
        for (ArrayValue.Entry ptr = array.getHead(); ptr != null; ptr = ptr.getNext()) {
            Value key = ptr.getKey();
            if (start == index && replace != null) {
                for (ArrayValue.Entry replaceEntry = replace.getHead(); replaceEntry != null; replaceEntry = replaceEntry.getNext()) {
                    ((ArrayValue)newArray).put(replaceEntry.getValue());
                }
            }
            if (start <= index && index < end) {
                if (ptr.getKey() instanceof StringValue) {
                    ((ArrayValue)result).put(ptr.getKey(), ptr.getValue());
                } else {
                    ((ArrayValue)result).put(ptr.getValue());
                }
            } else if (ptr.getKey() instanceof StringValue) {
                ((ArrayValue)newArray).put(ptr.getKey(), ptr.getValue());
            } else {
                ((ArrayValue)newArray).put(ptr.getValue());
            }
            ++index;
        }
        if (index <= start && replace != null) {
            for (ArrayValue.Entry replaceEntry = replace.getHead(); replaceEntry != null; replaceEntry = replaceEntry.getNext()) {
                ((ArrayValue)newArray).put(replaceEntry.getValue());
            }
        }
        return result;
    }

    public Value array_sum(Env env, @ReadOnly ArrayValue array) {
        if (array == null) {
            return NullValue.NULL;
        }
        double sum = 0.0;
        for (Map.Entry<Value, Value> entry : array.entrySet()) {
            sum += entry.getValue().toDouble();
        }
        return DoubleValue.create(sum);
    }

    public Value array_unique(Env env, ArrayValue array) {
        if (array == null) {
            return BooleanValue.FALSE;
        }
        array.sort(CNO_VALUE_NORMAL, false, false);
        Map.Entry<Value, Value> lastEntry = null;
        ArrayValueImpl uniqueArray = new ArrayValueImpl();
        for (Map.Entry<Value, Value> entry : array.entrySet()) {
            Value entryValue = entry.getValue();
            if (lastEntry == null) {
                ((ArrayValue)uniqueArray).put(entry.getKey(), entryValue);
                lastEntry = entry;
                continue;
            }
            Value lastEntryValue = (Value)lastEntry.getValue();
            if (!entryValue.toString().equals(lastEntryValue.toString())) {
                ((ArrayValue)uniqueArray).put(entry.getKey(), entryValue);
            }
            lastEntry = entry;
        }
        uniqueArray.sort(CNO_KEY_NORMAL, false, false);
        return uniqueArray;
    }

    public Value array_unshift(Env env, ArrayValue array, Value[] values) {
        if (array == null) {
            return NullValue.NULL;
        }
        for (int i = values.length - 1; i >= 0; --i) {
            array.unshift(values[i]);
        }
        array.keyReset(0L, false);
        return array;
    }

    public Value array_values(Env env, ArrayValue array) {
        if (array == null) {
            return NullValue.NULL;
        }
        ArrayValueImpl arrayValues = new ArrayValueImpl();
        for (Map.Entry<Value, Value> entry : array.entrySet()) {
            ((ArrayValue)arrayValues).put(entry.getValue());
        }
        return arrayValues;
    }

    public boolean array_walk(Env env, @NotNull ArrayValue array, Callback callback, @Optional(value="NULL") Value userData) {
        if (callback == null || !callback.isValid()) {
            env.error(L.l("'{0}' is an unknown function", (Object)callback.getCallbackName()));
            return false;
        }
        if (array == null) {
            return false;
        }
        try {
            Value[] keyArray = array.getKeyArray(env);
            for (int i = 0; i < keyArray.length; ++i) {
                Value key = keyArray[i];
                Value val = array.getRaw(key);
                callback.call(env, array, key, val, key, userData);
            }
            return true;
        }
        catch (Exception e) {
            log.log(Level.WARNING, e.toString(), e);
            env.warning("An error occured while invoking the callback", (Throwable)e);
            return false;
        }
    }

    public boolean array_walk_recursive(Env env, @NotNull ArrayValue array, Callback callback, @Optional(value="NULL") Value extra) {
        if (callback == null || !callback.isValid()) {
            env.error(L.l("'{0}' is an unknown function", (Object)callback.getCallbackName()));
            return false;
        }
        if (array == null) {
            return false;
        }
        try {
            Value[] keyArray = array.getKeyArray(env);
            for (int i = 0; i < keyArray.length; ++i) {
                Value key = keyArray[i];
                Value val = array.getRaw(key);
                if (val.isArray()) {
                    boolean result = this.array_walk_recursive(env, (ArrayValue)val.toValue(), callback, extra);
                    if (result) continue;
                    return false;
                }
                callback.call(env, array, key, val, key, extra);
            }
            return true;
        }
        catch (Exception e) {
            log.log(Level.WARNING, e.toString(), e);
            env.warning("An error occured while invoking the callback", (Throwable)e);
            return false;
        }
    }

    public boolean arsort(Env env, ArrayValue array, @Optional long sortFlag) {
        if (array == null) {
            return false;
        }
        switch ((int)sortFlag) {
            case 2: {
                array.sort(CS_VALUE_REVERSE, false, false);
                break;
            }
            case 1: {
                array.sort(CN_VALUE_REVERSE, false, false);
                break;
            }
            case 5: {
                Locale locale = env.getLocaleInfo().getCollate();
                array.sort(new CompareLocale(ArrayValue.GET_VALUE, -1, Collator.getInstance(locale)), false, false);
                break;
            }
            default: {
                array.sort(CNO_VALUE_REVERSE, false, false);
            }
        }
        return true;
    }

    public static boolean asort(Env env, ArrayValue array, @Optional long sortFlag) {
        if (array == null) {
            return false;
        }
        switch ((int)sortFlag) {
            case 2: {
                array.sort(CS_VALUE_NORMAL, false, false);
                break;
            }
            case 1: {
                array.sort(CN_VALUE_NORMAL, false, false);
                break;
            }
            case 5: {
                Locale locale = env.getLocaleInfo().getCollate();
                array.sort(new CompareLocale(ArrayValue.GET_VALUE, 1, Collator.getInstance(locale)), false, false);
                break;
            }
            default: {
                array.sort(CNO_VALUE_NORMAL, false, false);
            }
        }
        return true;
    }

    public static boolean ksort(Env env, ArrayValue array, @Optional long sortFlag) {
        if (array == null) {
            return false;
        }
        switch ((int)sortFlag) {
            case 2: {
                array.sort(CS_KEY_NORMAL, false, false);
                break;
            }
            case 1: {
                array.sort(CN_KEY_NORMAL, false, false);
                break;
            }
            case 5: {
                Locale locale = env.getLocaleInfo().getCollate();
                array.sort(new CompareLocale(ArrayValue.GET_KEY, 1, Collator.getInstance(locale)), false, false);
                break;
            }
            default: {
                array.sort(CNO_KEY_NORMAL, false, false);
            }
        }
        return true;
    }

    public boolean krsort(Env env, ArrayValue array, @Optional long sortFlag) {
        if (array == null) {
            return false;
        }
        switch ((int)sortFlag) {
            case 2: {
                array.sort(CS_KEY_REVERSE, false, false);
                break;
            }
            case 1: {
                array.sort(CN_KEY_REVERSE, false, false);
                break;
            }
            case 5: {
                Locale locale = env.getLocaleInfo().getCollate();
                array.sort(new CompareLocale(ArrayValue.GET_KEY, -1, Collator.getInstance(locale)), false, false);
                break;
            }
            default: {
                array.sort(CNO_KEY_REVERSE, false, false);
            }
        }
        return true;
    }

    public static Value natsort(ArrayValue array) {
        if (array == null) {
            return NullValue.NULL;
        }
        ArrayModule.trimArrayStrings(array);
        array.sort(CNA_VALUE_NORMAL_SENSITIVE, false, false);
        return BooleanValue.TRUE;
    }

    public static Value natcasesort(ArrayValue array) {
        if (array == null) {
            return NullValue.NULL;
        }
        ArrayModule.trimArrayStrings(array);
        array.sort(CNA_VALUE_NORMAL_INSENSITIVE, false, false);
        return BooleanValue.TRUE;
    }

    private static void trimArrayStrings(ArrayValue array) {
        if (array != null) {
            for (Map.Entry<Value, Value> entry : array.entrySet()) {
                Value entryValue = entry.getValue();
                if (!(entryValue instanceof StringValue)) continue;
                array.put(entry.getKey(), StringValue.create(entryValue.toString().trim()));
            }
        }
    }

    public boolean in_array(@ReadOnly Value needle, @ReadOnly ArrayValue stack, @Optional(value="false") boolean strict) {
        if (stack == null) {
            return false;
        }
        if (strict) {
            return stack.containsStrict(needle) != NullValue.NULL;
        }
        return stack.contains(needle) != NullValue.NULL;
    }

    public boolean sort(Env env, ArrayValue array, @Optional long sortFlag) {
        if (array == null) {
            return false;
        }
        switch ((int)sortFlag) {
            case 2: {
                array.sort(CS_VALUE_NORMAL, true, true);
                break;
            }
            case 1: {
                array.sort(CN_VALUE_NORMAL, true, true);
                break;
            }
            case 5: {
                Locale locale = env.getLocaleInfo().getCollate();
                array.sort(new CompareLocale(ArrayValue.GET_VALUE, 1, Collator.getInstance(locale)), true, true);
                break;
            }
            default: {
                array.sort(CNO_VALUE_NORMAL, true, true);
            }
        }
        return true;
    }

    public boolean rsort(Env env, ArrayValue array, @Optional long sortFlag) {
        if (array == null) {
            return false;
        }
        switch ((int)sortFlag) {
            case 2: {
                array.sort(CS_VALUE_REVERSE, true, true);
                break;
            }
            case 1: {
                array.sort(CN_VALUE_REVERSE, true, true);
                break;
            }
            case 5: {
                Locale locale = env.getLocaleInfo().getCollate();
                array.sort(new CompareLocale(ArrayValue.GET_VALUE, -1, Collator.getInstance(locale)), true, true);
                break;
            }
            default: {
                array.sort(CNO_VALUE_REVERSE, true, true);
            }
        }
        return true;
    }

    public boolean usort(Env env, ArrayValue array, Callback func, @Optional long sortFlag) {
        if (array == null) {
            return false;
        }
        if (!func.isValid()) {
            env.warning(L.l("Invalid comparison function"));
            return false;
        }
        CompareCallBack cmp = new CompareCallBack(ArrayValue.GET_VALUE, 1, func, env);
        array.sort(cmp, true, true);
        return true;
    }

    public static boolean uasort(Env env, ArrayValue array, Callback func, @Optional long sortFlag) {
        if (array == null) {
            return false;
        }
        if (!func.isValid()) {
            env.warning(L.l("Invalid comparison function"));
            return false;
        }
        array.sort(new CompareCallBack(ArrayValue.GET_VALUE, 1, func, env), false, false);
        return true;
    }

    public static boolean uksort(Env env, ArrayValue array, Callback func, @Optional long sortFlag) {
        if (array == null) {
            return false;
        }
        if (!func.isValid()) {
            env.warning(L.l("Invalid comparison function"));
            return false;
        }
        CompareCallBack cmp = new CompareCallBack(ArrayValue.GET_KEY, 1, func, env);
        array.sort(cmp, false, false);
        return true;
    }

    public Value range(Env env, @ReadOnly Value start, @ReadOnly Value end, @Optional(value="1") long step) {
        if (step < 1L) {
            step = 1L;
        }
        if (!start.getType().equals(end.getType())) {
            start = LongValue.create(start.toLong());
            end = LongValue.create(end.toLong());
        } else if (Character.isDigit(start.toChar())) {
            start = LongValue.create(start.toLong());
            end = LongValue.create(end.toLong());
        } else {
            start = this.rangeIncrement(start, 0L);
            end = this.rangeIncrement(end, 0L);
        }
        if (!start.eq(end)) {
            if (start instanceof StringValue && (long)Math.abs(end.toChar() - start.toChar()) < step) {
                env.warning("steps exceeds the specified range");
                return BooleanValue.FALSE;
            }
            if (start instanceof LongValue && Math.abs(end.toLong() - start.toLong()) < step) {
                env.warning("steps exceeds the specified range");
                return BooleanValue.FALSE;
            }
        }
        boolean increment = true;
        if (!end.geq(start)) {
            step *= -1L;
            increment = false;
        }
        ArrayValueImpl array = new ArrayValueImpl();
        do {
            ((ArrayValue)array).put(start);
            start = this.rangeIncrement(start, step);
        } while (increment && start.leq(end) || !increment && start.geq(end));
        return array;
    }

    private Value rangeIncrement(Value value, long step) {
        if (value instanceof StringValue) {
            return StringValue.create((char)((long)value.toChar() + step));
        }
        return LongValue.create(value.toLong() + step);
    }

    @UsesSymbolTable
    public static Value extract(Env env, ArrayValue array, @Optional(value="EXTR_OVERWRITE") long rawType, @Optional(value="NULL") Value valuePrefix) {
        boolean extrRefs;
        if (array == null) {
            return NullValue.NULL;
        }
        long extractType = rawType & 0xFFFFFFFFFFFFFEFFL;
        boolean bl = extrRefs = (rawType & 0x100L) != 0L;
        if (extractType < 0L || extractType > 6L && extractType != 256L) {
            env.warning("Unknown extract type");
            return NullValue.NULL;
        }
        if (!(extractType < 2L || extractType > 5L || valuePrefix != null && valuePrefix instanceof StringValue)) {
            env.warning("Prefix expected to be specified");
            return NullValue.NULL;
        }
        String prefix = "";
        if (valuePrefix instanceof StringValue) {
            prefix = valuePrefix.toString() + "_";
        }
        int completedSymbols = 0;
        for (Value entryKey : array.keySet()) {
            Value entryValue = extrRefs ? array.getRef(entryKey) : array.get(entryKey);
            String symbolName = entryKey.toString();
            Value tableValue = env.getValue(symbolName);
            switch ((int)extractType) {
                case 1: {
                    if (tableValue == NullValue.NULL) break;
                    symbolName = "";
                    break;
                }
                case 2: {
                    if (tableValue == NullValue.NULL) break;
                    symbolName = prefix + symbolName;
                    break;
                }
                case 3: {
                    symbolName = prefix + symbolName;
                    break;
                }
                case 4: {
                    if (ArrayModule.validVariableName(symbolName)) break;
                    symbolName = prefix + symbolName;
                    break;
                }
                case 6: {
                    if (tableValue != NullValue.NULL) break;
                    symbolName = "";
                    break;
                }
                case 5: {
                    if (tableValue != NullValue.NULL) {
                        symbolName = prefix + symbolName;
                        break;
                    }
                    symbolName = "";
                    break;
                }
            }
            if (!ArrayModule.validVariableName(symbolName)) continue;
            env.setValue(symbolName, entryValue);
            ++completedSymbols;
        }
        return LongValue.create(completedSymbols);
    }

    private static boolean validVariableName(String variableName) {
        if (variableName.length() < 1) {
            return false;
        }
        char checkChar = variableName.charAt(0);
        if (!Character.isLetter(checkChar) && checkChar != '_') {
            return false;
        }
        for (int k = 1; k < variableName.length(); ++k) {
            checkChar = variableName.charAt(k);
            if (Character.isLetterOrDigit(checkChar) || checkChar == '_') continue;
            return false;
        }
        return true;
    }

    public Value array_diff(Env env, ArrayValue array, Value[] arrays) {
        if (array == null) {
            return NullValue.NULL;
        }
        if (arrays.length < 1) {
            env.warning("Wrong parameter count for array_diff()");
            return NullValue.NULL;
        }
        ArrayValueImpl diffArray = new ArrayValueImpl();
        for (Map.Entry<Value, Value> entry : array.entrySet()) {
            boolean valueFound = false;
            Value entryValue = entry.getValue();
            for (int k = 0; k < arrays.length && !valueFound; ++k) {
                if (!(arrays[k] instanceof ArrayValue)) {
                    env.warning("Argument #" + (k + 2) + " is not an array");
                    return NullValue.NULL;
                }
                valueFound = ((ArrayValue)arrays[k]).contains(entryValue) != NullValue.NULL;
            }
            if (valueFound) continue;
            ((ArrayValue)diffArray).put(entry.getKey(), entryValue);
        }
        return diffArray;
    }

    public Value array_diff_assoc(Env env, ArrayValue array, Value[] arrays) {
        if (array == null) {
            return NullValue.NULL;
        }
        if (arrays.length < 1) {
            env.warning("Wrong parameter count for array_diff()");
            return NullValue.NULL;
        }
        ArrayValueImpl diffArray = new ArrayValueImpl();
        for (Map.Entry<Value, Value> entry : array.entrySet()) {
            boolean valueFound = false;
            Value entryValue = entry.getValue();
            Value entryKey = entry.getKey();
            for (int k = 0; k < arrays.length && !valueFound; ++k) {
                if (!(arrays[k] instanceof ArrayValue)) {
                    env.warning("Argument #" + (k + 2) + " is not an array");
                    return NullValue.NULL;
                }
                valueFound = ((ArrayValue)arrays[k]).contains(entryValue).eq(entryKey);
            }
            if (valueFound) continue;
            ((ArrayValue)diffArray).put(entryKey, entryValue);
        }
        return diffArray;
    }

    public Value array_diff_key(Env env, ArrayValue array, Value[] arrays) {
        if (array == null) {
            return NullValue.NULL;
        }
        if (arrays.length < 1) {
            env.warning("Wrong parameter count for array_diff()");
            return NullValue.NULL;
        }
        ArrayValueImpl diffArray = new ArrayValueImpl();
        for (Map.Entry<Value, Value> entry : array.entrySet()) {
            boolean keyFound = false;
            Value entryKey = entry.getKey();
            for (int k = 0; k < arrays.length && !keyFound; ++k) {
                if (!(arrays[k] instanceof ArrayValue)) {
                    env.warning("Argument #" + (k + 2) + " is not an array");
                    return NullValue.NULL;
                }
                keyFound = ((ArrayValue)arrays[k]).containsKey(entryKey) != null;
            }
            if (keyFound) continue;
            ((ArrayValue)diffArray).put(entryKey, entry.getValue());
        }
        return diffArray;
    }

    public Value array_diff_uassoc(Env env, ArrayValue array, Value[] arrays) {
        if (array == null) {
            return NullValue.NULL;
        }
        if (arrays.length < 2) {
            env.warning("Wrong parameter count for array_diff()");
            return NullValue.NULL;
        }
        AbstractFunction func = env.findFunction(arrays[arrays.length - 1].toString().intern());
        if (func == null) {
            env.warning("Invalid comparison function");
            return NullValue.NULL;
        }
        ArrayValueImpl diffArray = new ArrayValueImpl();
        for (Map.Entry<Value, Value> entry : array.entrySet()) {
            boolean ValueFound = false;
            Value entryValue = entry.getValue();
            Value entryKey = entry.getKey();
            for (int k = 0; k < arrays.length - 1 && !ValueFound; ++k) {
                if (!(arrays[k] instanceof ArrayValue)) {
                    env.warning("Argument #" + (k + 2) + " is not an array");
                    return NullValue.NULL;
                }
                Value searchKey = ((ArrayValue)arrays[k]).contains(entryValue);
                if (searchKey == NullValue.NULL) continue;
                ValueFound = (int)func.call(env, searchKey, entryKey).toLong() == 0;
            }
            if (ValueFound) continue;
            ((ArrayValue)diffArray).put(entryKey, entryValue);
        }
        return diffArray;
    }

    public Value array_diff_ukey(Env env, ArrayValue array, Value[] arrays) {
        if (array == null) {
            return NullValue.NULL;
        }
        if (arrays.length < 2) {
            env.warning("Wrong parameter count for array_diff()");
            return NullValue.NULL;
        }
        AbstractFunction func = env.findFunction(arrays[arrays.length - 1].toString().intern());
        if (func == null) {
            env.warning("Invalid comparison function");
            return NullValue.NULL;
        }
        ArrayValueImpl diffArray = new ArrayValueImpl();
        for (Map.Entry<Value, Value> entry : array.entrySet()) {
            boolean keyFound = false;
            Value entryKey = entry.getKey();
            for (int k = 0; k < arrays.length - 1 && !keyFound; ++k) {
                if (!(arrays[k] instanceof ArrayValue)) {
                    env.warning("Argument #" + (k + 2) + " is not an array");
                    return NullValue.NULL;
                }
                Iterator<Value> keyItr = ((ArrayValue)arrays[k]).keySet().iterator();
                keyFound = false;
                while (keyItr.hasNext() && !keyFound) {
                    Value currentKey = keyItr.next();
                    keyFound = (int)func.call(env, entryKey, currentKey).toLong() == 0;
                }
            }
            if (keyFound) continue;
            ((ArrayValue)diffArray).put(entryKey, entry.getValue());
        }
        return diffArray;
    }

    public Value array_intersect(Env env, ArrayValue array, Value[] arrays) {
        if (array == null) {
            return NullValue.NULL;
        }
        if (arrays.length < 1) {
            env.warning("Wrong parameter count for array_diff()");
            return NullValue.NULL;
        }
        ArrayValueImpl interArray = new ArrayValueImpl();
        for (Map.Entry<Value, Value> entry : array.entrySet()) {
            boolean valueFound = false;
            Value entryValue = entry.getValue();
            for (int k = 0; k < arrays.length; ++k) {
                if (!(arrays[k] instanceof ArrayValue)) {
                    env.warning("Argument #" + (k + 2) + " is not an array");
                    return NullValue.NULL;
                }
                if (k > 0 && !valueFound) break;
                valueFound = ((ArrayValue)arrays[k]).contains(entryValue) != NullValue.NULL;
            }
            if (!valueFound) continue;
            ((ArrayValue)interArray).put(entry.getKey(), entryValue);
        }
        return interArray;
    }

    public Value array_intersect_assoc(Env env, ArrayValue array, Value[] arrays) {
        if (array == null) {
            return NullValue.NULL;
        }
        if (arrays.length < 1) {
            env.warning("Wrong parameter count for array_diff()");
            return NullValue.NULL;
        }
        ArrayValueImpl interArray = new ArrayValueImpl();
        for (Map.Entry<Value, Value> entry : array.entrySet()) {
            boolean valueFound = false;
            Value entryKey = entry.getKey();
            Value entryValue = entry.getValue();
            for (int k = 0; k < arrays.length; ++k) {
                if (!(arrays[k] instanceof ArrayValue)) {
                    env.warning("Argument #" + (k + 2) + " is not an array");
                    return NullValue.NULL;
                }
                if (k > 0 && !valueFound) break;
                Value searchValue = ((ArrayValue)arrays[k]).containsKey(entryKey);
                valueFound = searchValue != null ? searchValue.eq(entryValue) : false;
            }
            if (!valueFound) continue;
            ((ArrayValue)interArray).put(entryKey, entryValue);
        }
        return interArray;
    }

    public Value array_intersect_key(Env env, ArrayValue array, Value[] arrays) {
        if (array == null) {
            return NullValue.NULL;
        }
        if (arrays.length < 1) {
            env.warning("Wrong parameter count for array_diff()");
            return NullValue.NULL;
        }
        ArrayValueImpl interArray = new ArrayValueImpl();
        for (Map.Entry<Value, Value> entry : array.entrySet()) {
            boolean keyFound = false;
            Value entryKey = entry.getKey();
            for (int k = 0; k < arrays.length; ++k) {
                if (!(arrays[k] instanceof ArrayValue)) {
                    env.warning("Argument #" + (k + 2) + " is not an array");
                    return NullValue.NULL;
                }
                if (k > 0 && !keyFound) break;
                keyFound = ((ArrayValue)arrays[k]).containsKey(entryKey) != null;
            }
            if (!keyFound) continue;
            ((ArrayValue)interArray).put(entryKey, entry.getValue());
        }
        return interArray;
    }

    public Value array_intersect_uassoc(Env env, ArrayValue array, Value[] arrays) {
        if (array == null) {
            return NullValue.NULL;
        }
        if (arrays.length < 2) {
            env.warning("Wrong parameter count for array_diff()");
            return NullValue.NULL;
        }
        AbstractFunction func = env.findFunction(arrays[arrays.length - 1].toString().intern());
        if (func == null) {
            env.warning("Invalid comparison function");
            return NullValue.NULL;
        }
        ArrayValueImpl interArray = new ArrayValueImpl();
        for (Map.Entry<Value, Value> entry : array.entrySet()) {
            boolean valueFound = false;
            Value entryKey = entry.getKey();
            Value entryValue = entry.getValue();
            for (int k = 0; k < arrays.length - 1; ++k) {
                if (!(arrays[k] instanceof ArrayValue)) {
                    env.warning("Argument #" + (k + 2) + " is not an array");
                    return NullValue.NULL;
                }
                if (k > 0 && !valueFound) break;
                Value searchValue = ((ArrayValue)arrays[k]).containsKey(entryKey);
                valueFound = searchValue != null ? func.call(env, searchValue, entryValue).toLong() == 0L : false;
            }
            if (!valueFound) continue;
            ((ArrayValue)interArray).put(entryKey, entryValue);
        }
        return interArray;
    }

    public Value array_intersect_ukey(Env env, ArrayValue array, Value[] arrays) {
        if (array == null) {
            return NullValue.NULL;
        }
        if (arrays.length < 2) {
            env.warning("Wrong parameter count for array_diff()");
            return NullValue.NULL;
        }
        AbstractFunction func = env.findFunction(arrays[arrays.length - 1].toString().intern());
        if (func == null) {
            env.warning("Invalid comparison function");
            return NullValue.NULL;
        }
        ArrayValueImpl interArray = new ArrayValueImpl();
        for (Map.Entry<Value, Value> entry : array.entrySet()) {
            boolean keyFound = false;
            Value entryKey = entry.getKey();
            for (int k = 0; k < arrays.length - 1; ++k) {
                if (!(arrays[k] instanceof ArrayValue)) {
                    env.warning("Argument #" + (k + 2) + " is not an array");
                    return NullValue.NULL;
                }
                if (k > 0 && !keyFound) break;
                Iterator<Value> keyItr = ((ArrayValue)arrays[k]).keySet().iterator();
                keyFound = false;
                while (keyItr.hasNext() && !keyFound) {
                    Value currentKey = keyItr.next();
                    keyFound = (int)func.call(env, entryKey, currentKey).toLong() == 0;
                }
            }
            if (!keyFound) continue;
            ((ArrayValue)interArray).put(entryKey, entry.getValue());
        }
        return interArray;
    }

    public Value array_map(Env env, Callback fun, ArrayValue arg, Value[] args) {
        Iterator<Map.Entry<Value, Value>> argIter = arg.entrySet().iterator();
        Iterator[] iters = new Iterator[args.length];
        for (int i = 0; i < args.length; ++i) {
            if (!(args[i] instanceof ArrayValue)) {
                throw env.createErrorException(L.l("expected array"));
            }
            ArrayValue argArray = (ArrayValue)args[i];
            iters[i] = argArray.values().iterator();
        }
        ArrayValueImpl resultArray = new ArrayValueImpl();
        Value[] param = new Value[args.length + 1];
        while (argIter.hasNext()) {
            Map.Entry<Value, Value> entry = argIter.next();
            param[0] = entry.getValue();
            for (int i = 0; i < iters.length; ++i) {
                param[i + 1] = (Value)iters[i].next();
                if (param[i + 1] != null) continue;
                param[i + 1] = NullValue.NULL;
            }
            ((ArrayValue)resultArray).put(entry.getKey(), fun.call(env, param));
        }
        return resultArray;
    }

    public Value array_merge(Value[] args) {
        ArrayValueImpl result = new ArrayValueImpl();
        for (Value arg : args) {
            if (arg.isNull()) {
                return NullValue.NULL;
            }
            if (!(arg.toValue() instanceof ArrayValue)) continue;
            ArrayValue array = (ArrayValue)arg.toValue();
            for (Map.Entry<Value, Value> entry : array.entrySet()) {
                Value key = entry.getKey();
                Value value = entry.getValue();
                if (key.isNumberConvertible()) {
                    ((ArrayValue)result).put(value);
                    continue;
                }
                ((ArrayValue)result).put(key, value);
            }
        }
        return result;
    }

    public Value array_merge_recursive(Value[] args) {
        ArrayValueImpl result = new ArrayValueImpl();
        for (Value arg : args) {
            if (!(arg.toValue() instanceof ArrayValue)) continue;
            ArrayModule.arrayMergeRecursiveImpl(result, (ArrayValue)arg.toValue());
        }
        return result;
    }

    private static void arrayMergeRecursiveImpl(ArrayValue result, ArrayValue array) {
        for (Map.Entry<Value, Value> entry : array.entrySet()) {
            Value key = entry.getKey();
            Value value = entry.getValue().toValue();
            if (key.isNumberConvertible()) {
                result.put(value);
                continue;
            }
            Value oldValue = result.get(key).toValue();
            if (oldValue != null && oldValue.isset()) {
                if (oldValue.isArray() && value.isArray()) {
                    ArrayModule.arrayMergeRecursiveImpl((ArrayValue)oldValue, (ArrayValue)value);
                    continue;
                }
                if (oldValue.isArray()) {
                    oldValue.put(value);
                    continue;
                }
                if (value.isArray()) {
                    value.put(oldValue);
                    continue;
                }
                ArrayValueImpl newArray = new ArrayValueImpl();
                ((ArrayValue)newArray).put(oldValue);
                ((ArrayValue)newArray).put(value);
                result.put(key, newArray);
                continue;
            }
            result.put(key, value);
        }
    }

    public static boolean array_multisort(Env env, Value[] arrays) {
        int i;
        boolean isNewKeys = true;
        if (arrays.length == 0 || !arrays[0].isArray()) {
            env.warning("the first argument must be an array");
            return false;
        }
        Value primary = arrays[0];
        Iterator<Value> keyIter = primary.getKeyIterator(env);
        while (keyIter.hasNext()) {
            if (keyIter.next() instanceof LongValue) continue;
            isNewKeys = false;
            break;
        }
        Value[] rows = primary.getKeyArray(env);
        int maxsize = 0;
        for (int i2 = 0; i2 < arrays.length; ++i2) {
            if (!(arrays[i2] instanceof ArrayValue)) continue;
            maxsize = Math.max(maxsize, arrays[i2].getSize());
        }
        Value[] p = new LongValue[maxsize];
        for (i = 0; i < rows.length; ++i) {
            p[i] = LongValue.create(i);
        }
        Arrays.sort(p, new MultiSortComparator(env, rows, arrays));
        for (i = 0; i < arrays.length; ++i) {
            if (!arrays[i].isArray()) continue;
            ArrayModule.permute(env, (ArrayValue)arrays[i], p, isNewKeys);
        }
        return true;
    }

    private static void permute(Env env, ArrayValue array, Value[] permutation, boolean isNewKeys) {
        Value[] keys = array.getKeyArray(env);
        Value[] values = array.getValueArray(env);
        array.clear();
        if (isNewKeys) {
            for (int i = 0; i < permutation.length; ++i) {
                int p = permutation[i].toInt();
                Value value = values[p];
                array.put(LongValue.create(i), value.toValue().copy());
            }
        } else {
            for (int i = 0; i < permutation.length; ++i) {
                int p = permutation[i].toInt();
                Value key = keys[p];
                Value value = values[p];
                array.put(key, value.toValue().copy());
            }
        }
    }

    public Value array_udiff(Env env, Value[] arrays) {
        Callback cmp;
        if (arrays.length < 3) {
            env.warning("Wrong paremeter count for array_udiff()");
            return NullValue.NULL;
        }
        if (!(arrays[0] instanceof ArrayValue)) {
            env.warning("Argument #1 is not an array");
            return NullValue.NULL;
        }
        ArrayValue array = (ArrayValue)arrays[0];
        Value callbackValue = arrays[arrays.length - 1];
        try {
            cmp = env.createCallback(callbackValue);
        }
        catch (Throwable t) {
            log.log(Level.WARNING, t.toString(), t);
            env.warning("Not a valid callback " + callbackValue.toString());
            return NullValue.NULL;
        }
        if (cmp == null) {
            env.warning("Not a valid callback " + callbackValue.toString());
            return NullValue.NULL;
        }
        ArrayValueImpl diffArray = new ArrayValueImpl();
        boolean isFound = false;
        for (Value entryKey : array.keySet()) {
            Value entryValue = array.get(entryKey);
            block5: for (int k = 1; k < arrays.length - 1 && !isFound; ++k) {
                if (!(arrays[k] instanceof ArrayValue)) {
                    env.warning("Argument #" + (k + 1) + " is not an array");
                    return NullValue.NULL;
                }
                ArrayValue checkArray = (ArrayValue)arrays[k];
                for (Map.Entry<Value, Value> entry : checkArray.entrySet()) {
                    try {
                        isFound = cmp.call(env, entryValue, entry.getValue()).toLong() == 0L;
                    }
                    catch (Throwable t) {
                        log.log(Level.WARNING, t.toString(), t);
                        env.warning("An error occurred while invoking the filter callback");
                        return NullValue.NULL;
                    }
                    if (!isFound) continue;
                    continue block5;
                }
            }
            if (!isFound) {
                ((ArrayValue)diffArray).put(entryKey, entryValue);
            }
            isFound = false;
        }
        return diffArray;
    }

    public Value array_udiff_assoc(Env env, Value[] arrays) {
        Callback cmp;
        if (arrays.length < 3) {
            env.warning("Wrong paremeter count for array_udiff_assoc()");
            return NullValue.NULL;
        }
        if (!(arrays[0] instanceof ArrayValue)) {
            env.warning("Argument #1 is not an array");
            return NullValue.NULL;
        }
        ArrayValue array = (ArrayValue)arrays[0];
        Value callbackValue = arrays[arrays.length - 1];
        try {
            cmp = env.createCallback(callbackValue);
        }
        catch (Throwable t) {
            log.log(Level.WARNING, t.toString(), t);
            env.warning("Not a valid callback " + callbackValue.toString());
            return NullValue.NULL;
        }
        if (cmp == null) {
            env.warning("Not a valid callback " + callbackValue.toString());
            return NullValue.NULL;
        }
        ArrayValueImpl diffArray = new ArrayValueImpl();
        boolean isFound = false;
        for (Value entryKey : array.keySet()) {
            Value entryValue = array.get(entryKey);
            block5: for (int k = 1; k < arrays.length - 1 && !isFound; ++k) {
                if (!(arrays[k] instanceof ArrayValue)) {
                    env.warning("Argument #" + (k + 1) + " is not an array");
                    return NullValue.NULL;
                }
                ArrayValue checkArray = (ArrayValue)arrays[k];
                for (Map.Entry<Value, Value> entry : checkArray.entrySet()) {
                    try {
                        boolean keyFound = entryKey.eql(entry.getKey());
                        boolean valueFound = false;
                        if (keyFound) {
                            valueFound = cmp.call(env, entryValue, entry.getValue()).toLong() == 0L;
                        }
                        isFound = keyFound && valueFound;
                    }
                    catch (Throwable t) {
                        log.log(Level.WARNING, t.toString(), t);
                        env.warning("An error occurred while invoking the filter callback");
                        return NullValue.NULL;
                    }
                    if (!isFound) continue;
                    continue block5;
                }
            }
            if (!isFound) {
                ((ArrayValue)diffArray).put(entryKey, entryValue);
            }
            isFound = false;
        }
        return diffArray;
    }

    public Value array_udiff_uassoc(Env env, Value[] arrays) {
        Callback cmpKey;
        Callback cmpValue;
        if (arrays.length < 4) {
            env.warning("Wrong paremeter count for array_udiff_uassoc()");
            return NullValue.NULL;
        }
        if (!(arrays[0] instanceof ArrayValue)) {
            env.warning("Argument #1 is not an array");
            return NullValue.NULL;
        }
        ArrayValue array = (ArrayValue)arrays[0];
        Value callbackValue = arrays[arrays.length - 2];
        try {
            cmpValue = env.createCallback(callbackValue);
        }
        catch (Throwable t) {
            log.log(Level.WARNING, t.toString(), t);
            env.warning("Not a valid callback " + callbackValue.toString());
            return NullValue.NULL;
        }
        if (cmpValue == null) {
            env.warning("Not a valid callback " + callbackValue.toString());
            return NullValue.NULL;
        }
        Value callbackKey = arrays[arrays.length - 1];
        try {
            cmpKey = env.createCallback(callbackKey);
        }
        catch (Throwable t) {
            log.log(Level.WARNING, t.toString(), t);
            env.warning("Not a valid callback " + callbackKey.toString());
            return NullValue.NULL;
        }
        if (cmpKey == null) {
            env.warning("Not a valid callback " + callbackKey.toString());
            return NullValue.NULL;
        }
        ArrayValueImpl diffArray = new ArrayValueImpl();
        boolean isFound = false;
        for (Value entryKey : array.keySet()) {
            Value entryValue = array.get(entryKey);
            block7: for (int k = 1; k < arrays.length - 2 && !isFound; ++k) {
                if (!(arrays[k] instanceof ArrayValue)) {
                    env.warning("Argument #" + (k + 1) + " is not an array");
                    return NullValue.NULL;
                }
                ArrayValue checkArray = (ArrayValue)arrays[k];
                for (Map.Entry<Value, Value> entry : checkArray.entrySet()) {
                    try {
                        boolean valueFound = cmpValue.call(env, entryValue, entry.getValue()).toLong() == 0L;
                        boolean keyFound = false;
                        if (valueFound) {
                            keyFound = cmpKey.call(env, entryKey, entry.getKey()).toLong() == 0L;
                        }
                        isFound = valueFound && keyFound;
                    }
                    catch (Throwable t) {
                        log.log(Level.WARNING, t.toString(), t);
                        env.warning("An error occurred while invoking the filter callback");
                        return NullValue.NULL;
                    }
                    if (!isFound) continue;
                    continue block7;
                }
            }
            if (!isFound) {
                ((ArrayValue)diffArray).put(entryKey, entryValue);
            }
            isFound = false;
        }
        return diffArray;
    }

    public Value array_uintersect(Env env, Value[] arrays) {
        Callback cmp;
        if (arrays.length < 3) {
            env.warning("Wrong paremeter count for array_uintersect()");
            return NullValue.NULL;
        }
        if (!(arrays[0] instanceof ArrayValue)) {
            env.warning("Argument #1 is not an array");
            return NullValue.NULL;
        }
        ArrayValue array = (ArrayValue)arrays[0];
        Value callbackValue = arrays[arrays.length - 1];
        try {
            cmp = env.createCallback(callbackValue);
        }
        catch (Throwable t) {
            log.log(Level.WARNING, t.toString(), t);
            env.warning("Not a valid callback " + callbackValue.toString());
            return NullValue.NULL;
        }
        if (cmp == null) {
            env.warning("Not a valid callback " + callbackValue.toString());
            return NullValue.NULL;
        }
        ArrayValueImpl interArray = new ArrayValueImpl();
        boolean isFound = true;
        for (Value entryKey : array.keySet()) {
            Value entryValue = array.get(entryKey);
            block5: for (int k = 1; k < arrays.length - 1 && isFound; ++k) {
                if (!(arrays[k] instanceof ArrayValue)) {
                    env.warning("Argument #" + (k + 1) + " is not an array");
                    return NullValue.NULL;
                }
                ArrayValue checkArray = (ArrayValue)arrays[k];
                for (Map.Entry<Value, Value> entry : checkArray.entrySet()) {
                    try {
                        isFound = cmp.call(env, entryValue, entry.getValue()).toLong() == 0L;
                    }
                    catch (Throwable t) {
                        log.log(Level.WARNING, t.toString(), t);
                        env.warning("An error occurred while invoking the filter callback");
                        return NullValue.NULL;
                    }
                    if (!isFound) continue;
                    continue block5;
                }
            }
            if (!isFound) continue;
            ((ArrayValue)interArray).put(entryKey, entryValue);
        }
        return interArray;
    }

    public Value array_uintersect_assoc(Env env, Value[] arrays) {
        Callback cmp;
        if (arrays.length < 3) {
            env.warning("Wrong paremeter count for array_uintersect_assoc()");
            return NullValue.NULL;
        }
        if (!(arrays[0] instanceof ArrayValue)) {
            env.warning("Argument #1 is not an array");
            return NullValue.NULL;
        }
        ArrayValue array = (ArrayValue)arrays[0];
        Value callbackValue = arrays[arrays.length - 1];
        try {
            cmp = env.createCallback(callbackValue);
        }
        catch (Throwable t) {
            log.log(Level.WARNING, t.toString(), t);
            env.warning("Not a valid callback " + callbackValue.toString());
            return NullValue.NULL;
        }
        if (cmp == null) {
            env.warning("Not a valid callback " + callbackValue.toString());
            return NullValue.NULL;
        }
        ArrayValueImpl interArray = new ArrayValueImpl();
        boolean isFound = true;
        for (Value entryKey : array.keySet()) {
            Value entryValue = array.get(entryKey);
            block5: for (int k = 1; k < arrays.length - 1 && isFound; ++k) {
                if (!(arrays[k] instanceof ArrayValue)) {
                    env.warning("Argument #" + (k + 1) + " is not an array");
                    return NullValue.NULL;
                }
                ArrayValue checkArray = (ArrayValue)arrays[k];
                for (Map.Entry<Value, Value> entry : checkArray.entrySet()) {
                    try {
                        boolean keyFound = entryKey.eql(entry.getKey());
                        boolean valueFound = false;
                        if (keyFound) {
                            valueFound = cmp.call(env, entryValue, entry.getValue()).toLong() == 0L;
                        }
                        isFound = keyFound && valueFound;
                    }
                    catch (Throwable t) {
                        log.log(Level.WARNING, t.toString(), t);
                        env.warning("An error occurred while invoking the filter callback");
                        return NullValue.NULL;
                    }
                    if (!isFound) continue;
                    continue block5;
                }
            }
            if (!isFound) continue;
            ((ArrayValue)interArray).put(entryKey, entryValue);
        }
        return interArray;
    }

    public Value array_uintersect_uassoc(Env env, Value[] arrays) {
        Callback cmpKey;
        Callback cmpValue;
        if (arrays.length < 4) {
            env.warning("Wrong paremeter count for array_uintersect_uassoc()");
            return NullValue.NULL;
        }
        if (!(arrays[0] instanceof ArrayValue)) {
            env.warning("Argument #1 is not an array");
            return NullValue.NULL;
        }
        ArrayValue array = (ArrayValue)arrays[0];
        Value callbackValue = arrays[arrays.length - 2];
        try {
            cmpValue = env.createCallback(callbackValue);
        }
        catch (Throwable t) {
            log.log(Level.WARNING, t.toString(), t);
            env.warning("Not a valid callback " + callbackValue.toString());
            return NullValue.NULL;
        }
        if (cmpValue == null) {
            env.warning("Not a valid callback " + callbackValue.toString());
            return NullValue.NULL;
        }
        Value callbackKey = arrays[arrays.length - 1];
        try {
            cmpKey = env.createCallback(callbackKey);
        }
        catch (Throwable t) {
            log.log(Level.WARNING, t.toString(), t);
            env.warning("Not a valid callback " + callbackKey.toString());
            return NullValue.NULL;
        }
        if (cmpKey == null) {
            env.warning("Not a valid callback " + callbackKey.toString());
            return NullValue.NULL;
        }
        ArrayValueImpl interArray = new ArrayValueImpl();
        boolean isFound = true;
        for (Value entryKey : array.keySet()) {
            Value entryValue = array.get(entryKey);
            block7: for (int k = 1; k < arrays.length - 2 && isFound; ++k) {
                if (!(arrays[k] instanceof ArrayValue)) {
                    env.warning("Argument #" + (k + 1) + " is not an array");
                    return NullValue.NULL;
                }
                ArrayValue checkArray = (ArrayValue)arrays[k];
                for (Map.Entry<Value, Value> entry : checkArray.entrySet()) {
                    try {
                        boolean valueFound = cmpValue.call(env, entryValue, entry.getValue()).toLong() == 0L;
                        boolean keyFound = false;
                        if (valueFound) {
                            keyFound = cmpKey.call(env, entryKey, entry.getKey()).toLong() == 0L;
                        }
                        isFound = valueFound && keyFound;
                    }
                    catch (Throwable t) {
                        log.log(Level.WARNING, t.toString(), t);
                        env.warning("An error occurred while invoking the filter callback");
                        return NullValue.NULL;
                    }
                    if (!isFound) continue;
                    continue block7;
                }
            }
            if (!isFound) continue;
            ((ArrayValue)interArray).put(entryKey, entryValue);
        }
        return interArray;
    }

    @UsesSymbolTable
    public ArrayValue compact(Env env, Value[] variables) {
        ArrayValueImpl compactArray = new ArrayValueImpl();
        for (Value variableName : variables) {
            if (variableName instanceof StringValue) {
                Value tableValue = env.getValue(variableName.toString());
                if (!tableValue.isset()) continue;
                ((ArrayValue)compactArray).put(variableName, tableValue);
                continue;
            }
            if (!(variableName instanceof ArrayValue)) continue;
            ArrayValue array = (ArrayValue)variableName;
            ArrayValue innerArray = this.compact(env, array.valuesToArray());
            compactArray.putAll(innerArray);
        }
        return compactArray;
    }

    public static Value sizeof(Env env, @ReadOnly Value value, @Optional(value="false") boolean recursive) {
        return ArrayModule.count(env, value, recursive);
    }

    private static class StringParser {
        private int _current;
        private int _length;
        private String _string;
        private static final int SYMBOL = 1;
        private static final int LETTER = 2;
        private static final int DIGIT = 3;

        StringParser(String string) {
            this._string = string;
            this._length = string.length();
            this._current = 0;
        }

        public boolean hasNext() {
            return this._current < this._length;
        }

        public String next() {
            try {
                char character = this._string.charAt(this._current);
                if (character == '0') {
                    ++this._current;
                    return "0";
                }
                int type = Character.isLetter(character) ? 2 : (Character.isDigit(character) ? 3 : 1);
                int start = this._current;
                while (this._current < this._length && (type == 2 && Character.isLetter(this._string.charAt(this._current)) || type == 3 && Character.isDigit(this._string.charAt(this._current)) || type == 1 && !Character.isLetterOrDigit(this._string.charAt(this._current)))) {
                    ++this._current;
                }
                return this._string.substring(start, this._current);
            }
            catch (Exception e) {
                log.log(Level.WARNING, e.toString(), e);
                return null;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MultiSortComparator
    implements Comparator<LongValue> {
        private final Env _env;
        private final Value[] _rows;
        private final Value[] _arrays;

        public MultiSortComparator(Env env, Value[] rows, Value[] arrays) {
            this._env = env;
            this._rows = rows;
            this._arrays = arrays;
        }

        @Override
        public int compare(LongValue index1, LongValue index2) {
            for (int i = 0; i < this._arrays.length; ++i) {
                int direction = 4;
                int mode = 0;
                ArrayValue av = (ArrayValue)this._arrays[i];
                block8: while (i + 1 < this._arrays.length && this._arrays[i + 1] instanceof LongValue) {
                    int flag = this._arrays[++i].toInt();
                    switch (flag) {
                        case 4: {
                            direction = 4;
                            continue block8;
                        }
                        case 3: {
                            direction = 3;
                            continue block8;
                        }
                        case 0: {
                            mode = 0;
                            continue block8;
                        }
                        case 2: {
                            mode = 2;
                            continue block8;
                        }
                        case 1: {
                            mode = 1;
                            continue block8;
                        }
                    }
                    this._env.warning("Unknown sort flag: " + this._arrays[i]);
                }
                Value lValue = av.get(this._rows[index1.toInt()]);
                Value rValue = av.get(this._rows[index2.toInt()]);
                int cmp = mode == 2 ? lValue.toString().compareTo(rValue.toString()) : (mode == 1 ? NumberValue.compareNum(lValue, rValue) : lValue.cmp(rValue));
                if (cmp == 0) continue;
                return direction == 4 ? cmp : -1 * cmp;
            }
            return 0;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CompareCallBack
    implements Comparator<Map.Entry<Value, Value>> {
        private ArrayValue.AbstractGet _getter;
        private int _order;
        private Callback _func;
        private Env _env;

        CompareCallBack(ArrayValue.AbstractGet getter, int order, Callback func, Env env) {
            this._getter = getter;
            this._order = order;
            this._func = func;
            this._env = env;
        }

        @Override
        public int compare(Map.Entry<Value, Value> aEntry, Map.Entry<Value, Value> bEntry) {
            try {
                Value aElement = this._getter.get(aEntry);
                Value bElement = this._getter.get(bEntry);
                return (int)this._func.call(this._env, aElement, bElement).toLong();
            }
            catch (Exception e) {
                throw new QuercusModuleException(e);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CompareNatural
    implements Comparator<Map.Entry<Value, Value>> {
        private ArrayValue.AbstractGet _getter;
        private int _order;
        private boolean _isCaseSensitive;

        CompareNatural(ArrayValue.AbstractGet getter, int order, boolean isCaseSensitive) {
            this._getter = getter;
            this._order = order;
            this._isCaseSensitive = isCaseSensitive;
        }

        @Override
        public int compare(Map.Entry<Value, Value> aEntry, Map.Entry<Value, Value> bEntry) {
            try {
                String aElement = this._getter.get(aEntry).toString();
                String bElement = this._getter.get(bEntry).toString();
                if (!this._isCaseSensitive) {
                    aElement = aElement.toLowerCase();
                    bElement = bElement.toLowerCase();
                }
                StringParser aParser = new StringParser(aElement);
                StringParser bParser = new StringParser(bElement);
                while (aParser.hasNext() && bParser.hasNext()) {
                    int comparison;
                    String aPart = aParser.next();
                    String bPart = bParser.next();
                    try {
                        Long aLong = Long.valueOf(aPart);
                        Long bLong = Long.valueOf(bPart);
                        comparison = aLong.compareTo(bLong);
                    }
                    catch (NumberFormatException e) {
                        comparison = aPart.compareTo(bPart);
                    }
                    if (comparison < 0) {
                        return -1;
                    }
                    if (comparison <= 0) continue;
                    return 1;
                }
                if (bParser.hasNext()) {
                    return 1;
                }
                if (aParser.hasNext()) {
                    return -1;
                }
                return 0;
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CompareNormal
    implements Comparator<Map.Entry<Value, Value>> {
        private ArrayValue.AbstractGet _getter;
        private int _order;

        CompareNormal(ArrayValue.AbstractGet getter, int order) {
            this._getter = getter;
            this._order = order;
        }

        @Override
        public int compare(Map.Entry<Value, Value> aEntry, Map.Entry<Value, Value> bEntry) {
            if (this._getter instanceof ArrayValue.GetKey) {
                ArrayValue.KeyComparator k = ArrayValue.KeyComparator.CMP;
                return k.compare(aEntry, bEntry) * this._order;
            }
            ArrayValue.ValueComparator c = ArrayValue.ValueComparator.CMP;
            return c.compare(aEntry, bEntry) * this._order;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CompareLocale
    implements Comparator<Map.Entry<Value, Value>> {
        private ArrayValue.AbstractGet _getter;
        private int _order;
        private Collator _collator;

        CompareLocale(ArrayValue.AbstractGet getter, int order, Collator collator) {
            this._getter = getter;
            this._order = order;
            this._collator = collator;
        }

        @Override
        public int compare(Map.Entry<Value, Value> aEntry, Map.Entry<Value, Value> bEntry) {
            String aElement = this._getter.get(aEntry).toString();
            String bElement = this._getter.get(bEntry).toString();
            return this._collator.compare(aElement, bElement) * this._order;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CompareNumeric
    implements Comparator<Map.Entry<Value, Value>> {
        private ArrayValue.AbstractGet _getter;
        private int _order;

        CompareNumeric(ArrayValue.AbstractGet getter, int order) {
            this._getter = getter;
            this._order = order;
        }

        @Override
        public int compare(Map.Entry<Value, Value> aEntry, Map.Entry<Value, Value> bEntry) {
            try {
                double aElement = this._getter.get(aEntry).toDouble();
                double bElement = this._getter.get(bEntry).toDouble();
                if (aElement == bElement) {
                    return 0;
                }
                if (aElement < bElement) {
                    return -1 * this._order;
                }
                return this._order;
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CompareString
    implements Comparator<Map.Entry<Value, Value>> {
        private ArrayValue.AbstractGet _getter;
        private int _order;

        CompareString(ArrayValue.AbstractGet getter, int order) {
            this._getter = getter;
            this._order = order;
        }

        @Override
        public int compare(Map.Entry<Value, Value> aEntry, Map.Entry<Value, Value> bEntry) {
            String aElement = this._getter.get(aEntry).toString();
            String bElement = this._getter.get(bEntry).toString();
            return aElement.compareTo(bElement) * this._order;
        }
    }
}

