/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.lib;

import com.caucho.quercus.annotation.Optional;
import com.caucho.quercus.annotation.ReadOnly;
import com.caucho.quercus.env.ArrayValue;
import com.caucho.quercus.env.ArrayValueImpl;
import com.caucho.quercus.env.BooleanValue;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.JavaValue;
import com.caucho.quercus.env.ObjectValue;
import com.caucho.quercus.env.QuercusClass;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.expr.Expr;
import com.caucho.quercus.lib.ArrayModule;
import com.caucho.quercus.module.AbstractQuercusModule;
import com.caucho.quercus.program.AbstractFunction;
import com.caucho.util.L10N;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassesModule
extends AbstractQuercusModule {
    private static final L10N L = new L10N(ClassesModule.class);
    private static final Logger log = Logger.getLogger(ClassesModule.class.getName());

    public boolean class_exists(Env env, String className, @Optional(value="true") boolean useAutoload) {
        QuercusClass cl = env.findClass(className, useAutoload);
        return cl != null && !cl.isInterface();
    }

    public Value get_class(Env env, Value value) {
        if (value instanceof ObjectValue) {
            ObjectValue obj = (ObjectValue)value;
            return env.createString(obj.getName());
        }
        if (value instanceof JavaValue) {
            JavaValue obj = (JavaValue)value;
            return env.createString(obj.getClassName());
        }
        return BooleanValue.FALSE;
    }

    public static Set<String> get_class_methods(Env env, Value clss) {
        QuercusClass cl = clss instanceof ObjectValue ? ((ObjectValue)clss).getQuercusClass() : env.findClass(clss.toString());
        if (cl == null) {
            return null;
        }
        TreeSet<String> names = new TreeSet<String>();
        for (AbstractFunction fun : cl.getClassMethods()) {
            names.add(fun.getName());
        }
        return names;
    }

    public static Value get_class_vars(Env env, Value clss) {
        QuercusClass cl = clss instanceof ObjectValue ? ((ObjectValue)clss).getQuercusClass() : env.findClass(clss.toString());
        if (cl == null) {
            return BooleanValue.FALSE;
        }
        ArrayValueImpl varArray = new ArrayValueImpl();
        for (Map.Entry<StringValue, Expr> entry : cl.getClassVars().entrySet()) {
            Value key = entry.getKey();
            Value value = entry.getValue().eval(env);
            varArray.append(key, value);
        }
        ArrayModule.ksort(env, varArray, 2L);
        return varArray;
    }

    public static Value get_declared_classes(Env env) {
        return env.getDeclaredClasses();
    }

    public static Value get_object_vars(Env env, Value obj) {
        ArrayValueImpl result = new ArrayValueImpl();
        Iterator<Map.Entry<Value, Value>> iter = obj.getIterator(env);
        while (iter.hasNext()) {
            Map.Entry<Value, Value> entry = iter.next();
            ((ArrayValue)result).put(entry.getKey(), entry.getValue());
        }
        return result;
    }

    public Value get_parent_class(Env env, @ReadOnly Value value) {
        String parent;
        String className;
        QuercusClass cl;
        if (value instanceof ObjectValue) {
            ObjectValue obj = (ObjectValue)value;
            String parent2 = obj.getParentClassName();
            if (parent2 != null) {
                return env.createString(parent2);
            }
        } else if (value instanceof StringValue && (cl = env.findClass(className = value.toString())) != null && (parent = cl.getParentName()) != null) {
            return env.createString(parent);
        }
        return BooleanValue.FALSE;
    }

    public boolean interface_exists(Env env, String interfaceName, @Optional(value="true") boolean useAutoload) {
        QuercusClass cl = env.findClass(interfaceName, useAutoload);
        return cl != null && cl.isInterface();
    }

    public static boolean is_a(@ReadOnly Value value, String name) {
        return value.isA(name);
    }

    public static boolean is_object(@ReadOnly Value value) {
        return value.isObject();
    }

    public static boolean is_subclass_of(Env env, @ReadOnly Value value, String name) {
        if (value instanceof StringValue) {
            QuercusClass cl = env.findClass(value.toString());
            return cl.isA(name) && !cl.getName().equalsIgnoreCase(name);
        }
        return value.isA(name) && !value.getClassName().equalsIgnoreCase(name);
    }

    public static boolean method_exists(Value obj, String methodName) {
        return obj.findFunction(methodName.intern()) != null;
    }
}

