/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.lib;

import com.caucho.quercus.Quercus;
import com.caucho.quercus.QuercusException;
import com.caucho.quercus.annotation.VariableArguments;
import com.caucho.quercus.env.ArrayValue;
import com.caucho.quercus.env.ArrayValueImpl;
import com.caucho.quercus.env.Callback;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.LongValue;
import com.caucho.quercus.env.NullValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.module.AbstractQuercusModule;
import com.caucho.util.L10N;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FunctionModule
extends AbstractQuercusModule {
    private static final L10N L = new L10N(FunctionModule.class);
    private static final Logger log = Logger.getLogger(FunctionModule.class.getName());

    public static Value call_user_func(Env env, Callback function, Value[] args) {
        return function.call(env, args).copyReturn();
    }

    public static Value call_user_func_array(Env env, Callback function, Value arg) {
        Value[] args;
        ArrayValue argArray = arg instanceof ArrayValue ? (ArrayValue)arg : new ArrayValueImpl().append(arg);
        if (argArray != null) {
            args = new Value[argArray.getSize()];
            int i = 0;
            for (ArrayValue.Entry head = argArray.getHead(); head != null; head = head.getNext()) {
                args[i++] = head.getRawValue();
            }
        } else {
            args = new Value[]{};
        }
        return function.call(env, args).copyReturn();
    }

    public static Value create_function(Env env, String args, String code) {
        if (log.isLoggable(Level.FINER)) {
            log.finer(code);
        }
        try {
            Quercus quercus = env.getQuercus();
            return quercus.parseFunction(args, code);
        }
        catch (IOException e) {
            throw new QuercusException(e);
        }
    }

    public static Value get_defined_functions(Env env) {
        return env.getDefinedFunctions();
    }

    @VariableArguments
    public static Value func_get_arg(Env env, int index) {
        Value[] args = env.getFunctionArgs();
        if (0 <= index && index < args.length) {
            return args[index];
        }
        return NullValue.NULL;
    }

    @VariableArguments
    public static Value func_get_args(Env env) {
        Value[] args = env.getFunctionArgs();
        ArrayValueImpl result = new ArrayValueImpl();
        for (int i = 0; i < args.length; ++i) {
            ((ArrayValue)result).put(args[i]);
        }
        return result;
    }

    @VariableArguments
    public static Value func_num_args(Env env) {
        Value[] args = env.getFunctionArgs();
        if (args != null && args.length > 0) {
            return new LongValue(args.length);
        }
        return LongValue.ZERO;
    }

    public static boolean function_exists(Env env, String name) {
        return name != null && env.findFunction(name) != null;
    }

    public static Value register_shutdown_function(Env env, Callback fun, Value[] args) {
        env.addShutdown(fun, args);
        return NullValue.NULL;
    }
}

