/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.lib;

import com.caucho.quercus.QuercusException;
import com.caucho.quercus.QuercusModuleException;
import com.caucho.quercus.annotation.NotNull;
import com.caucho.quercus.annotation.Optional;
import com.caucho.quercus.annotation.ReturnNullAsFalse;
import com.caucho.quercus.env.ArrayValue;
import com.caucho.quercus.env.ArrayValueImpl;
import com.caucho.quercus.env.BooleanValue;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.LongValue;
import com.caucho.quercus.env.ResourceValue;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.module.AbstractQuercusModule;
import com.caucho.util.L10N;
import com.caucho.vfs.Path;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.WriteStream;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.color.ColorSpace;
import java.awt.geom.Arc2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.FlatteningPathIterator;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ColorConvertOp;
import java.awt.image.ConvolveOp;
import java.awt.image.Kernel;
import java.awt.image.RenderedImage;
import java.awt.image.RescaleOp;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;

public class ImageModule
extends AbstractQuercusModule {
    private static final Logger log = Logger.getLogger(ImageModule.class.getName());
    private static final L10N L = new L10N(ImageModule.class);
    public static final long IMG_GIF = 1L;
    public static final long IMG_JPG = 2L;
    public static final long IMG_JPEG = 2L;
    public static final long IMG_PNG = 4L;
    public static final long IMG_WBMP = 8L;
    public static final long IMG_XPM = 16L;
    public static final int IMAGETYPE_GIF = 1;
    public static final int IMAGETYPE_JPG = 2;
    public static final int IMAGETYPE_JPEG = 2;
    public static final int IMAGETYPE_PNG = 3;
    public static final int IMAGETYPE_SWF = 4;
    public static final int IMAGETYPE_PSD = 5;
    public static final int IMAGETYPE_BMP = 6;
    public static final int IMAGETYPE_TIFF_II = 7;
    public static final int IMAGETYPE_TIFF_MM = 8;
    public static final int IMAGETYPE_JPC = 9;
    public static final int IMAGETYPE_JP2 = 10;
    public static final int IMAGETYPE_JPX = 11;
    public static final int IMAGETYPE_JB2 = 12;
    public static final int IMAGETYPE_SWC = 13;
    public static final int IMAGETYPE_IFF = 14;
    public static final int IMAGETYPE_WBMP = 15;
    public static final int IMAGETYPE_XBM = 16;
    public static final int IMG_COLOR_STYLED = -2;
    public static final int IMG_COLOR_BRUSHED = -3;
    private static final int PNG_IHDR = ImageModule.pngCode("IHDR");
    public static final int IMG_ARC_PIE = 0;
    public static final int IMG_ARC_CHORD = 1;
    public static final int IMG_ARC_NOFILL = 2;
    public static final int IMG_ARC_EDGED = 4;
    public static final int IMG_FILTER_NEGATE = 0;
    public static final int IMG_FILTER_GRAYSCALE = 1;
    public static final int IMG_FILTER_BRIGHTNESS = 2;
    public static final int IMG_FILTER_CONTRAST = 3;
    public static final int IMG_FILTER_COLORIZE = 4;
    public static final int IMG_FILTER_EDGEDETECT = 5;
    public static final int IMG_FILTER_EMBOSS = 6;
    public static final int IMG_FILTER_GAUSSIAN_BLUR = 7;
    public static final int IMG_FILTER_SELECTIVE_BLUR = 8;
    public static final int IMG_FILTER_MEAN_REMOVAL = 9;
    public static final int IMG_FILTER_SMOOTH = 10;

    public String[] getLoadedExtensions() {
        return new String[]{"gd"};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Value getimagesize(Env env, Path file, @Optional ArrayValue imageArray) {
        if (!file.canRead()) {
            return BooleanValue.FALSE;
        }
        ImageInfo info = new ImageInfo();
        ReadStream is = null;
        try {
            is = file.openRead();
            if (!ImageModule.parseImageSize(is, info)) {
                BooleanValue booleanValue = BooleanValue.FALSE;
                return booleanValue;
            }
        }
        catch (Exception e) {
            log.log(Level.FINE, e.toString(), e);
            BooleanValue booleanValue = BooleanValue.FALSE;
            return booleanValue;
        }
        finally {
            is.close();
        }
        if (imageArray == null) {
            imageArray = new ArrayValueImpl();
        }
        imageArray.put(new LongValue(info._width));
        imageArray.put(new LongValue(info._height));
        imageArray.put(new LongValue(info._type));
        imageArray.put(env.createString("width=\"" + info._width + "\" height=\"" + info._height + "\""));
        if (info._bits >= 0) {
            imageArray.put(env.createString("bits"), new LongValue(info._bits));
        }
        if (info._type == 2) {
            imageArray.put("channels", 3L);
        }
        if (info._mime != null) {
            imageArray.put("mime", info._mime);
        }
        return imageArray;
    }

    private static boolean parseImageSize(ReadStream is, ImageInfo info) throws IOException {
        int ch = is.read();
        if (ch == 137) {
            if (is.read() != 80 || is.read() != 78 || is.read() != 71 || is.read() != 13 || is.read() != 10 || is.read() != 26 || is.read() != 10) {
                return false;
            }
            return ImageModule.parsePNGImageSize(is, info);
        }
        if (ch == 71) {
            if (is.read() != 73 || is.read() != 70 || is.read() != 56 || (ch = is.read()) != 55 && ch != 57 || is.read() != 97) {
                return false;
            }
            return ImageModule.parseGIFImageSize(is, info);
        }
        if (ch == 255) {
            if (is.read() != 216) {
                return false;
            }
            return ImageModule.parseJPEGImageSize(is, info);
        }
        return false;
    }

    private static boolean parsePNGImageSize(ReadStream is, ImageInfo info) throws IOException {
        int length;
        while ((length = ImageModule.readInt(is)) > 0) {
            int type = ImageModule.readInt(is);
            if (type == PNG_IHDR) {
                int width = ImageModule.readInt(is);
                int height = ImageModule.readInt(is);
                int depth = is.read() & 0xFF;
                int color = is.read() & 0xFF;
                int compression = is.read() & 0xFF;
                int filter = is.read() & 0xFF;
                int interlace = is.read() & 0xFF;
                info._width = width;
                info._height = height;
                info._type = 3;
                info._bits = depth;
                info._mime = "image/png";
                return true;
            }
            for (int i = 0; i < length; ++i) {
                if (is.read() >= 0) continue;
                return false;
            }
            int crc = ImageModule.readInt(is);
        }
        return false;
    }

    private static boolean parseGIFImageSize(ReadStream is, ImageInfo info) throws IOException {
        int width = (is.read() & 0xFF) + 256 * (is.read() & 0xFF);
        int height = (is.read() & 0xFF) + 256 * (is.read() & 0xFF);
        int flags = is.read() & 0xFF;
        info._width = width;
        info._height = height;
        info._type = 1;
        info._bits = flags & 7;
        info._mime = "image/gif";
        return true;
    }

    private static boolean parseJPEGImageSize(ReadStream is, ImageInfo info) throws IOException {
        int ch;
        while ((ch = is.read()) == 255) {
            int len;
            ch = is.read();
            if (ch == 255) {
                is.unread();
                continue;
            }
            if (208 <= ch && ch <= 217 || 1 == ch) continue;
            if (ch == 192) {
                int width;
                len = 256 * is.read() + is.read();
                int bits = is.read();
                int height = 256 * is.read() + is.read();
                info._width = width = 256 * is.read() + is.read();
                info._height = height;
                info._type = 2;
                info._bits = bits;
                info._mime = "image/jpeg";
                return true;
            }
            len = 256 * is.read() + is.read();
            is.skip((long)(len - 2));
        }
        return false;
    }

    private static int pngCode(String code) {
        return code.charAt(0) << 24 | code.charAt(1) << 16 | code.charAt(2) << 8 | code.charAt(3);
    }

    private static int readInt(ReadStream is) throws IOException {
        return (is.read() & 0xFF) << 24 | (is.read() & 0xFF) << 16 | (is.read() & 0xFF) << 8 | is.read() & 0xFF;
    }

    public static Value gd_info() {
        return new ArrayValueImpl().append(StringValue.create("GD Version"), StringValue.create("2.0 or higher")).append(StringValue.create("FreeType Support"), BooleanValue.TRUE).append(StringValue.create("FreeType Linkage"), StringValue.create("with freetype")).append(StringValue.create("T1Lib Support"), BooleanValue.TRUE).append(StringValue.create("GIF Read Support"), BooleanValue.TRUE).append(StringValue.create("GIF Create Support"), BooleanValue.TRUE).append(StringValue.create("JPG Support"), BooleanValue.TRUE).append(StringValue.create("PNG Support"), BooleanValue.TRUE).append(StringValue.create("WBMP Support"), BooleanValue.TRUE).append(StringValue.create("XPM Support"), BooleanValue.FALSE).append(StringValue.create("XBM Support"), BooleanValue.FALSE).append(StringValue.create("JIS-mapped Japanese Font Support"), BooleanValue.FALSE);
    }

    public static long imagetypes() {
        return 7L;
    }

    public static Value image_type_to_extension(int imageType, boolean dot) {
        switch (imageType) {
            case 1: {
                return StringValue.create(dot ? ".gif" : "gif");
            }
            case 2: {
                return StringValue.create(dot ? ".jpg" : "jpg");
            }
            case 3: {
                return StringValue.create(dot ? ".png" : "png");
            }
            case 4: {
                return StringValue.create(dot ? ".swf" : "swf");
            }
            case 5: {
                return StringValue.create(dot ? ".psd" : "psd");
            }
            case 6: {
                return StringValue.create(dot ? ".bmp" : "bmp");
            }
            case 7: {
                return StringValue.create(dot ? ".tiff" : "tiff");
            }
            case 8: {
                return StringValue.create(dot ? ".tiff" : "tiff");
            }
            case 9: {
                return StringValue.create(dot ? ".jpc" : "jpc");
            }
            case 10: {
                return StringValue.create(dot ? ".jp2" : "jp2");
            }
            case 11: {
                return StringValue.create(dot ? ".jpf" : "jpf");
            }
            case 12: {
                return StringValue.create(dot ? ".jb2" : "jb2");
            }
            case 13: {
                return StringValue.create(dot ? ".swc" : "swc");
            }
            case 14: {
                return StringValue.create(dot ? ".iff" : "iff");
            }
            case 15: {
                return StringValue.create(dot ? ".wbmp" : "wbmp");
            }
            case 16: {
                return StringValue.create(dot ? ".xbm" : "xbm");
            }
        }
        throw new QuercusException("unknown imagetype " + imageType);
    }

    public static Value image_type_to_mime_type(int imageType) {
        switch (imageType) {
            case 1: {
                return StringValue.create("image/gif");
            }
            case 2: {
                return StringValue.create("image/jpeg");
            }
            case 3: {
                return StringValue.create("image/png");
            }
            case 4: {
                return StringValue.create("application/x-shockwave-flash");
            }
            case 5: {
                return StringValue.create("image/psd");
            }
            case 6: {
                return StringValue.create("image/bmp");
            }
            case 7: {
                return StringValue.create("image/tiff");
            }
            case 8: {
                return StringValue.create("image/tiff");
            }
            case 9: {
                return StringValue.create("application/octet-stream");
            }
            case 10: {
                return StringValue.create("image/jp2");
            }
            case 11: {
                return StringValue.create("application/octet-stream");
            }
            case 12: {
                return StringValue.create("application/octet-stream");
            }
            case 13: {
                return StringValue.create("application/x-shockwave-flash");
            }
            case 14: {
                return StringValue.create("image/iff");
            }
            case 15: {
                return StringValue.create("image/vnd.wap.wbmp");
            }
            case 16: {
                return StringValue.create("image/xbm");
            }
        }
        throw new QuercusException("unknown imageType " + imageType);
    }

    public static boolean imagegif(Env env, QuercusImage image) {
        try {
            ImageIO.write((RenderedImage)image._bufferedImage, "gif", (OutputStream)env.getOut());
            return true;
        }
        catch (IOException e) {
            throw new QuercusModuleException(e);
        }
    }

    public static boolean imagepng(Env env, QuercusImage image) {
        try {
            ImageIO.write((RenderedImage)image._bufferedImage, "png", (OutputStream)env.getOut());
            return true;
        }
        catch (IOException e) {
            throw new QuercusModuleException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean imagejpeg(Env env, QuercusImage image, @Optional Path path, @Optional int quality) {
        try {
            if (path != null) {
                WriteStream os = path.openWrite();
                try {
                    ImageIO.write((RenderedImage)image._bufferedImage, "jpeg", (OutputStream)os);
                }
                finally {
                    os.close();
                }
            } else {
                ImageIO.write((RenderedImage)image._bufferedImage, "jpeg", (OutputStream)env.getOut());
            }
            return true;
        }
        catch (IOException e) {
            log.log(Level.FINE, e.toString(), e);
            return false;
        }
    }

    public static boolean imagealphablending(QuercusImage image, boolean useAlphaBlending) {
        image.getGraphics().setComposite(useAlphaBlending ? AlphaComposite.SrcOver : AlphaComposite.Src);
        return true;
    }

    public static boolean imageantialias(QuercusImage image, boolean useAntiAliasing) {
        image.getGraphics().setRenderingHint(RenderingHints.KEY_ANTIALIASING, useAntiAliasing ? RenderingHints.VALUE_ANTIALIAS_ON : RenderingHints.VALUE_ANTIALIAS_OFF);
        return true;
    }

    public static long imagecolorallocate(QuercusImage image, int r, int g, int b) {
        return 0x7F000000 | (r & 0xFF) << 16 | (g & 0xFF) << 8 | (b & 0xFF) << 0;
    }

    public static long imagecolorallocatealpha(QuercusImage image, int r, int g, int b, int a) {
        int alpha = 127 - (a & 0xFF);
        return alpha << 24 | (r & 0xFF) << 16 | (g & 0xFF) << 8 | (b & 0xFF) << 0;
    }

    public static boolean imagecolordeallocate(QuercusImage image, int rgb) {
        return true;
    }

    public static long imagecolorat(QuercusImage image, int x, int y) {
        return image.getPixel(x, y);
    }

    public static long imagecolorclosest(QuercusImage image, int r, int g, int b) {
        return ImageModule.imagecolorallocate(image, r, g, b);
    }

    public static long imagecolorclosestalpha(QuercusImage image, int r, int g, int b, int a) {
        return ImageModule.imagecolorallocatealpha(image, r, g, b, a);
    }

    public static long imagecolorexact(QuercusImage image, int r, int g, int b) {
        return ImageModule.imagecolorallocate(image, r, g, b);
    }

    public static long imagecolorexactalpha(QuercusImage image, int r, int g, int b, int a) {
        return ImageModule.imagecolorallocatealpha(image, r, g, b, a);
    }

    public static boolean imagecolormatch(QuercusImage image1, QuercusImage image2) {
        return true;
    }

    public static long imagecolorresolve(QuercusImage image, int r, int g, int b) {
        return ImageModule.imagecolorallocate(image, r, g, b);
    }

    public static long imagecolorresolvealpha(QuercusImage image, int r, int g, int b, int a) {
        return ImageModule.imagecolorallocatealpha(image, r, g, b, a);
    }

    public static ArrayValue imagecolorsforindex(QuercusImage image, int argb) {
        ArrayValueImpl arrayValue = new ArrayValueImpl();
        arrayValue.put("red", argb >> 16 & 0xFF);
        arrayValue.put("green", argb >> 8 & 0xFF);
        arrayValue.put("blue", argb >> 0 & 0xFF);
        int alpha = 127 - (argb >> 24 & 0xFF);
        arrayValue.put("alpha", alpha);
        return arrayValue;
    }

    public static Value imagecolorstotal() {
        return LongValue.create(0L);
    }

    public static Value imagecreate(int width, int height) {
        return new QuercusImage(width, height);
    }

    public static QuercusImage imagecreatefromgif(Env env, Path filename) {
        return new QuercusImage(env, filename);
    }

    @ReturnNullAsFalse
    public static QuercusImage imagecreatefromjpeg(Env env, Path filename) {
        try {
            return new QuercusImage(env, filename);
        }
        catch (Exception e) {
            env.warning(L.l("Can't open {0} as a jpeg image", (Object)filename));
            log.log(Level.FINE, e.toString(), e);
            return null;
        }
    }

    public static QuercusImage imagecreatefrompng(Env env, Path filename) {
        return new QuercusImage(env, filename);
    }

    public static Value imagecreatefromxbm(Env env, Path filename) {
        return new QuercusImage(env, filename);
    }

    public static QuercusImage imagecreatefromxpm(Env env, Path filename) {
        return new QuercusImage(env, filename);
    }

    public static QuercusImage imagecreatefromwbmp(Env env, Path filename) {
        return new QuercusImage(env, filename);
    }

    public static QuercusImage imagecreatefromstring(Env env, InputStream data) {
        return new QuercusImage(data);
    }

    public static Value imagecreatetruecolor(int width, int height) {
        return new QuercusImage(width, height);
    }

    public static boolean imagedestroy(QuercusImage image) {
        return true;
    }

    public static boolean imageistruecolor(QuercusImage image) {
        return true;
    }

    public static boolean imageinterlace(QuercusImage image, boolean enable) {
        return true;
    }

    public static boolean imagesetpixel(QuercusImage image, int x, int y, int color) {
        image.setPixel(x, y, color);
        return true;
    }

    public static boolean imageline(QuercusImage image, int x1, int y1, int x2, int y2, int color) {
        image.stroke(new Line2D.Float(x1, y1, x2, y2), color);
        return true;
    }

    public static boolean imagedashedline(QuercusImage image, int x1, int y1, int x2, int y2, int color) {
        Graphics2D g = image.getGraphics();
        Stroke stroke = g.getStroke();
        g.setColor(ImageModule.intToColor(color));
        g.setStroke(new BasicStroke(1.0f, 1, 1, 1.0f, new float[]{5.0f, 5.0f}, 0.0f));
        g.draw(new Line2D.Float(x1, y1, x2, y2));
        g.setStroke(stroke);
        return true;
    }

    public static boolean imagearc(QuercusImage image, double cx, double cy, double width, double height, double start, double end, int color) {
        Arc2D.Double arc = new Arc2D.Double(cx - width / 2.0, cy - height / 2.0, width, height, -1.0 * start, -1.0 * (end - start), 0);
        image.stroke(arc, color);
        return true;
    }

    public static boolean imagefilledarc(QuercusImage image, double cx, double cy, double width, double height, double start, double end, int color, int style) {
        int type = 2;
        if ((style & 1) != 0) {
            type = 1;
        }
        if ((style & 0) != 0) {
            type = 2;
        }
        Arc2D.Double arc = new Arc2D.Double(cx - width / 2.0, cy - height / 2.0, width, height, -1.0 * start, -1.0 * (end - start), type);
        if ((style & 2) == 0) {
            image.fill(arc, color);
        }
        if ((style & 4) != 0) {
            image.stroke(arc, color);
        }
        return true;
    }

    public static boolean imageellipse(QuercusImage image, double cx, double cy, double width, double height, int color) {
        Ellipse2D.Double shape = new Ellipse2D.Double(cx - width / 2.0, cy - height / 2.0, width, height);
        image.stroke(shape, color);
        return true;
    }

    public static boolean imagefilledellipse(QuercusImage image, double cx, double cy, double width, double height, int color) {
        Ellipse2D.Double ellipse = new Ellipse2D.Double(cx - width / 2.0, cy - height / 2.0, width, height);
        image.fill(ellipse, color);
        return true;
    }

    private static Polygon arrayToPolygon(ArrayValue points, int numPoints) {
        Polygon polygon = new Polygon();
        ArrayValue.Entry entry = points.getHead();
        for (int i = 0; i < numPoints; ++i) {
            int x = entry.getValue().toInt();
            entry = entry.getNext();
            int y = entry.getValue().toInt();
            entry = entry.getNext();
            polygon.addPoint(x, y);
        }
        return polygon;
    }

    public static boolean imagepolygon(QuercusImage image, ArrayValue points, int numPoints, int color) {
        image.stroke(ImageModule.arrayToPolygon(points, numPoints), color);
        return true;
    }

    public static boolean imagefilledpolygon(QuercusImage image, ArrayValue points, int numPoints, int color) {
        image.fill(ImageModule.arrayToPolygon(points, numPoints), color);
        return true;
    }

    public static boolean imagerectangle(QuercusImage image, int x1, int y1, int x2, int y2, int color) {
        int tmp;
        if (x2 < x1) {
            tmp = x1;
            x1 = x2;
            x2 = tmp;
        }
        if (y2 < y1) {
            tmp = y1;
            y1 = y2;
            y2 = tmp;
        }
        image.stroke(new Rectangle2D.Float(x1, y1, x2 - x1, y2 - y1), color);
        return true;
    }

    public static boolean imagefilledrectangle(QuercusImage image, int x1, int y1, int x2, int y2, int color) {
        image.fill(new Rectangle2D.Float(x1, y1, x2 - x1 + 1, y2 - y1 + 1), color);
        return true;
    }

    public static boolean imagechar(QuercusImage image, int font, int x, int y, String c, int color) {
        Graphics2D g = image.getGraphics();
        g.setColor(ImageModule.intToColor(color));
        Font awtfont = image.getFont(font);
        int height = image.getGraphics().getFontMetrics(awtfont).getAscent();
        g.setFont(awtfont);
        g.drawString(c.substring(0, 1), x, y + height);
        return true;
    }

    public static boolean imagestring(QuercusImage image, int font, int x, int y, String s, int color) {
        Graphics2D g = image.getGraphics();
        g.setColor(ImageModule.intToColor(color));
        Font awtfont = image.getFont(font);
        int height = image.getGraphics().getFontMetrics(awtfont).getAscent();
        g.setFont(awtfont);
        g.drawString(s, x, y + height);
        return true;
    }

    public static boolean imagecharup(QuercusImage image, int font, int x, int y, String c, int color) {
        Graphics2D g = (Graphics2D)image.getGraphics().create();
        g.rotate(-1.5707963267948966);
        g.setColor(ImageModule.intToColor(color));
        Font awtfont = image.getFont(font);
        int height = image.getGraphics().getFontMetrics(awtfont).getAscent();
        g.setFont(awtfont);
        g.drawString(c.substring(0, 1), -1 * y, x + height);
        return true;
    }

    public static int imagesx(@NotNull QuercusImage image) {
        if (image == null) {
            return 0;
        }
        Graphics2D g = image.getGraphics();
        Rectangle bounds = g.getDeviceConfiguration().getBounds();
        return (int)bounds.getWidth();
    }

    public static int imagesy(@NotNull QuercusImage image) {
        if (image == null) {
            return 0;
        }
        Graphics2D g = image.getGraphics();
        Rectangle bounds = g.getDeviceConfiguration().getBounds();
        return (int)bounds.getHeight();
    }

    public static int imagefontheight(int font) {
        if (font < 1) {
            return 8;
        }
        if (font == 1) {
            return 8;
        }
        if (font == 2) {
            return 13;
        }
        if (font == 3) {
            return 13;
        }
        if (font == 4) {
            return 16;
        }
        if (font == 5) {
            return 15;
        }
        return 15;
    }

    public static int imagefontwidth(int font) {
        if (font < 1) {
            return 5;
        }
        if (font == 1) {
            return 5;
        }
        if (font == 2) {
            return 6;
        }
        if (font == 3) {
            return 7;
        }
        if (font == 4) {
            return 8;
        }
        if (font == 5) {
            return 9;
        }
        return 9;
    }

    public static boolean imagecopy(QuercusImage dest, QuercusImage src, int dx, int dy, int sx, int sy, int w, int h) {
        dest.getGraphics().drawImage(src._bufferedImage, dx, dy, dx + w, dy + h, sx, sy, sx + w, sy + h, null);
        return true;
    }

    public static boolean imagecopymerge(QuercusImage dest, QuercusImage src, int dx, int dy, int sx, int sy, int w, int h, int pct) {
        BufferedImage rgba = new BufferedImage(dest.getWidth(), dest.getHeight(), 2);
        rgba.getGraphics().drawImage(src._bufferedImage, 0, 0, null);
        RescaleOp rescaleOp = new RescaleOp(new float[]{1.0f, 1.0f, 1.0f, (float)pct / 100.0f}, new float[]{0.0f, 0.0f, 0.0f, 0.0f}, null);
        BufferedImage rescaledImage = rescaleOp.filter(rgba, null);
        Graphics2D g = (Graphics2D)dest.getGraphics().create();
        g.setComposite(AlphaComposite.SrcOver);
        g.drawImage(rescaledImage, dx, dy, dx + w, dy + h, sx, sy, sx + w, sy + h, null);
        return true;
    }

    public static boolean imagecopymergegray(QuercusImage dest, QuercusImage src, int dx, int dy, int sx, int sy, int w, int h, int pct) {
        BufferedImage rgba = new BufferedImage(dest.getWidth(), dest.getHeight(), 2);
        rgba.getGraphics().drawImage(src._bufferedImage, 0, 0, null);
        RescaleOp rescaleOp = new RescaleOp(new float[]{1.0f, 1.0f, 1.0f, (float)pct / 100.0f}, new float[]{0.0f, 0.0f, 0.0f, 0.0f}, null);
        BufferedImage rescaledImage = rescaleOp.filter(rgba, null);
        ColorConvertOp colorConvertOp = new ColorConvertOp(ColorSpace.getInstance(1003), null);
        colorConvertOp.filter(dest._bufferedImage, dest._bufferedImage);
        Graphics2D g = (Graphics2D)dest.getGraphics().create();
        g.setComposite(AlphaComposite.SrcOver);
        g.drawImage(rescaledImage, dx, dy, dx + w, dy + h, sx, sy, sx + w, sy + h, null);
        return true;
    }

    public static boolean imagecopyresampled(QuercusImage dest, QuercusImage src, int dx, int dy, int sx, int sy, int dw, int dh, int sw, int sh) {
        Graphics2D g = (Graphics2D)dest.getGraphics().create();
        g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g.drawImage(src._bufferedImage, dx, dy, dx + dw, dy + dh, sx, sy, sx + sw, sy + sh, null);
        g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_DEFAULT);
        return true;
    }

    public static boolean imagecopyresized(QuercusImage dest, QuercusImage src, int dx, int dy, int sx, int sy, int dw, int dh, int sw, int sh) {
        Graphics2D g = (Graphics2D)dest.getGraphics().create();
        g.drawImage(src._bufferedImage, dx, dy, dx + dw, dy + dh, sx, sy, sx + sw, sy + sh, null);
        return true;
    }

    public static boolean imagesetbrush(QuercusImage image, QuercusImage brush) {
        image.setBrush(brush);
        return true;
    }

    public static boolean imagesetstyle(QuercusImage image, ArrayValue style) {
        image.setStyle(style);
        return true;
    }

    public static boolean imagesetthickness(QuercusImage image, int thickness) {
        image.setThickness(thickness);
        return true;
    }

    public static boolean imagepalettecopy(QuercusImage source, QuercusImage dest) {
        return true;
    }

    public static boolean imagesavealpha(QuercusImage image, boolean set) {
        return true;
    }

    public static boolean imagecolorset(QuercusImage image, int index, int r, int g, int b) {
        return true;
    }

    public static long imagecolortransparent(QuercusImage image, @Optional int color) {
        return -16777216L;
    }

    public static boolean imagefill(QuercusImage image, int x, int y, int color) {
        image.flood(x, y, color);
        return true;
    }

    public static boolean imagefilltoborder(QuercusImage image, int x, int y, int border, int color) {
        image.flood(x, y, color, border);
        return true;
    }

    public static boolean imageconvolution(QuercusImage image, ArrayValue matrix, double div, double offset) {
        float[] kernelValues = new float[9];
        ArrayValue.Entry entry = matrix.getHead();
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 3; ++x) {
                kernelValues[x + y * 3] = (float)matrix.get(LongValue.create(y)).get(LongValue.create(x)).toDouble();
            }
        }
        ConvolveOp convolveOp = new ConvolveOp(new Kernel(3, 3, kernelValues), 1, null);
        BufferedImage bufferedImage = convolveOp.filter(image._bufferedImage, null);
        image._bufferedImage.getGraphics().drawImage(bufferedImage, 1, 0, null);
        return true;
    }

    public static boolean imagefilter(Env env, QuercusImage image, int filterType, @Optional int arg1, @Optional int arg2, @Optional int arg3) {
        switch (filterType) {
            case 0: {
                env.warning(L.l("imagefilter(IMG_FILTER_NEGATE) unimplemented"));
                return false;
            }
            case 1: {
                env.warning(L.l("imagefilter(IMG_FILTER_GRAYSCALE) unimplemented"));
                return false;
            }
            case 2: {
                env.warning(L.l("imagefilter(IMG_FILTER_BRIGHTNESS) unimplementetd"));
                return false;
            }
            case 3: {
                env.warning(L.l("imagefilter(IMG_FILTER_CONTRAST) unimplementetd"));
                return false;
            }
            case 4: {
                env.warning(L.l("imagefilter(IMG_FILTER_COLORIZE) unimplemented"));
                return false;
            }
            case 5: {
                env.warning(L.l("imagefilter(IMG_FILTER_EDGEDETECT) unimplemented"));
                return false;
            }
            case 6: {
                env.warning(L.l("imagefilter(IMG_FILTER_EMBOSS) unimplemented"));
                return false;
            }
            case 7: {
                env.warning(L.l("imagefilter(IMG_FILTER_GAUSSIAN_BLUR) unimplemented"));
                return false;
            }
            case 8: {
                env.warning(L.l("imagefilter(IMG_FILTER_SELECTIVE_BLUR) unimplemented"));
                return false;
            }
            case 9: {
                env.warning(L.l("imagefilter(IMG_FILTER_MEAN_REMOVAL) unimplemented"));
                return false;
            }
            case 10: {
                env.warning(L.l("imagefilter(IMG_FILTER_SMOOTH) unimplemented"));
                return false;
            }
        }
        throw new QuercusException("unknown filterType in imagefilter()");
    }

    public static boolean iptcembed(String iptcdata, String jpegFileName, @Optional int spool) {
        throw new QuercusException("iptcembed is not [yet] supported");
    }

    public static boolean imagegammacorrect(QuercusImage image, float gammaBefore, float gammaAfter) {
        return true;
    }

    public static boolean imagerotate(QuercusImage image, float angle, int backgroundColor, @Optional int ignoreTransparent) {
        return false;
    }

    public static long imagecolorclosesthwb(QuercusImage image, int r, int g, int b) {
        throw new QuercusException("imagecolorclosesthwb is not supported");
    }

    public static boolean imagelayereffect(QuercusImage image, int effect) {
        return false;
    }

    public static ArrayValue imageftbbox(float size, float angle, Path fontFile, String text, @Optional ArrayValue extraInfo) {
        throw new QuercusException("imageftbbox() not implemented");
    }

    public static ArrayValue imagefttext(QuercusImage image, float size, float angle, int x, int y, int col, Path fontFile, String text, ArrayValue extraInfo) {
        throw new QuercusException("imagefttext() not implemented");
    }

    public static long imageloadfont(Path file) {
        throw new QuercusException("imageloadfont() not implemented");
    }

    public static ArrayValue imagepsbbox(String text, int font, int size, @Optional int space, @Optional int tightness, @Optional float angle) {
        throw new QuercusException("imagepsbbox() not implemented");
    }

    public static int imagepscopyfont(Value fontIndex) {
        throw new QuercusException("imagepscopyfont() not implemented");
    }

    public static boolean imagepsencodefont(Value fontIndex, Path encodingFile) {
        throw new QuercusException("imagepsencodefont() not implemented");
    }

    public static boolean imagepsextendfont(int fontIndex, float extend) {
        throw new QuercusException("imagepsextendfont() not implemented");
    }

    public static boolean imagepsfreefont(Value fontIndex) {
        throw new QuercusException("imagepsfreefont() not implemented");
    }

    public static Value imagepsloadfont(Path fontFile) {
        throw new QuercusException("imagepsloadfont() not implemented");
    }

    public static boolean imagepsslantfont(Value fontIndex, float slant) {
        throw new QuercusException("imagepsslantfont() not implemented");
    }

    public static ArrayValue imagepstext(QuercusImage image, String text, Value fontIndex, int size, int fg, int bg, int x, int y, @Optional int space, @Optional int tightness, @Optional float angle, @Optional int antialias_steps) {
        throw new QuercusException("imagepstext() not implemented");
    }

    public static void image2wbmp(QuercusImage image, @Optional Path filename, @Optional int threshhold) {
        throw new QuercusException("not supported");
    }

    public static void jpeg2wbmp(String jpegFilename, String wbmpName, int d_height, int d_width, int threshhold) {
        throw new QuercusException("not supported");
    }

    public static void png2wbmp(String pngFilename, String wbmpName, int d_height, int d_width, int threshhold) {
        throw new QuercusException("not supported");
    }

    public static void imagecreatefromgd2(Path file) {
        throw new QuercusException(".gd images are not supported");
    }

    public static void imagecreatefromgd2part(Path file, int srcX, int srcY, int width, int height) {
        throw new QuercusException(".gd images are not supported");
    }

    public static void imagecreatefromgd(Path file) {
        throw new QuercusException(".gd images are not supported");
    }

    public static void imagegd2(QuercusImage image, @Optional Path file) {
        throw new QuercusException("imagegd2 is not implemented");
    }

    public static void imagegd(QuercusImage image, @Optional Path file) {
        throw new QuercusException("imagegd is not implemented");
    }

    private static Color intToColor(int argb) {
        int alpha = argb >> 24;
        alpha <<= 1;
        alpha |= (alpha & 2) >> 1;
        return new Color(argb >> 16 & 0xFF, argb >> 8 & 0xFF, argb >> 0 & 0xFF, alpha);
    }

    public static class QuercusImage
    extends ResourceValue {
        private int _width;
        private int _height;
        BufferedImage _bufferedImage;
        private Graphics2D _graphics;
        private BufferedImage _brush;
        private int[] _style;
        private int _thickness;

        public QuercusImage(int width, int height) {
            this._width = width;
            this._height = height;
            this._bufferedImage = new BufferedImage(width, height, 1);
            this._graphics = (Graphics2D)this._bufferedImage.getGraphics();
        }

        public QuercusImage(InputStream inputStream) {
            try {
                this._bufferedImage = ImageIO.read(inputStream);
                this._width = this._bufferedImage.getWidth(null);
                this._height = this._bufferedImage.getHeight(null);
                this._graphics = (Graphics2D)this._bufferedImage.getGraphics();
            }
            catch (IOException e) {
                throw new QuercusException(e);
            }
        }

        public QuercusImage(Env env, Path filename) {
            try {
                this._bufferedImage = ImageIO.read((InputStream)filename.openRead());
                this._width = this._bufferedImage.getWidth(null);
                this._height = this._bufferedImage.getHeight(null);
                this._graphics = (Graphics2D)this._bufferedImage.getGraphics();
            }
            catch (IOException e) {
                throw new QuercusException(e);
            }
        }

        public String toString() {
            return "resource(Image)";
        }

        public int getPixel(int x, int y) {
            return this._bufferedImage.getRGB(x, y);
        }

        public void setPixel(int x, int y, int color) {
            this._bufferedImage.setRGB(x, y, color);
        }

        public Graphics2D getGraphics() {
            return this._graphics;
        }

        public Font getFont(int font) {
            if (font <= 1) {
                return new Font("sansserif", 0, 8);
            }
            switch (font) {
                case 2: {
                    return new Font("sansserif", 0, 10);
                }
                case 3: {
                    return new Font("sansserif", 0, 11);
                }
                case 4: {
                    return new Font("sansserif", 0, 12);
                }
            }
            return new Font("sansserif", 0, 14);
        }

        public int getWidth() {
            return this._bufferedImage.getWidth(null);
        }

        public int getHeight() {
            return this._bufferedImage.getHeight(null);
        }

        public void fill(Shape shape, int color) {
            this._graphics.setColor(ImageModule.intToColor(color));
            this._graphics.fill(shape);
        }

        public void stroke(Shape shape, int color) {
            switch (color) {
                case -2: {
                    this.strokeStyled(shape);
                    break;
                }
                case -3: {
                    this.strokeBrushed(shape);
                    break;
                }
                default: {
                    this._graphics.setColor(ImageModule.intToColor(color));
                    this._graphics.setStroke(new BasicStroke(this._thickness));
                    this._graphics.draw(shape);
                }
            }
        }

        private void strokeStyled(Shape shape) {
            for (int i = 0; i < this._style.length; ++i) {
                this._graphics.setColor(ImageModule.intToColor(this._style[i]));
                BasicStroke stroke = new BasicStroke(this._thickness, 1, 1, 1.0f, new float[]{1.0f, this._style.length - 1}, i);
                this._graphics.setStroke(stroke);
                this._graphics.draw(shape);
            }
        }

        private void strokeBrushed(Shape shape) {
            Graphics2D g = this._graphics;
            FlatteningPathIterator fpi = new FlatteningPathIterator(shape.getPathIterator(g.getTransform()), 1.0);
            float[] floats = new float[6];
            fpi.currentSegment(floats);
            float last_x = floats[0];
            float last_y = floats[1];
            while (!fpi.isDone()) {
                fpi.currentSegment(floats);
                int distance = (int)Math.sqrt((floats[0] - last_x) * (floats[0] - last_x) + (floats[1] - last_y) * (floats[1] - last_y));
                if (distance <= 1) {
                    distance = 1;
                }
                for (int i = 1; i <= distance; ++i) {
                    int x = (int)(floats[0] * (float)i + last_x * (float)(distance - i)) / distance;
                    int y = (int)(floats[1] * (float)i + last_y * (float)(distance - i)) / distance;
                    g.drawImage((Image)this._brush, x -= this._brush.getWidth() / 2, y -= this._brush.getHeight() / 2, null);
                }
                last_x = floats[0];
                last_y = floats[1];
                fpi.next();
            }
        }

        public void setThickness(int thickness) {
            this._style = null;
            this._thickness = thickness;
        }

        public void setStyle(ArrayValue colors) {
            this._style = new int[colors.getSize()];
            ArrayValue.Entry e = colors.getHead();
            for (int i = 0; i < this._style.length; ++i) {
                this._style[i] = e.getValue().toInt();
                e = e.getNext();
            }
        }

        public void setBrush(QuercusImage image) {
            this._brush = image._bufferedImage;
        }

        public BufferedImage getBrush() {
            return this._brush;
        }

        public void flood(int x, int y, int color) {
            this.flood(x, y, color, 0, false);
        }

        public void flood(int x, int y, int color, int border) {
            this.flood(x, y, color, border, true);
        }

        private void flood(int startx, int starty, int color, int border, boolean useBorder) {
            LinkedList<Integer> xq = new LinkedList<Integer>();
            LinkedList<Integer> yq = new LinkedList<Integer>();
            xq.add(startx);
            yq.add(starty);
            color &= 0xFFFFFF;
            border &= 0xFFFFFF;
            while (xq.size() > 0) {
                int i;
                int x = (Integer)xq.poll();
                int y = (Integer)yq.poll();
                int p = this.getPixel(x, y) & 0xFFFFFF;
                if (useBorder ? p == border || p == color : p != 0) continue;
                this.setPixel(x, y, color);
                for (i = x - 1; i >= 0; --i) {
                    p = this.getPixel(i, y) & 0xFFFFFF;
                    if (useBorder ? p == border || p == color : p != 0) break;
                    this.setPixel(i, y, color);
                    xq.add(i);
                    yq.add(y + 1);
                    xq.add(i);
                    yq.add(y - 1);
                }
                for (i = x + 1; i < this.getWidth(); ++i) {
                    p = this.getPixel(i, y) & 0xFFFFFF;
                    if (useBorder ? p == border || p == color : p != 0) break;
                    this.setPixel(i, y, color);
                    xq.add(i);
                    yq.add(y + 1);
                    xq.add(i);
                    yq.add(y - 1);
                }
                xq.add(x);
                yq.add(y + 1);
                xq.add(x);
                yq.add(y - 1);
            }
        }
    }

    static class ImageInfo {
        int _width;
        int _height;
        int _type;
        int _bits;
        String _mime;

        ImageInfo() {
        }
    }
}

