/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.lib;

import com.caucho.quercus.QuercusModuleException;
import com.caucho.quercus.annotation.Optional;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.module.AbstractQuercusModule;
import com.caucho.util.CharBuffer;
import com.caucho.util.L10N;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MailModule
extends AbstractQuercusModule {
    private static final Logger log = Logger.getLogger(MailModule.class.getName());
    private static final L10N L = new L10N(MailModule.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean mail(Env env, String to, String subject, StringValue message, @Optional String additionalHeaders, @Optional String additionalParameters) {
        Transport smtp = null;
        try {
            Address[] from;
            StringValue user;
            StringValue port;
            Properties props = new Properties();
            StringValue host = env.getIni("SMTP");
            if (host != null && !host.toString().equals("")) {
                props.put("mail.smtp.host", host.toString());
            }
            if ((port = env.getIni("smtp_port")) != null && !port.toString().equals("")) {
                props.put("mail.smtp.port", port.toString());
            }
            if ((user = env.getIni("sendmail_from")) != null && !user.toString().equals("")) {
                props.put("mail.from", user.toString());
            }
            String username = env.getIniString("smtp_username");
            String password = env.getIniString("smtp_password");
            if (password != null && !"".equals(password)) {
                props.put("mail.smtp.auth", "true");
            }
            Session mailSession = Session.getInstance((Properties)props, null);
            smtp = mailSession.getTransport("smtp");
            MimeMessage msg = new MimeMessage(mailSession);
            msg.setSubject(subject);
            msg.setContent((Object)message.toString(), "text/plain");
            ArrayList<Address> addrList = MailModule.addRecipients(msg, Message.RecipientType.TO, to);
            if (additionalHeaders != null) {
                MailModule.addHeaders(msg, additionalHeaders);
            }
            if ((from = msg.getFrom()) == null || from.length == 0) {
                log.fine(L.l("mail 'From' not set, setting to Java System property 'user.name'"));
                msg.setFrom();
            }
            msg.saveChanges();
            if (addrList.size() == 0) {
                throw new QuercusModuleException(L.l("mail has no recipients"));
            }
            from = msg.getFrom();
            log.fine(L.l("sending mail, From: {0}, To: {1}", (Object)from[0], (Object)to));
            if (password != null && !"".equals(password)) {
                smtp.connect(username, password);
            } else {
                smtp.connect();
            }
            Address[] addr = new Address[addrList.size()];
            addrList.toArray(addr);
            smtp.sendMessage((Message)msg, addr);
            log.fine("quercus-mail: sent mail to " + to);
            boolean bl = true;
            return bl;
        }
        catch (RuntimeException e) {
            log.log(Level.FINER, e.toString(), e);
            throw e;
        }
        catch (MessagingException e) {
            log.log(Level.FINE, e.toString(), e);
            env.warning(e.getMessage());
            boolean bl = false;
            return bl;
        }
        catch (Exception e) {
            log.log(Level.FINE, e.toString(), e);
            env.warning(e.toString());
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (smtp != null) {
                    smtp.close();
                }
            }
            catch (Exception e) {
                log.log(Level.FINER, e.toString(), e);
            }
        }
    }

    private static ArrayList<Address> addRecipients(MimeMessage msg, Message.RecipientType type, String to) throws MessagingException {
        String[] split = to.split("[ \t,<>]");
        ArrayList<Address> addresses = new ArrayList<Address>();
        for (int i = 0; i < split.length; ++i) {
            if (split[i].indexOf(64) <= 0) continue;
            InternetAddress addr = new InternetAddress(split[i]);
            addresses.add((Address)addr);
            msg.addRecipient(type, (Address)addr);
        }
        return addresses;
    }

    private static void addHeaders(MimeMessage msg, String headers) throws MessagingException {
        int i = 0;
        int len = headers.length();
        CharBuffer buffer = new CharBuffer();
        while (i < len) {
            char ch;
            while (i < len && Character.isWhitespace(headers.charAt(i))) {
                ++i;
            }
            if (len <= i) {
                return;
            }
            buffer.clear();
            while (i < len && !Character.isWhitespace(ch = headers.charAt(i)) && ch != ':') {
                buffer.append(ch);
                ++i;
            }
            while (i < len && ((ch = headers.charAt(i)) == ' ' || ch == '\t' || ch == '\f' || ch == ':')) {
                ++i;
            }
            String name = buffer.toString();
            buffer.clear();
            while (i < len && (ch = headers.charAt(i)) != '\r' && ch != '\n') {
                buffer.append(ch);
                ++i;
            }
            String value = buffer.toString();
            if ("".equals(value)) continue;
            if (name.equalsIgnoreCase("From")) {
                msg.setFrom((Address)new InternetAddress(value));
                continue;
            }
            msg.addHeader(name, value);
        }
    }
}

