/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.lib;

import com.caucho.quercus.annotation.Optional;
import com.caucho.quercus.env.ArrayValue;
import com.caucho.quercus.env.BooleanValue;
import com.caucho.quercus.env.DoubleValue;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.LongValue;
import com.caucho.quercus.env.NullValue;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.module.AbstractQuercusModule;
import com.caucho.util.L10N;
import com.caucho.util.RandomUtil;
import java.util.Iterator;

public class MathModule
extends AbstractQuercusModule {
    private static final L10N L = new L10N(MathModule.class);
    public static final double M_PI = Math.PI;
    public static final double M_E = Math.E;
    public static final long RAND_MAX = Integer.MAX_VALUE;
    public static final double M_LOG2E = MathModule.log2(Math.E);
    public static final double M_LOG10E = Math.log10(Math.E);
    public static final double M_LN2 = Math.log(2.0);
    public static final double M_LN10 = Math.log(10.0);
    public static final double M_PI_2 = 1.5707963267948966;
    public static final double M_PI_4 = 0.7853981633974483;
    public static final double M_1_PI = 0.3183098861837907;
    public static final double M_2_PI = 0.6366197723675814;
    public static final double M_SQRTPI = Math.sqrt(Math.PI);
    public static final double M_2_SQRTPI = 2.0 / Math.sqrt(Math.PI);
    public static final double M_SQRT2 = Math.sqrt(2.0);
    public static final double M_SQRT3 = Math.sqrt(3.0);
    public static final double M_SQRT1_2 = 1.0 / Math.sqrt(2.0);
    public static final double M_LNPI = Math.log(Math.PI);
    public static final double M_EULER = 0.5772156649015329;

    private static double log2(double v) {
        return Math.log(v) / Math.log(2.0);
    }

    public static Value abs(Value value) {
        if (value.getValueType().isDoubleCmp()) {
            return DoubleValue.create(Math.abs(value.toDouble()));
        }
        return LongValue.create(Math.abs(value.toLong()));
    }

    public static double acos(double value) {
        return Math.acos(value);
    }

    public static Value acosh(Env env, Value value) {
        throw new UnsupportedOperationException();
    }

    public static Value asin(Value value) {
        return new DoubleValue(Math.asin(value.toDouble()));
    }

    public static Value asinh(Value value) {
        throw new UnsupportedOperationException();
    }

    public static double atan2(double yV, double xV) {
        return Math.atan2(yV, xV);
    }

    public static double atan(double value) {
        return Math.atan(value);
    }

    public static Value atanh(Value value) {
        throw new UnsupportedOperationException();
    }

    public static Value base_convert(Env env, String number, int fromBase, int toBase) {
        if (fromBase < 2 || fromBase > 36) {
            env.warning(L.l("invalid `{0}' ({1})", (Object)"from base", fromBase));
            return BooleanValue.FALSE;
        }
        if (toBase < 2 || toBase > 36) {
            env.warning(L.l("invalid `{0}' ({1})", (Object)"to base", toBase));
            return BooleanValue.FALSE;
        }
        long result = 0L;
        int len = number.length();
        for (int i = 0; i < len; ++i) {
            int value;
            char ch = number.charAt(i);
            if ('0' <= ch && ch <= '9') {
                value = ch - 48;
            } else if ('a' <= ch && ch <= 'z') {
                value = ch - 97 + 10;
            } else {
                if ('A' > ch || ch > 'Z') continue;
                value = ch - 97 + 10;
            }
            if (fromBase <= value) continue;
            result *= (long)fromBase;
            result += (long)value;
        }
        if (result == 0L) {
            return env.createString("0");
        }
        StringBuilder sb = new StringBuilder();
        do {
            int d = (int)(result % (long)toBase);
            result /= (long)toBase;
            if (d < 10) {
                sb.append((char)(d + 48));
                continue;
            }
            sb.append((char)(d - 10 + 97));
        } while (result != 0L);
        sb.reverse();
        return env.createString(sb.toString());
    }

    public static long bindec(StringValue bin) {
        long result = 0L;
        int len = bin.length();
        for (int i = 0; i < len; ++i) {
            char ch = bin.charAt(i);
            if ('0' == ch) {
                result = 2L * result;
            } else if ('1' == ch) {
                result = 2L * result;
                ++result;
            }
            if (result >= 0L) continue;
            throw new ArithmeticException(L.l("overflow"));
        }
        return result;
    }

    public static double ceil(double value) {
        return Math.ceil(value);
    }

    public static double cos(double value) {
        return Math.cos(value);
    }

    public static double cosh(double value) {
        return Math.cosh(value);
    }

    public static String decbin(long value) {
        if (value == 0L) {
            return "0";
        }
        StringBuilder sb = new StringBuilder();
        while (value != 0L) {
            int d = (int)(value & 1L);
            value /= 2L;
            if (d == 0) {
                sb.append('0');
                continue;
            }
            sb.append('1');
        }
        sb.reverse();
        return sb.toString();
    }

    public static String dechex(long value) {
        if (value == 0L) {
            return "0";
        }
        StringBuilder sb = new StringBuilder();
        while (value != 0L) {
            int d = (int)(value & 0xFL);
            value /= 16L;
            if (d < 10) {
                sb.append((char)(d + 48));
                continue;
            }
            sb.append((char)(d + 97 - 10));
        }
        sb.reverse();
        return sb.toString();
    }

    public static String decoct(long value) {
        if (value == 0L) {
            return "0";
        }
        StringBuilder sb = new StringBuilder();
        while (value != 0L) {
            int d = (int)(value & 7L);
            value /= 8L;
            sb.append((char)(d + 48));
        }
        sb.reverse();
        return sb.toString();
    }

    public static double deg2rad(double value) {
        return value * Math.PI / 180.0;
    }

    public static Value exp(Value value) {
        return new DoubleValue(Math.exp(value.toDouble()));
    }

    public static Value expm1(Value value) {
        return new DoubleValue(Math.expm1(value.toDouble()));
    }

    public static Value floor(Value value) {
        return new DoubleValue(Math.floor(value.toDouble()));
    }

    public static double fmod(double xV, double yV) {
        return Math.IEEEremainder(xV, yV);
    }

    public static long hexdec(StringValue s) {
        long v = 0L;
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            char ch = s.charAt(i);
            if ('0' <= ch && ch <= '9') {
                v = 16L * v + (long)ch - 48L;
                continue;
            }
            if ('a' <= ch && ch <= 'f') {
                v = 16L * v + (long)ch - 97L + 10L;
                continue;
            }
            if ('A' > ch || ch > 'F') continue;
            v = 16L * v + (long)ch - 65L + 10L;
        }
        return v;
    }

    public static double hypot(double a, double b) {
        return Math.hypot(a, b);
    }

    public static boolean is_finite(Value value) {
        if (value instanceof LongValue) {
            return true;
        }
        if (value instanceof DoubleValue) {
            double v = value.toDouble();
            return !Double.isInfinite(v);
        }
        return false;
    }

    public static Value is_infinite(Value value) {
        if (value instanceof LongValue) {
            return BooleanValue.FALSE;
        }
        if (value instanceof DoubleValue) {
            double v = value.toDouble();
            return Double.isInfinite(v) ? BooleanValue.TRUE : BooleanValue.FALSE;
        }
        return BooleanValue.FALSE;
    }

    public static Value is_nan(Value value) {
        if (value instanceof LongValue) {
            return BooleanValue.FALSE;
        }
        if (value instanceof DoubleValue) {
            double v = value.toDouble();
            return Double.isNaN(v) ? BooleanValue.TRUE : BooleanValue.FALSE;
        }
        return BooleanValue.FALSE;
    }

    public static double log(double value) {
        return Math.log(value);
    }

    public static double log10(double value) {
        return Math.log10(value);
    }

    public static double log1p(double value) {
        return Math.log1p(value);
    }

    public static Value getrandmax() {
        return MathModule.mt_getrandmax();
    }

    public static Value max(Env env, Value[] args) {
        if (args.length == 1 && args[0] instanceof ArrayValue) {
            Value array = args[0];
            Value max = NullValue.NULL;
            double maxValue = Double.MIN_VALUE;
            Iterator<Value> iter = array.getValueIterator(env);
            while (iter.hasNext()) {
                Value value = iter.next();
                double dValue = value.toDouble();
                if (!(maxValue < dValue)) continue;
                maxValue = dValue;
                max = value;
            }
            return max;
        }
        double maxValue = -1.7976931348623157E308;
        Value max = NullValue.NULL;
        for (int i = 0; i < args.length; ++i) {
            double value = args[i].toDouble();
            if (!(maxValue < value)) continue;
            maxValue = value;
            max = args[i];
        }
        return max;
    }

    public static Value min(Env env, Value[] args) {
        if (args.length == 1 && args[0] instanceof ArrayValue) {
            Value array = args[0];
            Value min = NullValue.NULL;
            double minValue = Double.MAX_VALUE;
            Iterator<Value> iter = array.getValueIterator(env);
            while (iter.hasNext()) {
                Value value = iter.next();
                double dValue = value.toDouble();
                if (!(dValue < minValue)) continue;
                minValue = dValue;
                min = value;
            }
            return min;
        }
        double minValue = Double.MAX_VALUE;
        Value min = NullValue.NULL;
        for (int i = 0; i < args.length; ++i) {
            double value = args[i].toDouble();
            if (!(value < minValue)) continue;
            minValue = value;
            min = args[i];
        }
        return min;
    }

    public static Value mt_getrandmax() {
        return new LongValue(Integer.MAX_VALUE);
    }

    public static long mt_rand(@Optional(value="0") long min, @Optional(value="RAND_MAX") long max) {
        long range = max - min + 1L;
        if (range <= 0L) {
            return min;
        }
        long value = RandomUtil.getRandomLong();
        if (value < 0L) {
            value = -value;
        }
        return min + value % range;
    }

    public static Value mt_srand(@Optional long seed) {
        return NullValue.NULL;
    }

    public static long octdec(StringValue oct) {
        long result = 0L;
        int len = oct.length();
        for (int i = 0; i < len; ++i) {
            char ch = oct.charAt(i);
            if ('0' > ch || ch > '7') continue;
            result <<= 3;
            if ((result += (long)(ch - 48)) >= 0L) continue;
            throw new ArithmeticException(L.l("overflow"));
        }
        return result;
    }

    public static double pi() {
        return Math.PI;
    }

    public static double pow(double base, double exp) {
        return Math.pow(base, exp);
    }

    public static double rad2deg(double value) {
        return 180.0 * value / Math.PI;
    }

    public static long rand(@Optional int min, @Optional(value="RAND_MAX") int max) {
        return MathModule.mt_rand(min, max);
    }

    public static double round(double value, @Optional int precision) {
        if (precision > 0) {
            double exp = Math.pow(10.0, precision);
            return (double)Math.round(value * exp) / exp;
        }
        return Math.round(value);
    }

    public static double sin(double value) {
        return Math.sin(value);
    }

    public static Value sinh(Value value) {
        return new DoubleValue(Math.sinh(value.toDouble()));
    }

    public static double sqrt(double value) {
        return Math.sqrt(value);
    }

    public static Value srand(@Optional long seed) {
        return NullValue.NULL;
    }

    public static double tan(double value) {
        return Math.tan(value);
    }

    public static double tanh(double value) {
        return Math.tanh(value);
    }
}

