/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.lib;

import com.caucho.quercus.annotation.Optional;
import com.caucho.quercus.env.BooleanValue;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.Value;
import com.caucho.util.L10N;
import com.caucho.util.LruCache;
import java.util.logging.Logger;

public class Memcache {
    private static final Logger log = Logger.getLogger(Memcache.class.getName());
    private static final L10N L = new L10N(Memcache.class);
    private Cache _cache;

    public boolean addServer(Env env, String host, @Optional int port, @Optional boolean persistent, @Optional int weight, @Optional int timeout, @Optional int retryInterval) {
        if (this._cache == null) {
            this.connect(env, host, port, timeout);
        }
        return true;
    }

    public boolean connect(Env env, String host, @Optional int port, @Optional(value="1") int timeout) {
        String name = "memcache::" + host + ":" + port;
        this._cache = (Cache)env.getQuercus().getSpecial(name);
        if (this._cache == null) {
            this._cache = new Cache();
            env.getQuercus().setSpecial(name, this._cache);
        }
        return true;
    }

    public Value get(Env env, Value keys) {
        if (keys.isArray()) {
            return BooleanValue.FALSE;
        }
        String key = keys.toString();
        Value value = this._cache.get(key);
        if (value != null) {
            return value.copy(env);
        }
        return BooleanValue.FALSE;
    }

    public String getVersion() {
        return "1.0";
    }

    public boolean pconnect(Env env, String host, @Optional int port, @Optional(value="1") int timeout) {
        return this.connect(env, host, port, timeout);
    }

    public boolean set(Env env, String key, Value value, @Optional int flag, @Optional int expire) {
        this._cache.set(key, value.copy(env));
        return true;
    }

    public boolean setCompressThreshold(int threshold, @Optional double minSavings) {
        return true;
    }

    public boolean close() {
        return true;
    }

    public String toString() {
        return "Memcache[]";
    }

    static class Cache
    extends Value {
        private LruCache<String, Value> _map = new LruCache(256);

        Cache() {
        }

        public Value get(String key) {
            return (Value)this._map.get((Object)key);
        }

        public void set(String key, Value value) {
            this._map.put((Object)key, (Object)value);
        }
    }
}

