/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.lib;

import com.caucho.quercus.QuercusModuleException;
import com.caucho.quercus.annotation.NotNull;
import com.caucho.quercus.annotation.Optional;
import com.caucho.quercus.annotation.Reference;
import com.caucho.quercus.annotation.ReturnNullAsFalse;
import com.caucho.quercus.env.ArrayValue;
import com.caucho.quercus.env.ArrayValueImpl;
import com.caucho.quercus.env.BooleanValue;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.LongValue;
import com.caucho.quercus.env.NullValue;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.lib.ArrayModule;
import com.caucho.quercus.lib.file.SocketInputOutput;
import com.caucho.quercus.module.AbstractQuercusModule;
import com.caucho.util.L10N;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.naming.NameNotFoundException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.InitialDirContext;

public class NetworkModule
extends AbstractQuercusModule {
    private static final L10N L = new L10N(NetworkModule.class);
    private static final Logger log = Logger.getLogger(NetworkModule.class.getName());
    private static final LinkedHashMap<String, LongValue> _protoToNum = new LinkedHashMap();
    private static final LinkedHashMap<String, ServiceNode> _servToNum = new LinkedHashMap();
    public static final int LOG_EMERG = 0;
    public static final int LOG_ALERT = 1;
    public static final int LOG_CRIT = 2;
    public static final int LOG_ERR = 3;
    public static final int LOG_WARNING = 4;
    public static final int LOG_NOTICE = 5;
    public static final int LOG_INFO = 6;
    public static final int LOG_DEBUG = 7;
    public static final int LOG_PID = 1;
    public static final int LOG_CONS = 2;
    public static final int LOG_NDELAY = 8;
    public static final int LOG_NOWAIT = 16;
    public static final int LOG_ODELAY = 4;
    public static final int LOG_PERROR = 32;
    public static final int LOG_AUTH = 32;
    public static final int LOG_AUTHPRIV = 80;
    public static final int LOG_CRON = 72;
    public static final int LOG_DAEMON = 24;
    public static final int LOG_KERN = 0;
    public static final int LOG_LOCAL0 = 128;
    public static final int LOG_LOCAL1 = 136;
    public static final int LOG_LOCAL2 = 144;
    public static final int LOG_LOCAL3 = 152;
    public static final int LOG_LOCAL4 = 160;
    public static final int LOG_LOCAL5 = 168;
    public static final int LOG_LOCAL6 = 176;
    public static final int LOG_LOCAL7 = 184;
    public static final int LOG_LPR = 48;
    public static final int LOG_MAIL = 16;
    public static final int LOG_NEWS = 56;
    public static final int LOG_SYSLOG = 40;
    public static final int LOG_USER = 8;
    public static final int LOG_UUCP = 64;
    public static final int DNS_A = 1;
    public static final int DNS_CNAME = 16;
    public static final int DNS_HINFO = 4096;
    public static final int DNS_MX = 16384;
    public static final int DNS_NS = 2;
    public static final int DNS_PTR = 2048;
    public static final int DNS_SOA = 32;
    public static final int DNS_TXT = 32768;
    public static final int DNS_AAAA = 0x8000000;
    public static final int DNS_SRV = 0x2000000;
    public static final int DNS_NAPTR = 0x4000000;
    public static final int DNS_A6 = 0x1000000;
    public static final int DNS_ALL = 251713587;
    public static final int DNS_ANY = 0x10000000;

    public static SocketInputOutput fsockopen(Env env, String host, @Optional(value="80") int port, @Optional @Reference Value errno, @Optional @Reference Value errstr, @Optional double timeout) {
        try {
            Socket s = new Socket(host, port);
            if (timeout > 0.0) {
                s.setSoTimeout((int)(timeout * 1000.0));
            } else {
                s.setSoTimeout(120000);
            }
            SocketInputOutput stream = new SocketInputOutput(env, s, SocketInputOutput.Domain.AF_INET);
            stream.init();
            return stream;
        }
        catch (IOException e) {
            log.log(Level.FINE, e.toString(), e);
            if (errstr != null) {
                errstr.set(env.createString(e.toString()));
            }
            return null;
        }
    }

    public static Value ip2long(String ip) {
        if (ip == null) {
            return LongValue.MINUS_ONE;
        }
        long v = 0L;
        int p = 0;
        int len = ip.length();
        for (int i = 0; i < 4; ++i) {
            int digit = 0;
            char ch = '\u0000';
            while (p < len && '0' <= (ch = ip.charAt(p)) && ch <= '9') {
                digit = 10 * digit + ch - 48;
                ++p;
            }
            if (p < len && ch != '.') {
                return BooleanValue.FALSE;
            }
            if (p == len && i < 3) {
                return BooleanValue.FALSE;
            }
            ++p;
            v = 256L * v + (long)digit;
        }
        return new LongValue(v);
    }

    public static String gethostbyname(String hostname) {
        if (hostname == null) {
            return "";
        }
        InetAddress ip = null;
        try {
            ip = InetAddress.getByName(hostname);
        }
        catch (Exception e) {
            log.log(Level.WARNING, e.toString(), e);
            return hostname;
        }
        return ip.getHostAddress();
    }

    public static Value gethostbynamel(Env env, String hostname) {
        InetAddress[] ip = null;
        try {
            ip = InetAddress.getAllByName(hostname);
        }
        catch (Exception e) {
            log.log(Level.WARNING, e.toString(), e);
            return BooleanValue.FALSE;
        }
        ArrayValueImpl ipArray = new ArrayValueImpl();
        for (int k = 0; k < ip.length; ++k) {
            String currentIPString = ip[k].getHostAddress();
            StringValue currentIP = env.createString(currentIPString);
            ipArray.append(currentIP);
        }
        return ipArray;
    }

    @ReturnNullAsFalse
    public static String gethostbyaddr(Env env, String ip) {
        if (ip == null) {
            env.warning("Address must not be null.");
            return null;
        }
        String formIPv4 = "(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)";
        CharSequence ipToCS = ip.subSequence(0, ip.length());
        if (!Pattern.matches(formIPv4, ipToCS)) {
            env.warning("Address is not in a.b.c.d form");
            return null;
        }
        String[] splitIP = null;
        try {
            splitIP = ip.split("\\.");
        }
        catch (Exception e) {
            log.log(Level.WARNING, e.toString(), e);
            env.warning("Regex expression invalid");
            return ip;
        }
        byte[] addr = new byte[splitIP.length];
        for (int k = 0; k < splitIP.length; ++k) {
            Integer intForm = new Integer(splitIP[k]);
            addr[k] = intForm.byteValue();
        }
        InetAddress host = null;
        try {
            host = InetAddress.getByAddress(addr);
        }
        catch (Exception e) {
            log.log(Level.WARNING, e.toString(), e);
            return ip;
        }
        return host.getHostName();
    }

    public static Value getprotobyname(String protoName) {
        if (!_protoToNum.containsKey(protoName)) {
            return BooleanValue.FALSE;
        }
        return LongValue.create(_protoToNum.get(protoName).toLong());
    }

    @ReturnNullAsFalse
    public static String getprotobynumber(int protoNumber) {
        for (Map.Entry<String, LongValue> entry : _protoToNum.entrySet()) {
            if (entry.getValue().toLong() != (long)protoNumber) continue;
            return entry.getKey();
        }
        return null;
    }

    public static Value getservbyname(String service, String protocol) {
        if (!_servToNum.containsKey(service)) {
            return BooleanValue.FALSE;
        }
        ServiceNode node = _servToNum.get(service);
        if (!node.protocolCheck(protocol)) {
            return BooleanValue.FALSE;
        }
        return node.getPort();
    }

    @ReturnNullAsFalse
    public static String getservbyport(int port, String protocol) {
        for (Map.Entry<String, ServiceNode> entry : _servToNum.entrySet()) {
            ServiceNode node = entry.getValue();
            if (node.getPort().toLong() != (long)port || !node.protocolCheck(protocol)) continue;
            return entry.getKey();
        }
        return null;
    }

    public static boolean getmxrr(Env env, @NotNull String hostname, @Reference Value mxhosts, @Optional @Reference Value weight) {
        return NetworkModule.dns_get(env, hostname, "MX", mxhosts, weight);
    }

    private static boolean dns_get(Env env, String hostname, String type, Value hostsRef, Value weightRef) {
        try {
            if (hostname == null || type == null) {
                return false;
            }
            InitialDirContext ictx = new InitialDirContext();
            Attributes attributes = type.equals("ANY") || type.equals("ALL") ? ictx.getAttributes("dns:/" + hostname) : ictx.getAttributes("dns:/" + hostname, new String[]{type});
            ArrayValueImpl hosts = new ArrayValueImpl();
            ArrayValueImpl weights = new ArrayValueImpl();
            NamingEnumeration<? extends Attribute> list = attributes.getAll();
            if (!list.hasMore()) {
                return false;
            }
            while (list.hasMore()) {
                Attribute record = list.next();
                String id = record.getID();
                NamingEnumeration<?> attrList = record.getAll();
                while (attrList.hasMore()) {
                    int space;
                    String target = String.valueOf(attrList.next());
                    if (target.endsWith(".")) {
                        target = target.substring(0, target.length() - 1);
                    }
                    int weight = 0;
                    if ("MX".equals(id) && (space = target.indexOf(" ")) > -1) {
                        String hostPart;
                        String priorityPart = target.substring(0, space);
                        target = hostPart = target.substring(space + 1);
                        try {
                            weight = Integer.valueOf(priorityPart);
                        }
                        catch (NumberFormatException ex) {
                            log.log(Level.FINE, ex.toString(), ex);
                        }
                    }
                    weights.append(LongValue.create(weight));
                    hosts.append(StringValue.create(target));
                }
            }
            ArrayModule.array_multisort(env, new Value[]{weights, hosts});
            if (hostsRef != null) {
                hostsRef.set(hosts);
            }
            if (weightRef != null) {
                weightRef.set(weights);
            }
            return true;
        }
        catch (NameNotFoundException e) {
            return false;
        }
        catch (NamingException e) {
            throw new QuercusModuleException(e);
        }
    }

    public static boolean dns_get_mx(Env env, @NotNull String hostname, @Reference Value mxhosts, @Optional @Reference Value weight) {
        return NetworkModule.dns_get(env, hostname, "MX", mxhosts, weight);
    }

    public static boolean checkdnsrr(Env env, @NotNull String hostname, @Optional(value="MX") String type) {
        return NetworkModule.dns_get(env, hostname, type, null, null);
    }

    public static boolean dns_check_record(Env env, @NotNull String hostname, @Optional(value="MX") String type) {
        return NetworkModule.dns_get(env, hostname, type, null, null);
    }

    public ArrayValue dns_get_record(Env env, @NotNull String hostname, @Optional(value="-1") int type, @Optional @Reference Value authnsRef, @Optional @Reference Value addtlRef) {
        String typeName;
        ArrayValueImpl result = new ArrayValueImpl();
        ArrayValueImpl authns = null;
        if (authnsRef != null && !authnsRef.isNull()) {
            authns = new ArrayValueImpl();
            authnsRef.set(authns);
            env.stub("authns unimplemented");
        }
        ArrayValueImpl addtl = null;
        if (addtlRef != null && !addtlRef.isNull()) {
            addtl = new ArrayValueImpl();
            addtlRef.set(addtl);
            env.stub("addtl unimplemented");
        }
        if (hostname == null) {
            return result;
        }
        if (type == -1) {
            type = 0x10000000;
        }
        switch (type) {
            case 1: {
                typeName = "A";
                break;
            }
            case 16: {
                typeName = "CNAME";
                break;
            }
            case 4096: {
                typeName = "HINFO";
                break;
            }
            case 16384: {
                typeName = "MX";
                break;
            }
            case 2: {
                typeName = "NS";
                break;
            }
            case 2048: {
                typeName = "PTR";
                break;
            }
            case 32: {
                typeName = "SOA";
                break;
            }
            case 32768: {
                typeName = "TXT";
                break;
            }
            case 0x8000000: {
                typeName = "AAAA";
                break;
            }
            case 0x2000000: {
                typeName = "SRV";
                break;
            }
            case 0x4000000: {
                typeName = "NAPTR";
                break;
            }
            case 0x1000000: {
                typeName = "A6";
                break;
            }
            default: {
                typeName = null;
            }
        }
        try {
            InitialDirContext ictx = new InitialDirContext();
            Attributes attributes = typeName == null ? ictx.getAttributes("dns:/" + hostname) : ictx.getAttributes("dns:/" + hostname, new String[]{typeName});
            NamingEnumeration<? extends Attribute> list = attributes.getAll();
            while (list.hasMore()) {
                Attribute record = list.next();
                String id = record.getID();
                NamingEnumeration<?> attrList = record.getAll();
                while (attrList.hasMore()) {
                    String attr = String.valueOf(attrList.next());
                    String target = attr;
                    if (target.endsWith(".")) {
                        target = target.substring(0, target.length() - 1);
                    }
                    ArrayValueImpl recordValue = new ArrayValueImpl();
                    recordValue.put("host", hostname);
                    recordValue.put("type", id);
                    if ("MX".equals(id)) {
                        int space = target.indexOf(" ");
                        if (space > -1) {
                            String priorityPart = target.substring(0, space);
                            String hostPart = target.substring(space + 1);
                            try {
                                recordValue.put("pri", Integer.valueOf(priorityPart).intValue());
                                target = hostPart;
                            }
                            catch (NumberFormatException ex) {
                                log.log(Level.FINE, ex.toString(), ex);
                            }
                        }
                    } else if ("A".equals(id)) {
                        try {
                            recordValue.put("ip", target);
                            target = null;
                        }
                        catch (Exception e) {
                            log.log(Level.FINE, e.toString(), e);
                        }
                    }
                    if (target != null) {
                        recordValue.put("target", target);
                    }
                    ((ArrayValue)result).put(recordValue);
                }
            }
        }
        catch (NameNotFoundException ex) {
            log.log(Level.FINER, ex.toString(), ex);
        }
        catch (NamingException ex) {
            throw new QuercusModuleException(ex);
        }
        return result;
    }

    public static Value define_syslog_variables(Env env) {
        env.stub("unimplemented");
        return NullValue.NULL;
    }

    public static boolean openlog(Env env, String ident, int option, int facility) {
        env.stub("unimplemented");
        return true;
    }

    public static boolean closelog() {
        return true;
    }

    public static boolean syslog(Env env, int priority, String message) {
        Level level = Level.OFF;
        switch (priority) {
            case 0: 
            case 1: 
            case 2: {
                level = Level.SEVERE;
                break;
            }
            case 3: 
            case 4: {
                level = Level.WARNING;
                break;
            }
            case 5: {
                level = Level.CONFIG;
                break;
            }
            case 6: {
                level = Level.INFO;
                break;
            }
            case 7: {
                level = Level.FINE;
            }
        }
        env.getLogger().log(level, message);
        return true;
    }

    static {
        _protoToNum.put("ip", LongValue.create(0L));
        _protoToNum.put("icmp", LongValue.create(1L));
        _protoToNum.put("ggp", LongValue.create(3L));
        _protoToNum.put("tcp", LongValue.create(6L));
        _protoToNum.put("egp", LongValue.create(8L));
        _protoToNum.put("pup", LongValue.create(12L));
        _protoToNum.put("udp", LongValue.create(17L));
        _protoToNum.put("hmp", LongValue.create(12L));
        _protoToNum.put("xns-idp", LongValue.create(22L));
        _protoToNum.put("rdp", LongValue.create(27L));
        _protoToNum.put("rvd", LongValue.create(66L));
        _servToNum.put("echo", new ServiceNode(7, true, true));
        _servToNum.put("discard", new ServiceNode(9, true, true));
        _servToNum.put("systat", new ServiceNode(11, true, true));
        _servToNum.put("daytime", new ServiceNode(13, true, true));
        _servToNum.put("qotd", new ServiceNode(17, true, true));
        _servToNum.put("chargen", new ServiceNode(19, true, true));
        _servToNum.put("ftp-data", new ServiceNode(20, true, false));
        _servToNum.put("ftp", new ServiceNode(21, true, false));
        _servToNum.put("telnet", new ServiceNode(23, true, false));
        _servToNum.put("smtp", new ServiceNode(25, true, false));
        _servToNum.put("time", new ServiceNode(37, true, true));
        _servToNum.put("rlp", new ServiceNode(39, false, true));
        _servToNum.put("nameserver", new ServiceNode(42, true, true));
        _servToNum.put("nicname", new ServiceNode(43, true, false));
        _servToNum.put("domain", new ServiceNode(53, true, true));
        _servToNum.put("bootps", new ServiceNode(67, false, true));
        _servToNum.put("bootpc", new ServiceNode(68, false, true));
        _servToNum.put("tftp", new ServiceNode(69, false, true));
        _servToNum.put("gopher", new ServiceNode(70, true, false));
        _servToNum.put("finger", new ServiceNode(79, true, false));
        _servToNum.put("http", new ServiceNode(80, true, false));
        _servToNum.put("kerberos", new ServiceNode(88, true, true));
        _servToNum.put("hostname", new ServiceNode(101, true, false));
        _servToNum.put("iso-tsap", new ServiceNode(102, true, false));
        _servToNum.put("rtelnet", new ServiceNode(107, true, false));
        _servToNum.put("pop2", new ServiceNode(109, true, false));
        _servToNum.put("pop3", new ServiceNode(110, true, false));
        _servToNum.put("sunrpc", new ServiceNode(111, true, true));
        _servToNum.put("auth", new ServiceNode(113, true, false));
        _servToNum.put("uucp-path", new ServiceNode(117, true, false));
        _servToNum.put("nntp", new ServiceNode(119, true, false));
        _servToNum.put("ntp", new ServiceNode(123, false, true));
        _servToNum.put("epmap", new ServiceNode(135, true, true));
        _servToNum.put("netbios-ns", new ServiceNode(137, true, true));
        _servToNum.put("netbios-dgm", new ServiceNode(138, false, true));
        _servToNum.put("netbios-ssn", new ServiceNode(139, true, false));
        _servToNum.put("imap", new ServiceNode(143, true, false));
        _servToNum.put("pcmail-srv", new ServiceNode(158, true, false));
        _servToNum.put("snmp", new ServiceNode(161, false, true));
        _servToNum.put("snmptrap", new ServiceNode(162, false, true));
        _servToNum.put("print-srv", new ServiceNode(170, true, false));
        _servToNum.put("bgp", new ServiceNode(179, true, false));
        _servToNum.put("irc", new ServiceNode(194, true, false));
        _servToNum.put("ipx", new ServiceNode(213, false, true));
        _servToNum.put("ldap", new ServiceNode(389, true, false));
        _servToNum.put("https", new ServiceNode(443, true, true));
        _servToNum.put("microsoft-ds", new ServiceNode(445, true, true));
        _servToNum.put("kpasswd", new ServiceNode(464, true, true));
        _servToNum.put("isakmp", new ServiceNode(500, false, true));
        _servToNum.put("exec", new ServiceNode(512, true, false));
        _servToNum.put("biff", new ServiceNode(512, false, true));
        _servToNum.put("login", new ServiceNode(513, true, false));
        _servToNum.put("who", new ServiceNode(513, false, true));
        _servToNum.put("cmd", new ServiceNode(514, true, false));
        _servToNum.put("syslog", new ServiceNode(514, false, true));
        _servToNum.put("printer", new ServiceNode(515, true, false));
        _servToNum.put("talk", new ServiceNode(517, false, true));
        _servToNum.put("ntalk", new ServiceNode(518, false, true));
        _servToNum.put("efs", new ServiceNode(520, true, false));
        _servToNum.put("router", new ServiceNode(520, false, true));
        _servToNum.put("timed", new ServiceNode(525, false, true));
        _servToNum.put("tempo", new ServiceNode(526, true, false));
        _servToNum.put("courier", new ServiceNode(530, true, false));
        _servToNum.put("conference", new ServiceNode(531, true, false));
        _servToNum.put("netnews", new ServiceNode(532, true, false));
        _servToNum.put("netwall", new ServiceNode(533, false, true));
        _servToNum.put("uucp", new ServiceNode(540, true, false));
        _servToNum.put("klogin", new ServiceNode(543, true, false));
        _servToNum.put("kshell", new ServiceNode(544, true, false));
        _servToNum.put("new-rwho", new ServiceNode(550, false, true));
        _servToNum.put("remotefs", new ServiceNode(556, true, false));
        _servToNum.put("rmonitor", new ServiceNode(560, false, true));
        _servToNum.put("monitor", new ServiceNode(561, false, true));
        _servToNum.put("ldaps", new ServiceNode(636, true, false));
        _servToNum.put("doom", new ServiceNode(666, true, true));
        _servToNum.put("kerberos-adm", new ServiceNode(749, true, true));
        _servToNum.put("kerberos-iv", new ServiceNode(750, false, true));
        _servToNum.put("kpop", new ServiceNode(1109, true, false));
        _servToNum.put("phone", new ServiceNode(1167, false, true));
        _servToNum.put("ms-sql-s", new ServiceNode(1433, true, true));
        _servToNum.put("ms-sql-m", new ServiceNode(1434, true, true));
        _servToNum.put("wins", new ServiceNode(1512, true, true));
        _servToNum.put("ingreslock", new ServiceNode(1524, true, false));
        _servToNum.put("12tp", new ServiceNode(1701, false, true));
        _servToNum.put("pptp", new ServiceNode(1723, true, false));
        _servToNum.put("radius", new ServiceNode(1812, false, true));
        _servToNum.put("radacct", new ServiceNode(1813, false, true));
        _servToNum.put("nfsd", new ServiceNode(2049, false, true));
        _servToNum.put("knetd", new ServiceNode(2053, true, false));
        _servToNum.put("man", new ServiceNode(9535, true, false));
    }

    private static class ServiceNode {
        private LongValue _port;
        private boolean _isTCP;
        private boolean _isUDP;

        ServiceNode(int port, boolean tcp, boolean udp) {
            this._port = LongValue.create(port);
            this._isTCP = tcp;
            this._isUDP = udp;
        }

        public LongValue getPort() {
            return this._port;
        }

        public boolean protocolCheck(String protocol) {
            if (protocol.equals("tcp")) {
                return this._isTCP;
            }
            if (protocol.equals("udp")) {
                return this._isUDP;
            }
            return false;
        }

        public boolean isTCP() {
            return this._isTCP;
        }

        public boolean isUDP() {
            return this._isUDP;
        }
    }
}

