/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.lib;

import com.caucho.quercus.env.Env;
import com.caucho.quercus.lib.file.AbstractBinaryOutput;
import com.caucho.quercus.lib.file.PopenOutput;
import com.caucho.vfs.StreamImpl;
import com.caucho.vfs.VfsStream;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ProcOpenOutput
extends AbstractBinaryOutput {
    private static final Logger log = Logger.getLogger(PopenOutput.class.getName());
    private Env _env;
    private WriteStream _os;

    public ProcOpenOutput(Env env, OutputStream out) throws IOException {
        this._env = env;
        this._env.addClose(this);
        this._os = new WriteStream((StreamImpl)new VfsStream(null, out));
    }

    public OutputStream getOutputStream() {
        return this._os;
    }

    public void print(char v) throws IOException {
        if (this._os != null) {
            this._os.print(v);
        }
    }

    public void print(String v) throws IOException {
        if (this._os != null) {
            this._os.print(v);
        }
    }

    public void write(int ch) throws IOException {
        if (this._os != null) {
            this._os.write(ch);
        }
    }

    public void write(byte[] buffer, int offset, int length) throws IOException {
        if (this._os != null) {
            this._os.write(buffer, offset, length);
        }
    }

    public void flush() {
        try {
            if (this._os != null) {
                this._os.flush();
            }
        }
        catch (IOException e) {
            log.log(Level.FINE, e.toString(), e);
        }
    }

    public void closeWrite() {
        this.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        try {
            WriteStream os = this._os;
            this._os = null;
            if (os != null) {
                os.close();
            }
        }
        catch (IOException e) {
            log.log(Level.FINE, e.toString(), e);
        }
        finally {
            this._env.removeClose(this);
        }
    }

    public String toString() {
        return "ProcOpenOutput[pipe]";
    }
}

