/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.lib;

import com.caucho.quercus.env.Env;
import com.caucho.quercus.lib.ProcOpenInput;
import com.caucho.quercus.lib.ProcOpenOutput;
import java.io.Closeable;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ProcOpenResource
implements Closeable {
    private static final Logger log = Logger.getLogger(ProcOpenResource.class.getName());
    private Env _env;
    private ProcOpenOutput _in;
    private ProcOpenInput _out;
    private ProcOpenInput _err;
    private Process _process;

    public ProcOpenResource(Env env, Process process, ProcOpenOutput in, ProcOpenInput out, ProcOpenInput err) {
        this._env = env;
        this._process = process;
        this._in = in;
        this._out = out;
        this._err = err;
        env.addClose(this);
    }

    public void close() {
        this.pclose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int pclose() {
        try {
            if (this._in != null) {
                this._in.close();
            }
            this._out.close();
            this._err.close();
            int n = this._process.waitFor();
            return n;
        }
        catch (Exception e) {
            log.log(Level.FINE, e.getMessage());
            this._env.warning(e);
            int n = -1;
            return n;
        }
        finally {
            this._env.removeClose(this);
        }
    }

    public boolean terminate() {
        if (this._in != null) {
            this._in.close();
        }
        this._out.close();
        this._err.close();
        this._process.destroy();
        this._env.removeClose(this);
        return true;
    }
}

