/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.lib;

import com.caucho.quercus.QuercusException;
import com.caucho.quercus.QuercusModuleException;
import com.caucho.quercus.QuercusRuntimeException;
import com.caucho.quercus.annotation.Optional;
import com.caucho.quercus.annotation.Reference;
import com.caucho.quercus.env.ArrayValue;
import com.caucho.quercus.env.ArrayValueImpl;
import com.caucho.quercus.env.BooleanValue;
import com.caucho.quercus.env.BytesValue;
import com.caucho.quercus.env.Callback;
import com.caucho.quercus.env.DefaultValue;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.LongValue;
import com.caucho.quercus.env.NullValue;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.env.UnicodeBuilderValue;
import com.caucho.quercus.env.UnicodeValueImpl;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.env.Var;
import com.caucho.quercus.module.AbstractQuercusModule;
import com.caucho.util.L10N;
import com.caucho.util.LruCache;
import java.io.CharConversionException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RegexpModule
extends AbstractQuercusModule {
    private static final L10N L = new L10N(RegexpModule.class);
    private static final int REGEXP_EVAL = 1;
    private static final int REGEXP_UNICODE = 2;
    public static final int PREG_PATTERN_ORDER = 1;
    public static final int PREG_SET_ORDER = 2;
    public static final int PREG_OFFSET_CAPTURE = 4;
    public static final int PREG_SPLIT_NO_EMPTY = 1;
    public static final int PREG_SPLIT_DELIM_CAPTURE = 2;
    public static final int PREG_SPLIT_OFFSET_CAPTURE = 4;
    public static final int PREG_GREP_INVERT = 1;
    public static final boolean[] PREG_QUOTE = new boolean[256];
    private static final LruCache<StringValue, PCREPattern> _namePatternCache = new LruCache(1024);
    private static final LruCache<StringValue, Pattern> _patternCache = new LruCache(1024);
    private static final LruCache<StringValue, ArrayList<Replacement>> _replacementCache = new LruCache(1024);
    private static final HashMap<String, Value> _constMap = new HashMap();
    private static final String[] POSIX_CLASSES = new String[]{"[:alnum:]", "[:alpha:]", "[:blank:]", "[:cntrl:]", "[:digit:]", "[:graph:]", "[:lower:]", "[:print:]", "[:punct:]", "[:space:]", "[:upper:]", "[:xdigit:]"};
    private static final String[] REGEXP_CLASSES = new String[]{"\\p{Alnum}", "\\p{Alpha}", "\\p{Blank}", "\\p{Cntrl}", "\\p{Digit}", "\\p{Graph}", "\\p{Lower}", "\\p{Print}", "\\p{Punct}", "\\p{Space}", "\\p{Upper}", "\\p{XDigit}"};

    @Override
    public String[] getLoadedExtensions() {
        return new String[]{"pcre"};
    }

    public static Value ereg(Env env, StringValue pattern, StringValue string, @Optional @Reference Value regsV) {
        return RegexpModule.ereg(env, pattern, string, regsV, 0);
    }

    public static Value eregi(Env env, StringValue pattern, StringValue string, @Optional @Reference Value regsV) {
        return RegexpModule.ereg(env, pattern, string, regsV, 2);
    }

    private static Value ereg(Env env, StringValue rawPattern, StringValue string, Value regsV, int flags) {
        String cleanPattern = RegexpModule.cleanEregRegexp(rawPattern, false);
        Pattern pattern = Pattern.compile(cleanPattern, flags);
        Matcher matcher = pattern.matcher(string);
        if (!matcher.find()) {
            return BooleanValue.FALSE;
        }
        if (regsV != null && !(regsV instanceof NullValue)) {
            ArrayValueImpl regs = new ArrayValueImpl();
            regsV.set(regs);
            ((ArrayValue)regs).put(LongValue.ZERO, new UnicodeValueImpl(matcher.group()));
            int count = matcher.groupCount();
            for (int i = 1; i <= count; ++i) {
                String group = matcher.group(i);
                Value value = group == null ? BooleanValue.FALSE : new UnicodeValueImpl(group);
                ((ArrayValue)regs).put(new LongValue(i), value);
            }
            int len = matcher.end() - matcher.start();
            if (len == 0) {
                return LongValue.ONE;
            }
            return new LongValue(len);
        }
        return LongValue.ONE;
    }

    public static int preg_match(Env env, BytesValue regexp, BytesValue subject, @Optional @Reference Value matchRef, @Optional int flags, @Optional int offset) {
        boolean isOffsetCapture;
        if (regexp.length() < 2) {
            env.warning(L.l("Regexp pattern must have opening and closing delimiters"));
            return 0;
        }
        PCREPattern pcrePattern = (PCREPattern)_namePatternCache.get((Object)regexp);
        if (pcrePattern == null) {
            pcrePattern = new PCREPattern(env, regexp);
            _namePatternCache.put((Object)regexp, (Object)pcrePattern);
        }
        Matcher matcher = pcrePattern.matcher(env, subject);
        ArrayValueImpl regs = matchRef instanceof DefaultValue ? null : new ArrayValueImpl();
        if (matcher == null || !matcher.find(offset)) {
            matchRef.set(regs);
            return 0;
        }
        boolean bl = isOffsetCapture = (flags & 4) != 0;
        if (regs != null) {
            if (isOffsetCapture) {
                ArrayValueImpl part = new ArrayValueImpl();
                part.append(new UnicodeValueImpl(matcher.group()));
                part.append(new LongValue(matcher.start()));
                ((ArrayValue)regs).put(LongValue.ZERO, part);
            } else {
                ((ArrayValue)regs).put(LongValue.ZERO, new UnicodeValueImpl(matcher.group()));
            }
            int count = matcher.groupCount();
            for (int i = 1; i <= count; ++i) {
                StringValue name;
                String group = matcher.group(i);
                if (group == null) continue;
                if (isOffsetCapture) {
                    for (int j = ((ArrayValue)regs).getSize(); j < i; ++j) {
                        ArrayValueImpl part = new ArrayValueImpl();
                        part.append(StringValue.EMPTY);
                        part.append(LongValue.MINUS_ONE);
                        ((ArrayValue)regs).put(new LongValue(j), part);
                    }
                    ArrayValueImpl part = new ArrayValueImpl();
                    part.append(new UnicodeValueImpl(group));
                    part.append(new LongValue(matcher.start(i)));
                    name = pcrePattern.get(i);
                    if (name != null) {
                        ((ArrayValue)regs).put(name, part);
                    }
                    ((ArrayValue)regs).put(new LongValue(i), part);
                    continue;
                }
                for (int j = ((ArrayValue)regs).getSize(); j < i; ++j) {
                    ((ArrayValue)regs).put(new LongValue(j), StringValue.EMPTY);
                }
                UnicodeValueImpl match = new UnicodeValueImpl(group);
                name = pcrePattern.get(i);
                if (name != null) {
                    ((ArrayValue)regs).put(name, match);
                }
                ((ArrayValue)regs).put(new LongValue(i), match);
            }
            matchRef.set(regs);
        }
        return 1;
    }

    public static int preg_match_all(Env env, BytesValue regexp, BytesValue subject, @Reference Value matchRef, @Optional(value="PREG_PATTERN_ORDER") int flags, @Optional int offset) {
        PCREPattern pcrePattern;
        if (regexp.length() < 2) {
            env.warning(L.l("Pattern must have at least opening and closing delimiters"));
            return 0;
        }
        if ((flags & 1) == 0) {
            if ((flags & 2) == 0) {
                flags |= 1;
            }
        } else if ((flags & 2) != 0) {
            env.warning(L.l("Cannot combine PREG_PATTER_ORDER and PREG_SET_ORDER"));
            return 0;
        }
        if ((pcrePattern = (PCREPattern)_namePatternCache.get((Object)regexp)) == null) {
            pcrePattern = new PCREPattern(env, regexp);
            _namePatternCache.put((Object)regexp, (Object)pcrePattern);
        }
        ArrayValue matches = matchRef instanceof ArrayValue ? (ArrayValue)matchRef : new ArrayValueImpl();
        matches.clear();
        matchRef.set(matches);
        if ((flags & 1) != 0) {
            return RegexpModule.pregMatchAllPatternOrder(env, pcrePattern, subject, matches, flags, offset);
        }
        if ((flags & 2) != 0) {
            return RegexpModule.pregMatchAllSetOrder(env, pcrePattern, subject, matches, flags, offset);
        }
        throw new UnsupportedOperationException();
    }

    public static int pregMatchAllPatternOrder(Env env, PCREPattern pcrePattern, BytesValue subject, ArrayValue matches, int flags, int offset) {
        Matcher matcher = pcrePattern.matcher(env, subject);
        int groupCount = matcher == null ? 0 : matcher.groupCount();
        ArrayValue[] matchList = new ArrayValue[groupCount + 1];
        for (int j = 0; j <= groupCount; ++j) {
            ArrayValueImpl values = new ArrayValueImpl();
            StringValue patternName = pcrePattern.get(j);
            if (patternName != null) {
                matches.put(patternName, values);
            }
            matches.put(values);
            matchList[j] = values;
        }
        if (matcher == null || !matcher.find()) {
            return 0;
        }
        int count = 0;
        do {
            ++count;
            for (int j = 0; j <= groupCount; ++j) {
                int end;
                ArrayValue values = matchList[j];
                int start = matcher.start(j);
                StringValue groupValue = subject.substring(start, end = matcher.end(j));
                if (groupValue != null) {
                    groupValue = groupValue.toUnicodeValue(env);
                }
                Value result = NullValue.NULL;
                if (groupValue != null) {
                    if ((flags & 4) != 0) {
                        result = new ArrayValueImpl();
                        result.put(groupValue);
                        result.put(LongValue.create(start));
                    } else {
                        result = groupValue;
                    }
                }
                values.put(result);
            }
        } while (matcher.find());
        return count;
    }

    private static int pregMatchAllSetOrder(Env env, PCREPattern pattern, BytesValue subject, ArrayValue matches, int flags, int offset) {
        Matcher matcher = pattern.matcher(env, subject);
        if (matcher == null || !matcher.find()) {
            return 0;
        }
        int count = 0;
        do {
            ++count;
            ArrayValueImpl matchResult = new ArrayValueImpl();
            matches.put(matchResult);
            for (int i = 0; i <= matcher.groupCount(); ++i) {
                int start = matcher.start(i);
                int end = matcher.end(i);
                if (end - start <= 0) continue;
                StringValue groupValue = subject.substring(start, end);
                if (groupValue != null) {
                    groupValue = groupValue.toUnicodeValue(env);
                }
                Value result = NullValue.NULL;
                if (groupValue != null) {
                    int j;
                    if ((flags & 4) != 0) {
                        for (j = ((ArrayValue)matchResult).getSize(); j < i; ++j) {
                            ArrayValueImpl part = new ArrayValueImpl();
                            part.append(StringValue.EMPTY);
                            part.append(LongValue.MINUS_ONE);
                            ((ArrayValue)matchResult).put(LongValue.create(j), part);
                        }
                        result = new ArrayValueImpl();
                        result.put(groupValue);
                        result.put(LongValue.create(start));
                    } else {
                        for (j = ((ArrayValue)matchResult).getSize(); j < i; ++j) {
                            ((ArrayValue)matchResult).put(LongValue.create(j), StringValue.EMPTY);
                        }
                        result = groupValue;
                    }
                }
                ((ArrayValue)matchResult).put(result);
            }
        } while (matcher.find());
        return count;
    }

    public static String preg_quote(StringValue string, @Optional String delim) {
        StringBuilder sb = new StringBuilder();
        boolean[] extra = null;
        if (delim != null && !delim.equals("")) {
            extra = new boolean[256];
            for (int i = 0; i < delim.length(); ++i) {
                extra[delim.charAt((int)i)] = true;
            }
        }
        int length = string.length();
        for (int i = 0; i < length; ++i) {
            char ch = string.charAt(i);
            if (ch >= '\u0100') {
                sb.append(ch);
                continue;
            }
            if (PREG_QUOTE[ch]) {
                sb.append('\\');
                sb.append(ch);
                continue;
            }
            if (extra != null && extra[ch]) {
                sb.append('\\');
                sb.append(ch);
                continue;
            }
            sb.append(ch);
        }
        return sb.toString();
    }

    public static Value preg_replace(Env env, Value pattern, Value replacement, Value subject, @Optional(value="-1") long limit, @Optional @Reference Value count) {
        if (subject instanceof ArrayValue) {
            ArrayValueImpl result = new ArrayValueImpl();
            for (Value value : ((ArrayValue)subject).values()) {
                ((ArrayValue)result).put(RegexpModule.pregReplace(env, pattern, replacement, value.toStringValue(), limit, count));
            }
            return result;
        }
        if (subject.isset()) {
            return RegexpModule.pregReplace(env, pattern, replacement, subject.toStringValue(), limit, count);
        }
        return StringValue.EMPTY;
    }

    private static Value pregReplace(Env env, Value patternValue, Value replacement, StringValue subject, @Optional(value="-1") long limit, Value countV) {
        StringValue string = subject;
        if (limit < 0L) {
            limit = Long.MAX_VALUE;
        }
        if (patternValue.isArray() && replacement.isArray()) {
            ArrayValue patternArray = (ArrayValue)patternValue;
            ArrayValue replacementArray = (ArrayValue)replacement;
            Iterator<Value> patternIter = patternArray.values().iterator();
            Iterator<Value> replacementIter = replacementArray.values().iterator();
            while (patternIter.hasNext() && replacementIter.hasNext()) {
                string = RegexpModule.pregReplaceString(env, patternIter.next().toStringValue(), replacementIter.next().toStringValue(), string, limit, countV);
            }
        } else if (patternValue.isArray()) {
            ArrayValue patternArray = (ArrayValue)patternValue;
            for (Value value : patternArray.values()) {
                string = RegexpModule.pregReplaceString(env, value.toStringValue(), replacement.toStringValue(), string, limit, countV);
            }
        } else {
            return RegexpModule.pregReplaceString(env, patternValue.toStringValue(), replacement.toStringValue(), string, limit, countV);
        }
        return string;
    }

    private static StringValue pregReplaceCallbackImpl(Env env, StringValue patternString, Callback fun, StringValue subject, long limit, Value countV) {
        long numberOfMatches = 0L;
        if (limit < 0L) {
            limit = Long.MAX_VALUE;
        }
        Pattern pattern = RegexpModule.compileRegexp(patternString);
        Matcher matcher = pattern.matcher(subject);
        StringValue result = new UnicodeBuilderValue();
        int tail = 0;
        while (matcher.find() && numberOfMatches < limit) {
            if (countV != null && countV instanceof Var) {
                long count = ((Var)countV).getRawValue().toLong();
                countV.set(LongValue.create(count + 1L));
            }
            if (tail < matcher.start()) {
                result = result.append(subject.substring(tail, matcher.start()));
            }
            ArrayValueImpl regs = new ArrayValueImpl();
            for (int i = 0; i <= matcher.groupCount(); ++i) {
                String group = matcher.group(i);
                if (group != null) {
                    ((ArrayValue)regs).put(new UnicodeValueImpl(group));
                    continue;
                }
                ((ArrayValue)regs).put(StringValue.EMPTY);
            }
            Value replacement = fun.call(env, regs);
            result = result.append(replacement);
            tail = matcher.end();
            ++numberOfMatches;
        }
        if (tail < subject.length()) {
            result = result.append(subject.substring(tail));
        }
        return result;
    }

    private static StringValue pregReplaceString(Env env, StringValue patternString, StringValue replacement, StringValue subject, long limit, Value countV) {
        Pattern pattern = RegexpModule.compileRegexp(patternString);
        int patternFlags = RegexpModule.regexpFlags(patternString);
        boolean isEval = (patternFlags & 1) != 0;
        ArrayList<Replacement> replacementProgram = (ArrayList<Replacement>)_replacementCache.get((Object)replacement);
        if (replacementProgram == null) {
            replacementProgram = RegexpModule.compileReplacement(env, replacement, isEval);
            _replacementCache.put((Object)replacement, replacementProgram);
        }
        return RegexpModule.pregReplaceStringImpl(env, pattern, replacementProgram, subject, limit, countV, isEval);
    }

    public static Value ereg_replace(Env env, StringValue patternString, StringValue replacement, StringValue subject) {
        Pattern pattern = Pattern.compile(RegexpModule.cleanRegexp(patternString, false));
        ArrayList<Replacement> replacementProgram = (ArrayList<Replacement>)_replacementCache.get((Object)replacement);
        if (replacementProgram == null) {
            replacementProgram = RegexpModule.compileReplacement(env, replacement, false);
            _replacementCache.put((Object)replacement, replacementProgram);
        }
        return RegexpModule.pregReplaceStringImpl(env, pattern, replacementProgram, subject, -1L, NullValue.NULL, false);
    }

    public static Value eregi_replace(Env env, StringValue patternString, StringValue replacement, StringValue subject) {
        Pattern pattern = Pattern.compile(RegexpModule.cleanRegexp(patternString, false), 2);
        ArrayList<Replacement> replacementProgram = (ArrayList<Replacement>)_replacementCache.get((Object)replacement);
        if (replacementProgram == null) {
            replacementProgram = RegexpModule.compileReplacement(env, replacement, false);
            _replacementCache.put((Object)replacement, replacementProgram);
        }
        return RegexpModule.pregReplaceStringImpl(env, pattern, replacementProgram, subject, -1L, NullValue.NULL, false);
    }

    /*
     * Unable to fully structure code
     */
    private static StringValue pregReplaceStringImpl(Env env, Pattern pattern, ArrayList<Replacement> replacementProgram, StringValue subject, long limit, Value countV, boolean isEval) {
        if (limit < 0L) {
            limit = 0x7FFFFFFFFFFFFFFFL;
        }
        length = subject.length();
        matcher = pattern.matcher(subject);
        result = null;
        tail = 0;
        replacementLen = replacementProgram.size();
        while (matcher.find() && limit-- > 0L) {
            if (result == null) {
                result = new UnicodeBuilderValue();
            }
            if (countV != null && countV instanceof Var) {
                countV.set(LongValue.create(countV.toLong() + 1L));
            }
            if (tail < matcher.start()) {
                result.append(subject, tail, matcher.start());
            }
            if (isEval) {
                evalString = new UnicodeBuilderValue();
                for (i = 0; i < replacementLen; ++i) {
                    replacement = replacementProgram.get(i);
                    replacement.eval(evalString, subject, matcher);
                }
                try {
                    if (evalString.length() <= 0) ** GOTO lbl34
                    result.append(env.evalCode(evalString.toString()));
                }
                catch (IOException e) {
                    throw new QuercusException(e);
                }
            } else {
                for (i = 0; i < replacementLen; ++i) {
                    replacement = replacementProgram.get(i);
                    replacement.eval((UnicodeBuilderValue)result, subject, matcher);
                }
            }
lbl34:
            // 3 sources

            tail = matcher.end();
        }
        if (result == null) {
            return subject;
        }
        if (tail < length) {
            result.append(subject, tail, length);
        }
        return result;
    }

    public static Value preg_replace_callback(Env env, Value pattern, Callback fun, Value subject, @Optional(value="-1") long limit, @Optional @Reference Value count) {
        if (subject instanceof ArrayValue) {
            ArrayValueImpl result = new ArrayValueImpl();
            for (Value value : ((ArrayValue)subject).values()) {
                ((ArrayValue)result).put(RegexpModule.pregReplaceCallback(env, pattern.toStringValue(), fun, value.toStringValue(), limit, count));
            }
            return result;
        }
        if (subject instanceof StringValue) {
            return RegexpModule.pregReplaceCallback(env, pattern.toStringValue(), fun, subject.toStringValue(), limit, count);
        }
        return NullValue.NULL;
    }

    private static Value pregReplaceCallback(Env env, Value patternValue, Callback fun, StringValue subject, @Optional(value="-1") long limit, @Optional @Reference Value countV) {
        if (limit < 0L) {
            limit = Long.MAX_VALUE;
        }
        if (patternValue.isArray()) {
            ArrayValue patternArray = (ArrayValue)patternValue;
            for (Value value : patternArray.values()) {
                subject = RegexpModule.pregReplaceCallbackImpl(env, value.toStringValue(), fun, subject, limit, countV);
            }
            return subject;
        }
        if (patternValue instanceof StringValue) {
            return RegexpModule.pregReplaceCallbackImpl(env, patternValue.toStringValue(), fun, subject, limit, countV);
        }
        return NullValue.NULL;
    }

    public static Value preg_split(Env env, StringValue patternString, StringValue string, @Optional(value="-1") long limit, @Optional int flags) {
        if (limit <= 0L) {
            limit = Long.MAX_VALUE;
        }
        Pattern pattern = RegexpModule.compileRegexp(patternString);
        Matcher matcher = pattern.matcher(string);
        ArrayValueImpl result = new ArrayValueImpl();
        int head = 0;
        long count = 0L;
        boolean allowEmpty = (flags & 1) == 0;
        boolean isCaptureOffset = (flags & 4) != 0;
        boolean isCaptureDelim = (flags & 2) != 0;
        GroupNeighborMap neighborMap = new GroupNeighborMap(pattern.pattern(), matcher.groupCount());
        while (matcher.find()) {
            StringValue unmatched;
            int startPosition = head;
            if (count == limit - 1L) {
                unmatched = string.substring(head);
                head = string.length();
            } else {
                unmatched = string.substring(head, matcher.start());
                head = matcher.end();
            }
            if (unmatched.length() != 0 || allowEmpty) {
                if (isCaptureOffset) {
                    ArrayValueImpl part = new ArrayValueImpl();
                    ((ArrayValue)part).put(unmatched);
                    ((ArrayValue)part).put(LongValue.create(startPosition));
                    ((ArrayValue)result).put(part);
                } else {
                    ((ArrayValue)result).put(unmatched);
                }
                ++count;
            }
            if (count == limit) break;
            if (!isCaptureDelim) continue;
            for (int i = 1; i <= matcher.groupCount(); ++i) {
                ArrayValueImpl part;
                int start = matcher.start(i);
                int end = matcher.end(i);
                if (start == -1) continue;
                if (allowEmpty) {
                    int group = i;
                    while (neighborMap.hasNeighbor(group) && matcher.start(group = neighborMap.getNeighbor(group)) == -1) {
                        if (isCaptureOffset) {
                            part = new ArrayValueImpl();
                            ((ArrayValue)part).put(StringValue.EMPTY);
                            ((ArrayValue)part).put(LongValue.create(startPosition));
                            ((ArrayValue)result).put(part);
                            continue;
                        }
                        ((ArrayValue)result).put(StringValue.EMPTY);
                    }
                }
                if (end - start <= 0 && !allowEmpty) continue;
                StringValue groupValue = string.substring(start, end);
                if (isCaptureOffset) {
                    part = new ArrayValueImpl();
                    ((ArrayValue)part).put(groupValue);
                    ((ArrayValue)part).put(LongValue.create(startPosition));
                    ((ArrayValue)result).put(part);
                    continue;
                }
                ((ArrayValue)result).put(groupValue);
            }
        }
        if (count < limit && (head < string.length() || allowEmpty)) {
            if (isCaptureOffset) {
                ArrayValueImpl part = new ArrayValueImpl();
                ((ArrayValue)part).put(string.substring(head));
                ((ArrayValue)part).put(LongValue.create(head));
                ((ArrayValue)result).put(part);
            } else {
                ((ArrayValue)result).put(string.substring(head));
            }
        }
        return result;
    }

    public static String sql_regcase(String string) {
        StringBuilder sb = new StringBuilder();
        int len = string.length();
        for (int i = 0; i < len; ++i) {
            char ch = string.charAt(i);
            if (Character.isLowerCase(ch)) {
                sb.append('[');
                sb.append(Character.toUpperCase(ch));
                sb.append(ch);
                sb.append(']');
                continue;
            }
            if (Character.isUpperCase(ch)) {
                sb.append('[');
                sb.append(ch);
                sb.append(Character.toLowerCase(ch));
                sb.append(']');
                continue;
            }
            sb.append(ch);
        }
        return sb.toString();
    }

    public static Value split(Env env, StringValue patternString, StringValue string, @Optional(value="-1") long limit) {
        long count;
        if (limit < 0L) {
            limit = Long.MAX_VALUE;
        }
        String cleanRegexp = RegexpModule.cleanRegexp(patternString, false);
        Pattern pattern = Pattern.compile(cleanRegexp);
        ArrayValueImpl result = new ArrayValueImpl();
        Matcher matcher = pattern.matcher(string);
        int head = 0;
        for (count = 0L; matcher.find() && count < limit; ++count) {
            StringValue value;
            if (count == limit - 1L) {
                value = string.substring(head);
                head = string.length();
            } else {
                value = string.substring(head, matcher.start());
                head = matcher.end();
            }
            ((ArrayValue)result).put(value);
        }
        if (head <= string.length() && count != limit) {
            ((ArrayValue)result).put(string.substring(head));
        }
        return result;
    }

    public static Value preg_grep(Env env, StringValue patternString, ArrayValue input, @Optional(value="0") int flag) {
        if (input == null) {
            return NullValue.NULL;
        }
        Pattern pattern = RegexpModule.compileRegexp(patternString);
        Matcher matcher = null;
        ArrayValueImpl matchArray = new ArrayValueImpl();
        for (Map.Entry<Value, Value> entry : input.entrySet()) {
            Value entryValue = entry.getValue();
            Value entryKey = entry.getKey();
            matcher = pattern.matcher(entryValue.toString());
            boolean found = matcher.find();
            if (!found && flag == 1) {
                matchArray.append(entryKey, entryValue);
                continue;
            }
            if (!found || flag == 1) continue;
            matchArray.append(entryKey, entryValue);
        }
        return matchArray;
    }

    public static ArrayValue spliti(Env env, StringValue patternString, StringValue string, @Optional(value="-1") long limit) {
        long count;
        if (limit < 0L) {
            limit = Long.MAX_VALUE;
        }
        String cleanRegexp = RegexpModule.cleanRegexp(patternString, false);
        Pattern pattern = Pattern.compile(cleanRegexp, 2);
        ArrayValueImpl result = new ArrayValueImpl();
        Matcher matcher = pattern.matcher(string);
        int head = 0;
        for (count = 0L; matcher.find() && count < limit; ++count) {
            StringValue value;
            if (count == limit - 1L) {
                value = string.substring(head);
                head = string.length();
            } else {
                value = string.substring(head, matcher.start());
                head = matcher.end();
            }
            ((ArrayValue)result).put(value);
        }
        if (head <= string.length() && count != limit) {
            ((ArrayValue)result).put(string.substring(head));
        }
        return result;
    }

    private static Pattern compileRegexp(StringValue rawRegexp) {
        return RegexpModule.compileRegexp(rawRegexp, 0);
    }

    private static Pattern compileRegexp(StringValue rawRegexp, int groupCount) {
        Pattern pattern = (Pattern)_patternCache.get((Object)rawRegexp);
        if (pattern != null) {
            return pattern;
        }
        if (rawRegexp.length() < 2) {
            throw new IllegalStateException(L.l("Can't find delimiters in regexp '{0}'.", (Object)rawRegexp));
        }
        char delim = rawRegexp.charAt(0);
        if (delim == '{') {
            delim = '}';
        } else if (delim == '[') {
            delim = ']';
        } else if (delim == '(') {
            delim = ')';
        } else if (delim == '<') {
            delim = '>';
        }
        int tail = rawRegexp.lastIndexOf(delim);
        if (tail <= 0) {
            throw new IllegalStateException(L.l("Can't find second {0} in regexp '{1}'.", (Object)String.valueOf(delim), (Object)rawRegexp));
        }
        int len = rawRegexp.length();
        int flags = 0;
        boolean isExt = false;
        boolean isGreedy = true;
        block7: for (int i = tail + 1; i < len; ++i) {
            char ch = rawRegexp.charAt(i);
            switch (ch) {
                case 'i': {
                    flags |= 2;
                    continue block7;
                }
                case 's': {
                    flags |= 0x20;
                    continue block7;
                }
                case 'x': {
                    flags |= 4;
                    continue block7;
                }
                case 'm': {
                    flags |= 8;
                    continue block7;
                }
                case 'U': {
                    isGreedy = false;
                }
            }
        }
        StringValue regexp = rawRegexp.substring(1, tail);
        String cleanRegexp = RegexpModule.cleanRegexp(regexp, (flags & 4) != 0, groupCount);
        if (!isGreedy) {
            cleanRegexp = RegexpModule.toNonGreedy(cleanRegexp);
        }
        pattern = Pattern.compile(cleanRegexp, flags);
        _patternCache.put((Object)rawRegexp, (Object)pattern);
        return pattern;
    }

    private static int regexpFlags(StringValue rawRegexp) {
        char ch;
        int tail;
        char delim = rawRegexp.charAt(0);
        if (delim == '{') {
            delim = '}';
        } else if (delim == '[') {
            delim = ']';
        } else if (delim == '(') {
            delim = ')';
        } else if (delim == '<') {
            delim = '>';
        }
        int len = rawRegexp.length();
        int flags = 0;
        for (tail = len - 1; tail >= 0 && (ch = rawRegexp.charAt(tail)) != delim; --tail) {
            if (ch == 'e') {
                flags |= 1;
                continue;
            }
            if (ch != 'u') continue;
            flags |= 2;
        }
        if (tail <= 0) {
            throw new IllegalStateException(L.l("Can't find second {0} in regexp '{1}'.", (Object)String.valueOf(delim), (Object)rawRegexp));
        }
        return flags;
    }

    private static ArrayList<Replacement> compileReplacement(Env env, StringValue replacement, boolean isEval) {
        ArrayList<Replacement> program = new ArrayList<Replacement>();
        StringBuilder text = new StringBuilder();
        for (int i = 0; i < replacement.length(); ++i) {
            char ch = replacement.charAt(i);
            if ((ch == '\\' || ch == '$') && i + 1 < replacement.length()) {
                int group;
                char digit = replacement.charAt(i + 1);
                if ('0' <= digit && digit <= '9') {
                    group = digit - 48;
                    if (++i + 1 < replacement.length() && '0' <= (digit = replacement.charAt(i + 1)) && digit <= '9') {
                        group = 10 * group + digit - 48;
                        ++i;
                    }
                    if (text.length() > 0) {
                        program.add(new TextReplacement(text));
                    }
                    if (isEval) {
                        program.add(new GroupEscapeReplacement(group));
                    } else {
                        program.add(new GroupReplacement(group));
                    }
                    text.setLength(0);
                    continue;
                }
                if (ch == '\\') {
                    ++i;
                    if (digit != '\\') {
                        text.append('\\');
                    }
                    text.append(digit);
                    continue;
                }
                if (digit == '{') {
                    i += 2;
                    group = 0;
                    while (i < replacement.length() && '0' <= (digit = replacement.charAt(i)) && digit <= '9') {
                        group = 10 * group + digit - 48;
                        ++i;
                    }
                    if (digit != '}') {
                        env.warning(L.l("bad regexp {0}", (Object)replacement));
                        throw new QuercusException("bad regexp");
                    }
                    if (text.length() > 0) {
                        program.add(new TextReplacement(text));
                    }
                    if (isEval) {
                        program.add(new GroupEscapeReplacement(group));
                    } else {
                        program.add(new GroupReplacement(group));
                    }
                    text.setLength(0);
                    continue;
                }
                text.append(ch);
                continue;
            }
            text.append(ch);
        }
        if (text.length() > 0) {
            program.add(new TextReplacement(text));
        }
        return program;
    }

    private static String cleanRegexp(StringValue regexp, boolean isComments) {
        return RegexpModule.cleanRegexp(regexp, isComments, 0);
    }

    private static String cleanRegexp(StringValue regexp, boolean isComments, int groupCount) {
        int len = regexp.length();
        StringBuilder sb = new StringBuilder();
        int quote = 0;
        boolean sawVerticalBar = false;
        block12: for (int i = 0; i < len; ++i) {
            char ch = regexp.charAt(i);
            if (sawVerticalBar && !Character.isWhitespace(ch) && ch != '#' && ch != '|') {
                sawVerticalBar = false;
            }
            switch (ch) {
                case '\\': {
                    if (i + 1 < len) {
                        if ((ch = regexp.charAt(++i)) == '0') {
                            sb.append('\\');
                            sb.append('0');
                            sb.append(ch);
                            continue block12;
                        }
                        if ('1' <= ch && ch <= '9') {
                            char digit;
                            int backref = 0;
                            for (int j = i; j < len && backref <= groupCount && '0' <= (digit = regexp.charAt(j)) && digit <= '9'; ++j) {
                                backref = backref * 10 + (digit - 48);
                            }
                            if (backref <= groupCount) {
                                sb.append('\\');
                            } else {
                                sb.append("\\0");
                            }
                            sb.append(ch);
                            continue block12;
                        }
                        if (ch == 'x' && i + 1 < len && regexp.charAt(i + 1) == '{') {
                            sb.append('\\');
                            int tail = regexp.indexOf('}', i + 1);
                            if (tail > 0) {
                                StringValue hex = regexp.substring(i + 2, tail);
                                int length = hex.length();
                                if (length == 1) {
                                    sb.append("x0" + hex);
                                } else if (length == 2) {
                                    sb.append("x" + hex);
                                } else if (length == 3) {
                                    sb.append("u0" + hex);
                                } else if (length == 4) {
                                    sb.append("u" + hex);
                                } else {
                                    throw new QuercusRuntimeException(L.l("illegal hex escape"));
                                }
                                i = tail;
                                continue block12;
                            }
                            sb.append("\\x");
                            continue block12;
                        }
                        if (Character.isLetter(ch)) {
                            switch (ch) {
                                case 'A': 
                                case 'B': 
                                case 'D': 
                                case 'G': 
                                case 'P': 
                                case 'S': 
                                case 'W': 
                                case 'X': 
                                case 'Z': 
                                case 'a': 
                                case 'b': 
                                case 'c': 
                                case 'd': 
                                case 'e': 
                                case 'f': 
                                case 'n': 
                                case 'p': 
                                case 'r': 
                                case 's': 
                                case 't': 
                                case 'w': 
                                case 'x': 
                                case 'z': {
                                    sb.append('\\');
                                    sb.append(ch);
                                    continue block12;
                                }
                            }
                            sb.append(ch);
                            continue block12;
                        }
                        sb.append('\\');
                        sb.append(ch);
                        continue block12;
                    }
                    sb.append('\\');
                    continue block12;
                }
                case '[': {
                    if (quote == 91) {
                        if (i + 1 < len && regexp.charAt(i + 1) == ':') {
                            String test = regexp.substring(i).toString();
                            boolean hasMatch = false;
                            for (int j = 0; j < POSIX_CLASSES.length; ++j) {
                                if (!test.startsWith(POSIX_CLASSES[j])) continue;
                                hasMatch = true;
                                sb.append(REGEXP_CLASSES[j]);
                                i += POSIX_CLASSES[j].length() - 1;
                            }
                            if (!hasMatch) {
                                sb.append("\\[");
                            }
                        } else {
                            sb.append("\\[");
                        }
                    } else if (i + 1 < len && regexp.charAt(i + 1) == '[' && (i + 2 >= len || regexp.charAt(i + 2) != ':')) {
                        sb.append("[\\[");
                        ++i;
                    } else if (i + 2 < len && regexp.charAt(i + 1) == '^' && regexp.charAt(i + 2) == ']') {
                        sb.append("[^\\]");
                        i += 2;
                    } else {
                        sb.append('[');
                    }
                    if (quote != 0) continue block12;
                    quote = 91;
                    continue block12;
                }
                case '#': {
                    if (quote == 91) {
                        sb.append("\\#");
                        continue block12;
                    }
                    if (isComments) {
                        sb.append(ch);
                        ++i;
                        while (i < len) {
                            ch = regexp.charAt(i);
                            sb.append(ch);
                            if (ch == '\n' || ch == '\r') continue block12;
                            ++i;
                        }
                        continue block12;
                    }
                    sb.append(ch);
                    continue block12;
                }
                case ']': {
                    sb.append(ch);
                    if (quote != 91) continue block12;
                    quote = 0;
                    continue block12;
                }
                case '{': {
                    if (i + 1 < len && ('0' <= (ch = regexp.charAt(i + 1)) && ch <= '9' || ch == ',')) {
                        sb.append("{");
                        ++i;
                        while (i < len && ('0' <= (ch = regexp.charAt(i)) && ch <= '9' || ch == ',')) {
                            sb.append(ch);
                            ++i;
                        }
                        if (i >= len) continue block12;
                        sb.append(regexp.charAt(i));
                        continue block12;
                    }
                    sb.append("\\{");
                    continue block12;
                }
                case '}': {
                    sb.append("\\}");
                    continue block12;
                }
                case '|': {
                    if (sawVerticalBar) continue block12;
                    sb.append('|');
                    sawVerticalBar = true;
                    continue block12;
                }
                default: {
                    sb.append(ch);
                }
            }
        }
        return sb.toString();
    }

    private static String cleanEregRegexp(StringValue regexp, boolean isComments) {
        int len = regexp.length();
        StringBuilder sb = new StringBuilder();
        int quote = 0;
        boolean sawVerticalBar = false;
        block12: for (int i = 0; i < len; ++i) {
            char ch = regexp.charAt(i);
            if (sawVerticalBar && !Character.isWhitespace(ch) && ch != '#' && ch != '|') {
                sawVerticalBar = false;
            }
            switch (ch) {
                case '\\': {
                    if (quote == 91) {
                        sb.append('\\');
                        sb.append('\\');
                        continue block12;
                    }
                    if (i + 1 < len) {
                        if ((ch = regexp.charAt(++i)) == '0' || '1' <= ch && ch <= '3' && i + 1 < len && '0' <= regexp.charAt(i + 1) && ch <= '7') {
                            sb.append('\\');
                            sb.append('0');
                            sb.append(ch);
                            continue block12;
                        }
                        if (ch == 'x' && i + 1 < len && regexp.charAt(i + 1) == '{') {
                            sb.append('\\');
                            int tail = regexp.indexOf('}', i + 1);
                            if (tail > 0) {
                                StringValue hex = regexp.substring(i + 2, tail);
                                int length = hex.length();
                                if (length == 1) {
                                    sb.append("x0" + hex);
                                } else if (length == 2) {
                                    sb.append("x" + hex);
                                } else if (length == 3) {
                                    sb.append("u0" + hex);
                                } else if (length == 4) {
                                    sb.append("u" + hex);
                                } else {
                                    throw new QuercusRuntimeException(L.l("illegal hex escape"));
                                }
                                i = tail;
                                continue block12;
                            }
                            sb.append("\\x");
                            continue block12;
                        }
                        if (Character.isLetter(ch)) {
                            switch (ch) {
                                case 'A': 
                                case 'B': 
                                case 'D': 
                                case 'G': 
                                case 'P': 
                                case 'S': 
                                case 'W': 
                                case 'X': 
                                case 'Z': 
                                case 'a': 
                                case 'b': 
                                case 'c': 
                                case 'd': 
                                case 'e': 
                                case 'f': 
                                case 'n': 
                                case 'p': 
                                case 'r': 
                                case 's': 
                                case 't': 
                                case 'w': 
                                case 'x': 
                                case 'z': {
                                    sb.append('\\');
                                    sb.append(ch);
                                    continue block12;
                                }
                            }
                            sb.append(ch);
                            continue block12;
                        }
                        sb.append('\\');
                        sb.append(ch);
                        continue block12;
                    }
                    sb.append('\\');
                    continue block12;
                }
                case '[': {
                    if (quote == 91) {
                        if (i + 1 < len && regexp.charAt(i + 1) == ':') {
                            String test = regexp.substring(i).toString();
                            boolean hasMatch = false;
                            for (int j = 0; j < POSIX_CLASSES.length; ++j) {
                                if (!test.startsWith(POSIX_CLASSES[j])) continue;
                                hasMatch = true;
                                sb.append(REGEXP_CLASSES[j]);
                                i += POSIX_CLASSES[j].length() - 1;
                            }
                            if (!hasMatch) {
                                sb.append("\\[");
                            }
                        } else {
                            sb.append("\\[");
                        }
                    } else if (i + 1 < len && regexp.charAt(i + 1) == '[' && (i + 2 >= len || regexp.charAt(i + 2) != ':')) {
                        sb.append("[\\[");
                        ++i;
                    } else if (i + 2 < len && regexp.charAt(i + 1) == '^' && regexp.charAt(i + 2) == ']') {
                        sb.append("[^\\]");
                        i += 2;
                    } else {
                        sb.append('[');
                    }
                    if (quote != 0) continue block12;
                    quote = 91;
                    continue block12;
                }
                case '#': {
                    if (quote == 91) {
                        sb.append("\\#");
                        continue block12;
                    }
                    if (isComments) {
                        sb.append(ch);
                        ++i;
                        while (i < len) {
                            ch = regexp.charAt(i);
                            sb.append(ch);
                            if (ch == '\n' || ch == '\r') continue block12;
                            ++i;
                        }
                        continue block12;
                    }
                    sb.append(ch);
                    continue block12;
                }
                case ']': {
                    sb.append(ch);
                    if (quote != 91) continue block12;
                    quote = 0;
                    continue block12;
                }
                case '{': {
                    if (i + 1 < len && ('0' <= (ch = regexp.charAt(i + 1)) && ch <= '9' || ch == ',')) {
                        sb.append("{");
                        ++i;
                        while (i < len && ('0' <= (ch = regexp.charAt(i)) && ch <= '9' || ch == ',')) {
                            sb.append(ch);
                            ++i;
                        }
                        if (i >= len) continue block12;
                        sb.append(regexp.charAt(i));
                        continue block12;
                    }
                    sb.append("\\{");
                    continue block12;
                }
                case '}': {
                    sb.append("\\}");
                    continue block12;
                }
                case '|': {
                    if (sawVerticalBar) continue block12;
                    sb.append('|');
                    sawVerticalBar = true;
                    continue block12;
                }
                default: {
                    sb.append(ch);
                }
            }
        }
        return sb.toString();
    }

    private static String toNonGreedy(String regexp) {
        int len = regexp.length();
        StringBuilder sb = new StringBuilder();
        int quote = 0;
        block7: for (int i = 0; i < len; ++i) {
            char ch = regexp.charAt(i);
            switch (ch) {
                case '\\': {
                    sb.append(ch);
                    if (i + 1 >= len) continue block7;
                    sb.append(regexp.charAt(i + 1));
                    ++i;
                    continue block7;
                }
                case '[': {
                    sb.append(ch);
                    if (quote != 0) continue block7;
                    quote = ch;
                    continue block7;
                }
                case ']': {
                    sb.append(ch);
                    if (quote != 91) continue block7;
                    quote = 0;
                    continue block7;
                }
                case '(': {
                    sb.append(ch);
                    if (i + 1 >= len || (ch = regexp.charAt(i + 1)) != '?') continue block7;
                    sb.append(ch);
                    ++i;
                    continue block7;
                }
                case '*': 
                case '+': 
                case '?': {
                    sb.append(ch);
                    if (i + 1 < len && (ch = regexp.charAt(i + 1)) != '?') {
                        sb.append('?');
                        continue block7;
                    }
                    ++i;
                    continue block7;
                }
                default: {
                    sb.append(ch);
                }
            }
        }
        return sb.toString();
    }

    static {
        RegexpModule.PREG_QUOTE[92] = true;
        RegexpModule.PREG_QUOTE[43] = true;
        RegexpModule.PREG_QUOTE[42] = true;
        RegexpModule.PREG_QUOTE[63] = true;
        RegexpModule.PREG_QUOTE[91] = true;
        RegexpModule.PREG_QUOTE[94] = true;
        RegexpModule.PREG_QUOTE[93] = true;
        RegexpModule.PREG_QUOTE[36] = true;
        RegexpModule.PREG_QUOTE[40] = true;
        RegexpModule.PREG_QUOTE[41] = true;
        RegexpModule.PREG_QUOTE[123] = true;
        RegexpModule.PREG_QUOTE[125] = true;
        RegexpModule.PREG_QUOTE[61] = true;
        RegexpModule.PREG_QUOTE[33] = true;
        RegexpModule.PREG_QUOTE[60] = true;
        RegexpModule.PREG_QUOTE[62] = true;
        RegexpModule.PREG_QUOTE[124] = true;
        RegexpModule.PREG_QUOTE[58] = true;
        RegexpModule.PREG_QUOTE[46] = true;
    }

    static class PCREPattern {
        private static final Logger log = Logger.getLogger(PCREPattern.class.getName());
        private final StringValue _regexp;
        private final Pattern _pattern;
        private final int _flags;
        private int _groupCount;
        private HashMap<Integer, StringValue> _patternMap;

        PCREPattern(Env env, BytesValue regexp) {
            StringValue regexpValue;
            this._flags = RegexpModule.regexpFlags(regexp);
            if (this.isUnicode()) {
                try {
                    regexpValue = regexp.toUnicodeValue(env);
                }
                catch (QuercusRuntimeException ex) {
                    if (ex.getCause().getClass() == CharConversionException.class) {
                        regexpValue = null;
                        log.log(Level.FINE, ex.toString(), ex);
                    }
                    throw ex;
                }
            } else {
                regexpValue = regexp.toStringValue();
            }
            if (regexpValue == null) {
                this._regexp = null;
                this._pattern = null;
            } else {
                this._regexp = this.cleanRegexpAndAddGroups(regexpValue);
                this._pattern = RegexpModule.compileRegexp(this._regexp, this._groupCount);
            }
        }

        public StringValue getCleanedPattern() {
            return this._regexp;
        }

        private boolean isUnicode() {
            return (this._flags & 2) != 0;
        }

        private void add(int group, StringValue name) {
            if (this._patternMap == null) {
                this._patternMap = new HashMap();
            }
            this._patternMap.put(group, name);
        }

        public StringValue get(int group) {
            if (this._patternMap == null) {
                return null;
            }
            return this._patternMap.get(group);
        }

        public Matcher matcher(Env env, BytesValue value) {
            if (this._regexp == null || this._pattern == null) {
                return null;
            }
            if (this.isUnicode()) {
                return this._pattern.matcher(value.toUnicodeValue(env));
            }
            return this._pattern.matcher(value.toStringValue());
        }

        private StringValue cleanRegexpAndAddGroups(StringValue pattern) {
            UnicodeBuilderValue sb = new UnicodeBuilderValue();
            int length = pattern.length();
            int groupCount = 1;
            for (int i = 0; i < length; ++i) {
                char ch = pattern.charAt(i);
                sb.append(ch);
                if (ch != '(') continue;
                if (++i >= length) break;
                ch = pattern.charAt(i);
                if (ch != '?') {
                    sb.append(ch);
                    ++groupCount;
                    continue;
                }
                if (++i >= length) break;
                ch = pattern.charAt(i);
                if (ch != 'P') {
                    sb.append('?');
                    sb.append(ch);
                    continue;
                }
                if (++i >= length) break;
                ch = pattern.charAt(i);
                if (ch == '<') {
                    if (++i >= length) break;
                    int start = i;
                    while (i < length && pattern.charAt(i) != '>') {
                        ++i;
                    }
                    StringValue name = pattern.substring(start, i);
                    this.add(groupCount++, name);
                    continue;
                }
                if (ch == '=') {
                    throw new UnsupportedOperationException("back references to named subpatterns");
                }
                throw new QuercusModuleException("bad PCRE named subpattern");
            }
            this._groupCount = groupCount - 1;
            return sb;
        }
    }

    static class GroupNeighborMap {
        private int[] _neighborMap;
        private static int UNSET = -1;

        public GroupNeighborMap(String regexp, int groups) {
            this._neighborMap = new int[groups + 1];
            for (int i = 1; i <= groups; ++i) {
                this._neighborMap[i] = UNSET;
            }
            boolean sawEscape = false;
            boolean sawVerticalBar = false;
            boolean isLiteral = false;
            int group = 0;
            int parent = UNSET;
            int length = regexp.length();
            ArrayList<Boolean> openParenStack = new ArrayList<Boolean>(groups);
            for (int i = 0; i < length; ++i) {
                char ch = regexp.charAt(i);
                if (ch == ' ' || ch == '\t' || ch == '\n' || ch == 'r' || ch == '\f') continue;
                if (ch == '\\') {
                    sawEscape = !sawEscape;
                    continue;
                }
                if (ch == '[' && !sawEscape) {
                    isLiteral = true;
                    continue;
                }
                if (ch == ']' && !sawEscape) {
                    isLiteral = false;
                    continue;
                }
                if (isLiteral || sawEscape) {
                    sawEscape = false;
                    continue;
                }
                if (ch == '(') {
                    if (i + 1 < length && regexp.charAt(i + 1) == '?') {
                        openParenStack.add(true);
                        continue;
                    }
                    openParenStack.add(false);
                    ++group;
                    if (sawVerticalBar) {
                        sawVerticalBar = false;
                        this._neighborMap[group] = group - 1;
                        continue;
                    }
                    this._neighborMap[group] = parent;
                    parent = group;
                    continue;
                }
                if (ch == ')') {
                    if (((Boolean)openParenStack.remove(openParenStack.size() - 1)).booleanValue()) continue;
                    sawVerticalBar = false;
                    continue;
                }
                if (ch != '|') continue;
                sawVerticalBar = true;
            }
        }

        public boolean hasNeighbor(int group) {
            return this._neighborMap[group] != UNSET;
        }

        public int getNeighbor(int group) {
            return this._neighborMap[group];
        }
    }

    static class GroupEscapeReplacement
    extends Replacement {
        private int _group;

        GroupEscapeReplacement(int group) {
            this._group = group;
        }

        void eval(UnicodeBuilderValue sb, StringValue subject, Matcher matcher) {
            if (this._group <= matcher.groupCount()) {
                StringValue group = subject.substring(matcher.start(this._group), matcher.end(this._group));
                int len = group.length();
                for (int i = 0; i < len; ++i) {
                    char ch = group.charAt(i);
                    if (ch == '\'') {
                        sb.append("\\'");
                        continue;
                    }
                    if (ch == '\"') {
                        sb.append("\\\"");
                        continue;
                    }
                    sb.append(ch);
                }
            }
        }

        public String toString() {
            return this.getClass().getSimpleName() + "[" + this._group + "]";
        }
    }

    static class GroupReplacement
    extends Replacement {
        private int _group;

        GroupReplacement(int group) {
            this._group = group;
        }

        void eval(UnicodeBuilderValue sb, StringValue subject, Matcher matcher) {
            if (this._group <= matcher.groupCount()) {
                sb.append(subject.substring(matcher.start(this._group), matcher.end(this._group)));
            }
        }

        public String toString() {
            return this.getClass().getSimpleName() + "[" + this._group + "]";
        }
    }

    static class TextReplacement
    extends Replacement {
        private char[] _text;

        TextReplacement(StringBuilder text) {
            int length = text.length();
            this._text = new char[length];
            text.getChars(0, length, this._text, 0);
        }

        void eval(UnicodeBuilderValue sb, StringValue subject, Matcher matcher) {
            sb.append(this._text, 0, this._text.length);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.getClass().getSimpleName());
            sb.append('[');
            for (char ch : this._text) {
                sb.append(ch);
            }
            sb.append(']');
            return sb.toString();
        }
    }

    static class Replacement {
        Replacement() {
        }

        void eval(UnicodeBuilderValue sb, StringValue subject, Matcher matcher) {
        }

        public String toString() {
            return this.getClass().getSimpleName() + "[]";
        }
    }
}

