/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.lib;

import com.caucho.quercus.QuercusModuleException;
import com.caucho.quercus.annotation.Optional;
import com.caucho.quercus.env.ArrayValue;
import com.caucho.quercus.env.ArrayValueImpl;
import com.caucho.quercus.env.BooleanValue;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.LongValue;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.lib.file.FileModule;
import com.caucho.quercus.module.AbstractQuercusModule;
import com.caucho.quercus.module.IniDefinition;
import com.caucho.quercus.module.IniDefinitions;
import com.caucho.util.IntMap;
import com.caucho.util.L10N;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.util.logging.Logger;

public class TokenModule
extends AbstractQuercusModule {
    private static final L10N L = new L10N(TokenModule.class);
    private static final Logger log = Logger.getLogger(TokenModule.class.getName());
    public static final int T_ABSTRACT = 256;
    public static final int T_AND_EQUAL = 257;
    public static final int T_ARRAY = 258;
    public static final int T_ARRAY_CAST = 259;
    public static final int T_AS = 260;
    public static final int T_BAD_CHARACTER = 261;
    public static final int T_BOOLEAN_AND = 262;
    public static final int T_BOOLEAN_OR = 263;
    public static final int T_BOOL_CAST = 264;
    public static final int T_BREAK = 265;
    public static final int T_CASE = 266;
    public static final int T_CATCH = 267;
    public static final int T_CHARACTER = 268;
    public static final int T_CLASS = 269;
    public static final int T_CLONE = 270;
    public static final int T_CLOSE_TAG = 271;
    public static final int T_COMMENT = 272;
    public static final int T_CONCAT_EQUAL = 273;
    public static final int T_CONST = 274;
    public static final int T_CONSTANT_ENCAPSED_STRING = 275;
    public static final int T_CONTINUE = 276;
    public static final int T_CURLY_OPEN = 277;
    public static final int T_DEC = 278;
    public static final int T_DECLARE = 279;
    public static final int T_DEFAULT = 280;
    public static final int T_DIV_EQUAL = 281;
    public static final int T_DNUMBER = 282;
    public static final int T_DOC_COMMENT = 283;
    public static final int T_DO = 284;
    public static final int T_DOLLAR_OPEN_CURLY_BRACES = 285;
    public static final int T_DOUBLE_ARROW = 286;
    public static final int T_DOUBLE_CAST = 287;
    public static final int T_DOUBLE_COLON = 288;
    public static final int T_ECHO = 289;
    public static final int T_ELSE = 290;
    public static final int T_ELSEIF = 291;
    public static final int T_EMPTY = 292;
    public static final int T_ENCAPSED_AND_WHITESPACE = 293;
    public static final int T_ENDDECLARE = 294;
    public static final int T_ENDFOR = 295;
    public static final int T_ENDFOREACH = 296;
    public static final int T_ENDIF = 297;
    public static final int T_ENDSWITCH = 298;
    public static final int T_ENDWHILE = 299;
    public static final int T_END_HEREDOC = 300;
    public static final int T_EVAL = 301;
    public static final int T_EXIT = 302;
    public static final int T_EXTENDS = 303;
    public static final int T_FILE = 304;
    public static final int T_FINAL = 305;
    public static final int T_FOR = 306;
    public static final int T_FOREACH = 307;
    public static final int T_FUNCTION = 308;
    public static final int T_GLOBAL = 309;
    public static final int T_HALT_COMPILER = 310;
    public static final int T_IF = 311;
    public static final int T_IMPLEMENTS = 312;
    public static final int T_INC = 313;
    public static final int T_INCLUDE = 314;
    public static final int T_INCLUDE_ONCE = 315;
    public static final int T_INLINE_HTML = 316;
    public static final int T_INSTANCEOF = 317;
    public static final int T_INT_CAST = 318;
    public static final int T_INTERFACE = 319;
    public static final int T_ISSET = 320;
    public static final int T_IS_EQUAL = 321;
    public static final int T_IS_GREATER_OR_EQUAL = 322;
    public static final int T_IS_IDENTICAL = 323;
    public static final int T_IS_NOT_EQUAL = 324;
    public static final int T_IS_NOT_IDENTICAL = 325;
    public static final int T_IS_SMALLER_OR_EQUAL = 326;
    public static final int T_LINE = 327;
    public static final int T_LIST = 328;
    public static final int T_LNUMBER = 329;
    public static final int T_LOGICAL_AND = 330;
    public static final int T_LOGICAL_OR = 331;
    public static final int T_LOGICAL_XOR = 332;
    public static final int T_MINUS_EQUAL = 333;
    public static final int T_ML_COMMENT = 334;
    public static final int T_MOD_EQUAL = 335;
    public static final int T_MUL_EQUAL = 336;
    public static final int T_NEW = 337;
    public static final int T_NUM_STRING = 338;
    public static final int T_OBJECT_CAST = 339;
    public static final int T_OBJECT_OPERATOR = 340;
    public static final int T_OLD_FUNCTION = 341;
    public static final int T_OPEN_TAG = 342;
    public static final int T_OPEN_TAG_WITH_ECHO = 343;
    public static final int T_OR_EQUAL = 344;
    public static final int T_PAAMAYIM_NEKUDOTAYIM = 288;
    public static final int T_PLUS_EQUAL = 345;
    public static final int T_PRINT = 346;
    public static final int T_PRIVATE = 347;
    public static final int T_PUBLIC = 348;
    public static final int T_PROTECTED = 349;
    public static final int T_REQUIRE = 350;
    public static final int T_REQUIRE_ONCE = 351;
    public static final int T_RETURN = 352;
    public static final int T_SL = 353;
    public static final int T_SL_EQUAL = 354;
    public static final int T_SR = 355;
    public static final int T_SR_EQUAL = 356;
    public static final int T_START_HEREDOC = 357;
    public static final int T_STATIC = 358;
    public static final int T_STRING = 359;
    public static final int T_STRING_CAST = 360;
    public static final int T_STRING_VARNAME = 361;
    public static final int T_SWITCH = 362;
    public static final int T_THROW = 363;
    public static final int T_TRY = 364;
    public static final int T_UNSET = 365;
    public static final int T_UNSET_CAST = 366;
    public static final int T_USE = 367;
    public static final int T_VAR = 368;
    public static final int T_VARIABLE = 369;
    public static final int T_WHILE = 370;
    public static final int T_WHITESPACE = 371;
    public static final int T_XOR_EQUAL = 372;
    public static final int T_FUNC_C = 373;
    public static final int T_CLASS_C = 374;
    private static final IntMap _reservedMap = new IntMap();
    private static final IniDefinitions _iniDefinitions = new IniDefinitions();
    static final IniDefinition INI_HIGHLIGHT_STRING;
    static final IniDefinition INI_HIGHLIGHT_COMMENT;
    static final IniDefinition INI_HIGHLIGHT_KEYWORD;
    static final IniDefinition INI_HIGHLIGHT_BG;
    static final IniDefinition INI_HIGHLIGHT_DEFAULT;
    static final IniDefinition INI_HIGHLIGHT_HTML;

    public String[] getLoadedExtensions() {
        return new String[]{"tokenizer"};
    }

    public IniDefinitions getIniDefinitions() {
        return _iniDefinitions;
    }

    public static Value highlight_file(Env env, String filename, @Optional boolean isReturn) {
        StringValue v = FileModule.file_get_contents(env, filename, false, null, 0L, Integer.MAX_VALUE);
        if (v == null) {
            return BooleanValue.FALSE;
        }
        return TokenModule.highlight_string(env, v, isReturn);
    }

    public static Value highlight_string(Env env, StringValue s, @Optional boolean isReturn) {
        try {
            int token;
            StringValue topColor;
            StringValue sb = isReturn ? env.createUnicodeBuilder() : null;
            WriteStream out = env.getOut();
            Token lexer = new Token(env, s);
            StringValue lastColor = topColor = env.createString("#000000");
            TokenModule.highlight(sb, out, "<code>");
            TokenModule.highlight(sb, out, "<span style=\"color: #000000\">\n");
            while ((token = lexer.nextToken()) >= 0) {
                StringValue color = TokenModule.getColor(env, token);
                if (color != null && !color.equals(lastColor)) {
                    if (!topColor.equals(lastColor)) {
                        TokenModule.highlight(sb, out, "</span>");
                    }
                    if (!topColor.equals(color)) {
                        TokenModule.highlight(sb, out, "<span style=\"color: " + color + "\">");
                    }
                    lastColor = color;
                }
                if (32 <= token && token <= 127) {
                    if (sb != null) {
                        sb.append((char)token);
                        continue;
                    }
                    out.print((char)token);
                    continue;
                }
                StringValue lexeme = lexer.getLexeme();
                TokenModule.highlight(sb, out, lexeme);
            }
            if (!topColor.equals(lastColor)) {
                TokenModule.highlight(sb, out, "</span>\n");
            }
            TokenModule.highlight(sb, out, "</span>\n");
            TokenModule.highlight(sb, out, "</code>");
            if (sb != null) {
                return sb;
            }
            return BooleanValue.TRUE;
        }
        catch (IOException e) {
            throw new QuercusModuleException(e);
        }
    }

    private static void highlight(StringValue sb, WriteStream out, String string) throws IOException {
        if (sb != null) {
            sb.append(string);
        } else {
            out.print(string);
        }
    }

    private static void highlight(StringValue sb, WriteStream out, StringValue string) throws IOException {
        if (sb != null) {
            int len = string.length();
            block8: for (int i = 0; i < len; ++i) {
                char ch = string.charAt(i);
                switch (ch) {
                    case '<': {
                        sb.append("&lt;");
                        continue block8;
                    }
                    case '>': {
                        sb.append("&gt;");
                        continue block8;
                    }
                    default: {
                        sb.append(ch);
                    }
                }
            }
        } else {
            int len = string.length();
            block9: for (int i = 0; i < len; ++i) {
                char ch = string.charAt(i);
                switch (ch) {
                    case '<': {
                        out.print("&lt;");
                        continue block9;
                    }
                    case '>': {
                        out.print("&gt;");
                        continue block9;
                    }
                    default: {
                        out.print(ch);
                    }
                }
            }
        }
    }

    private static StringValue getColor(Env env, int token) {
        switch (token) {
            case 316: {
                return env.getIni("highlight.html");
            }
            case 261: 
            case 268: 
            case 271: 
            case 282: 
            case 300: 
            case 304: 
            case 327: 
            case 329: 
            case 342: 
            case 343: {
                return env.getIni("highlight.default");
            }
            case 272: 
            case 283: 
            case 334: {
                return env.getIni("highlight.comment");
            }
            case 275: 
            case 359: {
                return env.getIni("highlight.string");
            }
            case 293: 
            case 371: {
                return null;
            }
        }
        return env.getIni("highlight.keyword");
    }

    public static ArrayValue token_get_all(Env env, StringValue s) {
        int token;
        ArrayValueImpl result = new ArrayValueImpl();
        Token lexer = new Token(env, s);
        while ((token = lexer.nextToken()) >= 0) {
            if (32 <= token && token <= 127) {
                ((ArrayValue)result).put(env.createString((char)token));
                continue;
            }
            ((ArrayValue)result).put(new ArrayValueImpl().append(LongValue.create(token)).append(lexer.getLexeme()));
        }
        return result;
    }

    public static String token_name(int token) {
        switch (token) {
            case 256: {
                return "T_ABSTRACT";
            }
            case 257: {
                return "T_AND_EQUAL";
            }
            case 258: {
                return "T_ARRAY";
            }
            case 259: {
                return "T_ARRAY_CAST";
            }
            case 260: {
                return "T_AS";
            }
            case 261: {
                return "T_BAD_CHARACTER";
            }
            case 262: {
                return "T_BOOLEAN_AND";
            }
            case 263: {
                return "T_BOOLEAN_OR";
            }
            case 264: {
                return "T_BOOL_CAST";
            }
            case 265: {
                return "T_BREAK";
            }
            case 266: {
                return "T_CASE";
            }
            case 267: {
                return "T_CATCH";
            }
            case 268: {
                return "T_CHARACTER";
            }
            case 269: {
                return "T_CLASS";
            }
            case 270: {
                return "T_CLONE";
            }
            case 271: {
                return "T_CLOSE_TAG";
            }
            case 272: {
                return "T_COMMENT";
            }
            case 273: {
                return "T_CONCAT_EQUAL";
            }
            case 274: {
                return "T_CONST";
            }
            case 275: {
                return "T_CONSTANT_ENCAPSED_STRING";
            }
            case 276: {
                return "T_CONTINUE";
            }
            case 277: {
                return "T_CURLY_OPEN";
            }
            case 278: {
                return "T_DEC";
            }
            case 279: {
                return "T_DECLARE";
            }
            case 280: {
                return "T_DEFAULT";
            }
            case 281: {
                return "T_DIV_EQUAL";
            }
            case 282: {
                return "T_DNUMBER";
            }
            case 283: {
                return "T_DOC_COMMENT";
            }
            case 284: {
                return "T_DO";
            }
            case 285: {
                return "T_DOLLAR_OPEN_CURLY_BRACES";
            }
            case 286: {
                return "T_DOUBLE_ARROW";
            }
            case 287: {
                return "T_DOUBLE_CAST";
            }
            case 288: {
                return "T_DOUBLE_COLON";
            }
            case 289: {
                return "T_ECHO";
            }
            case 290: {
                return "T_ELSE";
            }
            case 291: {
                return "T_ELSEIF";
            }
            case 292: {
                return "T_EMPTY";
            }
            case 293: {
                return "T_ENCAPSED_AND_WHITESPACE";
            }
            case 294: {
                return "T_ENDDECLARE";
            }
            case 295: {
                return "T_ENDFOR";
            }
            case 296: {
                return "T_ENDFOREACH";
            }
            case 297: {
                return "T_ENDIF";
            }
            case 298: {
                return "T_ENDSWITCH";
            }
            case 299: {
                return "T_ENDWHILE";
            }
            case 300: {
                return "T_END_HEREDOC";
            }
            case 301: {
                return "T_EVAL";
            }
            case 302: {
                return "T_EXIT";
            }
            case 303: {
                return "T_EXTENDS";
            }
            case 304: {
                return "T_FILE";
            }
            case 305: {
                return "T_FINAL";
            }
            case 306: {
                return "T_FOR";
            }
            case 307: {
                return "T_FOREACH";
            }
            case 308: {
                return "T_FUNCTION";
            }
            case 309: {
                return "T_GLOBAL";
            }
            case 310: {
                return "T_HALT_COMPILER";
            }
            case 311: {
                return "T_IF";
            }
            case 312: {
                return "T_IMPLEMENTS";
            }
            case 313: {
                return "T_INC";
            }
            case 314: {
                return "T_INCLUDE";
            }
            case 315: {
                return "T_INCLUDE_ONCE";
            }
            case 316: {
                return "T_INLINE_HTML";
            }
            case 317: {
                return "T_INSTANCEOF";
            }
            case 318: {
                return "T_INT_CAST";
            }
            case 319: {
                return "T_INTERFACE";
            }
            case 320: {
                return "T_ISSET";
            }
            case 321: {
                return "T_IS_EQUAL";
            }
            case 322: {
                return "T_IS_GREATER_OR_EQUAL";
            }
            case 323: {
                return "T_IS_IDENTICAL";
            }
            case 324: {
                return "T_IS_NOT_EQUAL";
            }
            case 325: {
                return "T_IS_NOT_IDENTICAL";
            }
            case 326: {
                return "T_IS_SMALLER_OR_EQUAL";
            }
            case 327: {
                return "T_LINE";
            }
            case 328: {
                return "T_LIST";
            }
            case 329: {
                return "T_LNUMBER";
            }
            case 330: {
                return "T_LOGICAL_AND";
            }
            case 331: {
                return "T_LOGICAL_OR";
            }
            case 332: {
                return "T_LOGICAL_XOR";
            }
            case 333: {
                return "T_MINUS_EQUAL";
            }
            case 334: {
                return "T_ML_COMMENT";
            }
            case 335: {
                return "T_MOD_EQUAL";
            }
            case 336: {
                return "T_MUL_EQUAL";
            }
            case 337: {
                return "T_NEW";
            }
            case 338: {
                return "T_NUM_STRING";
            }
            case 339: {
                return "T_OBJECT_CAST";
            }
            case 340: {
                return "T_OBJECT_OPERATOR";
            }
            case 341: {
                return "T_OLD_FUNCTION";
            }
            case 342: {
                return "T_OPEN_TAG";
            }
            case 343: {
                return "T_OPEN_TAG_WITH_ECHO";
            }
            case 344: {
                return "T_OR_EQUAL";
            }
            case 345: {
                return "T_PLUS_EQUAL";
            }
            case 346: {
                return "T_PRINT";
            }
            case 347: {
                return "T_PRIVATE";
            }
            case 348: {
                return "T_PUBLIC";
            }
            case 349: {
                return "T_PROTECTED";
            }
            case 350: {
                return "T_REQUIRE";
            }
            case 351: {
                return "T_REQUIRE_ONCE";
            }
            case 352: {
                return "T_RETURN";
            }
            case 353: {
                return "T_SL";
            }
            case 354: {
                return "T_SL_EQUAL";
            }
            case 355: {
                return "T_SR";
            }
            case 356: {
                return "T_SR_EQUAL";
            }
            case 357: {
                return "T_START_HEREDOC";
            }
            case 358: {
                return "T_STATIC";
            }
            case 359: {
                return "T_STRING";
            }
            case 360: {
                return "T_STRING_CAST";
            }
            case 361: {
                return "T_STRING_VARNAME";
            }
            case 362: {
                return "T_SWITCH";
            }
            case 363: {
                return "T_THROW";
            }
            case 364: {
                return "T_TRY";
            }
            case 365: {
                return "T_UNSET";
            }
            case 366: {
                return "T_UNSET_CAST";
            }
            case 367: {
                return "T_USE";
            }
            case 368: {
                return "T_VAR";
            }
            case 369: {
                return "T_VARIABLE";
            }
            case 370: {
                return "T_WHILE";
            }
            case 371: {
                return "T_WHITESPACE";
            }
            case 372: {
                return "T_XOR_EQUAL";
            }
            case 373: {
                return "T_FUNC_C";
            }
            case 374: {
                return "T_CLASS_C";
            }
        }
        return "UNDEFINED";
    }

    static {
        _reservedMap.put((Object)"abstract", 256);
        _reservedMap.put((Object)"array", 258);
        _reservedMap.put((Object)"as", 260);
        _reservedMap.put((Object)"break", 265);
        _reservedMap.put((Object)"case", 266);
        _reservedMap.put((Object)"catch", 267);
        _reservedMap.put((Object)"class", 269);
        _reservedMap.put((Object)"clone", 270);
        _reservedMap.put((Object)"const", 274);
        _reservedMap.put((Object)"continue", 276);
        _reservedMap.put((Object)"declare", 279);
        _reservedMap.put((Object)"default", 280);
        _reservedMap.put((Object)"do", 284);
        _reservedMap.put((Object)"echo", 289);
        _reservedMap.put((Object)"else", 290);
        _reservedMap.put((Object)"elseif", 291);
        _reservedMap.put((Object)"empty", 292);
        _reservedMap.put((Object)"enddeclare", 294);
        _reservedMap.put((Object)"endfor", 295);
        _reservedMap.put((Object)"endforeach", 296);
        _reservedMap.put((Object)"endif", 297);
        _reservedMap.put((Object)"endswitch", 298);
        _reservedMap.put((Object)"eval", 301);
        _reservedMap.put((Object)"exit", 302);
        _reservedMap.put((Object)"die", 302);
        _reservedMap.put((Object)"extends", 303);
        _reservedMap.put((Object)"__FILE__", 304);
        _reservedMap.put((Object)"final", 305);
        _reservedMap.put((Object)"for", 306);
        _reservedMap.put((Object)"foreach", 307);
        _reservedMap.put((Object)"function", 308);
        _reservedMap.put((Object)"cfunction", 308);
        _reservedMap.put((Object)"global", 309);
        _reservedMap.put((Object)"__halt_compiler", 310);
        _reservedMap.put((Object)"if", 311);
        _reservedMap.put((Object)"implements", 312);
        _reservedMap.put((Object)"include", 314);
        _reservedMap.put((Object)"include_once", 315);
        _reservedMap.put((Object)"instanceof", 317);
        _reservedMap.put((Object)"isset", 320);
        _reservedMap.put((Object)"list", 328);
        _reservedMap.put((Object)"and", 330);
        _reservedMap.put((Object)"or", 331);
        _reservedMap.put((Object)"xor", 332);
        _reservedMap.put((Object)"new", 337);
        _reservedMap.put((Object)"old_function", 341);
        _reservedMap.put((Object)"print", 346);
        _reservedMap.put((Object)"private", 347);
        _reservedMap.put((Object)"public", 348);
        _reservedMap.put((Object)"protected", 349);
        _reservedMap.put((Object)"require", 350);
        _reservedMap.put((Object)"require_once", 351);
        _reservedMap.put((Object)"return", 352);
        _reservedMap.put((Object)"static", 358);
        _reservedMap.put((Object)"switch", 362);
        _reservedMap.put((Object)"throw", 363);
        _reservedMap.put((Object)"try", 364);
        _reservedMap.put((Object)"unset", 365);
        _reservedMap.put((Object)"var", 368);
        _reservedMap.put((Object)"while", 370);
        _reservedMap.put((Object)"__FUNCTION__", 373);
        _reservedMap.put((Object)"__CLASS__", 374);
        INI_HIGHLIGHT_STRING = _iniDefinitions.add("highlight.string", "#DD0000", 7);
        INI_HIGHLIGHT_COMMENT = _iniDefinitions.add("highlight.comment", "#FF8000", 7);
        INI_HIGHLIGHT_KEYWORD = _iniDefinitions.add("highlight.keyword", "#007700", 7);
        INI_HIGHLIGHT_BG = _iniDefinitions.add("highlight.bg", "#ffffff", 7);
        INI_HIGHLIGHT_DEFAULT = _iniDefinitions.add("highlight.default", "#0000BB", 7);
        INI_HIGHLIGHT_HTML = _iniDefinitions.add("highlight.html", "#000000", 7);
    }

    static class Token {
        private Env _env;
        private final StringValue _s;
        private final int _length;
        private int _i;
        private boolean _inPhp;
        private StringValue _lexeme;

        Token(Env env, StringValue s) {
            this._env = env;
            this._s = s;
            this._length = s.length();
        }

        int nextToken() {
            this._lexeme = this._env.createUnicodeBuilder();
            if (!this._inPhp) {
                this._inPhp = true;
                if (this.parseHtml()) {
                    return 316;
                }
            }
            int ch = this.read();
            switch (ch) {
                case -1: {
                    return -1;
                }
                case 9: 
                case 10: 
                case 13: 
                case 32: {
                    this._lexeme.append((char)ch);
                    while (Character.isWhitespace(ch = this.read())) {
                        this._lexeme.append((char)ch);
                    }
                    this.unread();
                    return 371;
                }
                case 40: 
                case 41: 
                case 44: 
                case 59: 
                case 64: 
                case 91: 
                case 93: 
                case 123: 
                case 125: {
                    return ch;
                }
                case 38: {
                    ch = this.read();
                    if (ch == 38) {
                        this._lexeme.append("&&");
                        return 262;
                    }
                    if (ch == 61) {
                        this._lexeme.append("&=");
                        return 257;
                    }
                    this.unread();
                    return 38;
                }
                case 124: {
                    ch = this.read();
                    if (ch == 124) {
                        this._lexeme.append("||");
                        return 263;
                    }
                    if (ch == 61) {
                        this._lexeme.append("|=");
                        return 344;
                    }
                    this.unread();
                    return 124;
                }
                case 63: {
                    ch = this.read();
                    if (ch == 62) {
                        this._lexeme.append("?>");
                        this._inPhp = false;
                        return 271;
                    }
                    this.unread();
                    return 63;
                }
                case 47: {
                    ch = this.read();
                    if (ch == 47) {
                        this._lexeme.append("//");
                        while ((ch = this.read()) >= 0 && ch != 13 && ch != 10) {
                            this._lexeme.append((char)ch);
                        }
                        this.unread();
                        return 272;
                    }
                    if (ch == 61) {
                        this._lexeme.append("/=");
                        return 281;
                    }
                    if (ch == 42) {
                        int token = 272;
                        this._lexeme.append("/*");
                        ch = this.read();
                        if (ch == 42) {
                            token = 283;
                            this._lexeme.append("*");
                        } else {
                            this.unread();
                        }
                        while ((ch = this.read()) >= 0) {
                            this._lexeme.append((char)ch);
                            if (ch != 42) continue;
                            ch = this.read();
                            if (ch == 47) {
                                this._lexeme.append((char)ch);
                                return token;
                            }
                            this.unread();
                        }
                        return token;
                    }
                    this.unread();
                    return 47;
                }
                case 35: {
                    this._lexeme.append('#');
                    while ((ch = this.read()) >= 0 && ch != 13 && ch != 10) {
                        this._lexeme.append((char)ch);
                    }
                    this.unread();
                    return 272;
                }
                case 46: {
                    ch = this.read();
                    if (ch == 61) {
                        this._lexeme.append(".=");
                        return 273;
                    }
                    this.unread();
                    return 46;
                }
                case 34: 
                case 39: 
                case 96: {
                    int end = ch;
                    this._lexeme.append((char)ch);
                    while ((ch = this.read()) >= 0 && ch != end) {
                        this._lexeme.append((char)ch);
                        if (ch != 92) continue;
                        this._lexeme.append((char)this.read());
                    }
                    if (ch > 0) {
                        this._lexeme.append((char)ch);
                    }
                    return 275;
                }
                case 45: {
                    ch = this.read();
                    if (ch == 45) {
                        this._lexeme.append("--");
                        return 278;
                    }
                    if (ch == 61) {
                        this._lexeme.append("-=");
                        return 333;
                    }
                    if (ch == 62) {
                        this._lexeme.append("->");
                        return 340;
                    }
                    this.unread();
                    return 45;
                }
                case 43: {
                    ch = this.read();
                    if (ch == 43) {
                        this._lexeme.append("++");
                        return 313;
                    }
                    if (ch == 61) {
                        this._lexeme.append("+=");
                        return 345;
                    }
                    this.unread();
                    return 43;
                }
                case 62: {
                    ch = this.read();
                    if (ch == 62) {
                        ch = this.read();
                        if (ch == 61) {
                            this._lexeme.append(">>=");
                            return 356;
                        }
                        this.unread();
                        this._lexeme.append(">>");
                        return 355;
                    }
                    if (ch == 61) {
                        this._lexeme.append(">=");
                        return 322;
                    }
                    this.unread();
                    return 62;
                }
                case 36: {
                    ch = this.read();
                    if (ch == 123) {
                        this._lexeme.append("${");
                        return 285;
                    }
                    if (ch == 36) {
                        this.unread();
                        return 36;
                    }
                    if (Character.isJavaIdentifierStart(ch)) {
                        this.unread();
                        this._lexeme.append("$");
                        this.readIdentifier();
                        return 369;
                    }
                    this.unread();
                    return 36;
                }
                case 61: {
                    ch = this.read();
                    if (ch == 61) {
                        ch = this.read();
                        if (ch == 61) {
                            this._lexeme.append("===");
                            return 323;
                        }
                        this.unread();
                        this._lexeme.append("==");
                        return 321;
                    }
                    if (ch == 62) {
                        this._lexeme.append("=>");
                        return 286;
                    }
                    this.unread();
                    return 61;
                }
                case 33: {
                    ch = this.read();
                    if (ch == 61) {
                        ch = this.read();
                        if (ch == 61) {
                            this._lexeme.append("!==");
                            return 325;
                        }
                        this.unread();
                        this._lexeme.append("!=");
                        return 324;
                    }
                    this.unread();
                    return 33;
                }
                case 58: {
                    ch = this.read();
                    if (ch == 58) {
                        this._lexeme.append("::");
                        return 288;
                    }
                    this.unread();
                    return 58;
                }
                case 60: {
                    ch = this.read();
                    if (ch == 63) {
                        ch = this.read();
                        if (ch == 61) {
                            this._lexeme.append("<?=");
                            return 343;
                        }
                        if (ch != 112) {
                            this.unread();
                            this._lexeme.append("<?");
                            return 342;
                        }
                        ch = this.read();
                        if (ch != 104) {
                            this.unread();
                            this.unread();
                            this._lexeme.append("<?");
                            return 342;
                        }
                        ch = this.read();
                        if (ch != 112) {
                            this.unread();
                            this.unread();
                            this.unread();
                            this._lexeme.append("<?");
                            return 342;
                        }
                        this._lexeme.append("<?php");
                        return 342;
                    }
                    if (ch == 37) {
                        ch = this.read();
                        if (ch == 61) {
                            this._lexeme.append("<%=");
                            return 343;
                        }
                        this.unread();
                        this._lexeme.append("<%");
                        return 342;
                    }
                    if (ch == 60) {
                        ch = this.read();
                        if (ch == 61) {
                            this._lexeme.append("<<=");
                            return 354;
                        }
                        if (ch == 60) {
                            this._lexeme.append("<<<");
                            return 357;
                        }
                        this.unread();
                        this._lexeme.append("<<");
                        return 353;
                    }
                    if (ch == 61) {
                        this._lexeme.append("<=");
                        return 326;
                    }
                    if (ch == 62) {
                        this._lexeme.append("<>");
                        return 324;
                    }
                    this.unread();
                    return 60;
                }
                case 42: {
                    ch = this.read();
                    if (ch == 61) {
                        this._lexeme.append("*=");
                        return 336;
                    }
                    this.unread();
                    return 42;
                }
                case 37: {
                    ch = this.read();
                    if (ch == 61) {
                        this._lexeme.append("%=");
                        return 335;
                    }
                    this.unread();
                    return 37;
                }
                case 94: {
                    ch = this.read();
                    if (ch == 61) {
                        this._lexeme.append("^=");
                        return 372;
                    }
                    this.unread();
                    return 94;
                }
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: {
                    this.unread();
                    return this.parseNumber();
                }
            }
            if (Character.isJavaIdentifierStart(ch)) {
                this.unread();
                this.readIdentifier();
                int lexeme = _reservedMap.get((Object)this._lexeme.toString().toLowerCase());
                if (lexeme > 0) {
                    return lexeme;
                }
                return 359;
            }
            this._lexeme.append((char)ch);
            return 261;
        }

        StringValue getLexeme() {
            return this._lexeme;
        }

        private boolean parseHtml() {
            int ch;
            while ((ch = this.read()) >= 0) {
                if (ch != 60) {
                    this._lexeme.append((char)ch);
                    continue;
                }
                ch = this.read();
                if (ch == 63 || ch == 37) {
                    this.unread();
                    this.unread();
                    return this._lexeme.length() > 0;
                }
                this._lexeme.append('<');
                this.unread();
            }
            return this._lexeme.length() > 0;
        }

        private void readIdentifier() {
            int ch;
            while (Character.isJavaIdentifierPart(ch = this.read())) {
                this._lexeme.append((char)ch);
            }
            this.unread();
        }

        private int parseNumber() {
            int ch;
            boolean isInt = false;
            while (48 <= (ch = this.read()) && ch <= 57 || ch == 46 || ch == 120 || ch == 88 || 97 <= ch && ch <= 102 || 65 <= ch && ch <= 70) {
                this._lexeme.append((char)ch);
                if (!(97 <= ch && ch <= 102 || 65 <= ch && ch <= 102 || ch == 120) && ch != 88) continue;
                isInt = true;
            }
            this.unread();
            return 329;
        }

        private int read() {
            if (this._i < this._length) {
                return this._s.charAt(this._i++);
            }
            ++this._i;
            return -1;
        }

        private void unread() {
            if (this._i <= this._length) {
                --this._i;
            }
        }
    }
}

