/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.lib;

import com.caucho.quercus.env.ArrayValue;
import com.caucho.quercus.env.ArrayValueImpl;
import com.caucho.quercus.env.BooleanValue;
import com.caucho.quercus.env.DoubleValue;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.LongValue;
import com.caucho.quercus.env.NullValue;
import com.caucho.quercus.env.ObjectValue;
import com.caucho.quercus.env.QuercusClass;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.env.Value;
import com.caucho.util.L10N;
import com.caucho.util.LruCache;
import java.io.IOException;
import java.util.logging.Logger;

public final class UnserializeReader {
    private static final L10N L = new L10N(UnserializeReader.class);
    private static final Logger log = Logger.getLogger(UnserializeReader.class.getName());
    private static final LruCache<StringKey, StringValue> _keyCache = new LruCache(4096);
    private final char[] _buffer;
    private final int _length;
    private int _index;
    private StringKey _key = new StringKey();

    public UnserializeReader(StringValue s) {
        this._buffer = s.toCharArray();
        this._length = s.length();
    }

    public UnserializeReader(String s) {
        this._buffer = s.toCharArray();
        this._length = s.length();
    }

    public Value unserialize(Env env) throws IOException {
        int ch = this.read();
        switch (ch) {
            case 98: {
                this.expect(58);
                long v = this.readInt();
                this.expect(59);
                return v == 0L ? BooleanValue.FALSE : BooleanValue.TRUE;
            }
            case 115: {
                this.expect(58);
                int len = (int)this.readInt();
                this.expect(58);
                this.expect(34);
                StringValue s = this.readStringValue(env, len);
                this.expect(34);
                this.expect(59);
                return s;
            }
            case 105: {
                this.expect(58);
                long value = this.readInt();
                this.expect(59);
                return LongValue.create(value);
            }
            case 100: {
                this.expect(58);
                StringBuilder sb = new StringBuilder();
                ch = this.read();
                while (ch >= 0 && ch != 59) {
                    sb.append((char)ch);
                    ch = this.read();
                }
                if (ch != 59) {
                    throw new IOException(L.l("expected ';'"));
                }
                return new DoubleValue(Double.parseDouble(sb.toString()));
            }
            case 97: {
                this.expect(58);
                int len = (int)this.readInt();
                this.expect(58);
                this.expect(123);
                ArrayValueImpl array = new ArrayValueImpl(len);
                for (int i = 0; i < len; ++i) {
                    Value key = this.unserializeKey(env);
                    Value value = this.unserialize(env);
                    ((ArrayValue)array).put(key, value);
                }
                this.expect(125);
                return array;
            }
            case 79: {
                ObjectValue obj;
                this.expect(58);
                int len = (int)this.readInt();
                this.expect(58);
                this.expect(34);
                String className = this.readString(len);
                this.expect(34);
                this.expect(58);
                int count = (int)this.readInt();
                this.expect(58);
                this.expect(123);
                QuercusClass qClass = env.findClass(className);
                if (qClass != null) {
                    obj = qClass.newInstance(env);
                } else {
                    log.fine(L.l("{0} is an undefined class in unserialize", (Object)className));
                    obj = env.createObject();
                    obj.putField(env, "__Quercus_Incomplete_Class_name", env.createString(className));
                }
                for (int i = 0; i < count; ++i) {
                    String key = this.unserializeString();
                    Value value = this.unserialize(env);
                    obj.putField(env, key, value);
                }
                this.expect(125);
                return obj;
            }
            case 78: {
                this.expect(59);
                return NullValue.NULL;
            }
        }
        return BooleanValue.FALSE;
    }

    public Value unserializeKey(Env env) throws IOException {
        int ch = this.read();
        switch (ch) {
            case 115: {
                StringValue v;
                this.expect(58);
                int len = (int)this.readInt();
                this.expect(58);
                this.expect(34);
                if (len < 32) {
                    this._key.init(this._buffer, this._index, len);
                    v = (StringValue)_keyCache.get((Object)this._key);
                    if (v != null) {
                        this._index += len;
                    } else {
                        StringKey key = new StringKey(this._buffer, this._index, len);
                        v = this.readStringValue(env, len);
                        _keyCache.put((Object)key, (Object)v);
                    }
                } else {
                    v = this.readStringValue(env, len);
                }
                this.expect(34);
                this.expect(59);
                return v;
            }
            case 105: {
                this.expect(58);
                long value = this.readInt();
                this.expect(59);
                return LongValue.create(value);
            }
        }
        return BooleanValue.FALSE;
    }

    private String unserializeString() throws IOException {
        this.expect(115);
        this.expect(58);
        int len = (int)this.readInt();
        this.expect(58);
        this.expect(34);
        String s = this.readString(len);
        this.expect(34);
        this.expect(59);
        return s;
    }

    public final void expect(int expectCh) throws IOException {
        char ch;
        if (this._length <= this._index) {
            throw new IOException(L.l("expected '{0}' at end of string", (Object)String.valueOf((char)expectCh)));
        }
        if ((ch = this._buffer[this._index++]) != expectCh) {
            throw new IOException(L.l("expected '{0}' at '{1}'", (Object)String.valueOf((char)expectCh), (Object)String.valueOf(ch)));
        }
    }

    public final long readInt() {
        int ch = this.read();
        long sign = 1L;
        long value = 0L;
        if (ch == 45) {
            sign = -1L;
            ch = this.read();
        } else if (ch == 43) {
            ch = this.read();
        }
        while (48 <= ch && ch <= 57) {
            value = 10L * value + (long)ch - 48L;
            ch = this.read();
        }
        this.unread();
        return sign * value;
    }

    public final String readString(int len) {
        String s = new String(this._buffer, this._index, len);
        this._index += len;
        return s;
    }

    public final StringValue readStringValue(Env env, int len) {
        StringValue s = env.createString(this._buffer, this._index, len);
        this._index += len;
        return s;
    }

    public final int read() {
        if (this._index < this._length) {
            return this._buffer[this._index++];
        }
        return -1;
    }

    public final int read(char[] buffer, int offset, int length) {
        System.arraycopy(this._buffer, this._index, buffer, offset, length);
        this._index += length;
        return length;
    }

    public final void unread() {
        --this._index;
    }

    public static final class StringKey {
        char[] _buffer;
        int _offset;
        int _length;

        StringKey() {
        }

        StringKey(char[] buffer, int offset, int length) {
            this._buffer = new char[length];
            System.arraycopy(buffer, offset, this._buffer, 0, length);
            this._offset = 0;
            this._length = length;
        }

        void init(char[] buffer, int offset, int length) {
            this._buffer = buffer;
            this._offset = offset;
            this._length = length;
        }

        public int hashCode() {
            int offset;
            char[] buffer = this._buffer;
            int end = offset + this._length;
            int hash = 17;
            for (offset = this._offset; offset < end; ++offset) {
                hash = 65521 * hash + buffer[offset];
            }
            return hash;
        }

        public boolean equals(Object o) {
            if (!(o instanceof StringKey)) {
                return false;
            }
            StringKey key = (StringKey)o;
            int length = this._length;
            if (length != key._length) {
                return false;
            }
            char[] aBuf = this._buffer;
            char[] bBuf = key._buffer;
            int aOffset = this._offset;
            int bOffset = key._offset;
            int aEnd = aOffset + length;
            while (aOffset < aEnd) {
                if (aBuf[aOffset++] == bBuf[bOffset++]) continue;
                return false;
            }
            return true;
        }
    }
}

