/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.lib;

import com.caucho.quercus.annotation.Optional;
import com.caucho.quercus.env.ArrayValue;
import com.caucho.quercus.env.ArrayValueImpl;
import com.caucho.quercus.env.BooleanValue;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.LongValue;
import com.caucho.quercus.env.ObjectValue;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.env.UnsetValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.lib.file.BinaryInput;
import com.caucho.quercus.lib.file.BinaryStream;
import com.caucho.quercus.lib.file.FileModule;
import com.caucho.quercus.module.AbstractQuercusModule;
import com.caucho.util.Base64;
import com.caucho.util.CharBuffer;
import com.caucho.util.L10N;
import com.caucho.vfs.TempBuffer;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.Socket;
import java.net.URL;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;

public class UrlModule
extends AbstractQuercusModule {
    private static final L10N L = new L10N(UrlModule.class);
    private static final Logger log = Logger.getLogger(UrlModule.class.getName());

    public static String base64_encode(InputStream is) {
        CharBuffer cb = new CharBuffer();
        TempBuffer tb = TempBuffer.allocate();
        byte[] buffer = tb.getBuffer();
        int offset = 0;
        try {
            int len;
            while ((len = is.read(buffer, offset, buffer.length - offset)) >= 0) {
                int tail = len % 3;
                Base64.encode((CharBuffer)cb, (byte[])buffer, (int)0, (int)(len - tail));
                System.arraycopy(buffer, len - tail, buffer, 0, tail);
                offset = tail;
            }
            if (offset > 0) {
                Base64.encode((CharBuffer)cb, (byte[])buffer, (int)0, (int)offset);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            TempBuffer.free((TempBuffer)tb);
        }
        return cb.toString();
    }

    public static String base64_decode(String str) {
        if (str == null) {
            return "";
        }
        return Base64.decode((String)str);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Value get_headers(Env env, String urlString, @Optional Value format) {
        Socket socket = null;
        try {
            String line;
            URL url = new URL(urlString);
            if (!url.getProtocol().equals("http") && !url.getProtocol().equals("https")) {
                env.warning(L.l("Not an HTTP URL"));
                Value value = null;
                return value;
            }
            int port = 80;
            if (url.getPort() < 0) {
                if (url.getProtocol().equals("http")) {
                    port = 80;
                } else if (url.getProtocol().equals("https")) {
                    port = 443;
                }
            } else {
                port = url.getPort();
            }
            socket = new Socket(url.getHost(), port);
            OutputStream out = socket.getOutputStream();
            InputStream in = socket.getInputStream();
            StringBuilder request = new StringBuilder();
            request.append("HEAD ");
            if (url.getPath() != null) {
                request.append(url.getPath());
            }
            if (url.getQuery() != null) {
                request.append("?" + url.getQuery());
            }
            if (url.getRef() != null) {
                request.append("#" + url.getRef());
            }
            request.append(" HTTP/1.0\r\n");
            if (url.getHost() != null) {
                request.append("Host: " + url.getHost() + "\r\n");
            }
            request.append("\r\n");
            OutputStreamWriter writer = new OutputStreamWriter(out);
            writer.write(request.toString());
            writer.flush();
            LineNumberReader reader = new LineNumberReader(new InputStreamReader(in));
            ArrayValueImpl result = new ArrayValueImpl();
            if (format.toBoolean()) {
                line = reader.readLine();
                while (line != null) {
                    if ((line = line.trim()).length() != 0) {
                        int colon = line.indexOf(58);
                        if (colon < 0) {
                            ((ArrayValue)result).put(env.createString(line.trim()));
                        } else {
                            ArrayValue values;
                            StringValue key = env.createString(line.substring(0, colon).trim());
                            StringValue value = colon < line.length() ? env.createString(line.substring(colon + 1).trim()) : env.createEmptyString();
                            if (((ArrayValue)result).get(key) != UnsetValue.UNSET) {
                                values = (ArrayValue)((ArrayValue)result).get(key);
                            } else {
                                values = new ArrayValueImpl();
                                ((ArrayValue)result).put(key, values);
                            }
                            values.put(value);
                        }
                    }
                    line = reader.readLine();
                }
                for (Value key : result.keySet()) {
                    Value value = ((ArrayValue)result).get(key);
                    if (!value.isArray() || ((ArrayValue)value).getSize() != 1) continue;
                    ((ArrayValue)result).put(key, ((ArrayValue)value).get(LongValue.ZERO));
                }
            } else {
                line = reader.readLine();
                while (line != null) {
                    if ((line = line.trim()).length() != 0) {
                        ((ArrayValue)result).put(env.createString(line.trim()));
                    }
                    line = reader.readLine();
                }
            }
            ArrayValueImpl arrayValueImpl = result;
            return arrayValueImpl;
        }
        catch (Exception e) {
            env.warning(e);
            BooleanValue booleanValue = BooleanValue.FALSE;
            return booleanValue;
        }
        finally {
            try {
                if (socket != null) {
                    socket.close();
                }
            }
            catch (IOException e) {
                env.warning(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Value get_meta_tags(Env env, String filename, @Optional(value="false") boolean use_include_path) {
        InputStream in = null;
        ArrayValueImpl result = new ArrayValueImpl();
        try {
            BinaryStream stream = FileModule.fopen(env, filename, "r", use_include_path, null);
            if (stream == null || !(stream instanceof BinaryInput)) {
                ArrayValueImpl arrayValueImpl = result;
                return arrayValueImpl;
            }
            BinaryInput input = (BinaryInput)stream;
            block14: while (!input.isEOF()) {
                String tag = UrlModule.getNextTag(input);
                if (tag.equalsIgnoreCase("meta")) {
                    String[] attr;
                    String name = null;
                    String content = null;
                    while ((attr = UrlModule.getNextAttribute(input)) != null) {
                        if (name == null && attr[0].equalsIgnoreCase("name")) {
                            if (attr.length > 1) {
                                name = attr[1];
                            }
                        } else if (content == null && attr[0].equalsIgnoreCase("content") && attr.length > 1) {
                            content = attr[1];
                        }
                        if (name == null || content == null) continue;
                        ((ArrayValue)result).put(env.createString(name), env.createString(content));
                        continue block14;
                    }
                    continue;
                }
                if (!tag.equalsIgnoreCase("/head")) continue;
                break;
            }
        }
        catch (IOException e) {
            env.warning(e);
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException e) {
                env.warning(e);
            }
        }
        return result;
    }

    public static Value http_build_query(Env env, Value formdata, @Optional String numeric_prefix) {
        String result = UrlModule.httpBuildQueryImpl(env, "", formdata, numeric_prefix).toString();
        return env.createString(result);
    }

    public static StringBuilder httpBuildQueryImpl(Env env, String path, Value formdata, String numeric_prefix) {
        Set<Map.Entry<Value, Value>> entrySet;
        StringBuilder result = new StringBuilder();
        if (formdata.isArray()) {
            entrySet = ((ArrayValue)formdata).entrySet();
        } else if (formdata.isObject()) {
            Set<Map.Entry<String, Value>> stringEntrySet = ((ObjectValue)formdata).entrySet();
            LinkedHashMap<StringValue, Value> valueMap = new LinkedHashMap<StringValue, Value>();
            for (Map.Entry<String, Value> entry : stringEntrySet) {
                valueMap.put(env.createString(entry.getKey()), entry.getValue());
            }
            entrySet = valueMap.entrySet();
        } else {
            env.warning(L.l("formdata must be an array or object"));
            return result;
        }
        for (Map.Entry<Value, Value> entry : entrySet) {
            String newPath = UrlModule.makeNewPath(path, entry.getKey(), numeric_prefix);
            if (entry.getValue().isArray() || entry.getValue().isObject()) {
                result.append((CharSequence)UrlModule.httpBuildQueryImpl(env, newPath, entry.getValue(), null));
                result.append("&");
                continue;
            }
            result.append(newPath + "=");
            result.append(UrlModule.urlencode(entry.getValue().toString()));
            result.append("&");
        }
        if (result.length() > 0) {
            result.deleteCharAt(result.length() - 1);
        }
        return result;
    }

    private static String makeNewPath(String oldPath, Value key, String numeric_prefix) {
        if (oldPath.length() == 0) {
            if (key.isLongConvertible() && numeric_prefix != null) {
                return UrlModule.urlencode(numeric_prefix + key.toString());
            }
            return UrlModule.urlencode(key.toString());
        }
        return oldPath + "[" + UrlModule.urlencode(key.toString()) + "]";
    }

    public static Value parse_url(Env env, String str) {
        if (str == null) {
            str = "";
        }
        int length = str.length();
        CharBuffer sb = new CharBuffer();
        ArrayValueImpl value = new ArrayValueImpl();
        ParseUrlState state = ParseUrlState.INIT;
        String user = null;
        block7: for (int i = 0; i < length; ++i) {
            char ch = str.charAt(i);
            switch (ch) {
                case ':': {
                    if (state == ParseUrlState.INIT) {
                        value.put("scheme", sb.toString());
                        sb.clear();
                        if (length <= i + 1 || str.charAt(i + 1) != '/') {
                            state = ParseUrlState.PATH;
                            continue block7;
                        }
                        if (length <= i + 2 || str.charAt(i + 2) != '/') {
                            state = ParseUrlState.PATH;
                            continue block7;
                        }
                        if (length <= i + 3 || str.charAt(i + 3) != '/') {
                            i += 2;
                            state = ParseUrlState.USER;
                            continue block7;
                        }
                        i += 2;
                        state = ParseUrlState.PATH;
                        continue block7;
                    }
                    if (state == ParseUrlState.USER) {
                        user = sb.toString();
                        sb.clear();
                        state = ParseUrlState.PASS;
                        continue block7;
                    }
                    if (state == ParseUrlState.HOST) {
                        value.put("host", sb.toString());
                        sb.clear();
                        state = ParseUrlState.PORT;
                        continue block7;
                    }
                    sb.append(ch);
                    continue block7;
                }
                case '@': {
                    if (state == ParseUrlState.USER) {
                        value.put("user", sb.toString());
                        sb.clear();
                        state = ParseUrlState.HOST;
                        continue block7;
                    }
                    if (state == ParseUrlState.PASS) {
                        value.put("user", user);
                        value.put("pass", sb.toString());
                        sb.clear();
                        state = ParseUrlState.HOST;
                        continue block7;
                    }
                    sb.append(ch);
                    continue block7;
                }
                case '/': {
                    if (state == ParseUrlState.USER || state == ParseUrlState.HOST) {
                        value.put("host", sb.toString());
                        sb.clear();
                        state = ParseUrlState.PATH;
                        sb.append(ch);
                        continue block7;
                    }
                    if (state == ParseUrlState.PASS) {
                        value.put("host", user);
                        value.put(env.createString("port"), new LongValue(env.createString(sb.toString()).toLong()));
                        sb.clear();
                        state = ParseUrlState.PATH;
                        sb.append(ch);
                        continue block7;
                    }
                    if (state == ParseUrlState.PORT) {
                        value.put(env.createString("port"), new LongValue(env.createString(sb.toString()).toLong()));
                        sb.clear();
                        state = ParseUrlState.PATH;
                        sb.append(ch);
                        continue block7;
                    }
                    sb.append(ch);
                    continue block7;
                }
                case '?': {
                    if (state == ParseUrlState.USER || state == ParseUrlState.HOST) {
                        value.put("host", sb.toString());
                        sb.clear();
                        state = ParseUrlState.QUERY;
                        continue block7;
                    }
                    if (state == ParseUrlState.PASS) {
                        value.put("host", user);
                        value.put(env.createString("port"), new LongValue(env.createString(sb.toString()).toLong()));
                        sb.clear();
                        state = ParseUrlState.QUERY;
                        continue block7;
                    }
                    if (state == ParseUrlState.PORT) {
                        value.put(env.createString("port"), new LongValue(env.createString(sb.toString()).toLong()));
                        sb.clear();
                        state = ParseUrlState.QUERY;
                        continue block7;
                    }
                    if (state == ParseUrlState.PATH) {
                        if (sb.length() > 0) {
                            value.put("path", sb.toString());
                        }
                        sb.clear();
                        state = ParseUrlState.QUERY;
                        continue block7;
                    }
                    sb.append(ch);
                    continue block7;
                }
                case '#': {
                    if (state == ParseUrlState.USER || state == ParseUrlState.HOST) {
                        value.put("host", sb.toString());
                        sb.clear();
                        state = ParseUrlState.FRAGMENT;
                        continue block7;
                    }
                    if (state == ParseUrlState.PASS) {
                        value.put("host", user);
                        value.put(env.createString("port"), new LongValue(env.createString(sb.toString()).toLong()));
                        sb.clear();
                        state = ParseUrlState.FRAGMENT;
                        continue block7;
                    }
                    if (state == ParseUrlState.PORT) {
                        value.put(env.createString("port"), new LongValue(env.createString(sb.toString()).toLong()));
                        sb.clear();
                        state = ParseUrlState.FRAGMENT;
                        continue block7;
                    }
                    if (state == ParseUrlState.PATH) {
                        if (sb.length() > 0) {
                            value.put("path", sb.toString());
                        }
                        sb.clear();
                        state = ParseUrlState.FRAGMENT;
                        continue block7;
                    }
                    if (state == ParseUrlState.QUERY) {
                        if (sb.length() > 0) {
                            value.put("query", sb.toString());
                        }
                        sb.clear();
                        state = ParseUrlState.FRAGMENT;
                        continue block7;
                    }
                    sb.append(ch);
                    continue block7;
                }
                default: {
                    sb.append(ch);
                }
            }
        }
        if (sb.length() != 0) {
            if (state == ParseUrlState.USER || state == ParseUrlState.HOST) {
                value.put("host", sb.toString());
            } else if (state == ParseUrlState.PASS) {
                value.put("host", user);
                value.put(env.createString("port"), new LongValue(env.createString(sb.toString()).toLong()));
            } else if (state == ParseUrlState.PORT) {
                value.put(env.createString("port"), new LongValue(env.createString(sb.toString()).toLong()));
            } else if (state == ParseUrlState.QUERY) {
                value.put("query", sb.toString());
            } else if (state == ParseUrlState.FRAGMENT) {
                value.put("fragment", sb.toString());
            } else {
                value.put("path", sb.toString());
            }
        }
        return value;
    }

    public static String rawurldecode(String s) {
        if (s == null) {
            return "";
        }
        int len = s.length();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < len; ++i) {
            char ch = s.charAt(i);
            if (ch == '%' && i + 2 < len) {
                char d1 = s.charAt(i + 1);
                char d2 = s.charAt(i + 2);
                int v = 0;
                if ('0' <= d1 && d1 <= '9') {
                    v = 16 * (d1 - 48);
                } else if ('a' <= d1 && d1 <= 'f') {
                    v = 16 * (d1 - 97 + 10);
                } else if ('A' <= d1 && d1 <= 'F') {
                    v = 16 * (d1 - 65 + 10);
                } else {
                    sb.append('%');
                    continue;
                }
                if ('0' <= d2 && d2 <= '9') {
                    v += d2 - 48;
                } else if ('a' <= d2 && d2 <= 'f') {
                    v += d2 - 97 + 10;
                } else if ('A' <= d2 && d2 <= 'F') {
                    v += d2 - 65 + 10;
                } else {
                    sb.append('%');
                    continue;
                }
                i += 2;
                sb.append((char)v);
                continue;
            }
            sb.append(ch);
        }
        return sb.toString();
    }

    public static String rawurlencode(String str) {
        if (str == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < str.length(); ++i) {
            char ch = str.charAt(i);
            if ('a' <= ch && ch <= 'z' || 'A' <= ch && ch <= 'Z' || '0' <= ch && ch <= '9' || ch == '-' || ch == '_' || ch == '.') {
                sb.append(ch);
                continue;
            }
            sb.append('%');
            sb.append(UrlModule.toHexDigit(ch >> 4));
            sb.append(UrlModule.toHexDigit(ch));
        }
        return sb.toString();
    }

    public static String urlencode(String str) {
        StringBuilder sb = new StringBuilder();
        UrlModule.urlencode(sb, str);
        return sb.toString();
    }

    private static void urlencode(StringBuilder sb, String str) {
        int len = str.length();
        for (int i = 0; i < len; ++i) {
            char ch = str.charAt(i);
            if ('a' <= ch && ch <= 'z') {
                sb.append(ch);
                continue;
            }
            if ('A' <= ch && ch <= 'Z') {
                sb.append(ch);
                continue;
            }
            if ('0' <= ch && ch <= '9') {
                sb.append(ch);
                continue;
            }
            if (ch == '-' || ch == '_' || ch == '.') {
                sb.append(ch);
                continue;
            }
            if (ch == ' ') {
                sb.append('+');
                continue;
            }
            sb.append('%');
            sb.append(UrlModule.toHexDigit(ch / 16));
            sb.append(UrlModule.toHexDigit(ch));
        }
    }

    public static String urldecode(String s) {
        if (s == null) {
            return "";
        }
        int len = s.length();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < len; ++i) {
            char ch = s.charAt(i);
            if (ch == '%' && i + 2 < len) {
                char d1 = s.charAt(i + 1);
                char d2 = s.charAt(i + 2);
                int v = 0;
                if ('0' <= d1 && d1 <= '9') {
                    v = 16 * (d1 - 48);
                } else if ('a' <= d1 && d1 <= 'f') {
                    v = 16 * (d1 - 97 + 10);
                } else if ('A' <= d1 && d1 <= 'F') {
                    v = 16 * (d1 - 65 + 10);
                } else {
                    sb.append('%');
                    continue;
                }
                if ('0' <= d2 && d2 <= '9') {
                    v += d2 - 48;
                } else if ('a' <= d2 && d2 <= 'f') {
                    v += d2 - 97 + 10;
                } else if ('A' <= d2 && d2 <= 'F') {
                    v += d2 - 65 + 10;
                } else {
                    sb.append('%');
                    continue;
                }
                i += 2;
                sb.append((char)v);
                continue;
            }
            if (ch == '+') {
                sb.append(' ');
                continue;
            }
            sb.append(ch);
        }
        return sb.toString();
    }

    private static String getNextTag(BinaryInput input) throws IOException {
        StringBuilder tag = new StringBuilder();
        int ch = 0;
        while (!input.isEOF() && ch != 60) {
            ch = input.read();
        }
        while (!input.isEOF() && !Character.isWhitespace(ch = input.read())) {
            tag.append((char)ch);
        }
        return tag.toString();
    }

    private static String[] getNextAttribute(BinaryInput input) throws IOException {
        int ch;
        UrlModule.consumeWhiteSpace(input);
        StringBuilder attribute = new StringBuilder();
        while (!input.isEOF()) {
            ch = input.read();
            if (UrlModule.isValidAttributeCharacter(ch)) {
                attribute.append((char)ch);
                continue;
            }
            input.unread();
            break;
        }
        if (attribute.length() == 0) {
            return null;
        }
        UrlModule.consumeWhiteSpace(input);
        if (input.isEOF()) {
            return new String[]{attribute.toString()};
        }
        ch = input.read();
        if (ch != 61) {
            input.unread();
            return new String[]{attribute.toString()};
        }
        UrlModule.consumeWhiteSpace(input);
        int quote = 32;
        boolean quoted = false;
        if (input.isEOF()) {
            return new String[]{attribute.toString()};
        }
        ch = input.read();
        if (ch == 34 || ch == 39) {
            quoted = true;
            quote = ch;
        } else {
            input.unread();
        }
        StringBuilder value = new StringBuilder();
        while (!input.isEOF()) {
            ch = input.read();
            if (quoted && ch == quote || !quoted && Character.isWhitespace(ch) || ch == 62) break;
            value.append((char)ch);
        }
        return new String[]{attribute.toString(), value.toString()};
    }

    private static void consumeWhiteSpace(BinaryInput input) throws IOException {
        int ch = 0;
        while (!input.isEOF() && Character.isWhitespace(ch = input.read())) {
        }
        if (!Character.isWhitespace(ch)) {
            input.unread();
        }
    }

    private static boolean isValidAttributeCharacter(int ch) {
        return Character.isLetterOrDigit(ch) || ch == 45 || ch == 46 || ch == 95 || ch == 58;
    }

    private static char toHexDigit(int d) {
        if ((d &= 0xF) < 10) {
            return (char)(48 + d);
        }
        return (char)(65 + d - 10);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum ParseUrlState {
        INIT,
        USER,
        PASS,
        HOST,
        PORT,
        PATH,
        QUERY,
        FRAGMENT;

    }
}

