/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.lib;

import com.caucho.quercus.QuercusModuleException;
import com.caucho.quercus.annotation.Optional;
import com.caucho.quercus.annotation.ReadOnly;
import com.caucho.quercus.annotation.Reference;
import com.caucho.quercus.annotation.UsesSymbolTable;
import com.caucho.quercus.env.ArrayValue;
import com.caucho.quercus.env.ArrayValueImpl;
import com.caucho.quercus.env.BooleanValue;
import com.caucho.quercus.env.DoubleValue;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.JavaValue;
import com.caucho.quercus.env.LongValue;
import com.caucho.quercus.env.NullValue;
import com.caucho.quercus.env.QuercusClass;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.env.UnicodeValueImpl;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.env.Var;
import com.caucho.quercus.lib.UnserializeReader;
import com.caucho.quercus.module.AbstractQuercusModule;
import com.caucho.util.L10N;
import com.caucho.util.LruCache;
import com.caucho.vfs.StringWriter;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class VariableModule
extends AbstractQuercusModule {
    private static final Logger log = Logger.getLogger(VariableModule.class.getName());
    private static final L10N L = new L10N(VariableModule.class);
    private static final LruCache<StringValue, Value> _unserializeCache = new LruCache(256);

    public static Value constant(Env env, String name) {
        return env.getConstant(name);
    }

    public static Value debug_zval_dump(Env env, @ReadOnly Value v) {
        try {
            VariableModule.debug_impl(env, v, 0);
            return NullValue.NULL;
        }
        catch (IOException e) {
            throw new QuercusModuleException(e);
        }
    }

    public static Value var_dump(Env env, @ReadOnly Value v) {
        try {
            if (v == null) {
                env.getOut().print("NULL#java");
            } else {
                v.varDump(env, env.getOut(), 0, new IdentityHashMap<Value, String>());
            }
            env.getOut().println();
            return NullValue.NULL;
        }
        catch (IOException e) {
            throw new QuercusModuleException(e);
        }
    }

    public static Value define(Env env, String name, Value value, @Optional boolean isCaseInsensitive) {
        return env.addConstant(name, value, isCaseInsensitive);
    }

    public static boolean defined(Env env, StringValue name) {
        return env.isDefined(name.toString());
    }

    public static Value doubleval(@ReadOnly Value v) {
        return VariableModule.floatval(v);
    }

    public static boolean empty(@ReadOnly Value v) {
        if ((v = v.toValue()) instanceof NullValue) {
            return true;
        }
        if (v instanceof StringValue) {
            String s = v.toString();
            return s.equals("") || s.equals("0");
        }
        if (v instanceof LongValue) {
            return v.toLong() == 0L;
        }
        if (v instanceof BooleanValue) {
            return !v.toBoolean();
        }
        if (v instanceof ArrayValue) {
            ArrayValue array = (ArrayValue)v;
            return array.getSize() == 0;
        }
        return false;
    }

    public static Value floatval(@ReadOnly Value v) {
        return new DoubleValue(v.toDouble());
    }

    @UsesSymbolTable
    public static Value get_defined_vars(Env env) {
        ArrayValueImpl result = new ArrayValueImpl();
        HashMap<String, Var> map = env.getEnv();
        for (Map.Entry<String, Var> entry : map.entrySet()) {
            result.append(new UnicodeValueImpl(entry.getKey()), entry.getValue().toValue());
        }
        HashMap<String, Var> globalMap = env.getGlobalEnv();
        if (map != globalMap) {
            for (Map.Entry<String, Var> entry : globalMap.entrySet()) {
                result.append(new UnicodeValueImpl(entry.getKey()), entry.getValue().toValue());
            }
        }
        return result;
    }

    public static String gettype(@ReadOnly Value v) {
        return v.getType();
    }

    public static Value get_resource_type(Value v) {
        if (!(v instanceof JavaValue)) {
            return BooleanValue.FALSE;
        }
        Object obj = v.toJavaObject();
        try {
            Method m = obj.getClass().getMethod("getResourceType", new Class[0]);
            if (m != null) {
                return StringValue.create(String.valueOf(m.invoke(obj, new Object[0])));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return StringValue.create("Unknown");
    }

    public static boolean import_request_variables(Env env, String types, @Optional String prefix) {
        if ("".equals(prefix)) {
            env.notice(L.l("import_request_variables should use a prefix argument"));
        }
        for (int i = 0; i < types.length(); ++i) {
            char ch = types.charAt(i);
            Value value = null;
            if (ch == 'c' || ch == 'C') {
                value = env.getGlobalValue("_COOKIE");
            } else if (ch == 'g' || ch == 'G') {
                value = env.getGlobalValue("_GET");
            } else if (ch == 'p' || ch == 'P') {
                value = env.getGlobalValue("_POST");
            }
            if (!(value instanceof ArrayValue)) continue;
            ArrayValue array = (ArrayValue)value;
            for (Map.Entry<Value, Value> entry : array.entrySet()) {
                String key = entry.getKey().toString();
                env.setGlobalValue(prefix + key, array.getRef(entry.getKey()));
            }
        }
        return true;
    }

    public static long intval(@ReadOnly Value v) {
        return v.toLong();
    }

    public static boolean is_array(@ReadOnly Value v) {
        return v.isArray();
    }

    public static Value is_bool(@ReadOnly Value v) {
        return v.toValue() instanceof BooleanValue ? BooleanValue.TRUE : BooleanValue.FALSE;
    }

    public static boolean is_scalar(@ReadOnly Value v) {
        if (v == null) {
            return false;
        }
        Value value = v.toValue();
        return value instanceof DoubleValue || value instanceof StringValue || value instanceof LongValue || value instanceof BooleanValue;
    }

    public static boolean is_callable(Env env, Value v, @Optional boolean isSyntaxOnly, @Optional @Reference Value nameRef) {
        if (v instanceof StringValue) {
            if (nameRef != null) {
                nameRef.set(v);
            }
            if (isSyntaxOnly) {
                return true;
            }
            return env.findFunction(v.toString().intern()) != null;
        }
        if (v instanceof ArrayValue) {
            Value obj = v.get(LongValue.ZERO);
            Value name = v.get(LongValue.ONE);
            if (!(name instanceof StringValue)) {
                return false;
            }
            if (nameRef != null) {
                nameRef.set(name);
            }
            if (obj instanceof StringValue) {
                if (isSyntaxOnly) {
                    return true;
                }
                QuercusClass cl = env.findClass(obj.toString().intern());
                if (cl == null) {
                    return false;
                }
                return cl.findFunction(name.toString().intern()) != null;
            }
            if (obj.isObject()) {
                if (isSyntaxOnly) {
                    return true;
                }
                return obj.findFunction(name.toString().intern()) != null;
            }
            return false;
        }
        return false;
    }

    public static boolean is_double(@ReadOnly Value v) {
        return VariableModule.is_float(v);
    }

    public static boolean is_float(@ReadOnly Value v) {
        return v.toValue() instanceof DoubleValue;
    }

    public static Value is_int(@ReadOnly Value v) {
        return v.toValue() instanceof LongValue ? BooleanValue.TRUE : BooleanValue.FALSE;
    }

    public static Value is_integer(@ReadOnly Value v) {
        return VariableModule.is_int(v);
    }

    public static Value is_long(@ReadOnly Value v) {
        return VariableModule.is_int(v);
    }

    public static boolean is_null(@ReadOnly Value v) {
        return v.isNull();
    }

    public static boolean is_numeric(Env env, @ReadOnly Value v) {
        return v.isNumeric();
    }

    public static boolean is_object(Env env, @ReadOnly Value v) {
        return v.isObject();
    }

    public static boolean is_real(@ReadOnly Value v) {
        return VariableModule.is_float(v);
    }

    public boolean is_resource(@ReadOnly Value value) {
        return value.toValue() instanceof JavaValue;
    }

    public boolean is_string(@ReadOnly Value value) {
        return value.toValue() instanceof StringValue;
    }

    public static boolean isset(@ReadOnly Value v) {
        return v.isset();
    }

    public static Value strval(Env env, @ReadOnly Value v) {
        if (v instanceof StringValue) {
            return (StringValue)v;
        }
        return new UnicodeValueImpl(v.toString());
    }

    public static Value print_r(Env env, @ReadOnly Value v, @Optional boolean isReturn) {
        try {
            if (isReturn) {
                StringWriter writer = new StringWriter();
                WriteStream out = writer.openWrite();
                v.printR(env, out, 0, new IdentityHashMap<Value, String>());
                return env.createString(writer.getString());
            }
            WriteStream out = env.getOut();
            v.printR(env, out, 0, new IdentityHashMap<Value, String>());
            return BooleanValue.TRUE;
        }
        catch (IOException e) {
            throw new QuercusModuleException(e);
        }
    }

    private static void printDepth(WriteStream out, int depth) throws IOException {
        for (int i = 0; i < depth; ++i) {
            out.print(' ');
        }
    }

    public static String serialize(@ReadOnly Value v) {
        StringBuilder sb = new StringBuilder();
        v.serialize(sb);
        return sb.toString();
    }

    public static boolean settype(Env env, @Reference Value var, String type) {
        Value value = var.toValue();
        if ("null".equals(type)) {
            var.set(NullValue.NULL);
            return true;
        }
        if ("boolean".equals(type) || "bool".equals(type)) {
            var.set(value.toBoolean() ? BooleanValue.TRUE : BooleanValue.FALSE);
            return true;
        }
        if ("string".equals(type)) {
            var.set(value.toStringValue());
            return true;
        }
        if ("int".equals(type) || "integer".equals(type)) {
            var.set(new LongValue(value.toLong()));
            return true;
        }
        if ("float".equals(type) || "double".equals(type)) {
            var.set(new DoubleValue(value.toDouble()));
            return true;
        }
        if ("object".equals(type)) {
            var.set(value.toObject(env));
            return true;
        }
        if ("array".equals(type)) {
            if (value.isArray()) {
                var.set(value);
            } else {
                ArrayValueImpl array = new ArrayValueImpl();
                var.set(array);
                if (!value.isNull()) {
                    array.append(value);
                }
            }
            return true;
        }
        return false;
    }

    public static Value unserialize(Env env, StringValue s) {
        Value v = (Value)_unserializeCache.get((Object)s);
        if (v != null) {
            return v.copy(env);
        }
        try {
            UnserializeReader is = new UnserializeReader(s);
            v = is.unserialize(env);
        }
        catch (Throwable e) {
            log.log(Level.FINE, e.toString(), e);
            env.notice(e.toString());
            v = BooleanValue.FALSE;
        }
        _unserializeCache.put((Object)s, (Object)v.copy(env));
        return v;
    }

    public static Value var_export(Env env, @ReadOnly Value v, @Optional boolean isReturn) {
        StringBuilder sb = new StringBuilder();
        v.varExport(sb);
        if (isReturn) {
            return env.createString(sb.toString());
        }
        env.print(sb);
        return NullValue.NULL;
    }

    private static void debug_impl(Env env, Value v, int depth) throws IOException {
        WriteStream out = env.getOut();
        if (v instanceof Var) {
            out.print("&");
        }
        if ((v = v.toValue()) instanceof ArrayValue) {
            ArrayValue array = (ArrayValue)v;
            out.println("Array");
            VariableModule.printDepth(out, 2 * depth);
            out.println("(");
            for (Map.Entry<Value, Value> mapEntry : array.entrySet()) {
                ArrayValue.Entry entry = (ArrayValue.Entry)mapEntry;
                VariableModule.printDepth(out, 2 * depth);
                out.print("    [");
                out.print((Object)entry.getKey());
                out.print("] => ");
                VariableModule.debug_impl(env, entry.getValue(), depth + 1);
            }
            VariableModule.printDepth(out, 2 * depth);
            out.println(")");
        } else if (v instanceof BooleanValue) {
            if (v.toBoolean()) {
                out.print("bool(true)");
            } else {
                out.print("bool(false)");
            }
        } else if (v instanceof LongValue) {
            out.print("int(" + v.toLong() + ")");
        } else if (v instanceof DoubleValue) {
            out.print("float(" + v.toDouble() + ")");
        } else if (v instanceof StringValue) {
            out.print("string(" + v.toString() + ")");
        } else if (v instanceof NullValue) {
            out.print("NULL");
        } else {
            v.print(env);
        }
    }
}

