/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.lib.curl;

import com.caucho.quercus.QuercusModuleException;
import com.caucho.quercus.UnimplementedException;
import com.caucho.quercus.annotation.NotNull;
import com.caucho.quercus.annotation.Optional;
import com.caucho.quercus.annotation.Reference;
import com.caucho.quercus.annotation.ReturnNullAsFalse;
import com.caucho.quercus.env.ArrayValue;
import com.caucho.quercus.env.BooleanValue;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.LongValue;
import com.caucho.quercus.env.NullValue;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.lib.curl.CurlResource;
import com.caucho.quercus.lib.file.BinaryInput;
import com.caucho.quercus.lib.file.BinaryOutput;
import com.caucho.quercus.module.AbstractQuercusModule;
import com.caucho.util.L10N;
import com.caucho.util.QDate;
import com.caucho.vfs.Path;
import com.caucho.vfs.ReadStream;
import java.io.IOException;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CurlModule
extends AbstractQuercusModule {
    private static final Logger log = Logger.getLogger(CurlModule.class.getName());
    private static final L10N L = new L10N(CurlModule.class);
    public static final int CURLOPT_AUTOREFERER = 1;
    public static final int CURLOPT_COOKIESESSION = 2;
    public static final int CURLOPT_PORT = 6;
    public static final int CURLOPT_FILE = 7;
    public static final int CURLOPT_INFILE = 8;
    public static final int CURLOPT_INFILESIZE = 9;
    public static final int CURLOPT_URL = 10;
    public static final int CURLOPT_PROXY = 11;
    public static final int CURLOPT_VERBOSE = 12;
    public static final int CURLOPT_HEADER = 13;
    public static final int CURLOPT_HTTPHEADER = 14;
    public static final int CURLOPT_NOPROGRESS = 15;
    public static final int CURLOPT_NOBODY = 16;
    public static final int CURLOPT_FAILONERROR = 17;
    public static final int CURLOPT_UPLOAD = 18;
    public static final int CURLOPT_POST = 19;
    public static final int CURLOPT_NETRC = 22;
    public static final int CURLOPT_FOLLOWLOCATION = 23;
    public static final int CURLOPT_PUT = 25;
    public static final int CURLOPT_MUTE = 26;
    public static final int CURLOPT_USERPWD = 27;
    public static final int CURLOPT_PROXYUSERPWD = 28;
    public static final int CURLOPT_RANGE = 29;
    public static final int CURLOPT_TIMEOUT = 30;
    public static final int CURLOPT_POSTFIELDS = 31;
    public static final int CURLOPT_REFERER = 32;
    public static final int CURLOPT_USERAGENT = 33;
    public static final int CURLOPT_LOW_SPEED_LIMIT = 36;
    public static final int CURLOPT_LOW_SPEED_TIME = 37;
    public static final int CURLOPT_COOKIE = 39;
    public static final int CURLOPT_WRITEHEADER = 42;
    public static final int CURLOPT_SSL_VERIFYHOST = 43;
    public static final int CURLOPT_COOKIEFILE = 44;
    public static final int CURLOPT_TIMECONDITION = 46;
    public static final int CURLOPT_TIMEVALUE = 47;
    public static final int CURLOPT_CUSTOMREQUEST = 48;
    public static final int CURLOPT_STDERR = 49;
    public static final int CURLOPT_RETURNTRANSFER = 51;
    public static final int CURLOPT_HTTPPROXYTUNNEL = 56;
    public static final int CURLOPT_WRITEFUNCTION = 58;
    public static final int CURLOPT_READFUNCTION = 59;
    public static final int CURLOPT_PASSWDFUNCTION = 60;
    public static final int CURLOPT_HEADERFUNCTION = 61;
    public static final int CURLOPT_MAXREDIRS = 62;
    public static final int CURLOPT_MAXCONNECTS = 63;
    public static final int CURLOPT_CLOSEPOLICY = 64;
    public static final int CURLOPT_FRESH_CONNECT = 65;
    public static final int CURLOPT_FORBID_REUSE = 66;
    public static final int CURLOPT_CONNECTTIMEOUT = 69;
    public static final int CURLOPT_SSL_VERIFYPEER = 70;
    public static final int CURLOPT_COOKIEJAR = 73;
    public static final int CURLOPT_BINARYTRANSFER = 75;
    public static final int CURLOPT_NOSIGNAL = 76;
    public static final int CURLOPT_PROXYTYPE = 77;
    public static final int CURLOPT_BUFFERSIZE = 78;
    public static final int CURLOPT_HTTPGET = 79;
    public static final int CURLOPT_HTTP_VERSION = 80;
    public static final int CURLOPT_ENCODING = 88;
    public static final int CURLOPT_PROXYPORT = 89;
    public static final int CURLOPT_UNRESTRICTED_AUTH = 90;
    public static final int CURLOPT_HTTP200ALIASES = 92;
    public static final int CURLOPT_HTTPAUTH = 93;
    public static final int CURLAUTH_BASIC = 1;
    public static final int CURLAUTH_DIGEST = 2;
    public static final int CURLAUTH_GSSNEGOTIATE = 4;
    public static final int CURLAUTH_NTLM = 8;
    public static final int CURLAUTH_ANY = 15;
    public static final int CURLAUTH_ANYSAFE = 14;
    public static final int CURLOPT_PROXYAUTH = 100;
    public static final int CURLCLOSEPOLICY_LEAST_RECENTLY_USED = 101;
    public static final int CURLCLOSEPOLICY_LEAST_TRAFFIC = 102;
    public static final int CURLCLOSEPOLICY_SLOWEST = 103;
    public static final int CURLCLOSEPOLICY_CALLBACK = 104;
    public static final int CURLCLOSEPOLICY_OLDEST = 105;
    public static final int CURLINFO_EFFECTIVE_URL = 106;
    public static final int CURLINFO_HTTP_CODE = 107;
    public static final int CURLINFO_HEADER_OUT = 108;
    public static final int CURLINFO_HEADER_SIZE = 109;
    public static final int CURLINFO_REQUEST_SIZE = 110;
    public static final int CURLINFO_TOTAL_TIME = 111;
    public static final int CURLINFO_NAMELOOKUP_TIME = 112;
    public static final int CURLINFO_CONNECT_TIME = 113;
    public static final int CURLINFO_PRETRANSFER_TIME = 114;
    public static final int CURLINFO_SIZE_UPLOAD = 115;
    public static final int CURLINFO_SIZE_DOWNLOAD = 116;
    public static final int CURLINFO_SPEED_DOWNLOAD = 117;
    public static final int CURLINFO_SPEED_UPLOAD = 118;
    public static final int CURLINFO_FILETIME = 119;
    public static final int CURLINFO_CONTENT_LENGTH_DOWNLOAD = 121;
    public static final int CURLINFO_CONTENT_LENGTH_UPLOAD = 122;
    public static final int CURLINFO_STARTTRANSFER_TIME = 123;
    public static final int CURLINFO_CONTENT_TYPE = 124;
    public static final int CURLINFO_REDIRECT_TIME = 125;
    public static final int CURLINFO_REDIRECT_COUNT = 126;
    public static final int CURL_VERSION_SSL = 129;
    public static final int CURL_VERSION_LIBZ = 130;
    public static final int CURLVERSION_NOW = 131;
    public static final int CURLINFO_PRIVATE = 132;
    public static final int CURLE_OK = 0;
    public static final int CURLE_UNSUPPORTED_PROTOCOL = 1;
    public static final int CURLE_FAILED_INIT = 2;
    public static final int CURLE_URL_MALFORMAT = 3;
    public static final int CURLE_URL_MALFORMAT_USER = 4;
    public static final int CURLE_COULDNT_RESOLVE_PROXY = 5;
    public static final int CURLE_COULDNT_RESOLVE_HOST = 6;
    public static final int CURLE_COULDNT_CONNECT = 7;
    public static final int CURLE_PARTIAL_FILE = 18;
    public static final int CURLE_HTTP_NOT_FOUND = 22;
    public static final int CURLE_WRITE_ERROR = 23;
    public static final int CURLE_MALFORMAT_USER = 24;
    public static final int CURLE_READ_ERROR = 26;
    public static final int CURLE_OUT_OF_MEMORY = 27;
    public static final int CURLE_OPERATION_TIMEOUTED = 28;
    public static final int CURLE_HTTP_RANGE_ERROR = 33;
    public static final int CURLE_HTTP_POST_ERROR = 34;
    public static final int CURLE_SSL_CONNECT_ERROR = 35;
    public static final int CURLE_FILE_COULDNT_READ_FILE = 37;
    public static final int CURLE_LIBRARY_NOT_FOUND = 40;
    public static final int CURLE_FUNCTION_NOT_FOUND = 41;
    public static final int CURLE_ABORTED_BY_CALLBACK = 42;
    public static final int CURLE_BAD_FUNCTION_ARGUMENT = 43;
    public static final int CURLE_BAD_CALLING_ORDER = 44;
    public static final int CURLE_HTTP_PORT_FAILED = 45;
    public static final int CURLE_BAD_PASSWORD_ENTERED = 46;
    public static final int CURLE_TOO_MANY_REDIRECTS = 47;
    public static final int CURLE_OBSOLETE = 50;
    public static final int CURLE_GOT_NOTHING = 52;
    public static final int CURLE_SEND_ERROR = 55;
    public static final int CURLE_RECV_ERROR = 56;
    public static final int CURLE_SHARE_IN_USE = 57;
    public static final int CURLE_BAD_CONTENT_ENCODING = 61;
    public static final int CURLE_FILESIZE_EXCEEDED = 63;
    public static final int CURLFTPAUTH_SSL = 1;
    public static final int CURLFTPAUTH_TLS = 2;
    public static final int CURLM_CALL_MULTI_PERFORM = -1;
    public static final int CURLM_OK = 0;
    public static final int CURLM_BAD_HANDLE = 1;
    public static final int CURLM_BAD_EASY_HANDLE = 2;
    public static final int CURLM_OUT_OF_MEMORY = 3;
    public static final int CURLM_INTERNAL_ERROR = 4;
    public static final int CURLMSG_DONE = 1;
    public static final int CURL_TIMECOND_IFMODSINCE = 198;
    public static final int CURL_TIMECOND_IFUNMODSINCE = 199;
    public static final int CURL_HTTP_VERSION_NONE = 200;
    public static final int CURL_HTTP_VERSION_1_0 = 201;
    public static final int CURL_HTTP_VERSION_1_1 = 202;
    public static final int CURLPROXY_HTTP = 203;
    public static final int CURLPROXY_SOCKS5 = 204;

    public String[] getLoadedExtensions() {
        return new String[]{"curl"};
    }

    public static void curl_close(Env env, @NotNull CurlResource curl) {
        if (curl == null) {
            return;
        }
        curl.close();
    }

    @ReturnNullAsFalse
    public static CurlResource curl_copy_handle(Env env, @NotNull CurlResource curl) {
        if (curl == null) {
            return null;
        }
        return curl.clone();
    }

    public static Value curl_errno(Env env, @NotNull CurlResource curl) {
        if (curl == null) {
            return BooleanValue.FALSE;
        }
        return LongValue.create(curl.getErrorCode());
    }

    public static Value curl_error(Env env, @NotNull CurlResource curl) {
        if (curl == null) {
            return BooleanValue.FALSE;
        }
        return env.createString(curl.getError());
    }

    public static Value curl_exec(Env env, @NotNull CurlResource curl) {
        if (curl == null) {
            return BooleanValue.FALSE;
        }
        return curl.execute(env);
    }

    public static Value curl_getinfo(Env env, @NotNull CurlResource curl, @Optional Value option) {
        if (curl == null) {
            return BooleanValue.FALSE;
        }
        return CurlModule.getInfo(env, curl, option.toInt());
    }

    private static Value getInfo(Env env, CurlResource curl, int option) {
        switch (option) {
            case 106: {
                return env.createString(curl.getURL());
            }
            case 107: {
                return LongValue.create(curl.getResponseCode());
            }
            case 119: {
                break;
            }
            case 111: {
                break;
            }
            case 112: {
                break;
            }
            case 113: {
                break;
            }
            case 114: {
                break;
            }
            case 123: {
                break;
            }
            case 125: {
                break;
            }
            case 115: {
                break;
            }
            case 116: {
                break;
            }
            case 117: {
                break;
            }
            case 118: {
                break;
            }
            case 109: {
                return LongValue.create(curl.getHeader().length());
            }
            case 108: {
                return curl.getHeader();
            }
            case 110: {
                break;
            }
            case 121: {
                return LongValue.create(curl.getContentLength());
            }
            case 122: {
                break;
            }
            case 124: {
                String type = curl.getContentType();
                if (type == null) {
                    return NullValue.NULL;
                }
                return env.createString(type);
            }
            default: {
                env.warning(L.l("Unknown CURL getinfo option"));
            }
        }
        return NullValue.NULL;
    }

    public static CurlResource curl_init(Env env, @Optional(value="") String url) {
        CurlResource curl = new CurlResource();
        if (url != null && url.length() > 0) {
            CurlModule.setURL(curl, url);
        }
        return curl;
    }

    private static void setURL(CurlResource curl, String url) {
        String protocol;
        int atSignIndex = url.indexOf(64);
        if (atSignIndex < 0) {
            curl.setURL(url);
            return;
        }
        int j = url.indexOf("://");
        if (j < 0) {
            protocol = "http://";
            j = 0;
        } else {
            protocol = url.substring(0, j += 3);
        }
        int colonIndex = url.indexOf(58, j);
        if (colonIndex < 0) {
            return;
        }
        curl.setUsername(url.substring(j, colonIndex++));
        curl.setPassword(url.substring(colonIndex, atSignIndex++));
        curl.setURL(protocol + url.substring(atSignIndex));
    }

    public static LongValue curl_multi_add_handle(Env env, Value curls, Value curl) {
        throw new UnimplementedException("curl_multi_add_handle");
    }

    public static LongValue curl_multi_close(Env env, Value curls) {
        throw new UnimplementedException("curl_multi_close");
    }

    public static LongValue curl_multi_exec(Env env, Value curls, @Reference Value stillRunning) {
        throw new UnimplementedException("curl_multi_exec");
    }

    public static StringValue curl_multi_getcontent(Env env, Value curl) {
        throw new UnimplementedException("curl_multi_getcontent");
    }

    public static ArrayValue curl_multi_info_read(Env env, Value curls) {
        throw new UnimplementedException("curl_multi_info_read");
    }

    public static Value curl_multi_init(Env env) {
        throw new UnimplementedException("curl_multi_init");
    }

    public static LongValue curl_multi_remove_handle(Env env, Value curls, Value curl) {
        throw new UnimplementedException("curl_multi_remove_handle");
    }

    public static LongValue curl_multi_select(Env env, Value curls, @Optional Value timeout) {
        throw new UnimplementedException("curl_multi_select");
    }

    public static BooleanValue curl_setopt_array(Env env, @NotNull CurlResource curl, ArrayValue options) {
        if (curl == null) {
            return BooleanValue.FALSE;
        }
        for (Map.Entry<Value, Value> entry : options.entrySet()) {
            if (!CurlModule.setOption(env, curl, entry.getKey().toInt(), entry.getValue())) continue;
            return BooleanValue.FALSE;
        }
        return BooleanValue.TRUE;
    }

    public static BooleanValue curl_setopt(Env env, @NotNull CurlResource curl, int option, Value value) {
        if (curl == null) {
            return BooleanValue.FALSE;
        }
        if (CurlModule.setOption(env, curl, option, value)) {
            return BooleanValue.TRUE;
        }
        return BooleanValue.FALSE;
    }

    private static boolean setOption(Env env, CurlResource curl, int option, Value value) {
        block2 : switch (option) {
            case 1: {
                break;
            }
            case 2: {
                curl.setCookie(null);
                break;
            }
            case 17: {
                curl.setFailOnError(value.toBoolean());
                break;
            }
            case 23: {
                curl.setIsFollowingRedirects(value.toBoolean());
                break;
            }
            case 13: {
                curl.setIsReturningHeader(value.toBoolean());
                break;
            }
            case 79: {
                curl.setRequestMethod("GET");
                break;
            }
            case 56: {
                curl.setIsProxying(value.toBoolean());
                break;
            }
            case 26: {
                curl.setIsVerbose(!value.toBoolean());
                break;
            }
            case 22: {
                break;
            }
            case 16: {
                curl.setIsReturningBody(false);
                break;
            }
            case 15: {
                break;
            }
            case 19: {
                curl.setRequestMethod("POST");
                break;
            }
            case 25: {
                curl.setRequestMethod("PUT");
                break;
            }
            case 51: {
                curl.setIsReturningData(value.toBoolean());
                break;
            }
            case 90: {
                break;
            }
            case 70: {
                curl.setIsVerifySSLPeer(value.toBoolean());
                break;
            }
            case 18: {
                if (!value.toBoolean()) break;
                curl.setRequestMethod("PUT");
                break;
            }
            case 12: {
                curl.setIsVerbose(value.toBoolean());
                break;
            }
            case 78: {
                break;
            }
            case 69: {
                curl.setConnectTimeout(value.toInt() * 1000);
                break;
            }
            case 80: {
                if (value.toInt() != 201) break;
                env.stub("cURL HTTP/1.0 not specifically supported");
                break;
            }
            case 93: {
                break;
            }
            case 9: {
                curl.setUploadFileSize(value.toInt());
                break;
            }
            case 36: {
                break;
            }
            case 37: {
                break;
            }
            case 63: {
                break;
            }
            case 6: {
                curl.setPort(value.toInt());
                break;
            }
            case 100: {
                break;
            }
            case 89: {
                curl.setProxyPort(value.toInt());
                break;
            }
            case 77: {
                switch (value.toInt()) {
                    case 203: {
                        curl.setProxyType("HTTP");
                        break block2;
                    }
                    case 204: {
                        curl.setProxyType("SOCKS");
                        break block2;
                    }
                }
                env.warning(L.l("unknown curl proxy type"));
                break;
            }
            case 43: {
                int i = value.toInt();
                switch (i) {
                    case 0: {
                        curl.setIsVerifySSLCommonName(false);
                        curl.setIsVerifySSLHostname(false);
                        break block2;
                    }
                    case 1: {
                        curl.setIsVerifySSLCommonName(true);
                        curl.setIsVerifySSLHostname(false);
                        break block2;
                    }
                    case 2: {
                        curl.setIsVerifySSLCommonName(true);
                        curl.setIsVerifySSLHostname(true);
                        break block2;
                    }
                }
                env.warning(L.l("unknown ssl verify host option '{0}", (long)i));
                break;
            }
            case 46: {
                switch (value.toInt()) {
                    case 198: {
                        curl.setIfModifiedSince(true);
                        break block2;
                    }
                    case 199: {
                        curl.setIfModifiedSince(false);
                        break block2;
                    }
                }
                env.warning(L.l("invalid CURLOPT_TIMECONDITION option"));
                break;
            }
            case 30: {
                curl.setReadTimeout(value.toInt() * 1000);
                break;
            }
            case 47: {
                long time = (long)value.toInt() * 1000L;
                String format = "%a, %d %b %Y %H:%M:%S %Z";
                curl.setModifiedTime(QDate.formatGMT((long)time, (String)format));
                break;
            }
            case 39: {
                curl.setCookie(value.toString());
                break;
            }
            case 44: {
                ReadStream in = null;
                try {
                    int ch;
                    Path path = env.getPwd().lookup(value.toString());
                    if (!path.exists()) break;
                    in = path.openRead();
                    StringBuilder sb = new StringBuilder();
                    while ((ch = in.read()) >= 0) {
                        sb.append((char)ch);
                    }
                    curl.setCookie(sb.toString());
                    break;
                }
                catch (IOException e) {
                    throw new QuercusModuleException(e);
                }
                finally {
                    if (in != null) {
                        in.close();
                    }
                }
            }
            case 73: {
                curl.setCookieFilename(value.toString());
                break;
            }
            case 48: {
                curl.setRequestMethod(value.toString());
                break;
            }
            case 88: {
                String encoding = value.toString();
                if (encoding.length() == 0) {
                    encoding = "gzip, deflate, identity";
                }
                curl.setRequestProperty("Accept-Encoding", encoding);
                break;
            }
            case 31: {
                curl.setRequestMethod("POST");
                curl.setPostBody(value.toBinaryValue(env));
                break;
            }
            case 11: {
                curl.setIsProxying(true);
                curl.setProxyURL(value.toString());
                break;
            }
            case 28: {
                String proxyUserPwd = value.toString();
                int i = proxyUserPwd.indexOf(58);
                if (i >= 0) {
                    curl.setProxyUsername(proxyUserPwd.substring(0, i));
                }
                curl.setProxyPassword(proxyUserPwd.substring(i + 1));
                break;
            }
            case 29: {
                curl.setRequestProperty("Range", "bytes=" + value.toString());
                break;
            }
            case 32: {
                curl.setRequestProperty("Referer", value.toString());
                break;
            }
            case 10: {
                CurlModule.setURL(curl, value.toString());
                break;
            }
            case 33: {
                curl.setRequestProperty("User-Agent", value.toString());
                break;
            }
            case 27: {
                String userpwd = value.toString();
                int i = userpwd.indexOf(58);
                if (i >= 0) {
                    curl.setUsername(userpwd.substring(0, i));
                }
                curl.setPassword(userpwd.substring(i + 1));
                break;
            }
            case 92: {
                break;
            }
            case 14: {
                ArrayValue array = value.toArrayValue(env);
                for (Map.Entry<Value, Value> entry : array.entrySet()) {
                    String header;
                    String name = header = entry.getValue().toString();
                    String body = "";
                    int i = header.indexOf(58);
                    if (i >= 0) {
                        name = header.substring(0, i).trim();
                        body = header.substring(i + 1).trim();
                    }
                    curl.setRequestProperty(name, body);
                }
                break;
            }
            case 7: {
                Object outputFile = value.toJavaObject();
                if (!(outputFile instanceof BinaryOutput)) break;
                curl.setOutputFile((BinaryOutput)outputFile);
                break;
            }
            case 8: {
                Object uploadFile = value.toJavaObject();
                if (!(uploadFile instanceof BinaryInput)) break;
                curl.setUploadFile((BinaryInput)uploadFile);
                break;
            }
            case 49: {
                break;
            }
            case 42: {
                Object outputHeaderFile = value.toJavaObject();
                if (!(outputHeaderFile instanceof BinaryOutput)) break;
                curl.setOutputHeaderFile((BinaryOutput)outputHeaderFile);
                break;
            }
            case 61: {
                curl.setHeaderFunction(env.createCallback(value));
                throw new UnimplementedException("cURL callback support");
            }
            case 60: {
                curl.setPasswordFunction(env.createCallback(value));
                throw new UnimplementedException("cURL callback support");
            }
            case 59: {
                curl.setReadFunction(env.createCallback(value));
                throw new UnimplementedException("cURL callback support");
            }
            case 58: {
                curl.setWriteFunction(env.createCallback(value));
                throw new UnimplementedException("cURL callback support");
            }
            default: {
                env.warning(L.l("CURL option unknown or unimplemented"));
                log.log(Level.FINE, L.l("CURL option unknown orunimplemented"));
                return false;
            }
        }
        return true;
    }

    public static ArrayValue curl_version(Env env, @Optional Value version) {
        throw new UnimplementedException("curl_version");
    }
}

