/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.lib.curl;

import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.lib.curl.CurlResource;
import com.caucho.quercus.lib.curl.HttpConnection;
import com.caucho.quercus.lib.curl.HttpRequest;
import java.io.IOException;
import java.io.OutputStream;
import java.net.ProtocolException;

public class HttpPostRequest
extends HttpRequest {
    public HttpPostRequest(CurlResource curlResource) {
        super(curlResource);
    }

    protected void init(Env env) throws ProtocolException {
        super.init(env);
        this.getHttpConnection().setDoOutput(true);
    }

    protected void transfer(Env env) throws IOException {
        super.transfer(env);
        StringValue body = this.getCurlResource().getPostBody();
        if (body == null) {
            return;
        }
        HttpConnection conn = this.getHttpConnection();
        OutputStream out = conn.getOutputStream();
        int length = body.length();
        for (int i = 0; i < length; ++i) {
            out.write((byte)body.charAt(i));
        }
        out.close();
    }
}

