/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.lib.curl;

import com.caucho.quercus.QuercusModuleException;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.lib.curl.CurlResource;
import com.caucho.quercus.lib.curl.HttpConnection;
import com.caucho.quercus.lib.curl.HttpGetRequest;
import com.caucho.quercus.lib.curl.HttpPostRequest;
import com.caucho.quercus.lib.curl.HttpPutRequest;
import com.caucho.util.L10N;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.ConnectException;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.GZIPInputStream;
import java.util.zip.InflaterInputStream;

public class HttpRequest
implements Closeable {
    private static final Logger log = Logger.getLogger(HttpRequest.class.getName());
    private static final L10N L = new L10N(HttpRequest.class);
    private CurlResource _curl;
    private HttpConnection _conn;

    public HttpRequest(CurlResource curlResource) {
        this._curl = curlResource;
    }

    public static final HttpRequest getRequest(CurlResource curl) {
        String requestMethod = curl.getRequestMethod();
        if (requestMethod.equals("GET")) {
            return new HttpGetRequest(curl);
        }
        if (requestMethod.equals("POST")) {
            return new HttpPostRequest(curl);
        }
        if (requestMethod.equals("PUT")) {
            return new HttpPutRequest(curl);
        }
        return new HttpRequest(curl);
    }

    protected final void create(Env env) throws MalformedURLException, IOException {
        URL url = this.getURL(env, this._curl.getURL(), this._curl.getPort());
        if (url == null) {
            return;
        }
        if (this._curl.getIsProxying()) {
            URL proxyURL = this.getURL(env, this._curl.getProxyURL(), this._curl.getProxyPort());
            this._conn = HttpConnection.createConnection(url, this._curl.getUsername(), this._curl.getPassword(), this._curl, proxyURL, this._curl.getProxyUsername(), this._curl.getProxyPassword(), this._curl.getProxyType());
        } else {
            this._conn = HttpConnection.createConnection(url, this._curl.getUsername(), this._curl.getPassword(), this._curl);
        }
    }

    protected void init(Env env) throws ProtocolException {
        this._conn.setRequestMethod(this._curl.getRequestMethod());
        HashMap<String, String> _properties = this._curl.getRequestPropertiesMap();
        for (Map.Entry<String, String> entry : _properties.entrySet()) {
            this._conn.setRequestProperty(entry.getKey(), entry.getValue());
        }
        this._conn.setInstanceFollowRedirects(this._curl.getIsFollowingRedirects());
        int timeout = this._curl.getConnectTimeout();
        if (timeout >= 0) {
            this._conn.setConnectTimeout(timeout);
        }
        if ((timeout = this._curl.getReadTimeout()) >= 0) {
            this._conn.setReadTimeout(timeout);
        }
    }

    protected void connect(Env env) throws ConnectException, SocketTimeoutException, UnknownHostException, IOException {
        this._conn.connect(this._curl);
    }

    protected void transfer(Env env) throws IOException {
    }

    protected void finish(Env env) throws IOException {
        this._curl.setResponseCode(this._conn.getResponseCode());
        this._curl.setHeader(this.getHeader(env.createBinaryBuilder()));
        this._curl.setBody(this.getBody(env.createBinaryBuilder()));
        this._curl.setContentLength(this._conn.getContentLength());
        this._curl.setCookie(this._conn.getHeaderField("Set-Cookie"));
        this._conn.close();
    }

    public final void execute(Env env) {
        try {
            this.create(env);
            this.init(env);
            this.connect(env);
            this.transfer(env);
            this.finish(env);
        }
        catch (MalformedURLException e) {
            this.error(env, 3, e.getMessage(), e);
        }
        catch (SocketTimeoutException e) {
            this.error(env, 28, "connection timed out", e);
        }
        catch (ConnectException e) {
            this.error(env, 7, e.getMessage(), e);
        }
        catch (ProtocolException e) {
            throw new QuercusModuleException(e.getMessage());
        }
        catch (UnknownHostException e) {
            this.error(env, 6, "unknown host: " + e.getMessage(), e);
        }
        catch (IOException e) {
            this.error(env, 56, e.getMessage(), e);
        }
    }

    protected final CurlResource getCurlResource() {
        return this._curl;
    }

    protected final HttpConnection getHttpConnection() {
        return this._conn;
    }

    protected final void error(Env env, int code, String error) {
        log.log(Level.FINE, error);
        if (this._curl.getIsVerbose()) {
            env.warning(L.l(error));
        }
        this._curl.setError(error);
        this._curl.setErrorCode(code);
    }

    protected final void error(Env env, int code, String error, Throwable e) {
        log.log(Level.FINE, error, e);
        if (this._curl.getIsVerbose()) {
            env.warning(L.l(error));
        }
        this._curl.setError(error);
        this._curl.setErrorCode(code);
    }

    protected final URL getURL(Env env, String urlString, int port) throws MalformedURLException {
        URL url = urlString.indexOf("://") < 0 ? new URL("http://" + urlString) : new URL(urlString);
        if (port >= 0) {
            url = new URL(url.getProtocol(), url.getHost(), port, url.getFile());
        }
        return url;
    }

    private final StringValue getHeader(StringValue bb) {
        String key;
        bb.append(this._conn.getHeaderField(0));
        bb.append("\r\n");
        int i = 1;
        while ((key = this._conn.getHeaderFieldKey(i)) != null) {
            bb.append(key);
            bb.append(": ");
            bb.append(this._conn.getHeaderField(i));
            bb.append("\r\n");
            ++i;
        }
        bb.append("\r\n");
        return bb;
    }

    private final StringValue getBody(StringValue bb) throws SocketTimeoutException, IOException {
        InputStream in = this._conn.getResponseCode() < 400 ? this._conn.getInputStream() : this._conn.getErrorStream();
        if (in == null) {
            return StringValue.EMPTY;
        }
        String encoding = this._conn.getHeaderField("Content-Encoding");
        if (encoding != null) {
            if (encoding.equals("gzip")) {
                in = new GZIPInputStream(in);
            } else if (encoding.equals("deflate")) {
                in = new InflaterInputStream(in);
            } else if (!encoding.equals("identity")) {
                this._curl.setError(encoding);
                this._curl.setErrorCode(61);
                return StringValue.EMPTY;
            }
        }
        bb.append(in);
        return bb;
    }

    public void close() {
        if (this._conn != null) {
            this._conn.close();
        }
    }
}

