/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.lib.date;

import com.caucho.quercus.UnimplementedException;
import com.caucho.quercus.annotation.NotNull;
import com.caucho.quercus.annotation.Optional;
import com.caucho.quercus.annotation.ReturnNullAsFalse;
import com.caucho.quercus.env.ArrayValue;
import com.caucho.quercus.env.ArrayValueImpl;
import com.caucho.quercus.env.BooleanValue;
import com.caucho.quercus.env.DoubleValue;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.LongValue;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.lib.date.DateTime;
import com.caucho.quercus.lib.date.DateTimeZone;
import com.caucho.quercus.module.AbstractQuercusModule;
import com.caucho.util.Alarm;
import com.caucho.util.CharBuffer;
import com.caucho.util.L10N;
import com.caucho.util.QDate;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DateModule
extends AbstractQuercusModule {
    private static final L10N L = new L10N(DateModule.class);
    private static final Logger log = Logger.getLogger(DateModule.class.getName());
    public static final int CAL_GREGORIAN = 0;
    public static final int CAL_JULIAN = 1;
    private static final String[] _shortDayOfWeek = new String[]{"Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat", "Sun"};
    private static final String[] _fullDayOfWeek = new String[]{"Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday", "Sunday"};
    private static final String[] _shortMonth = new String[]{"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"};
    private static final String[] _fullMonth = new String[]{"January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"};
    private static final long MINUTE = 60000L;
    private static final long HOUR = 3600000L;
    private static final long DAY = 86400000L;
    private final QDate _localCalendar = QDate.createLocal();
    private final QDate _gmtCalendar = new QDate();

    public static int cal_days_in_month(int cal, int month, int year) {
        QDate date = new QDate();
        date.setYear(year);
        date.setMonth(month - 1);
        return date.getDaysInMonth();
    }

    public static boolean checkdate(int month, int day, int year) {
        if (1 > year || year > Short.MAX_VALUE) {
            return false;
        }
        if (1 > month || month > 12) {
            return false;
        }
        return 1 <= day && day <= DateModule.cal_days_in_month(0, month, year);
    }

    public String date(String format, @Optional(value="time()") long time) {
        return this.date(format, time, false);
    }

    public Value idate(Env env, String format, @Optional(value="time()") long time) {
        if (format.length() != 1) {
            log.log(Level.FINE, L.l("idate format '{0}' needs to be of length one and only one", (Object)format));
            env.warning(L.l("idate format '{0}' needs to be of length one and only one", (Object)format));
            return BooleanValue.FALSE;
        }
        switch (format.charAt(0)) {
            case 'B': 
            case 'H': 
            case 'I': 
            case 'L': 
            case 'U': 
            case 'W': 
            case 'Y': 
            case 'Z': 
            case 'd': 
            case 'h': 
            case 'i': 
            case 'm': 
            case 's': 
            case 't': 
            case 'w': 
            case 'y': 
            case 'z': {
                String dateString = this.date(format, time, false);
                int sign = 1;
                long result = 0L;
                int length = dateString.length();
                for (int i = 0; i < length; ++i) {
                    char ch = dateString.charAt(i);
                    if ('0' <= ch && ch <= '9') {
                        result = result * 10L + (long)ch - 48L;
                        continue;
                    }
                    if (ch == '-' && i == 0) {
                        sign = -1;
                        continue;
                    }
                    log.log(Level.FINEST, L.l("error parsing idate string '{0}'", (Object)dateString));
                    break;
                }
                return LongValue.create(result * (long)sign);
            }
        }
        log.log(Level.FINE, L.l("'{0}' is not a valid idate format", (Object)format));
        env.warning(L.l("'{0}' is not a valid idate format", (Object)format));
        return BooleanValue.FALSE;
    }

    public static long easter_date(@Optional(value="-1") int year) {
        QDate date = new QDate();
        if (year < 0) {
            date.setGMTTime(Alarm.getCurrentTime());
            year = date.getYear();
        }
        int y = year;
        int c = y / 100;
        int n = y - 19 * (y / 19);
        int k = (c - 17) / 25;
        int i = c - c / 4 - (c - k) / 3 + 19 * n + 15;
        i -= 30 * (i / 30);
        i -= i / 28 * (1 - i / 28 * (29 / (i + 1)) * ((21 - n) / 11));
        int j = y + y / 4 + i + 2 - c + c / 4;
        j -= 7 * (j / 7);
        int l = i - j;
        int m = 3 + (l + 40) / 44;
        int d = l + 28 - 31 * (m / 4);
        date.setYear(year);
        date.setMonth(m - 1);
        date.setDayOfMonth(d);
        return date.getGMTTime() / 1000L;
    }

    public static long easter_days(@Optional(value="-1") int year, @Optional int method) {
        return DateModule.easter_date(year);
    }

    public Value getdate(@Optional(value="time()") long time) {
        QDate date = new QDate(false);
        date.setLocalTime(1000L * time);
        ArrayValueImpl array = new ArrayValueImpl();
        array.put("seconds", date.getSecond());
        array.put("minutes", date.getMinute());
        array.put("hours", date.getHour());
        array.put("mday", date.getDayOfMonth());
        array.put("wday", date.getDayOfWeek());
        array.put("mon", date.getMonth() + 1);
        array.put("year", date.getYear());
        array.put("yday", date.getDayOfYear());
        array.put("weekday", _fullDayOfWeek[date.getDayOfWeek()]);
        array.put("month", _fullMonth[date.getMonth()]);
        ((ArrayValue)array).put(new LongValue(0L), new LongValue(time));
        return array;
    }

    public Value gettimeofday(Env env, @Optional boolean isFloatReturn) {
        long gmtTime = Alarm.getExactTime();
        if (isFloatReturn) {
            return new DoubleValue((double)gmtTime / 1000.0);
        }
        ArrayValueImpl result = new ArrayValueImpl();
        TimeZone localTimeZone = TimeZone.getDefault();
        long sec = gmtTime / 1000L;
        long microsec = (gmtTime - sec * 1000L) * 1000L;
        long minutesWest = (long)localTimeZone.getRawOffset() / 1000L / 60L * -1L;
        long dstTime = localTimeZone.useDaylightTime() ? 1L : 0L;
        result.put("sec", sec);
        result.put("usec", microsec);
        result.put("minuteswest", minutesWest);
        result.put("dsttime", dstTime);
        return result;
    }

    public String gmdate(String format, @Optional(value="time()") long time) {
        return this.date(format, time, true);
    }

    public long gmmktime(@Optional(value="-1") int hour, @Optional(value="-1") int minute, @Optional(value="-1") int second, @Optional(value="-1") int month, @Optional(value="-1") int day, @Optional(value="-1") int year) {
        QDate localDate = new QDate(false);
        QDate gmtDate = new QDate(false);
        long now = Alarm.getCurrentTime();
        localDate.setLocalTime(now);
        long gmtNow = localDate.getGMTTime();
        gmtDate.setGMTTime(gmtNow);
        if (hour >= 0) {
            gmtDate.setHour(hour);
        }
        if (minute >= 0) {
            gmtDate.setMinute(minute);
        }
        if (second >= 0) {
            gmtDate.setSecond(second);
        }
        if (month > 0) {
            gmtDate.setMonth(month - 1);
        }
        if (day > 0) {
            gmtDate.setDayOfMonth(day);
        }
        if (year > 0) {
            gmtDate.setYear(year);
        }
        return gmtDate.getGMTTime() / 1000L;
    }

    public String gmstrftime(String format, @Optional(value="-1") long phpTime) {
        long time = phpTime == -1L ? Alarm.getCurrentTime() : 1000L * phpTime;
        return QDate.formatGMT((long)time, (String)format);
    }

    public double gregoriantojd(int month, int day, int year) {
        if (month <= 2) {
            --year;
            month += 12;
        }
        long a = year / 100;
        long b = a / 4L;
        long c = 2L - a + b;
        long e = (long)(365.25 * (double)(year + 4716));
        long f = (long)(30.6001 * (double)(month + 1));
        return (double)(c + (long)day + e + f) - 1524.5;
    }

    private String date(String format, long time, boolean isGMT) {
        QDate calendar = isGMT ? this._gmtCalendar : this._localCalendar;
        return DateModule.dateImpl(format, time, calendar);
    }

    protected static String date(String format, long time, QDate calendar) {
        calendar = (QDate)calendar.clone();
        return DateModule.dateImpl(format, time, calendar);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String dateImpl(String format, long time, QDate calendar) {
        long now = 1000L * time;
        QDate qDate = calendar;
        synchronized (qDate) {
            calendar.setGMTTime(now);
            CharBuffer sb = new CharBuffer();
            int len = format.length();
            block43: for (int i = 0; i < len; ++i) {
                char ch = format.charAt(i);
                switch (ch) {
                    case 'd': {
                        int day = calendar.getDayOfMonth();
                        sb.append(day / 10);
                        sb.append(day % 10);
                        continue block43;
                    }
                    case 'D': {
                        int day = calendar.getDayOfWeek();
                        sb.append(_shortDayOfWeek[day - 1]);
                        continue block43;
                    }
                    case 'j': {
                        int day = calendar.getDayOfMonth();
                        sb.append(day);
                        continue block43;
                    }
                    case 'l': {
                        int day = calendar.getDayOfWeek();
                        sb.append(_fullDayOfWeek[day]);
                        continue block43;
                    }
                    case 'S': {
                        int day = calendar.getDayOfMonth();
                        switch (day) {
                            case 1: 
                            case 21: 
                            case 31: {
                                sb.append("st");
                                continue block43;
                            }
                            case 2: 
                            case 22: {
                                sb.append("nd");
                                continue block43;
                            }
                            case 3: 
                            case 23: {
                                sb.append("rd");
                                continue block43;
                            }
                        }
                        sb.append("th");
                        continue block43;
                    }
                    case 'w': {
                        int day = calendar.getDayOfWeek() - 1;
                        sb.append(day);
                        continue block43;
                    }
                    case 'z': {
                        int day = calendar.getDayOfYear();
                        sb.append(day);
                        continue block43;
                    }
                    case 'W': {
                        int week = calendar.getWeek();
                        sb.append(week);
                        continue block43;
                    }
                    case 'm': {
                        int month = calendar.getMonth() + 1;
                        sb.append(month / 10);
                        sb.append(month % 10);
                        continue block43;
                    }
                    case 'M': {
                        int month = calendar.getMonth();
                        sb.append(_shortMonth[month]);
                        continue block43;
                    }
                    case 'F': {
                        int month = calendar.getMonth();
                        sb.append(_fullMonth[month]);
                        continue block43;
                    }
                    case 'n': {
                        int month = calendar.getMonth() + 1;
                        sb.append(month);
                        continue block43;
                    }
                    case 't': {
                        int days = calendar.getDaysInMonth();
                        sb.append(days);
                        continue block43;
                    }
                    case 'Y': {
                        int year = calendar.getYear();
                        sb.append(year / 1000 % 10);
                        sb.append(year / 100 % 10);
                        sb.append(year / 10 % 10);
                        sb.append(year % 10);
                        continue block43;
                    }
                    case 'y': {
                        int year = calendar.getYear();
                        sb.append(year / 10 % 10);
                        sb.append(year % 10);
                        continue block43;
                    }
                    case 'L': {
                        if (calendar.isLeapYear()) {
                            sb.append(1);
                            continue block43;
                        }
                        sb.append(0);
                        continue block43;
                    }
                    case 'a': {
                        int hour = calendar.getHour();
                        if (hour < 12) {
                            sb.append("am");
                            continue block43;
                        }
                        sb.append("pm");
                        continue block43;
                    }
                    case 'A': {
                        int hour = calendar.getHour();
                        if (hour < 12) {
                            sb.append("AM");
                            continue block43;
                        }
                        sb.append("PM");
                        continue block43;
                    }
                    case 'g': {
                        int hour = calendar.getHour() % 12;
                        if (hour == 0) {
                            hour = 12;
                        }
                        sb.append(hour);
                        continue block43;
                    }
                    case 'G': {
                        int hour = calendar.getHour();
                        sb.append(hour);
                        continue block43;
                    }
                    case 'h': {
                        int hour = calendar.getHour() % 12;
                        if (hour == 0) {
                            hour = 12;
                        }
                        sb.append(hour / 10);
                        sb.append(hour % 10);
                        continue block43;
                    }
                    case 'H': {
                        int hour = calendar.getHour();
                        sb.append(hour / 10);
                        sb.append(hour % 10);
                        continue block43;
                    }
                    case 'i': {
                        int minutes = calendar.getMinute();
                        sb.append(minutes / 10);
                        sb.append(minutes % 10);
                        continue block43;
                    }
                    case 's': {
                        int seconds = calendar.getSecond();
                        sb.append(seconds / 10);
                        sb.append(seconds % 10);
                        continue block43;
                    }
                    case 'O': {
                        long offset = calendar.getZoneOffset();
                        int minute = (int)(offset / 60000L);
                        if (minute < 0) {
                            sb.append('-');
                        } else {
                            sb.append('+');
                        }
                        sb.append(minute / 60 / 10);
                        sb.append(minute / 60 % 10);
                        sb.append(minute / 10 % 10);
                        sb.append(minute % 10);
                        continue block43;
                    }
                    case 'I': {
                        if (calendar.isDST()) {
                            sb.append('1');
                            continue block43;
                        }
                        sb.append('0');
                        continue block43;
                    }
                    case 'T': {
                        TimeZone zone = calendar.getLocalTimeZone();
                        sb.append(zone.getDisplayName(calendar.isDST(), 0));
                        continue block43;
                    }
                    case 'e': {
                        TimeZone zone = calendar.getLocalTimeZone();
                        sb.append(zone.getID());
                        continue block43;
                    }
                    case 'Z': {
                        long offset = calendar.getZoneOffset();
                        sb.append(offset / 1000L);
                        continue block43;
                    }
                    case 'c': {
                        sb.append(calendar.printISO8601());
                        continue block43;
                    }
                    case 'r': {
                        sb.append(calendar.printDate());
                        continue block43;
                    }
                    case 'U': {
                        sb.append(now / 1000L);
                        continue block43;
                    }
                    case '\\': {
                        sb.append(format.charAt(++i));
                        continue block43;
                    }
                    default: {
                        sb.append(ch);
                    }
                }
            }
            return sb.toString();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayValue localtime(@NotNull @Optional(value="-1") long time, @Optional(value="false") boolean isAssociative) {
        long isdst;
        long yday;
        long wday;
        long year;
        long mon;
        long mday;
        long hour;
        long min;
        long sec;
        time = time < 0L ? Alarm.getCurrentTime() : (time *= 1000L);
        QDate qDate = this._localCalendar;
        synchronized (qDate) {
            this._localCalendar.setGMTTime(time);
            sec = this._localCalendar.getSecond();
            min = this._localCalendar.getMinute();
            hour = this._localCalendar.getHour();
            mday = this._localCalendar.getDayOfMonth();
            mon = this._localCalendar.getMonth();
            year = this._localCalendar.getYear();
            wday = this._localCalendar.getDayOfWeek();
            yday = this._localCalendar.getDayOfYear();
            isdst = this._localCalendar.isDST() ? 1L : 0L;
        }
        year -= 1900L;
        --wday;
        ArrayValueImpl value = new ArrayValueImpl();
        if (isAssociative) {
            value.put("tm_sec", sec);
            value.put("tm_min", min);
            value.put("tm_hour", hour);
            value.put("tm_mday", mday);
            value.put("tm_mon", mon);
            value.put("tm_year", year);
            value.put("tm_wday", wday);
            value.put("tm_yday", yday);
            value.put("tm_isdst", isdst);
        } else {
            value.put(sec);
            value.put(min);
            value.put(hour);
            value.put(mday);
            value.put(mon);
            value.put(year);
            value.put(wday);
            value.put(yday);
            value.put(isdst);
        }
        return value;
    }

    public static Value microtime(Env env, @Optional boolean getAsFloat) {
        long now = Alarm.getExactTimeNanoseconds() / 1000L;
        if (getAsFloat) {
            return new DoubleValue((double)now / 1000000.0);
        }
        return env.createUnicodeBuilder().append((double)(now % 1000000L) / 1000000.0).append(' ').append(now / 1000000L);
    }

    public long mktime(Env env, @Optional(value="-1") int hour, @Optional(value="-1") int minute, @Optional(value="-1") int second, @Optional(value="-1") int month, @Optional(value="-1") int day, @Optional(value="-1") int year, @Optional(value="-1") int isDST) {
        if (isDST != -1) {
            env.deprecatedArgument("isDST");
        }
        QDate date = new QDate(true);
        long now = Alarm.getCurrentTime();
        date.setLocalTime(now);
        if (hour >= 0) {
            date.setHour(hour);
        }
        if (minute >= 0) {
            date.setMinute(minute);
        }
        if (second >= 0) {
            date.setSecond(second);
        }
        if (month > 0) {
            date.setMonth(month - 1);
        }
        if (day > 0) {
            date.setDayOfMonth(day);
        }
        if (year > 0) {
            date.setYear(year);
        }
        return date.getGMTTime() / 1000L;
    }

    public String strftime(String format, @Optional(value="-1") long phpTime) {
        long time = phpTime == -1L ? Alarm.getCurrentTime() : 1000L * phpTime;
        return QDate.formatLocal((long)time, (String)format);
    }

    public Value strtotime(String timeString, @Optional(value="-1") long now) {
        try {
            now = now >= 0L ? 1000L * now : Alarm.getCurrentTime();
            QDate date = new QDate(true);
            date.setGMTTime(now);
            if (timeString.equals("")) {
                date.setHour(0);
                date.setMinute(0);
                date.setSecond(0);
                return new LongValue(date.getGMTTime() / 1000L);
            }
            DateParser parser = new DateParser(timeString, date);
            return new LongValue(parser.parse() / 1000L);
        }
        catch (Exception e) {
            log.log(Level.FINE, e.toString(), e);
            return BooleanValue.FALSE;
        }
    }

    public static long time() {
        return Alarm.getCurrentTime() / 1000L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long jdtounix(double jd) {
        long z = (long)(jd + 0.5);
        long w = (long)(((double)z - 1867216.25) / 36524.25);
        long x = w / 4L;
        long a = z + 1L + w - x;
        long b = a + 1524L;
        long c = (long)(((double)b - 122.1) / 365.25);
        long d = (long)(365.25 * (double)c);
        long e = (long)((double)(b - d) / 30.6001);
        long f = (long)(30.6001 * (double)e);
        long day = b - d - f;
        long month = e - 1L;
        long year = c - 4716L;
        if (month > 12L) {
            month -= 12L;
            ++year;
        }
        QDate qDate = this._localCalendar;
        synchronized (qDate) {
            this._localCalendar.setHour(0);
            this._localCalendar.setMinute(0);
            this._localCalendar.setSecond(0);
            this._localCalendar.setDayOfMonth((int)day);
            this._localCalendar.setMonth((int)(month - 1L));
            this._localCalendar.setYear((int)year);
            return this._localCalendar.getLocalTime() / 1000L;
        }
    }

    public static DateTime date_create(@Optional(value="now") String time, @Optional DateTimeZone dateTimeZone) {
        return DateTime.__construct(time, dateTimeZone);
    }

    public static void date_date_set(DateTime dateTime, int year, int month, int day) {
        dateTime.setDate(year, month, day);
    }

    public static String date_default_timezone_get(Env env) {
        TimeZone timeZone = env.getDefaultTimeZone();
        if (timeZone != null) {
            return timeZone.getID();
        }
        String id = env.getIniString("date.timezone");
        if (id != null) {
            return id;
        }
        return TimeZone.getDefault().getID();
    }

    public static boolean date_default_timezone_set(Env env, String id) {
        env.setDefaultTimeZone(id);
        return true;
    }

    public static String date_format(DateTime dateTime, String format) {
        return dateTime.format(format);
    }

    public static void date_isodate_set(DateTime dateTime, int year, int week, int day) {
        dateTime.setISODate(year, week, day);
    }

    public static void date_modify(DateTime dateTime, String modify) {
        dateTime.modify(modify);
    }

    public static long date_offset_get(DateTime dateTime) {
        return dateTime.getOffset();
    }

    public static Value date_parse(String date) {
        DateTime dateTime = new DateTime(date);
        QDate qDate = dateTime.getQDate();
        ArrayValueImpl array = new ArrayValueImpl();
        array.put("year", qDate.getYear());
        array.put("month", qDate.getMonth());
        array.put("day", qDate.getDayOfMonth());
        array.put("minute", qDate.getMinute());
        array.put("second", qDate.getSecond());
        array.put("fraction", (double)qDate.getMillisecond() / 1000.0);
        return array;
    }

    public static ArrayValue date_sun_info(long time, double latitude, double longitude) {
        throw new UnimplementedException("date_sun_info");
    }

    public static Value date_sunrise(int timestamp, @Optional int format, @Optional double latitude, @Optional double longitude, @Optional double zenith, @Optional double gmtOffset) {
        throw new UnimplementedException("date_sunrise");
    }

    public static Value date_sunset(int timestamp, @Optional int format, @Optional double latitude, @Optional double longitude, @Optional double zenith, @Optional double gmtOffset) {
        throw new UnimplementedException("date_sunset");
    }

    public static void date_time_set(DateTime dateTime, int hour, int minute, @Optional int second) {
        dateTime.setTime(hour, minute, second);
    }

    @ReturnNullAsFalse
    public static DateTimeZone date_timezone_get(Env env, @NotNull DateTime dateTime) {
        if (dateTime == null) {
            env.warning("DateTime parameter must not be null");
            return null;
        }
        return dateTime.getTimeZone();
    }

    public static void date_timezone_set(Env env, @NotNull DateTime dateTime, @NotNull DateTimeZone dateTimeZone) {
        if (dateTime == null || dateTimeZone == null) {
            env.warning("parameters must not be null");
            return;
        }
        dateTime.setTimeZone(dateTimeZone);
    }

    public static ArrayValue timezone_abbreviations_list() {
        return DateTimeZone.listAbbreviations();
    }

    public static ArrayValue timezone_identifiers_list() {
        return DateTimeZone.listIdentifiers();
    }

    public static Value timezone_name_from_abbr(StringValue abbr, @Optional(value="-1") int gmtOffset, @Optional boolean isDST) {
        if (gmtOffset == -1) {
            return DateTimeZone.findTimeZone(abbr);
        }
        return DateTimeZone.findTimeZone(abbr, gmtOffset, isDST);
    }

    public static String timezone_name_get(DateTimeZone dateTimeZone) {
        return dateTimeZone.getName();
    }

    public static long timezone_offset_get(DateTimeZone dateTimeZone, DateTime dateTime) {
        return dateTimeZone.getOffset(dateTime);
    }

    public static DateTimeZone timezone_open(String timeZone) {
        return new DateTimeZone(timeZone);
    }

    public static Value timezone_transitions_get(DateTimeZone dateTimeZone) {
        return dateTimeZone.getTransitions();
    }

    static class DateParser {
        private static final int INT = 1;
        private static final int PERIOD = 2;
        private static final int AGO = 3;
        private static final int AM = 4;
        private static final int PM = 5;
        private static final int MONTH = 6;
        private static final int WEEKDAY = 7;
        private static final int UTC = 8;
        private static final int UNIT_YEAR = 1;
        private static final int UNIT_MONTH = 2;
        private static final int UNIT_FORTNIGHT = 3;
        private static final int UNIT_WEEK = 4;
        private static final int UNIT_DAY = 5;
        private static final int UNIT_HOUR = 6;
        private static final int UNIT_MINUTE = 7;
        private static final int UNIT_SECOND = 8;
        private static final int UNIT_NOW = 9;
        private static final int NULL_VALUE = Integer.MAX_VALUE;
        private QDate _date;
        private String _s;
        private int _index;
        private int _length;
        private StringBuilder _sb = new StringBuilder();
        private int _peekToken;
        private int _value;
        private int _digits;
        private int _unit;
        private int _weekday;
        private boolean _hasDate;
        private boolean _hasTime;

        DateParser(String s, QDate date) {
            this._date = date;
            this._s = s;
            this._length = s.length();
        }

        long parse() {
            this._value = Integer.MAX_VALUE;
            this._unit = 0;
            while (true) {
                int token;
                if ((token = this.nextToken()) == 45) {
                    token = this.nextToken();
                    if (token == 1) {
                        this._value = -this._value;
                    } else {
                        this._peekToken = token;
                        continue;
                    }
                }
                if (token < 0) {
                    return this._date.getGMTTime();
                }
                if (token == 1) {
                    int digits = this._digits;
                    int value = this._value;
                    token = this.nextToken();
                    if (token == 2) {
                        this.parsePeriod();
                        continue;
                    }
                    if (token == 58) {
                        this.parseTime();
                        this._hasTime = true;
                        continue;
                    }
                    if (token == 45) {
                        this.parseISODate(value);
                        this._hasDate = true;
                        continue;
                    }
                    if (token == 47) {
                        this.parseUSDate(value);
                        this._hasDate = true;
                        continue;
                    }
                    if (token == 6) {
                        this.parseDayMonthDate(value);
                        this._hasDate = true;
                        continue;
                    }
                    this._peekToken = token;
                    this.parseBareInt(value, digits);
                    continue;
                }
                if (token == 2) {
                    this.parsePeriod();
                    continue;
                }
                if (token == 7) {
                    this.addWeekday(this._value, this._weekday);
                    this._value = Integer.MAX_VALUE;
                    continue;
                }
                if (token == 6) {
                    this.parseMonthDate(this._value);
                    this._hasDate = true;
                    continue;
                }
                if (token != 64 || (token = this.nextToken()) != 1) continue;
                int value = this._value;
                this._value = Integer.MAX_VALUE;
                this._date.setGMTTime((long)value * 1000L);
                token = this.nextToken();
                if (token == 46) {
                    token = this.nextToken();
                    if (token == 1) continue;
                    this._peekToken = token;
                    continue;
                }
                this._peekToken = token;
            }
        }

        private void parsePeriod() {
            int value = this._value;
            int unit = this._unit;
            this._value = Integer.MAX_VALUE;
            this._unit = 0;
            int token = this.nextToken();
            if (token == 3) {
                value = -value;
            } else {
                this._peekToken = token;
            }
            this.addTime(value, unit);
        }

        private void parseISODate(int value1) {
            int year = this._date.getYear();
            boolean month = false;
            boolean day = false;
            if (value1 < 0) {
                value1 = -value1;
            }
            int token = this.nextToken();
            int value2 = 0;
            if (token != 1) {
                this._peekToken = token;
                return;
            }
            value2 = this._value;
            this._value = Integer.MAX_VALUE;
            token = this.nextToken();
            if (token == 45) {
                token = this.nextToken();
                if (token == 1) {
                    if (value1 < 0) {
                        this._date.setYear(value1);
                    } else if (value1 <= 68) {
                        this._date.setYear(2000 + value1);
                    } else if (value1 < 100) {
                        this._date.setYear(1900 + value1);
                    } else {
                        this._date.setYear(value1);
                    }
                    this._date.setMonth(value2 - 1);
                    this._date.setDayOfMonth(this._value);
                } else {
                    this._date.setMonth(value1 - 1);
                    this._date.setDayOfMonth(value2);
                    this._peekToken = token;
                }
            } else {
                this._date.setMonth(value1 - 1);
                this._date.setDayOfMonth(value2);
                this._peekToken = token;
            }
        }

        private void parseUSDate(int value1) {
            int year = this._date.getYear();
            boolean month = false;
            boolean day = false;
            if (value1 < 0) {
                value1 = -value1;
            }
            int token = this.nextToken();
            int value2 = 0;
            if (token != 1) {
                this._peekToken = token;
                return;
            }
            value2 = this._value;
            this._value = Integer.MAX_VALUE;
            token = this.nextToken();
            if (token == 47) {
                token = this.nextToken();
                if (token == 1) {
                    this._date.setMonth(value1 - 1);
                    this._date.setDayOfMonth(value2);
                    if (this._value < 0) {
                        this._date.setYear(this._value);
                    } else if (this._value <= 68) {
                        this._date.setYear(2000 + this._value);
                    } else if (this._value < 100) {
                        this._date.setYear(1900 + this._value);
                    } else {
                        this._date.setYear(this._value);
                    }
                } else {
                    this._date.setMonth(value1 - 1);
                    this._date.setDayOfMonth(value2);
                    this._peekToken = token;
                }
                this._value = Integer.MAX_VALUE;
            } else {
                this._date.setMonth(value1 - 1);
                this._date.setDayOfMonth(value2);
                this._peekToken = token;
            }
        }

        private void parseDayMonthDate(int value1) {
            int year = this._date.getYear();
            boolean month = false;
            boolean day = false;
            if (value1 < 0) {
                value1 = -value1;
            }
            int value2 = this._value;
            this._value = Integer.MAX_VALUE;
            int token = this.nextToken();
            if (token == 45) {
                this._value = Integer.MAX_VALUE;
                token = this.nextToken();
            }
            if (token == 1) {
                this._date.setDayOfMonth(value1);
                this._date.setMonth(value2 - 1);
                if (this._value < 0) {
                    this._date.setYear(this._value);
                } else if (this._value <= 68) {
                    this._date.setYear(2000 + this._value);
                } else if (this._value < 100) {
                    this._date.setYear(1900 + this._value);
                } else {
                    this._date.setYear(this._value);
                }
                this._value = Integer.MAX_VALUE;
            } else {
                this._date.setDayOfMonth(value1);
                this._date.setMonth(value2 - 1);
                this._peekToken = token;
            }
        }

        private void parseMonthDate(int value1) {
            if (value1 < 0) {
                value1 = -value1;
            }
            this._value = Integer.MAX_VALUE;
            int token = this.nextToken();
            if (token == 45) {
                this._value = Integer.MAX_VALUE;
                token = this.nextToken();
            }
            if (token == 1) {
                int value2 = this._value;
                this._value = Integer.MAX_VALUE;
                token = this.nextToken();
                if (token == 45) {
                    this._value = Integer.MAX_VALUE;
                    token = this.nextToken();
                }
                if (token == 1) {
                    this._date.setMonth(value1 - 1);
                    this._date.setDayOfMonth(value2);
                    if (this._value < 0) {
                        this._date.setYear(this._value);
                    } else if (this._value <= 68) {
                        this._date.setYear(2000 + this._value);
                    } else if (this._value < 100) {
                        this._date.setYear(1900 + this._value);
                    } else {
                        this._date.setYear(this._value);
                    }
                    this._value = Integer.MAX_VALUE;
                } else {
                    this._date.setMonth(value1 - 1);
                    this._date.setDayOfMonth(value2);
                    this._peekToken = token;
                }
            } else {
                this._date.setMonth(value1 - 1);
                this._peekToken = token;
            }
        }

        private void parseTime() {
            int hour = this._value;
            this._value = Integer.MAX_VALUE;
            if (hour < 0) {
                hour = -hour;
            }
            this._date.setHour(hour);
            this._date.setMinute(0);
            this._date.setSecond(0);
            this._date.setMillisecond(0L);
            int token = this.nextToken();
            if (token != 1) {
                this._peekToken = token;
                return;
            }
            this._date.setMinute(this._value);
            this._value = Integer.MAX_VALUE;
            token = this.nextToken();
            if (token == 58) {
                token = this.nextToken();
                if (token != 1) {
                    this._peekToken = token;
                    return;
                }
                this._date.setSecond(this._value);
                this._value = Integer.MAX_VALUE;
                token = this.nextToken();
                if (token == 46) {
                    token = this.nextToken();
                    this._value = Integer.MAX_VALUE;
                    if (token != 1) {
                        this._peekToken = token;
                        return;
                    }
                }
            }
            if (token == 4) {
                hour = this._date.getHour();
                if (hour == 12) {
                    this._date.setHour(0);
                }
            } else if (token == 5) {
                hour = this._date.getHour();
                if (hour == 12) {
                    this._date.setHour(12);
                } else {
                    this._date.setHour(hour + 12);
                }
            } else {
                this._peekToken = token;
            }
            this.parseTimezone();
        }

        private void parseTimezone() {
            int token = this.nextToken();
            int sign = 1;
            boolean hasUTC = false;
            if (token == 8) {
                token = this.nextToken();
                hasUTC = true;
            }
            if (token == 45) {
                sign = -1;
            } else if (token == 43) {
                sign = 1;
            } else {
                this._peekToken = token;
                if (hasUTC) {
                    this._date.setGMTTime(this._date.getGMTTime() + this._date.getZoneOffset());
                }
                return;
            }
            boolean offset = false;
            token = this.nextToken();
            if (token != 1) {
                this._peekToken = token;
                if (hasUTC) {
                    this._date.setGMTTime(this._date.getGMTTime() + this._date.getZoneOffset());
                }
                return;
            }
            if (this._digits == 4) {
                int value = sign * this._value;
                this._value = Integer.MAX_VALUE;
                this._date.setGMTTime(this._date.getGMTTime() - (long)value * 60000L + this._date.getZoneOffset());
                return;
            }
            if (this._digits == 2) {
                int value = this._value;
                token = this.nextToken();
                if (token != 58) {
                    this._value = sign * this._value;
                    this._peekToken = token;
                    if (hasUTC) {
                        this._date.setGMTTime(this._date.getGMTTime() + this._date.getZoneOffset());
                    }
                    return;
                }
                value = sign * (100 * value + this._value);
                this._date.setGMTTime(this._date.getGMTTime() - (long)value * 60000L + this._date.getZoneOffset());
                return;
            }
            this._value = sign * this._value;
            this._peekToken = token;
            if (hasUTC) {
                this._date.setGMTTime(this._date.getGMTTime() + this._date.getZoneOffset());
            }
        }

        private void addTime(int value, int unit) {
            if (value == Integer.MAX_VALUE) {
                value = 1;
            } else if (value == -2147483647) {
                value = -1;
            }
            switch (unit) {
                case 1: {
                    this._date.setYear(this._date.getYear() + value);
                    break;
                }
                case 2: {
                    this._date.setMonth(this._date.getMonth() + value);
                    break;
                }
                case 3: {
                    this._date.setGMTTime(this._date.getGMTTime() + 1209600000L * (long)value);
                    break;
                }
                case 4: {
                    this._date.setGMTTime(this._date.getGMTTime() + 604800000L * (long)value);
                    break;
                }
                case 5: {
                    this._date.setGMTTime(this._date.getGMTTime() + 86400000L * (long)value);
                    break;
                }
                case 6: {
                    this._date.setGMTTime(this._date.getGMTTime() + 3600000L * (long)value);
                    break;
                }
                case 7: {
                    this._date.setGMTTime(this._date.getGMTTime() + 60000L * (long)value);
                    break;
                }
                case 8: {
                    this._date.setGMTTime(this._date.getGMTTime() + 1000L * (long)value);
                }
            }
        }

        private void addWeekday(int value, int weekday) {
            if (value == Integer.MAX_VALUE) {
                value = 0;
            } else if (value == -2147483647) {
                value = -1;
            }
            this._date.setDayOfMonth(this._date.getDayOfMonth() + (8 + weekday - this._date.getDayOfWeek()) % 7 + 7 * value);
        }

        private void parseBareInt(int value, int digits) {
            if (digits == 8 && !this._hasDate) {
                this._hasDate = true;
                this._date.setYear(value / 10000);
                this._date.setMonth(value / 100 % 12 - 1);
                this._date.setDayOfMonth(value % 100);
            } else if (digits == 6 && !this._hasTime) {
                this._hasTime = true;
                this._date.setHour(value / 10000);
                this._date.setMinute(value / 100 % 100);
                this._date.setSecond(value % 100);
                this.parseTimezone();
            } else if (digits == 4 && !this._hasTime) {
                this._hasTime = true;
                this._date.setHour(value / 100);
                this._date.setMinute(value % 100);
                this._date.setSecond(0);
                this.parseTimezone();
            } else if (digits == 2 && !this._hasTime) {
                this._hasTime = true;
                this._date.setHour(value);
                this._date.setMinute(0);
                this._date.setSecond(0);
                this.parseTimezone();
            }
            int token = this.nextToken();
            if (token == 46) {
                this._value = Integer.MAX_VALUE;
                token = this.nextToken();
                if (token == 1) {
                    this._value = Integer.MAX_VALUE;
                } else {
                    this._peekToken = token;
                }
            } else {
                this._peekToken = token;
            }
        }

        int nextToken() {
            int ch;
            if (this._peekToken > 0) {
                int token = this._peekToken;
                this._peekToken = 0;
                return token;
            }
            do {
                this.skipSpaces();
                ch = this.read();
                if (ch < 0) {
                    return -1;
                }
                if (ch == 45) {
                    return 45;
                }
                if (ch == 43) {
                    return 43;
                }
                if (ch == 58) {
                    return 58;
                }
                if (ch == 46) {
                    return 46;
                }
                if (ch == 47) {
                    return 47;
                }
                if (ch == 64) {
                    return 64;
                }
                if (48 > ch || ch > 57) continue;
                int value = 0;
                int digits = 0;
                while (48 <= ch && ch <= 57) {
                    ++digits;
                    value = 10 * value + ch - 48;
                    ch = this.read();
                }
                this._value = value;
                this._digits = digits;
                this.unread();
                return 1;
            } while ((97 > ch || ch > 122) && (65 > ch || ch > 90));
            this._sb.setLength(0);
            while (97 <= ch && ch <= 122 || 65 <= ch && ch <= 90 || ch == 46) {
                this._sb.append(Character.toLowerCase((char)ch));
                ch = this.read();
            }
            this.unread();
            String s = this._sb.toString();
            return this.parseString(s);
        }

        private int parseString(String s) {
            if (s.endsWith(".")) {
                s = s.substring(0, s.length() - 1);
            }
            if ("now".equals(s) || "today".equals(s)) {
                this._value = 0;
                this._unit = 9;
                return 2;
            }
            if ("last".equals(s)) {
                this._value = -1;
                return 1;
            }
            if ("this".equals(s)) {
                this._value = 0;
                return 1;
            }
            if ("am".equals(s) || "a.m".equals(s)) {
                return 4;
            }
            if ("pm".equals(s) || "p.m".equals(s)) {
                return 5;
            }
            if ("next".equals(s)) {
                this._value = 1;
                return 1;
            }
            if ("third".equals(s)) {
                this._value = 3;
                return 1;
            }
            if ("fourth".equals(s)) {
                this._value = 4;
                return 1;
            }
            if ("fifth".equals(s)) {
                this._value = 5;
                return 1;
            }
            if ("sixth".equals(s)) {
                this._value = 6;
                return 1;
            }
            if ("seventh".equals(s)) {
                this._value = 7;
                return 1;
            }
            if ("eighth".equals(s)) {
                this._value = 8;
                return 1;
            }
            if ("ninth".equals(s)) {
                this._value = 9;
                return 1;
            }
            if ("tenth".equals(s)) {
                this._value = 10;
                return 1;
            }
            if ("eleventh".equals(s)) {
                this._value = 11;
                return 1;
            }
            if ("twelfth".equals(s)) {
                this._value = 12;
                return 1;
            }
            if ("yesterday".equals(s)) {
                this._value = -1;
                this._unit = 5;
                return 2;
            }
            if ("tomorrow".equals(s)) {
                this._value = 1;
                this._unit = 5;
                return 2;
            }
            if ("ago".equals(s)) {
                return 3;
            }
            if ("year".equals(s) || "years".equals(s)) {
                this._unit = 1;
                return 2;
            }
            if ("month".equals(s) || "months".equals(s)) {
                this._unit = 2;
                return 2;
            }
            if ("fortnight".equals(s) || "fortnights".equals(s)) {
                this._unit = 3;
                return 2;
            }
            if ("week".equals(s) || "weeks".equals(s)) {
                this._unit = 4;
                return 2;
            }
            if ("day".equals(s) || "days".equals(s)) {
                this._unit = 5;
                return 2;
            }
            if ("hour".equals(s) || "hours".equals(s)) {
                this._unit = 6;
                return 2;
            }
            if ("minute".equals(s) || "minutes".equals(s)) {
                this._unit = 7;
                return 2;
            }
            if ("second".equals(s) || "seconds".equals(s)) {
                this._unit = 8;
                return 2;
            }
            if ("second".equals(s) || "seconds".equals(s)) {
                this._unit = 8;
                return 2;
            }
            if ("january".equals(s) || "jan".equals(s)) {
                this._value = 1;
                return 6;
            }
            if ("february".equals(s) || "feb".equals(s)) {
                this._value = 2;
                return 6;
            }
            if ("march".equals(s) || "mar".equals(s)) {
                this._value = 3;
                return 6;
            }
            if ("april".equals(s) || "apr".equals(s)) {
                this._value = 4;
                return 6;
            }
            if ("may".equals(s)) {
                this._value = 5;
                return 6;
            }
            if ("june".equals(s) || "jun".equals(s)) {
                this._value = 6;
                return 6;
            }
            if ("july".equals(s) || "jul".equals(s)) {
                this._value = 7;
                return 6;
            }
            if ("august".equals(s) || "aug".equals(s)) {
                this._value = 8;
                return 6;
            }
            if ("september".equals(s) || "sep".equals(s) || "sept".equals(s)) {
                this._value = 9;
                return 6;
            }
            if ("october".equals(s) || "oct".equals(s)) {
                this._value = 10;
                return 6;
            }
            if ("november".equals(s) || "nov".equals(s)) {
                this._value = 11;
                return 6;
            }
            if ("december".equals(s) || "dec".equals(s)) {
                this._value = 12;
                return 6;
            }
            if ("sunday".equals(s) || "sun".equals(s)) {
                this._weekday = 0;
                return 7;
            }
            if ("monday".equals(s) || "mon".equals(s)) {
                this._weekday = 1;
                return 7;
            }
            if ("tuesday".equals(s) || "tue".equals(s) || "tues".equals(s)) {
                this._weekday = 2;
                return 7;
            }
            if ("wednesday".equals(s) || "wed".equals(s) || "wednes".equals(s)) {
                this._weekday = 3;
                return 7;
            }
            if ("thursday".equals(s) || "thu".equals(s) || "thur".equals(s) || "thurs".equals(s)) {
                this._weekday = 4;
                return 7;
            }
            if ("friday".equals(s) || "fri".equals(s)) {
                this._weekday = 5;
                return 7;
            }
            if ("saturday".equals(s) || "sat".equals(s)) {
                this._weekday = 6;
                return 7;
            }
            if ("z".equals(s) || "gmt".equals(s) || "utc".equals(s)) {
                return 8;
            }
            return 0;
        }

        /*
         * Unable to fully structure code
         */
        private void skipSpaces() {
            block0: while (true) {
                if (Character.isWhitespace((char)(ch = this.read()))) {
                    continue;
                }
                if (ch != 40) break;
                ch = this.read();
                while (true) {
                    if (ch > 0 && ch != 41) ** break;
                    continue block0;
                    ch = this.read();
                }
                break;
            }
            this.unread();
        }

        int read() {
            if (this._index < this._length) {
                return this._s.charAt(this._index++);
            }
            ++this._index;
            return -1;
        }

        void unread() {
            --this._index;
        }
    }
}

