/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.lib.date;

import com.caucho.quercus.UnimplementedException;
import com.caucho.quercus.env.ArrayValue;
import com.caucho.quercus.env.ArrayValueImpl;
import com.caucho.quercus.env.BooleanValue;
import com.caucho.quercus.env.LongValue;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.lib.date.DateTime;
import java.util.Arrays;
import java.util.TimeZone;

public class DateTimeZone {
    private TimeZone _timeZone;

    protected DateTimeZone() {
        this._timeZone = TimeZone.getDefault();
    }

    protected DateTimeZone(String id) {
        this._timeZone = TimeZone.getTimeZone(id);
    }

    public static DateTimeZone __construct(String id) {
        return new DateTimeZone(id);
    }

    public static ArrayValue listAbbreviations() {
        ArrayValueImpl array = new ArrayValueImpl();
        String[] ids = TimeZone.getAvailableIDs();
        for (int i = 0; i < ids.length; ++i) {
            TimeZone tz = TimeZone.getTimeZone(ids[i]);
            DateTimeZone.addAbbreviation(array, tz, false);
            if (!tz.useDaylightTime()) continue;
            DateTimeZone.addAbbreviation(array, tz, true);
        }
        return array;
    }

    private static void addAbbreviation(ArrayValue array, TimeZone tz, boolean isDST) {
        ArrayValueImpl zone = new ArrayValueImpl();
        zone.put("dst", isDST);
        int offset = tz.getRawOffset() / 1000;
        if (isDST) {
            offset += tz.getDSTSavings() / 1000;
        }
        zone.put("offset", offset);
        zone.put("timezone_id", tz.getID());
        String name = tz.getDisplayName(isDST, 0);
        Value nameV = StringValue.create(name.toLowerCase());
        Value zones = array.get(nameV);
        if (zones.isNull()) {
            zones = new ArrayValueImpl();
            array.put(nameV, zones);
        }
        zones.put(zone);
    }

    public static ArrayValue listIdentifiers() {
        ArrayValueImpl array = new ArrayValueImpl();
        Object[] ids = TimeZone.getAvailableIDs();
        Arrays.sort(ids);
        for (int i = 0; i < ids.length; ++i) {
            array.put((String)ids[i]);
        }
        return array;
    }

    public String getName() {
        return this._timeZone.getID();
    }

    public long getOffset(DateTime dateTime) {
        return (long)this._timeZone.getOffset(dateTime.getTime()) / 1000L;
    }

    public Value getTransitions() {
        throw new UnimplementedException("DateTimeZone->getTransitions()");
    }

    protected TimeZone getTimeZone() {
        return this._timeZone;
    }

    protected static Value findTimeZone(StringValue abbr) {
        ArrayValue array = DateTimeZone.listAbbreviations();
        Value zones = array.get(abbr.toLowerCase());
        if (zones.isset()) {
            return zones.get(LongValue.ZERO).get(StringValue.create("timezone_id"));
        }
        return BooleanValue.FALSE;
    }

    protected static Value findTimeZone(StringValue abbr, int offset, boolean isDST) {
        ArrayValue array = DateTimeZone.listAbbreviations();
        Value zones = array.get(abbr.toLowerCase());
        if (zones.isset() && zones.isArray()) {
            Value offsetStr = StringValue.create("offset");
            for (Value zone : ((ArrayValue)zones).values()) {
                if (zone.get(offsetStr).toInt() != offset) continue;
                return zone.get(StringValue.create("timezone_id"));
            }
        }
        return DateTimeZone.findTimeZone(offset, isDST);
    }

    protected static Value findTimeZone(int offset, boolean isDST) {
        String[] zoneIDs = TimeZone.getAvailableIDs(offset * 1000);
        for (int i = 0; i < zoneIDs.length; ++i) {
            TimeZone zone = TimeZone.getTimeZone(zoneIDs[i]);
            if (isDST != zone.useDaylightTime()) continue;
            return StringValue.create(zoneIDs[i]);
        }
        return BooleanValue.FALSE;
    }

    public String toString() {
        return this._timeZone.getID();
    }
}

