/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.lib.db;

import com.caucho.quercus.QuercusModuleException;
import com.caucho.quercus.annotation.Optional;
import com.caucho.quercus.env.BooleanValue;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.lib.db.JdbcResultResource;
import com.caucho.quercus.lib.db.JdbcTableMetaData;
import com.caucho.util.L10N;
import com.caucho.util.LruCache;
import java.io.Closeable;
import java.sql.Connection;
import java.sql.DataTruncation;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class JdbcConnectionResource
implements Closeable {
    private static final L10N L = new L10N(JdbcConnectionResource.class);
    private static final Logger log = Logger.getLogger(JdbcConnectionResource.class.getName());
    private static LruCache<TableKey, JdbcTableMetaData> _tableMetadataMap = new LruCache(256);
    private Connection _conn;
    private Statement _stmt;
    private DatabaseMetaData _dmd;
    private JdbcResultResource _rs;
    private int _affectedRows;
    private String _errorMessage = "";
    private int _errorCode;
    private boolean _fieldCount = false;
    private SQLWarning _warnings;
    private Env _env;
    private String _host;
    private String _dbname;
    private int _port;
    private String _userName;
    private String _password;
    private String _driver;
    private String _url;
    private boolean _connected;

    public JdbcConnectionResource(Env env) {
        this._env = env;
    }

    public String error() {
        if (this.isConnected()) {
            return this.getErrorMessage();
        }
        return null;
    }

    public boolean isConnected() {
        return this._connected;
    }

    public Env getEnv() {
        return this._env;
    }

    public String getHost() {
        return this._host;
    }

    public String getUserName() {
        return this._userName;
    }

    public String getPassword() {
        return this._password;
    }

    public String getDbName() {
        return this._dbname;
    }

    public int getPort() {
        return this._port;
    }

    public String getDriver() {
        return this._driver;
    }

    public String getUrl() {
        return this._url;
    }

    protected void setConnection(String host, String userName, String password, String dbname, int port, Connection conn, String driver, String url) {
        this._host = host;
        this._userName = userName;
        this._password = password;
        this._dbname = dbname;
        this._port = port;
        this._conn = conn;
        this._driver = driver;
        this._url = url;
        if (conn != null) {
            this._connected = true;
            this._env.addClose(this);
        }
    }

    protected abstract boolean connectInternal(Env var1, @Optional(value="localhost") String var2, @Optional String var3, @Optional String var4, @Optional String var5, @Optional int var6, @Optional String var7, @Optional int var8, @Optional String var9, @Optional String var10);

    protected StringValue realEscapeString(StringValue str) {
        StringValue buf = this._env.createUnicodeBuilder();
        int strLength = str.length();
        block9: for (int i = 0; i < strLength; ++i) {
            char c = str.charAt(i);
            switch (c) {
                case '\u0000': {
                    buf.append('\\');
                    buf.append('\u0000');
                    continue block9;
                }
                case '\n': {
                    buf.append('\\');
                    buf.append('n');
                    continue block9;
                }
                case '\r': {
                    buf.append('\\');
                    buf.append('r');
                    continue block9;
                }
                case '\\': {
                    buf.append('\\');
                    buf.append('\\');
                    continue block9;
                }
                case '\'': {
                    buf.append('\\');
                    buf.append('\'');
                    continue block9;
                }
                case '\"': {
                    buf.append('\\');
                    buf.append('\"');
                    continue block9;
                }
                case '\u001a': {
                    buf.append('\\');
                    buf.append('Z');
                    continue block9;
                }
                default: {
                    buf.append(c);
                }
            }
        }
        return buf;
    }

    public int getAffectedRows() {
        return this._affectedRows;
    }

    public void setAffectedRows(int i) {
        this._affectedRows = i;
    }

    public int getFieldCount() {
        if (this._rs == null) {
            return 0;
        }
        return this._rs.getFieldCount();
    }

    protected JdbcResultResource getCatalogs() {
        this.clearErrors();
        try {
            ResultSet rs;
            if (this._dmd == null) {
                this._dmd = this._conn.getMetaData();
            }
            if ((rs = this._dmd.getCatalogs()) != null) {
                return this.createResult(this._env, this._stmt, rs);
            }
            return null;
        }
        catch (SQLException e) {
            this.saveErrors(e);
            log.log(Level.WARNING, e.toString(), e);
            return null;
        }
    }

    protected Value getCatalog() {
        this.clearErrors();
        try {
            return this._env.createString(this._conn.getCatalog());
        }
        catch (SQLException e) {
            this.saveErrors(e);
            log.log(Level.WARNING, e.toString(), e);
            return BooleanValue.FALSE;
        }
    }

    public String getCharacterSetName() {
        return "latin1";
    }

    public String getClientEncoding() {
        return this.getCharacterSetName();
    }

    public String getClientInfo() {
        try {
            if (this._dmd == null) {
                this._dmd = this._conn.getMetaData();
            }
            return this._dmd.getDatabaseProductVersion();
        }
        catch (SQLException e) {
            log.log(Level.FINE, e.toString(), e);
            return null;
        }
    }

    public Connection getConnection() {
        if (this._conn != null) {
            return this._conn;
        }
        if (this._errorMessage != null) {
            throw new QuercusModuleException(this._errorMessage);
        }
        throw new QuercusModuleException(L.l("Connection is not available"));
    }

    protected Connection getJavaConnection() throws SQLException {
        return this._env.getQuercus().getConnection(this._conn);
    }

    public String getURL() {
        return this._url;
    }

    public int getErrorCode() {
        return this._errorCode;
    }

    public String getErrorMessage() {
        return this._errorMessage;
    }

    public String getHostInfo() throws SQLException {
        if (this._dmd == null) {
            this._dmd = this._conn.getMetaData();
        }
        return this._dmd.getURL();
    }

    public String getServerInfo() throws SQLException {
        return this.getMetaData().getDatabaseProductVersion();
    }

    public JdbcTableMetaData getTableMetaData(String catalog, String schema, String table) throws SQLException {
        if (table == null || table.equals("")) {
            return null;
        }
        TableKey key = new TableKey(this.getURL(), catalog, schema, table);
        JdbcTableMetaData tableMd = (JdbcTableMetaData)_tableMetadataMap.get((Object)key);
        if (tableMd != null && tableMd.isValid()) {
            return tableMd;
        }
        tableMd = new JdbcTableMetaData(catalog, schema, table, this.getMetaData());
        _tableMetadataMap.put((Object)key, (Object)tableMd);
        return tableMd;
    }

    private DatabaseMetaData getMetaData() throws SQLException {
        if (this._dmd == null) {
            this._dmd = this._conn.getMetaData();
        }
        return this._dmd;
    }

    static int infoToVersion(String info) {
        String[] result = info.split("[.a-z-]");
        if (result.length < 3) {
            return 0;
        }
        return Integer.parseInt(result[0]) * 10000 + Integer.parseInt(result[1]) * 100 + Integer.parseInt(result[2]);
    }

    public boolean close(Env env) {
        if (this._connected) {
            this._connected = false;
        }
        return true;
    }

    public JdbcConnectionResource validateConnection() {
        if (!this._connected) {
            throw this._env.createErrorException(L.l("Connection is not properly initialized {0}\nDriver {1}", (Object)this._url, (Object)this._driver));
        }
        return this;
    }

    protected JdbcResultResource realQuery(String sql) {
        this.clearErrors();
        this._rs = null;
        Statement stmt = null;
        if (sql != null) {
            int i;
            int len = sql.length();
            for (i = 0; i < len && Character.isWhitespace(sql.charAt(i)); ++i) {
            }
            if (i + 1 < len) {
                char ch = sql.charAt(i);
                switch (ch) {
                    case 'A': 
                    case 'a': {
                        _tableMetadataMap.clear();
                        break;
                    }
                    case 'D': 
                    case 'd': {
                        ch = sql.charAt(i + 1);
                        if (ch != 'r' && ch != 'R') break;
                        _tableMetadataMap.clear();
                    }
                }
            }
        }
        try {
            Connection conn = this.getConnection();
            boolean canSeek = true;
            stmt = canSeek ? conn.createStatement(1004, 1007) : conn.createStatement();
            stmt.setEscapeProcessing(false);
            if (stmt.execute(sql)) {
                ResultSet rs = stmt.getResultSet();
                this._rs = this.createResult(this._env, stmt, rs);
                this._affectedRows = 0;
                this._warnings = stmt.getWarnings();
            } else {
                this.keepResourceValues(stmt);
                this._affectedRows = 0;
                this._affectedRows = stmt.getUpdateCount();
                if (this._rs != null) {
                    this._rs.setAffectedRows(this._affectedRows);
                }
                this._warnings = stmt.getWarnings();
                if (!this.keepStatementOpen()) {
                    stmt.close();
                }
            }
        }
        catch (DataTruncation truncationError) {
            try {
                this._affectedRows = stmt.getUpdateCount();
                this._warnings = stmt.getWarnings();
            }
            catch (SQLException e) {
                this.saveErrors(e);
                log.log(Level.WARNING, e.toString(), e);
                return null;
            }
        }
        catch (SQLException e) {
            this.saveErrors(e);
            if (this.keepStatementOpen()) {
                this.keepResourceValues(stmt);
            }
            log.log(Level.WARNING, e.toString(), e);
            return null;
        }
        return this._rs;
    }

    protected JdbcResultResource createResult(Env env, Statement stmt, ResultSet rs) {
        return new JdbcResultResource(env, stmt, rs, this);
    }

    public boolean setAutoCommit(boolean mode) {
        this.clearErrors();
        try {
            this._conn.setAutoCommit(mode);
        }
        catch (SQLException e) {
            this.saveErrors(e);
            log.log(Level.WARNING, e.toString(), e);
            return false;
        }
        return true;
    }

    public boolean commit() {
        this.clearErrors();
        try {
            this._conn.commit();
        }
        catch (SQLException e) {
            this.saveErrors(e);
            log.log(Level.WARNING, e.toString(), e);
            return false;
        }
        return true;
    }

    public boolean rollback() {
        this.clearErrors();
        try {
            this._conn.rollback();
        }
        catch (SQLException e) {
            this.saveErrors(e);
            log.log(Level.WARNING, e.toString(), e);
            return false;
        }
        return true;
    }

    public void setCatalog(String name) throws SQLException {
        this.clearErrors();
        this._conn.setCatalog(name);
    }

    public Object toObject() {
        return null;
    }

    public String toString() {
        return this._conn.toString();
    }

    public void close() {
        try {
            Statement stmt = this._stmt;
            this._stmt = null;
            if (stmt != null) {
                stmt.close();
            }
        }
        catch (SQLException e) {
            log.log(Level.FINER, e.toString(), e);
        }
        try {
            Connection conn = this._conn;
            if (conn != null) {
                conn.close();
            }
        }
        catch (SQLException e) {
            log.log(Level.FINER, e.toString(), e);
        }
    }

    protected void keepResourceValues(Statement stmt) {
    }

    protected boolean keepStatementOpen() {
        return false;
    }

    protected JdbcResultResource getResultResource() {
        return this._rs;
    }

    protected void setResultResource(JdbcResultResource rs) {
        this._rs = rs;
    }

    protected SQLWarning getWarnings() {
        return this._warnings;
    }

    public boolean ping() {
        try {
            return this.isConnected() && !this.getConnection().isClosed();
        }
        catch (SQLException e) {
            log.log(Level.FINE, e.toString(), e);
            return false;
        }
    }

    protected void setWarnings(SQLWarning warnings) {
        this._warnings = warnings;
    }

    protected void clearErrors() {
        this._errorMessage = null;
        this._errorCode = 0;
        this._warnings = null;
    }

    protected void saveErrors(SQLException e) {
        this._errorMessage = e.getMessage();
        this._errorCode = e.getErrorCode();
    }

    static class TableKey {
        private final String _url;
        private final String _catalog;
        private final String _schema;
        private final String _table;

        TableKey(String url, String catalog, String schema, String table) {
            this._url = url;
            this._catalog = catalog;
            this._schema = schema;
            this._table = table;
        }

        public int hashCode() {
            int hash = 37;
            if (this._url != null) {
                hash = 65537 * hash + this._url.hashCode();
            }
            if (this._catalog != null) {
                hash = 65537 * hash + this._catalog.hashCode();
            }
            if (this._schema != null) {
                hash = 65537 * hash + this._schema.hashCode();
            }
            if (this._table != null) {
                hash = 65537 * hash + this._table.hashCode();
            }
            return hash;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof TableKey)) {
                return false;
            }
            TableKey key = (TableKey)o;
            if (!this._url.equals(key._url)) {
                return false;
            }
            if (this._catalog == null != (key._catalog == null)) {
                return false;
            }
            if (this._catalog != null && !this._catalog.equals(key._catalog)) {
                return false;
            }
            if (this._schema == null != (key._schema == null)) {
                return false;
            }
            if (this._schema != null && !this._schema.equals(key._schema)) {
                return false;
            }
            if (this._table == null != (key._table == null)) {
                return false;
            }
            return this._table == null || this._table.equals(key._table);
        }
    }
}

