/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.lib.db;

import com.caucho.quercus.env.ArrayValue;
import com.caucho.quercus.env.ArrayValueImpl;
import com.caucho.quercus.env.BooleanValue;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.LongValue;
import com.caucho.quercus.env.NullValue;
import com.caucho.quercus.env.ObjectValue;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.lib.db.JdbcConnectionResource;
import com.caucho.quercus.lib.db.Oracle;
import com.caucho.quercus.lib.db.OracleOciLob;
import com.caucho.util.L10N;
import com.caucho.util.Log;
import java.io.InputStream;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.logging.Level;
import java.util.logging.Logger;

public class JdbcResultResource {
    private static final Logger log = Log.open(JdbcResultResource.class);
    private static final L10N L = new L10N(JdbcResultResource.class);
    public static final int FETCH_ASSOC = 1;
    public static final int FETCH_NUM = 2;
    public static final int FETCH_BOTH = 3;
    public static final String INTEGER = "int";
    public static final String BLOB = "blob";
    public static final String STRING = "string";
    public static final String DATE = "date";
    public static final String DATETIME = "datetime";
    public static final String REAL = "real";
    public static final String UNKNOWN = "unknown";
    private Statement _stmt;
    private ResultSet _rs;
    private int _fieldOffset;
    private JdbcConnectionResource _conn;
    private Env _env;
    private ResultSetMetaData _metaData;
    private Value[] _columnNames;
    private int _affectedRows;
    boolean _closed;

    public JdbcResultResource(Env env, Statement stmt, ResultSet rs, JdbcConnectionResource conn) {
        this._env = env;
        this._closed = false;
        this._stmt = stmt;
        this._rs = rs;
        this._conn = conn;
    }

    public JdbcResultResource(Env env, ResultSetMetaData metaData, JdbcConnectionResource conn) {
        this._env = env;
        this._closed = true;
        this._metaData = metaData;
        this._conn = conn;
        this._env = conn.getEnv();
    }

    public void close() {
        try {
            if (this._rs != null) {
                this._rs.close();
            }
            this._stmt = null;
            this._env = null;
            this._conn = null;
            this._closed = true;
        }
        catch (SQLException e) {
            log.log(Level.FINE, e.toString(), e);
        }
    }

    public ArrayValue fetchArray(Env env, int type) {
        try {
            if (this._rs.next()) {
                int i;
                ArrayValueImpl array = new ArrayValueImpl();
                if (this._metaData == null) {
                    this._metaData = this._rs.getMetaData();
                }
                int count = this._metaData.getColumnCount();
                if ((type & 1) != 0) {
                    this._columnNames = new Value[count];
                    for (i = 0; i < count; ++i) {
                        this._columnNames[i] = env.createString(this._metaData.getColumnName(i + 1));
                    }
                }
                for (i = 0; i < count; ++i) {
                    Value value = this.getColumnValue(env, this._rs, this._metaData, i + 1);
                    if ((type & 2) != 0) {
                        ((ArrayValue)array).put(LongValue.create(i), value);
                    }
                    if ((type & 1) == 0) continue;
                    ((ArrayValue)array).put(this._columnNames[i], value);
                }
                return array;
            }
            return null;
        }
        catch (SQLException e) {
            log.log(Level.FINE, e.toString(), e);
            return null;
        }
    }

    public ArrayValue fetchAssoc(Env env) {
        return this.fetchArray(env, 1);
    }

    public Value fetchField(Env env, int maxLength, String tableName, String type) {
        ObjectValue result = env.createObject();
        LongValue one = new LongValue(1L);
        LongValue zero = new LongValue(0L);
        try {
            this._rs.next();
            result.putField(env, "name", env.createString(this._rs.getString(1)));
            result.putField(env, "table", env.createString(tableName));
            result.putField(env, "max_length", new LongValue(maxLength));
            if (this._rs.getString(4).indexOf("YES") == -1) {
                result.putField(env, "not_null", one);
            } else {
                result.putField(env, "not_null", zero);
            }
            if (this._rs.getString(5).indexOf("PRI") != -1) {
                result.putField(env, "primary_key", one);
            } else {
                result.putField(env, "primary_key", zero);
            }
            if (this._rs.getString(5).indexOf("MUL") != -1) {
                result.putField(env, "multiple_key", one);
            } else {
                result.putField(env, "multiple_key", zero);
            }
            if (this._rs.getString(2).indexOf(INTEGER) != -1 || this._rs.getString(2).indexOf(REAL) != -1) {
                result.putField(env, "numeric", one);
            } else {
                result.putField(env, "numeric", zero);
            }
            if (this._rs.getString(2).indexOf(BLOB) != -1) {
                result.putField(env, BLOB, one);
            } else {
                result.putField(env, BLOB, zero);
            }
            result.putField(env, "type", env.createString(type));
            if (this._rs.getString(2).indexOf("unsigned") != -1) {
                result.putField(env, "unsigned", one);
            } else {
                result.putField(env, "unsigned", zero);
            }
            if (this._rs.getString(2).indexOf("zerofill") != -1) {
                result.putField(env, "zerofill", one);
            } else {
                result.putField(env, "zerofill", zero);
            }
            return result;
        }
        catch (SQLException e) {
            log.log(Level.FINE, e.toString(), e);
            return BooleanValue.FALSE;
        }
    }

    protected Value fetchFieldImproved(Env env, int maxLength, String name, String originalName, String table, int type, int scale) {
        ObjectValue result = env.createObject();
        try {
            if (this._metaData == null) {
                this._metaData = this._rs.getMetaData();
            }
            this._rs.next();
            result.putField(env, "name", env.createString(name));
            result.putField(env, "orgname", env.createString(originalName));
            result.putField(env, "table", env.createString(table));
            result.putField(env, "orgtable", env.createString(table));
            if (this._rs.getString(6) != null) {
                result.putField(env, "def", env.createString(this._rs.getString(6)));
            } else {
                result.putField(env, "def", env.createString(""));
            }
            result.putField(env, "max_length", new LongValue(maxLength));
            long flags = 0L;
            if (this._rs.getString(4).indexOf("YES") == -1) {
                ++flags;
            }
            if (this._rs.getString(5).indexOf("PRI") != -1) {
                flags += 2L;
                flags += 16384L;
            }
            if (this._rs.getString(5).indexOf("MUL") != -1) {
                flags += 8L;
                flags += 16384L;
            }
            if (this._rs.getString(2).indexOf(BLOB) != -1 || type == -1 || type == -4) {
                flags += 16L;
            }
            if (this._rs.getString(2).indexOf("unsigned") != -1) {
                flags += 32L;
            }
            if (this._rs.getString(2).indexOf("zerofill") != -1) {
                flags += 64L;
            }
            if (this._rs.getString(3) != null && this._rs.getString(3).indexOf("bin") != -1 || type == -4 || type == 91 || type == 93) {
                flags += 128L;
            }
            if (this._rs.getString(2).indexOf("enum") != -1) {
                flags += 256L;
            }
            if (this._rs.getString(7).indexOf("auto") != -1) {
                flags += 512L;
            }
            if (this._rs.getString(2).indexOf("set") != -1) {
                flags += 2048L;
            }
            if (type == -5 || type == -7 || type == 16 || type == 3 || type == 8 || type == 7 || type == 4 || type == 5) {
                flags += 32768L;
            }
            result.putField(env, "flags", new LongValue(flags));
            int quercusType = 0;
            switch (type) {
                case 3: {
                    quercusType = 0;
                    break;
                }
                case -7: {
                    quercusType = 1;
                    break;
                }
                case 5: {
                    quercusType = 2;
                    break;
                }
                case 4: {
                    if (this._rs.getString(2).indexOf("medium") == -1) {
                        quercusType = 3;
                        break;
                    }
                    quercusType = 9;
                    break;
                }
                case 7: {
                    quercusType = 4;
                    break;
                }
                case 8: {
                    quercusType = 5;
                    break;
                }
                case -5: {
                    quercusType = 8;
                    break;
                }
                case 91: {
                    quercusType = 10;
                    break;
                }
                case 93: {
                    quercusType = 12;
                    break;
                }
                case -4: 
                case -1: {
                    quercusType = 252;
                    break;
                }
                case 1: {
                    quercusType = 254;
                    break;
                }
                case 12: {
                    quercusType = 253;
                    break;
                }
                default: {
                    quercusType = 6;
                }
            }
            result.putField(env, "type", new LongValue(quercusType));
            result.putField(env, "decimals", new LongValue(scale));
        }
        catch (SQLException e) {
            log.log(Level.FINE, e.toString(), e);
            return BooleanValue.FALSE;
        }
        return result;
    }

    public Value fetchObject(Env env) {
        try {
            if (this._rs.next()) {
                ObjectValue result = env.createObject();
                if (this._metaData == null) {
                    this._metaData = this._rs.getMetaData();
                }
                int count = this._metaData.getColumnCount();
                for (int i = 0; i < count; ++i) {
                    String name = this._metaData.getColumnName(i + 1);
                    Value value = this.getColumnValue(env, this._rs, this._metaData, i + 1);
                    result.putField(env, name, value);
                }
                return result;
            }
            return NullValue.NULL;
        }
        catch (SQLException e) {
            log.log(Level.FINE, e.toString(), e);
            return NullValue.NULL;
        }
    }

    public ArrayValue fetchRow(Env env) {
        return this.fetchArray(env, 2);
    }

    public static String getColumnPHPName(int dataType) {
        switch (dataType) {
            case -7: 
            case -5: 
            case 4: 
            case 5: {
                return INTEGER;
            }
            case -4: 
            case -1: {
                return BLOB;
            }
            case 1: 
            case 12: {
                return STRING;
            }
            case 91: {
                return DATE;
            }
            case 93: {
                return DATETIME;
            }
            case 3: 
            case 7: 
            case 8: {
                return REAL;
            }
        }
        return UNKNOWN;
    }

    public int getAffectedRows() {
        return this._affectedRows;
    }

    protected int getColumnNumber(Value fieldNameOrNumber, int base) throws SQLException {
        int fieldNumber = -1;
        if (fieldNameOrNumber != null && fieldNameOrNumber.isLongConvertible()) {
            fieldNumber = fieldNameOrNumber.toInt() - base;
        }
        if (fieldNumber < 0) {
            fieldNumber = this.getColumnNumber(fieldNameOrNumber.toString());
        }
        return fieldNumber;
    }

    protected int getColumnNumber(String colName) throws SQLException {
        return this.getColumnNumber(colName, this.getMetaData());
    }

    private int getColumnNumber(String colName, ResultSetMetaData rsmd) throws SQLException {
        int numColumns = rsmd.getColumnCount();
        if (colName.indexOf(46) == -1) {
            for (int i = 1; i <= numColumns; ++i) {
                if (!colName.equals(rsmd.getColumnName(i))) continue;
                return i - 1;
            }
            return -1;
        }
        for (int i = 1; i <= numColumns; ++i) {
            if (!colName.equals(rsmd.getTableName(i) + '.' + rsmd.getColumnName(i))) continue;
            return i - 1;
        }
        return -1;
    }

    public Value getColumnValue(Env env, ResultSet rs, ResultSetMetaData metaData, int column) throws SQLException {
        try {
            switch (metaData.getColumnType(column)) {
                case 0: {
                    return NullValue.NULL;
                }
                case -7: {
                    String typeName = metaData.getColumnTypeName(column);
                    if (!typeName.equals("bool")) {
                        long value = rs.getLong(column);
                        if (rs.wasNull()) {
                            return NullValue.NULL;
                        }
                        return this._env.createString(String.valueOf(value));
                    }
                }
                case 16: {
                    boolean b = rs.getBoolean(column);
                    if (rs.wasNull()) {
                        return NullValue.NULL;
                    }
                    return env.createString(b ? "t" : "f");
                }
                case -6: 
                case -5: 
                case 4: 
                case 5: {
                    long value = rs.getLong(column);
                    if (rs.wasNull()) {
                        return NullValue.NULL;
                    }
                    return this._env.createString(String.valueOf(value));
                }
                case 8: {
                    double value = rs.getDouble(column);
                    if (rs.wasNull()) {
                        return NullValue.NULL;
                    }
                    StringValue sb = this._env.createUnicodeBuilder();
                    if (metaData.isCurrency(column)) {
                        sb.append("$");
                    }
                    return sb.append(value);
                }
                case 2004: {
                    Object object = rs.getBlob(column);
                    if (object.getClass().getName().equals("oracle.sql.BLOB")) {
                        OracleOciLob ociLob = new OracleOciLob((Oracle)this._conn, 13);
                        ociLob.setLob(object);
                        object = ociLob;
                    }
                    return env.wrapJava(object);
                }
                case 2005: {
                    Object object = rs.getClob(column);
                    if (object.getClass().getName().equals("oracle.sql.CLOB")) {
                        OracleOciLob ociLob = new OracleOciLob((Oracle)this._conn, 13);
                        ociLob.setLob(object);
                        object = ociLob;
                    }
                    return env.wrapJava(object);
                }
                case -4: 
                case -3: 
                case -2: {
                    StringValue bb = env.createBinaryBuilder();
                    InputStream is = rs.getBinaryStream(column);
                    if (is == null || rs.wasNull()) {
                        return NullValue.NULL;
                    }
                    try {
                        bb.append(is);
                    }
                    catch (RuntimeException e) {
                        log.log(Level.WARNING, e.toString(), e);
                        return NullValue.NULL;
                    }
                    return bb;
                }
            }
            String strValue = rs.getString(column);
            if (strValue == null || rs.wasNull()) {
                return NullValue.NULL;
            }
            return env.createString(strValue);
        }
        catch (SQLException e) {
            log.log(Level.FINE, e.toString(), e);
            return NullValue.NULL;
        }
    }

    public JdbcConnectionResource getConnection() {
        return this._conn;
    }

    public Value getFieldCatalog(int fieldOffset) {
        try {
            if (this._metaData == null) {
                this._metaData = this._rs.getMetaData();
            }
            if (this._metaData.getColumnCount() <= fieldOffset || fieldOffset < 0) {
                return BooleanValue.FALSE;
            }
            return this._env.createString(this._metaData.getCatalogName(fieldOffset + 1));
        }
        catch (SQLException e) {
            log.log(Level.FINE, e.toString(), e);
            return BooleanValue.FALSE;
        }
    }

    public int getFieldCount() {
        try {
            return this.getMetaData().getColumnCount();
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public Value getFieldFlags() {
        try {
            StringBuilder flags = new StringBuilder();
            this._rs.next();
            if (this._rs.getString(4).indexOf("YES") == -1) {
                flags.append("not_null");
            }
            if (this._rs.getString(5).indexOf("PRI") != -1) {
                if (flags.length() > 0) {
                    flags.append(' ');
                }
                flags.append("primary_key");
            } else if (this._rs.getString(5).indexOf("MUL") != -1) {
                if (flags.length() > 0) {
                    flags.append(' ');
                }
                flags.append("multiple_key");
            }
            if (this._rs.getString(2).indexOf(BLOB) != -1) {
                if (flags.length() > 0) {
                    flags.append(' ');
                }
                flags.append(BLOB);
            }
            if (this._rs.getString(2).indexOf("unsigned") != -1) {
                if (flags.length() > 0) {
                    flags.append(' ');
                }
                flags.append("unsigned");
            }
            if (this._rs.getString(2).indexOf("zerofill") != -1) {
                if (flags.length() > 0) {
                    flags.append(' ');
                }
                flags.append("zerofill");
            }
            if (this._rs.getString(3).indexOf("bin") != -1) {
                if (flags.length() > 0) {
                    flags.append(' ');
                }
                flags.append("binary");
            }
            if (this._rs.getString(2).indexOf("enum") != -1) {
                if (flags.length() > 0) {
                    flags.append(' ');
                }
                flags.append("enum");
            }
            if (this._rs.getString(7).indexOf("auto_increment") != -1) {
                if (flags.length() > 0) {
                    flags.append(' ');
                }
                flags.append("auto_increment");
            }
            if (this._rs.getString(2).indexOf(DATE) != -1) {
                if (flags.length() > 0) {
                    flags.append(' ');
                }
                flags.append("timestamp");
            }
            return this._env.createString(flags.toString());
        }
        catch (SQLException e) {
            log.log(Level.FINE, e.toString(), e);
            return BooleanValue.FALSE;
        }
    }

    public Value getFieldLength(Env env, int fieldOffset) {
        try {
            if (this._metaData == null) {
                this._metaData = this._rs.getMetaData();
            }
            if (this._metaData.getColumnCount() <= fieldOffset || fieldOffset < 0) {
                env.invalidArgument("field", fieldOffset);
                return BooleanValue.FALSE;
            }
            return new LongValue(this._metaData.getPrecision(fieldOffset + 1));
        }
        catch (SQLException e) {
            log.log(Level.FINE, e.toString(), e);
            return BooleanValue.FALSE;
        }
    }

    public Value getFieldName(Env env, int fieldOffset) {
        try {
            if (this._metaData == null) {
                this._metaData = this._rs.getMetaData();
            }
            if (this._metaData.getColumnCount() <= fieldOffset || fieldOffset < 0) {
                env.invalidArgument("field", fieldOffset);
                return BooleanValue.FALSE;
            }
            return env.createString(this._metaData.getColumnName(fieldOffset + 1));
        }
        catch (Exception e) {
            log.log(Level.FINE, e.toString(), e);
            return BooleanValue.FALSE;
        }
    }

    public Value getFieldNameAlias(int fieldOffset) {
        try {
            if (this._metaData == null) {
                this._metaData = this._rs.getMetaData();
            }
            if (this._metaData.getColumnCount() <= fieldOffset || fieldOffset < 0) {
                return BooleanValue.FALSE;
            }
            return this._env.createString(this._metaData.getColumnLabel(fieldOffset + 1));
        }
        catch (Exception e) {
            log.log(Level.FINE, e.toString(), e);
            return BooleanValue.FALSE;
        }
    }

    public Value getFieldNotNull(Env env, int fieldOffset) {
        try {
            if (this._metaData == null) {
                this._metaData = this._rs.getMetaData();
            }
            if (this._metaData.getColumnCount() <= fieldOffset || fieldOffset < 0) {
                env.invalidArgument("field", fieldOffset);
                return BooleanValue.FALSE;
            }
            if (this._metaData.isNullable(fieldOffset + 1) == 0) {
                return LongValue.ONE;
            }
            return LongValue.ZERO;
        }
        catch (Exception e) {
            log.log(Level.FINE, e.toString(), e);
            return BooleanValue.FALSE;
        }
    }

    public int getFieldOffset() {
        return this._fieldOffset;
    }

    public Value getFieldScale(int fieldOffset) {
        try {
            if (this._metaData == null) {
                this._metaData = this._rs.getMetaData();
            }
            if (this._metaData.getColumnCount() <= fieldOffset || fieldOffset < 0) {
                return BooleanValue.FALSE;
            }
            return new LongValue(this._metaData.getScale(fieldOffset + 1));
        }
        catch (SQLException e) {
            log.log(Level.FINE, e.toString(), e);
            return BooleanValue.FALSE;
        }
    }

    public Value getFieldTable(Env env, int fieldOffset) {
        try {
            if (this._metaData == null) {
                this._metaData = this._rs.getMetaData();
            }
            if (this._metaData.getColumnCount() <= fieldOffset || fieldOffset < 0) {
                env.invalidArgument("field", fieldOffset);
                return BooleanValue.FALSE;
            }
            String tableName = this._metaData.getTableName(fieldOffset + 1);
            if (tableName == null || tableName.equals("")) {
                return BooleanValue.FALSE;
            }
            return env.createString(tableName);
        }
        catch (SQLException e) {
            log.log(Level.FINE, e.toString(), e);
            return BooleanValue.FALSE;
        }
    }

    public Value getFieldType(Env env, int fieldOffset) {
        try {
            if (this._metaData == null) {
                this._metaData = this._rs.getMetaData();
            }
            if (this._metaData.getColumnCount() <= fieldOffset || fieldOffset < 0) {
                env.invalidArgument("field", fieldOffset);
                return BooleanValue.FALSE;
            }
            return env.createString(JdbcResultResource.getColumnPHPName(this._metaData.getColumnType(fieldOffset + 1)));
        }
        catch (Exception e) {
            log.log(Level.FINE, e.toString(), e);
            return BooleanValue.FALSE;
        }
    }

    protected Statement getJavaStatement() {
        return this._conn.getEnv().getQuercus().getStatement(this.getStatement());
    }

    protected Value getJdbcType(int fieldOffset) {
        try {
            if (this._metaData == null) {
                this._metaData = this._rs.getMetaData();
            }
            return new LongValue(this._metaData.getColumnType(fieldOffset + 1));
        }
        catch (Exception e) {
            log.log(Level.FINE, e.toString(), e);
            return BooleanValue.FALSE;
        }
    }

    public Value getLengths() {
        ArrayValueImpl result;
        ArrayValueImpl array = new ArrayValueImpl();
        try {
            if (this._metaData == null) {
                this._metaData = this._rs.getMetaData();
            }
            int numColumns = this._metaData.getColumnCount();
            for (int i = 1; i <= numColumns; ++i) {
                ((ArrayValue)array).put(new LongValue(this._rs.getObject(i).toString().length()));
            }
            result = array;
        }
        catch (SQLException e) {
            log.log(Level.FINE, e.toString(), e);
            return BooleanValue.FALSE;
        }
        return result;
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        if (this._metaData == null && this._rs != null) {
            this._metaData = this._rs.getMetaData();
        }
        return this._metaData;
    }

    public Value getNumFields() {
        try {
            int count;
            Value result = NullValue.NULL;
            if (this._metaData == null) {
                this._metaData = this._rs.getMetaData();
            }
            if ((count = this._metaData.getColumnCount()) != 0) {
                result = new LongValue(count);
            }
            return result;
        }
        catch (Exception e) {
            log.log(Level.FINE, e.toString(), e);
            return NullValue.NULL;
        }
    }

    public int getNumRows() {
        return JdbcResultResource.getNumRows(this._rs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getNumRows(ResultSet rs) {
        int n;
        block13: {
            int currentRow;
            block11: {
                if (rs == null) {
                    return -1;
                }
                currentRow = rs.getRow();
                try {
                    rs.last();
                    n = rs.getRow();
                    if (currentRow != 0) break block11;
                }
                catch (Exception e) {
                    int n2;
                    block14: {
                        block12: {
                            try {
                                log.log(Level.FINE, e.toString(), e);
                                n2 = -1;
                                if (currentRow != 0) break block12;
                            }
                            catch (Throwable throwable) {
                                try {
                                    if (currentRow == 0) {
                                        rs.beforeFirst();
                                    } else {
                                        rs.absolute(currentRow);
                                    }
                                    throw throwable;
                                }
                                catch (SQLException e2) {
                                    log.log(Level.FINE, e2.toString(), e2);
                                    return -1;
                                }
                            }
                            rs.beforeFirst();
                            break block14;
                        }
                        rs.absolute(currentRow);
                    }
                    return n2;
                }
                rs.beforeFirst();
                break block13;
            }
            rs.absolute(currentRow);
        }
        return n;
    }

    public Value getResultField(Env env, int row, Value field) {
        try {
            ResultSetMetaData md = this.getMetaData();
            int colNumber = field.isNumberConvertible() ? field.toInt() : this.getColumnNumber(field.toString(), this._metaData);
            if (colNumber < 0 || colNumber >= md.getColumnCount()) {
                env.invalidArgument("field", field);
                return BooleanValue.FALSE;
            }
            int currentRow = this._rs.getRow();
            if (!this._rs.absolute(row + 1) || this._rs.isAfterLast()) {
                if (currentRow > 0) {
                    this._rs.absolute(currentRow);
                } else {
                    this._rs.beforeFirst();
                }
                return BooleanValue.FALSE;
            }
            return this.getColumnValue(env, this._rs, this._metaData, colNumber + 1);
        }
        catch (SQLException e) {
            log.log(Level.FINE, e.toString(), e);
            return BooleanValue.FALSE;
        }
    }

    public ResultSet getResultSet() {
        return this._rs;
    }

    public Statement getStatement() {
        return this._stmt;
    }

    public boolean seek(Env env, int rowNumber) {
        return this.setRowNumber(rowNumber);
    }

    public void setAffectedRows(int affectedRows) {
        this._affectedRows = affectedRows;
    }

    public void setFieldOffset(int fieldOffset) {
        this._fieldOffset = fieldOffset;
    }

    public boolean setRowNumber(int rowNumber) {
        return JdbcResultResource.setRowNumber(this._rs, rowNumber);
    }

    public static boolean setRowNumber(ResultSet rs, int rowNumber) {
        int numRows = JdbcResultResource.getNumRows(rs);
        if (numRows <= rowNumber || rowNumber < 0) {
            return false;
        }
        try {
            if (rowNumber == 0) {
                rs.beforeFirst();
            } else {
                rs.absolute(rowNumber);
            }
        }
        catch (SQLException e) {
            log.log(Level.FINE, e.toString(), e);
            return false;
        }
        return true;
    }

    public Value toKey() {
        return this._env.createString("JdbcResultResource$" + System.identityHashCode(this));
    }

    public String toString() {
        return "com.caucho.quercus.resources.JdbcResultResource";
    }

    public JdbcResultResource validateResult() {
        return this;
    }
}

