/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.lib.db;

import com.caucho.quercus.env.BooleanValue;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.NullValue;
import com.caucho.quercus.env.UnsetValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.lib.db.JdbcConnectionResource;
import com.caucho.quercus.lib.db.JdbcResultResource;
import com.caucho.quercus.lib.db.OracleStatement;
import com.caucho.util.L10N;
import com.caucho.util.Log;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class JdbcStatementResource {
    private static final Logger log = Log.open(JdbcStatementResource.class);
    private static final L10N L = new L10N(JdbcStatementResource.class);
    private JdbcConnectionResource _conn;
    private ResultSet _rs;
    private String _query;
    private PreparedStatement _stmt;
    private ResultSetMetaData _metaData;
    private JdbcResultResource _resultResource = null;
    private char[] _types;
    private Value[] _params;
    private Value[] _results;
    private String _errorMessage = "";
    private int _errorCode;
    private String _stmtType;

    public JdbcStatementResource(JdbcConnectionResource connV, String query) throws SQLException {
        this._conn = connV;
        this.prepareStatement(query);
    }

    public JdbcStatementResource(JdbcConnectionResource connV) {
        this._conn = connV;
    }

    protected boolean bindParams(Env env, String types, Value[] params) {
        int i;
        int size = types.length();
        if (size != params.length) {
            env.warning(L.l("number of types does not match number of parameters"));
            return false;
        }
        for (i = 0; i < size; ++i) {
            if ("idsb".indexOf(types.charAt(i)) >= 0) continue;
            env.warning(L.l("invalid type string {0}", (Object)types));
            return false;
        }
        this._types = new char[size];
        this._params = new Value[size];
        for (i = 0; i < size; ++i) {
            this._types[i] = types.charAt(i);
            this._params[i] = params[i];
        }
        return true;
    }

    public boolean bindResults(Env env, Value[] outParams) {
        int numColumns;
        int size = outParams.length;
        try {
            ResultSetMetaData md = this.getMetaData();
            numColumns = md.getColumnCount();
        }
        catch (SQLException e) {
            log.log(Level.FINE, e.toString(), e);
            return false;
        }
        if (size != numColumns) {
            env.warning(L.l("number of bound variables does not equal number of columns"));
            return false;
        }
        this._results = new Value[size];
        System.arraycopy(outParams, 0, this._results, 0, size);
        return true;
    }

    public void close() {
        try {
            if (this._rs != null) {
                this._rs.close();
            }
            if (this._stmt != null) {
                this._stmt.close();
            }
        }
        catch (SQLException e) {
            this._errorMessage = e.getMessage();
            this._errorCode = e.getErrorCode();
            log.log(Level.FINE, e.toString(), e);
        }
    }

    protected boolean dataSeek(int offset) {
        return JdbcResultResource.setRowNumber(this._rs, offset);
    }

    public int errorCode() {
        return this._errorCode;
    }

    public String errorMessage() {
        return this._errorMessage;
    }

    public boolean execute(Env env) {
        try {
            if (this._types != null) {
                int size = this._types.length;
                block8: for (int i = 0; i < size; ++i) {
                    switch (this._types[i]) {
                        case 'i': {
                            this._stmt.setInt(i + 1, this._params[i].toInt());
                            continue block8;
                        }
                        case 'd': {
                            this._stmt.setDouble(i + 1, this._params[i].toDouble());
                            continue block8;
                        }
                        case 'b': {
                            this._stmt.setString(i + 1, this._params[i].toString());
                            continue block8;
                        }
                        case 's': {
                            this._stmt.setString(i + 1, this._params[i].toString());
                            continue block8;
                        }
                    }
                }
            }
            return this.executeStatement();
        }
        catch (SQLException e) {
            env.warning(L.l(e.toString()));
            log.log(Level.FINE, e.toString(), e);
            this._errorMessage = e.getMessage();
            this._errorCode = e.getErrorCode();
            return false;
        }
    }

    protected boolean executeStatement() throws SQLException {
        try {
            if (this._stmt.execute()) {
                this._conn.setAffectedRows(0);
                this._rs = this._stmt.getResultSet();
            } else {
                this._conn.setAffectedRows(this._stmt.getUpdateCount());
            }
            return true;
        }
        catch (SQLException e) {
            this._errorMessage = e.getMessage();
            this._errorCode = e.getErrorCode();
            throw e;
        }
    }

    public Value fetch(Env env) {
        try {
            if (this._rs.next()) {
                if (this._metaData == null) {
                    this._metaData = this._rs.getMetaData();
                }
                JdbcResultResource resultResource = this.getResultMetadata();
                int size = this._results.length;
                for (int i = 0; i < size; ++i) {
                    this._results[i].set(this._resultResource.getColumnValue(env, this._rs, this._metaData, i + 1));
                }
                return BooleanValue.TRUE;
            }
            return BooleanValue.FALSE;
        }
        catch (SQLException e) {
            log.log(Level.FINE, e.toString(), e);
            return NullValue.NULL;
        }
    }

    public boolean freeResult() {
        if (this._rs == null) {
            return true;
        }
        try {
            this._rs.close();
            this._rs = null;
            if (this._resultResource != null) {
                this._resultResource.close();
                this._resultResource = null;
            }
            return true;
        }
        catch (SQLException e) {
            this._errorMessage = e.getMessage();
            this._errorCode = e.getErrorCode();
            log.log(Level.FINE, e.toString(), e);
            return false;
        }
    }

    protected ResultSetMetaData getMetaData() throws SQLException {
        if (this._metaData == null) {
            this._metaData = this._rs.getMetaData();
        }
        return this._metaData;
    }

    public int getNumRows() throws SQLException {
        if (this._rs != null) {
            return JdbcResultResource.getNumRows(this._rs);
        }
        return 0;
    }

    protected PreparedStatement getPreparedStatement() {
        return this._stmt;
    }

    public JdbcResultResource getResultMetadata() {
        if (this._resultResource != null) {
            this._resultResource.setFieldOffset(0);
            return this._resultResource;
        }
        if (this._stmt == null || this._rs == null) {
            return null;
        }
        this._resultResource = new JdbcResultResource(this._conn.getEnv(), this._stmt, this._rs, this._conn);
        return this._resultResource;
    }

    protected ResultSet getResultSet() {
        return this._rs;
    }

    protected Connection getJavaConnection() throws SQLException {
        return this.validateConnection().getJavaConnection();
    }

    public String getStatementType() {
        this._stmtType = this._query;
        this._stmtType = this._stmtType.replaceAll("\\s+.*", "");
        if (this._stmtType.equals("")) {
            this._stmtType = "UNKNOWN";
        } else {
            this._stmtType = this._stmtType.toUpperCase();
            String s = this._stmtType.replaceAll("(SELECT|UPDATE|DELETE|INSERT|CREATE|DROP|ALTER|BEGIN|DECLARE)", "");
            if (!s.equals("")) {
                this._stmtType = "UNKNOWN";
            }
        }
        return this._stmtType;
    }

    public int paramCount() {
        if (this._query == null) {
            return -1;
        }
        int count = 0;
        int length = this._query.length();
        boolean inQuotes = false;
        for (int i = 0; i < length; ++i) {
            char c = this._query.charAt(i);
            if (c == '\\') {
                if (i >= length - 1) continue;
                ++i;
                continue;
            }
            if (inQuotes) {
                if (c != '\'') continue;
                inQuotes = false;
                continue;
            }
            if (c == '\'') {
                inQuotes = true;
                continue;
            }
            if (c != '?') continue;
            ++count;
        }
        return count;
    }

    public boolean prepare(String query) {
        try {
            if (this._stmt != null) {
                this._stmt.close();
            }
            this._query = query;
            this._stmt = this instanceof OracleStatement ? this._conn.getConnection().prepareCall(query, 1004, 1007) : this._conn.getConnection().prepareStatement(query, 1004, 1007);
            return true;
        }
        catch (SQLException e) {
            log.log(Level.FINE, e.toString(), e);
            this._errorMessage = e.getMessage();
            this._errorCode = e.getErrorCode();
            return false;
        }
    }

    public boolean prepareStatement(String query) {
        try {
            if (this._stmt != null) {
                this._stmt.close();
            }
            this._query = query;
            this._stmt = this instanceof OracleStatement ? this._conn.getConnection().prepareCall(query, 1004, 1007) : this._conn.getConnection().prepareStatement(query, 1004, 1007);
            return true;
        }
        catch (SQLException e) {
            log.log(Level.FINE, e.toString(), e);
            this._errorMessage = e.getMessage();
            this._errorCode = e.getErrorCode();
            return false;
        }
    }

    protected Value getParam(int i) {
        if (i >= this._params.length) {
            return UnsetValue.UNSET;
        }
        return this._params[i];
    }

    protected int getParamLength() {
        return this._params.length;
    }

    protected void setPreparedStatement(PreparedStatement stmt) {
        this._stmt = stmt;
    }

    protected void setResultSet(ResultSet rs) {
        this._rs = rs;
    }

    protected void setObject(int i, Object param) throws Exception {
        try {
            ParameterMetaData pmd = this._stmt.getParameterMetaData();
            int type = pmd.getParameterType(i);
            switch (type) {
                case 1111: {
                    String typeName = pmd.getParameterTypeName(i);
                    if (typeName.equals("interval")) {
                        this._stmt.setObject(i, param);
                        break;
                    }
                    Class<?> cl = Class.forName("org.postgresql.util.PGobject");
                    Constructor<?> constructor = cl.getDeclaredConstructor(null);
                    Object object = constructor.newInstance(new Object[0]);
                    Method method = cl.getDeclaredMethod("setType", String.class);
                    method.invoke(object, typeName);
                    method = cl.getDeclaredMethod("setValue", String.class);
                    method.invoke(object, param);
                    this._stmt.setObject(i, object, type);
                    break;
                }
                case 8: {
                    String typeName = pmd.getParameterTypeName(i);
                    if (typeName.equals("money")) {
                        String s = param.toString();
                        if (s.length() == 0) {
                            throw new IllegalArgumentException(L.l("argument `{0}' cannot be empty", param));
                        }
                        String money = s;
                        if (s.charAt(0) == '$') {
                            s = s.substring(1);
                        } else {
                            money = "$" + money;
                        }
                        try {
                            Double.parseDouble(s);
                        }
                        catch (Exception ex) {
                            throw new IllegalArgumentException(L.l("cannot convert argument `{0}' to money", param));
                        }
                        Class<?> cl = Class.forName("org.postgresql.util.PGmoney");
                        Constructor<?> constructor = cl.getDeclaredConstructor(String.class);
                        Object object = constructor.newInstance(money);
                        this._stmt.setObject(i, object, 1111);
                        break;
                    }
                }
                default: {
                    this._stmt.setObject(i, param, type);
                    break;
                }
            }
        }
        catch (SQLException e) {
            this._errorMessage = e.getMessage();
            this._errorCode = e.getErrorCode();
            throw e;
        }
        catch (Exception e) {
            this._stmt.clearParameters();
            throw e;
        }
    }

    public String toString() {
        return this.getClass().getName() + "[" + this._conn + "]";
    }

    public JdbcConnectionResource validateConnection() {
        return this._conn;
    }
}

