/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.lib.db;

import com.caucho.quercus.lib.db.JdbcColumnMetaData;
import com.caucho.util.Alarm;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;

public class JdbcTableMetaData {
    private final String _catalog;
    private final String _schema;
    private final String _name;
    private final long _lastModified;
    private long _maxIdleTime = 5000L;
    private final HashMap<String, JdbcColumnMetaData> _columnMap = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JdbcTableMetaData(String catalog, String schema, String name, DatabaseMetaData md) throws SQLException {
        this._catalog = catalog;
        this._schema = schema;
        this._name = name;
        this._lastModified = Alarm.getCurrentTime();
        ResultSet rs = md.getColumns(this._catalog, this._schema, this._name, null);
        try {
            JdbcColumnMetaData column;
            String columnName;
            while (rs.next()) {
                columnName = rs.getString(4);
                column = new JdbcColumnMetaData(this, rs);
                this._columnMap.put(columnName, column);
            }
            rs.close();
            rs = md.getPrimaryKeys(this._catalog, this._schema, this._name);
            while (rs.next()) {
                columnName = rs.getString(4);
                column = this._columnMap.get(columnName);
                column.setPrimaryKey(true);
            }
            rs.close();
            rs = md.getIndexInfo(this._catalog, this._schema, this._name, false, true);
            while (rs.next()) {
                columnName = rs.getString(9);
                column = this._columnMap.get(columnName);
                column.setIndex(true);
            }
        }
        finally {
            rs.close();
        }
    }

    public String getName() {
        return this._name;
    }

    public String getCatalog() {
        return this._catalog;
    }

    public JdbcColumnMetaData getColumn(String name) {
        return this._columnMap.get(name);
    }

    public boolean isValid() {
        return Alarm.getCurrentTime() - this._lastModified <= this._maxIdleTime;
    }

    public String toString() {
        return "JdbcTableMetaData[" + this.getName() + "]";
    }
}

