/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.lib.db;

import com.caucho.quercus.annotation.NotNull;
import com.caucho.quercus.annotation.Optional;
import com.caucho.quercus.annotation.ReturnNullAsFalse;
import com.caucho.quercus.env.ArrayValue;
import com.caucho.quercus.env.BooleanValue;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.LongValue;
import com.caucho.quercus.env.NullValue;
import com.caucho.quercus.env.ObjectValue;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.lib.db.JdbcColumnMetaData;
import com.caucho.quercus.lib.db.JdbcConnectionResource;
import com.caucho.quercus.lib.db.JdbcResultResource;
import com.caucho.quercus.lib.db.JdbcTableMetaData;
import com.caucho.quercus.lib.db.Mysqli;
import com.caucho.quercus.lib.db.MysqliResult;
import com.caucho.quercus.module.AbstractQuercusModule;
import com.caucho.util.L10N;
import com.caucho.util.Log;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MysqlModule
extends AbstractQuercusModule {
    private static final Logger log = Log.open(MysqlModule.class);
    private static final L10N L = new L10N(MysqlModule.class);
    public static final int MYSQL_ASSOC = 1;
    public static final int MYSQL_NUM = 2;
    public static final int MYSQL_BOTH = 3;
    public static final int MYSQL_USE_RESULT = 0;
    public static final int MYSQL_STORE_RESULT = 1;

    public String[] getLoadedExtensions() {
        return new String[]{"mysql"};
    }

    public int mysql_affected_rows(Env env, @Optional Mysqli conn) {
        if (conn == null) {
            conn = this.getConnection(env);
        }
        return conn.affected_rows();
    }

    public String mysql_client_encoding(Env env, @Optional Mysqli conn) {
        if (conn == null) {
            conn = this.getConnection(env);
        }
        return conn.client_encoding();
    }

    public boolean mysql_close(Env env, @Optional Mysqli conn) {
        if (conn == null) {
            conn = this.getConnection(env);
        }
        if (conn != null) {
            if (conn == this.getConnection(env)) {
                env.removeSpecialValue("caucho.mysql");
            }
            conn.close(env);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean mysql_create_db(Env env, @NotNull String name, @Optional Mysqli conn) {
        if (name == null) {
            return false;
        }
        if (conn == null) {
            conn = this.getConnection(env);
        }
        Statement stmt = null;
        try {
            try {
                stmt = conn.validateConnection().getConnection().createStatement();
                stmt.setEscapeProcessing(false);
                stmt.executeUpdate("CREATE DATABASE " + name);
            }
            finally {
                if (stmt != null) {
                    stmt.close();
                }
            }
        }
        catch (SQLException e) {
            log.log(Level.FINE, e.toString(), e);
            return false;
        }
        return true;
    }

    public boolean mysql_data_seek(Env env, @NotNull MysqliResult result, int rowNumber) {
        if (result == null) {
            return false;
        }
        if (result.seek(env, rowNumber)) {
            return true;
        }
        env.warning(L.l("Offset {0} is invalid for MySQL (or the query data is unbuffered)", (long)rowNumber));
        return false;
    }

    public Value mysql_db_name(Env env, @NotNull MysqliResult result, int row, @Optional(value="0") Value field) {
        if (result == null) {
            return BooleanValue.FALSE;
        }
        return this.mysql_result(env, result, row, field);
    }

    public Value mysql_result(Env env, @NotNull MysqliResult result, int row, @Optional(value="0") Value field) {
        if (result == null) {
            return BooleanValue.FALSE;
        }
        return result.getResultField(env, row, field);
    }

    public boolean mysql_drop_db(Env env, @NotNull String databaseName, @Optional Mysqli conn) {
        if (databaseName == null) {
            return false;
        }
        Value value = this.mysql_query(env, "DROP DATABASE " + databaseName, conn);
        return value != null && value.toBoolean();
    }

    public int mysql_errno(Env env, @Optional Mysqli conn) {
        if (conn == null) {
            conn = this.getConnection(env);
        }
        return conn.errno();
    }

    public String mysql_error(Env env, @Optional Mysqli conn) {
        String error;
        if (conn == null) {
            conn = this.getConnection(env);
        }
        if ((error = conn.error()) == null) {
            return "";
        }
        return error;
    }

    public Value mysql_escape_string(Env env, StringValue unescapedString) {
        return this.mysql_real_escape_string(env, unescapedString, null);
    }

    public Value mysql_real_escape_string(Env env, StringValue unescapedString, @Optional Mysqli conn) {
        if (conn == null) {
            conn = this.getConnection(env);
        }
        return conn.real_escape_string(unescapedString);
    }

    public Value mysql_fetch_array(Env env, @NotNull MysqliResult result, @Optional(value="MYSQL_BOTH") int type) {
        if (result == null) {
            return BooleanValue.FALSE;
        }
        ArrayValue value = result.fetch_array(env, type);
        if (value != null) {
            return value;
        }
        return BooleanValue.FALSE;
    }

    @ReturnNullAsFalse
    public ArrayValue mysql_fetch_assoc(Env env, @NotNull MysqliResult result) {
        if (result == null) {
            return null;
        }
        return result.fetch_array(env, 1);
    }

    public Value mysql_fetch_field(Env env, @NotNull MysqliResult result, @Optional(value="-1") int fieldOffset) {
        if (result == null) {
            return BooleanValue.FALSE;
        }
        try {
            int unsigned;
            ResultSetMetaData md;
            if (fieldOffset == -1) {
                fieldOffset = result.field_tell(env);
                result.setFieldOffset(fieldOffset + 1);
            }
            if ((md = result.getMetaData()).getColumnCount() <= fieldOffset || fieldOffset < 0) {
                env.invalidArgument("field", fieldOffset);
                return BooleanValue.FALSE;
            }
            int jdbcField = fieldOffset + 1;
            int jdbcColumnType = md.getColumnType(jdbcField);
            String catalogName = md.getCatalogName(jdbcField);
            String tableName = md.getTableName(jdbcField);
            String columnName = md.getColumnName(jdbcField);
            JdbcColumnMetaData columnMd = null;
            JdbcConnectionResource conn = this.getConnection(env).validateConnection();
            JdbcTableMetaData tableMd = conn.getTableMetaData(catalogName, null, tableName);
            if (tableMd != null) {
                columnMd = tableMd.getColumn(columnName);
            }
            int maxLength = 0;
            int notNull = md.isNullable(jdbcField) == 1 ? 0 : 1;
            int numeric = JdbcColumnMetaData.isNumeric(jdbcColumnType) ? 1 : 0;
            int blob = JdbcColumnMetaData.isBlob(jdbcColumnType) ? 1 : 0;
            String type = JdbcResultResource.getColumnPHPName(jdbcColumnType);
            int n = unsigned = md.isSigned(jdbcField) ? 0 : numeric;
            if (jdbcColumnType == 16 || jdbcColumnType == -7) {
                unsigned = 0;
            } else if (jdbcColumnType == 3) {
                numeric = 1;
            }
            int zerofill = 0;
            int primaryKey = 0;
            int multipleKey = 0;
            int uniqueKey = 0;
            if (columnMd != null) {
                zerofill = columnMd.isZeroFill() ? 1 : 0;
                primaryKey = columnMd.isPrimaryKey() ? 1 : 0;
                uniqueKey = columnMd.isUnique() ? 1 : 0;
            } else {
                notNull = 1;
            }
            ObjectValue fieldResult = env.createObject();
            fieldResult.putField(env, "name", columnName);
            fieldResult.putField(env, "table", tableName);
            fieldResult.putField(env, "def", "");
            fieldResult.putField(env, "max_length", maxLength);
            fieldResult.putField(env, "not_null", notNull);
            fieldResult.putField(env, "primary_key", primaryKey);
            fieldResult.putField(env, "multiple_key", multipleKey);
            fieldResult.putField(env, "unique_key", uniqueKey);
            fieldResult.putField(env, "numeric", numeric);
            fieldResult.putField(env, "blob", blob);
            fieldResult.putField(env, "type", type);
            fieldResult.putField(env, "unsigned", unsigned);
            fieldResult.putField(env, "zerofill", zerofill);
            return fieldResult;
        }
        catch (SQLException e) {
            log.log(Level.FINE, e.toString(), e);
            return BooleanValue.FALSE;
        }
    }

    public Value mysql_query(Env env, String sql, @Optional Mysqli conn) {
        if (conn == null) {
            conn = this.getConnection(env);
        }
        return conn.query(env, sql, 1);
    }

    public Value mysql_fetch_lengths(Env env, @NotNull MysqliResult result) {
        if (result == null) {
            return BooleanValue.FALSE;
        }
        return result.fetch_lengths();
    }

    public Value mysql_fetch_object(Env env, @NotNull MysqliResult result) {
        if (result == null) {
            return BooleanValue.FALSE;
        }
        Value value = result.fetch_object(env);
        if (value == NullValue.NULL) {
            value = BooleanValue.FALSE;
        }
        return value;
    }

    @ReturnNullAsFalse
    public ArrayValue mysql_fetch_row(Env env, @NotNull MysqliResult result) {
        if (result == null) {
            return null;
        }
        return result.fetch_row(env);
    }

    public Value mysql_field_flags(Env env, @NotNull MysqliResult result, int fieldOffset) {
        if (result == null) {
            return BooleanValue.FALSE;
        }
        Value fieldName = result.getFieldName(env, fieldOffset);
        if (fieldName == BooleanValue.FALSE) {
            return BooleanValue.FALSE;
        }
        Value fieldTable = result.getFieldTable(env, fieldOffset);
        if (fieldTable == BooleanValue.FALSE) {
            return BooleanValue.FALSE;
        }
        String sql = "SHOW FULL COLUMNS FROM " + fieldTable.toString() + " LIKE '" + fieldName.toString() + "'";
        Mysqli conn = this.getConnection(env);
        JdbcResultResource metaResult = conn.validateConnection().realQuery(sql);
        if (metaResult instanceof MysqliResult) {
            return ((MysqliResult)metaResult).getFieldFlags();
        }
        return BooleanValue.FALSE;
    }

    public Value mysql_field_name(Env env, @NotNull MysqliResult result, int fieldOffset) {
        if (result == null) {
            return BooleanValue.FALSE;
        }
        return result.getFieldName(env, fieldOffset);
    }

    public boolean mysql_field_seek(Env env, @NotNull MysqliResult result, int fieldOffset) {
        if (result == null) {
            return false;
        }
        return result.field_seek(env, fieldOffset);
    }

    public Value mysql_field_table(Env env, @NotNull MysqliResult result, int fieldOffset) {
        if (result == null) {
            return BooleanValue.FALSE;
        }
        return result.getFieldTable(env, fieldOffset);
    }

    public static Value mysql_field_type(Env env, @NotNull MysqliResult result, Value fieldOffset) {
        if (result == null) {
            return NullValue.NULL;
        }
        if (!fieldOffset.isset()) {
            return NullValue.NULL;
        }
        return result.getFieldType(env, fieldOffset.toInt());
    }

    public static Value mysql_fieldlen(Env env, @NotNull MysqliResult result, int fieldOffset) {
        return MysqlModule.mysql_field_len(env, result, fieldOffset);
    }

    public static Value mysql_field_len(Env env, @NotNull MysqliResult result, @Optional int fieldOffset) {
        if (result == null) {
            return BooleanValue.FALSE;
        }
        return result.getFieldLength(env, fieldOffset);
    }

    public boolean mysql_free_result(MysqliResult result) {
        if (result != null) {
            result.close();
        }
        return true;
    }

    public static String mysql_get_client_info(Env env) {
        String version = env.getQuercus().getMysqlVersion();
        if (version != null) {
            return version;
        }
        try {
            Driver driver = DriverManager.getDriver("jdbc:mysql://localhost/");
            return driver.getMajorVersion() + 46 + driver.getMinorVersion() + ".00";
        }
        catch (SQLException e) {
            return "0.00.00";
        }
    }

    public String mysql_get_host_info(Env env, @Optional Mysqli conn) {
        if (conn == null) {
            conn = this.getConnection(env);
        }
        return conn.get_host_info();
    }

    public int mysql_get_proto_info(Env env, @Optional Mysqli conn) {
        if (conn == null) {
            conn = this.getConnection(env);
        }
        return conn.get_proto_info();
    }

    @ReturnNullAsFalse
    public String mysql_get_server_info(Env env, @Optional Mysqli conn) {
        if (conn == null) {
            conn = this.getConnection(env);
        }
        if (conn != null && conn.isConnected()) {
            return conn.get_server_info();
        }
        return null;
    }

    public Value mysql_insert_id(Env env, @Optional Mysqli conn) {
        if (conn == null) {
            conn = this.getConnection(env);
        }
        return conn.insert_id();
    }

    public JdbcResultResource mysql_list_dbs(Env env, @Optional Mysqli conn) {
        if (conn == null) {
            conn = this.getConnection(env);
        }
        return conn.list_dbs();
    }

    public Value mysql_list_fields(Env env, String databaseName, String tableName, @Optional Mysqli conn) {
        if (databaseName == null) {
            return BooleanValue.FALSE;
        }
        if (tableName == null) {
            return BooleanValue.FALSE;
        }
        return this.mysql_db_query(env, databaseName, "SELECT * FROM " + tableName + " WHERE NULL", conn);
    }

    public Value mysql_db_query(Env env, String databaseName, String query, @Optional Mysqli conn) {
        if (conn == null) {
            conn = this.getConnection(env);
        }
        if (!conn.select_db(databaseName)) {
            return BooleanValue.FALSE;
        }
        return conn.query(env, query, 1);
    }

    public boolean mysql_select_db(Env env, String name, @Optional Mysqli conn) {
        if (conn == null) {
            conn = this.getConnection(env);
        }
        return conn.select_db(name);
    }

    public Object mysql_list_tables(Env env, String databaseName, @Optional Mysqli conn) {
        return this.mysql_query(env, "SHOW TABLES FROM " + databaseName, conn);
    }

    public int mysql_num_fields(Env env, @NotNull MysqliResult result) {
        if (result == null) {
            return -1;
        }
        return result.num_fields();
    }

    public Value mysql_num_rows(Env env, @NotNull MysqliResult result) {
        if (result == null) {
            return BooleanValue.FALSE;
        }
        return result.num_rows();
    }

    public Value mysql_numrows(Env env, @NotNull MysqliResult result) {
        return this.mysql_num_rows(env, result);
    }

    public Value mysql_pconnect(Env env, @Optional String server, @Optional String user, @Optional String password, @Optional Value newLinkV, @Optional Value flagsV) {
        return this.mysql_connect(env, server, user, password, newLinkV, flagsV);
    }

    public Value mysql_connect(Env env, @Optional String host, @Optional String userName, @Optional String password, @Optional Value newLinkV, @Optional Value flagsV) {
        Mysqli mysqli;
        int portIndex;
        int port = 3306;
        int length = host.length();
        if (length == 0 && (host = env.getIniString("mysql.default_host")) == null) {
            host = "localhost";
        }
        if ((portIndex = host.lastIndexOf(58)) > 0) {
            char ch;
            port = 0;
            for (int j = portIndex + 1; j < length && '0' <= (ch = host.charAt(j)) && ch <= '9'; ++j) {
                port = port * 10 + ch - 48;
            }
            host = host.substring(0, portIndex);
        }
        if (!(mysqli = new Mysqli(env, host, userName, password, "", port, "", 0, null, null)).isConnected()) {
            return BooleanValue.FALSE;
        }
        Value value = env.wrapJava(mysqli);
        env.setSpecialValue("caucho.mysql", mysqli);
        return value;
    }

    public boolean mysql_ping(Env env, @Optional Mysqli conn) {
        if (conn == null) {
            conn = this.getConnection(env);
        }
        return conn.ping();
    }

    public Value mysql_stat(Env env, Mysqli conn) {
        Value result;
        if (conn == null) {
            conn = this.getConnection(env);
        }
        return (result = conn.stat(env)) == BooleanValue.FALSE ? NullValue.NULL : result;
    }

    public Value mysql_tablename(Env env, @NotNull MysqliResult result, int i) {
        if (result == null) {
            return BooleanValue.FALSE;
        }
        return result.getResultField(env, i, LongValue.ZERO);
    }

    public Object mysql_unbuffered_query(Env env, @NotNull String name, @Optional Mysqli conn) {
        return this.mysql_query(env, name, conn);
    }

    private Mysqli getConnection(Env env) {
        Mysqli conn = (Mysqli)env.getSpecialValue("caucho.mysql");
        if (conn != null) {
            return conn;
        }
        conn = new Mysqli(env, "localhost", "", "", "", 3306, "", 0, null, null);
        env.setSpecialValue("caucho.mysql", conn);
        return conn;
    }
}

