/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.lib.db;

import com.caucho.quercus.UnimplementedException;
import com.caucho.quercus.annotation.Optional;
import com.caucho.quercus.annotation.ReturnNullAsFalse;
import com.caucho.quercus.env.BooleanValue;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.LongValue;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.env.UnicodeValueImpl;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.lib.db.JdbcConnectionResource;
import com.caucho.quercus.lib.db.JdbcResultResource;
import com.caucho.quercus.lib.db.MysqlModule;
import com.caucho.quercus.lib.db.MysqliModule;
import com.caucho.quercus.lib.db.MysqliResult;
import com.caucho.quercus.lib.db.MysqliStatement;
import com.caucho.util.L10N;
import java.sql.Connection;
import java.sql.DataTruncation;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Mysqli
extends JdbcConnectionResource {
    private static final Logger log = Logger.getLogger(Mysqli.class.getName());
    private static final L10N L = new L10N(Mysqli.class);
    private ArrayList<JdbcResultResource> _resultValues = new ArrayList();
    private int _nextResultValue = 0;
    private boolean _hasBeenUsed = true;

    public Mysqli(Env env, @Optional(value="localhost") String host, @Optional String user, @Optional String password, @Optional String db, @Optional(value="3306") int port, @Optional String socket, @Optional int flags, @Optional String driver, @Optional String url) {
        super(env);
        this.connectInternal(env, host, user, password, db, port, socket, flags, driver, url);
    }

    protected Mysqli(Env env) {
        super(env);
    }

    public String getResourceType() {
        return "mysql link";
    }

    @Override
    protected boolean connectInternal(Env env, @Optional(value="localhost") String host, @Optional String userName, @Optional String password, @Optional String dbname, @Optional(value="3306") int port, @Optional String socket, @Optional int flags, @Optional String driver, @Optional String url) {
        if (this.isConnected()) {
            env.warning(L.l("Connection is already opened to '{0}'", (Object)this));
            return false;
        }
        if (port <= 0) {
            port = 3306;
        }
        try {
            if (host == null || host.equals("")) {
                host = "localhost";
            }
            if (driver == null || driver.equals("")) {
                driver = "com.mysql.jdbc.jdbc2.optional.MysqlConnectionPoolDataSource";
            }
            if (url == null || url.equals("")) {
                url = "jdbc:mysql://" + host + ":" + port + "/" + dbname;
            }
            Connection jConn = env.getConnection(driver, url, userName, password);
            this.setConnection(host, userName, password, dbname, port, jConn, driver, url);
            return true;
        }
        catch (SQLException e) {
            env.warning(L.l("A link to the server could not be established.\n  url={0}\n  driver={1}\n  {2}", (Object)url, (Object)driver, (Object)e.toString()));
            env.setSpecialValue("mysqli.connectErrno", new LongValue(e.getErrorCode()));
            env.setSpecialValue("mysqli.connectError", new UnicodeValueImpl(e.getMessage()));
            return false;
        }
        catch (Exception e) {
            env.warning(L.l("A link to the server could not be established.\n  url={0}\n  driver={1}\n  {2}", (Object)url, (Object)driver, (Object)e.toString()));
            env.setSpecialValue("mysqli.connectError", new UnicodeValueImpl(e.toString()));
            return false;
        }
    }

    public int getaffected_rows() {
        return this.affected_rows();
    }

    public int affected_rows() {
        return this.validateConnection().getAffectedRows();
    }

    public boolean autocommit(boolean isAutoCommit) {
        return this.validateConnection().setAutoCommit(isAutoCommit);
    }

    public boolean change_user(String user, String password, String db) {
        this.close(this.getEnv());
        if (user == null || user.equals("")) {
            user = this.getUserName();
        }
        if (password == null || password.equals("")) {
            password = this.getPassword();
        }
        if (db == null || db.equals("")) {
            db = this.getDbName();
        }
        return this.connectInternal(this.getEnv(), this.getHost(), user, password, db, this.getPort(), "", 0, this.getDriver(), this.getUrl());
    }

    public String character_set_name() {
        return this.getCharacterSetName();
    }

    public String client_encoding() {
        return this.character_set_name();
    }

    public int geterrno() {
        return this.errno();
    }

    public int errno() {
        if (this.isConnected()) {
            return this.getErrorCode();
        }
        return 0;
    }

    public String geterror() {
        return this.error();
    }

    @Override
    public String error() {
        String errorString = super.error();
        if (errorString == null) {
            return "";
        }
        return errorString;
    }

    public Value escape_string(StringValue str) {
        return this.real_escape_string(str);
    }

    public String getclient_info(Env env) {
        return this.get_client_info(env);
    }

    public String get_client_info(Env env) {
        return MysqlModule.mysql_get_client_info(env);
    }

    public int getclient_version(Env env) {
        return MysqliModule.mysqli_get_client_version(env);
    }

    public String get_dbname() {
        return this.getDbName();
    }

    public String gethost_info() {
        return this.get_host_info();
    }

    public String get_host_info() {
        return this.getHost() + " via TCP socket";
    }

    public String get_host_name() {
        return this.getHost();
    }

    public String getinfo() {
        throw new UnimplementedException("mysqli info field");
    }

    public int get_port_number() {
        return this.getPort();
    }

    public int getprotocol_version() {
        return this.get_proto_info();
    }

    public int get_proto_info() {
        return 10;
    }

    public String getserver_info() {
        return this.get_server_info();
    }

    public String get_server_info() {
        try {
            return this.validateConnection().getServerInfo();
        }
        catch (SQLException e) {
            return null;
        }
    }

    public int getserver_version() {
        return this.get_server_version();
    }

    public int get_server_version() {
        try {
            String info = this.validateConnection().getServerInfo();
            return Mysqli.infoToVersion(info);
        }
        catch (SQLException e) {
            return 0;
        }
    }

    public int getfield_count() {
        return this.field_count();
    }

    public int field_count() {
        return this.validateConnection().getFieldCount();
    }

    public Value getinsert_id() {
        return this.insert_id();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Value insert_id() {
        try {
            JdbcConnectionResource connV = this.validateConnection();
            Connection conn = connV.getConnection();
            Statement stmt = null;
            try {
                stmt = conn.createStatement();
                ResultSet rs = stmt.executeQuery("SELECT @@identity");
                if (rs.next()) {
                    LongValue longValue = new LongValue(rs.getLong(1));
                    return longValue;
                }
                BooleanValue booleanValue = BooleanValue.FALSE;
                return booleanValue;
            }
            finally {
                if (stmt != null) {
                    stmt.close();
                }
            }
        }
        catch (SQLException e) {
            log.log(Level.FINE, e.toString(), e);
            return BooleanValue.FALSE;
        }
    }

    public boolean kill(int processId) {
        return false;
    }

    @ReturnNullAsFalse
    public JdbcResultResource list_dbs() {
        return this.validateConnection().getCatalogs();
    }

    public boolean more_results() {
        return ((Mysqli)this.validateConnection()).moreResults();
    }

    public boolean multi_query(String query) {
        return ((Mysqli)this.validateConnection()).multiQuery(query);
    }

    public boolean next_result() {
        return ((Mysqli)this.validateConnection()).nextResult();
    }

    public boolean options(int option, Value value) {
        return false;
    }

    @Override
    public boolean ping() {
        return super.ping();
    }

    public Value query(Env env, String sql, @Optional(value="MYSQLI_STORE_RESULT") int resultMode) {
        MysqliResult result = (MysqliResult)this.realQuery(sql);
        if (result == null) {
            if (this.getErrorCode() == 0) {
                return BooleanValue.TRUE;
            }
            return BooleanValue.FALSE;
        }
        return env.wrapJava(result);
    }

    public MysqliStatement prepare(Env env, String query) {
        MysqliStatement stmt = new MysqliStatement((Mysqli)this.validateConnection());
        stmt.prepare(query);
        return stmt;
    }

    public boolean real_connect(Env env, @Optional(value="localhost") String host, @Optional String userName, @Optional String password, @Optional String dbname, @Optional(value="3306") int port, @Optional String socket, @Optional int flags) {
        return this.connectInternal(env, host, userName, password, dbname, port, socket, flags, "", "");
    }

    public Value real_escape_string(StringValue str) {
        return this.realEscapeString(str);
    }

    @Override
    public boolean rollback() {
        return super.rollback();
    }

    public boolean select_db(String dbname) {
        try {
            if (this.isConnected()) {
                this.validateConnection().setCatalog(dbname);
                return true;
            }
            return false;
        }
        catch (SQLException e) {
            log.log(Level.FINE, e.toString(), e);
            this.getEnv().warning(e.getMessage());
            return false;
        }
    }

    public boolean set_charset(String charset) {
        return false;
    }

    public boolean set_opt(int option, Value value) {
        return this.options(option, value);
    }

    public String getsqlstate() {
        return this.sqlstate();
    }

    public String sqlstate() {
        return "HY" + this.validateConnection().getErrorCode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Value stat(Env env) {
        UnicodeValueImpl unicodeValueImpl;
        block8: {
            JdbcConnectionResource connV = this.validateConnection();
            Connection conn = connV.getConnection();
            Statement stmt = null;
            StringBuilder str = new StringBuilder();
            try {
                stmt = conn.createStatement();
                stmt.execute("SHOW STATUS");
                ResultSet rs = stmt.getResultSet();
                while (rs.next()) {
                    if (str.length() > 0) {
                        str.append(' ');
                    }
                    str.append(rs.getString(1));
                    str.append(": ");
                    str.append(rs.getString(2));
                }
                unicodeValueImpl = new UnicodeValueImpl(str.toString());
                if (stmt == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    log.log(Level.FINE, e.toString(), e);
                    return BooleanValue.FALSE;
                }
            }
            stmt.close();
        }
        return unicodeValueImpl;
    }

    public MysqliStatement stmt_init(Env env) {
        return new MysqliStatement((Mysqli)this.validateConnection());
    }

    @ReturnNullAsFalse
    public JdbcResultResource store_result(Env env) {
        return ((Mysqli)this.validateConnection()).storeResult();
    }

    public int getthread_id() {
        return this.thread_id();
    }

    public int thread_id() {
        return 1;
    }

    public boolean thread_safe() {
        return true;
    }

    @ReturnNullAsFalse
    public JdbcResultResource use_result(Env env) {
        return ((Mysqli)this.validateConnection()).storeResult();
    }

    public int getwarning_count() {
        return this.warning_count();
    }

    public int warning_count() {
        return ((Mysqli)this.validateConnection()).getWarningCount();
    }

    @Override
    protected JdbcResultResource createResult(Env env, Statement stmt, ResultSet rs) {
        return new MysqliResult(env, stmt, rs, this);
    }

    private int getWarningCount() {
        if (this.getWarnings() != null) {
            MysqliResult warningResult = this.metaQuery("SHOW WARNINGS", this.getCatalog().toString());
            int warningCount = 0;
            if (warningResult != null) {
                warningCount = JdbcResultResource.getNumRows(warningResult.getResultSet());
            }
            if (warningCount >= 0) {
                return warningCount;
            }
            return 0;
        }
        return 0;
    }

    protected MysqliResult metaQuery(String sql, String catalog) {
        this.clearErrors();
        Value currentCatalog = this.getCatalog();
        try {
            this.getConnection().setCatalog(catalog);
            Statement stmt = this.getConnection().createStatement();
            stmt.setEscapeProcessing(false);
            if (stmt.execute(sql)) {
                MysqliResult result = (MysqliResult)this.createResult(this.getEnv(), stmt, stmt.getResultSet());
                this.getConnection().setCatalog(currentCatalog.toString());
                return result;
            }
            this.getConnection().setCatalog(currentCatalog.toString());
            return null;
        }
        catch (SQLException e) {
            this.saveErrors(e);
            log.log(Level.WARNING, e.toString(), e);
            return null;
        }
    }

    private boolean moreResults() {
        return !this._hasBeenUsed || this._nextResultValue < this._resultValues.size() - 1;
    }

    private boolean multiQuery(String sql) {
        this.clearErrors();
        this._resultValues.clear();
        ArrayList<String> splitQuery = this.splitMultiQuery(sql);
        Statement stmt = null;
        try {
            this.setResultResource(null);
            for (String s : splitQuery) {
                stmt = this.getConnection().createStatement();
                stmt.setEscapeProcessing(false);
                if (stmt.execute(s)) {
                    this.setAffectedRows(0);
                    this.setResultResource(this.createResult(this.getEnv(), stmt, stmt.getResultSet()));
                    this._resultValues.add(this.getResultResource());
                    this.setWarnings(stmt.getWarnings());
                    continue;
                }
                this.setAffectedRows(stmt.getUpdateCount());
                this.setWarnings(stmt.getWarnings());
            }
        }
        catch (DataTruncation truncationError) {
            try {
                this.setAffectedRows(stmt.getUpdateCount());
                this.setWarnings(stmt.getWarnings());
            }
            catch (SQLException e) {
                this.saveErrors(e);
                log.log(Level.WARNING, e.toString(), e);
                return false;
            }
        }
        catch (SQLException e) {
            this.saveErrors(e);
            log.log(Level.WARNING, e.toString(), e);
            return false;
        }
        if (this._resultValues.size() > 0) {
            this._nextResultValue = 0;
            this._hasBeenUsed = false;
        }
        return true;
    }

    private boolean nextResult() {
        if (this._nextResultValue + 1 < this._resultValues.size()) {
            this._hasBeenUsed = false;
            ++this._nextResultValue;
            return true;
        }
        return false;
    }

    private ArrayList<String> splitMultiQuery(String sql) {
        ArrayList<String> result = new ArrayList<String>();
        String query = "";
        int length = sql.length();
        boolean inQuotes = false;
        for (int i = 0; i < length; ++i) {
            char c = sql.charAt(i);
            if (c == '\\') {
                query = query + c;
                if (i >= length - 1) continue;
                query = query + sql.charAt(i + 1);
                ++i;
                continue;
            }
            if (inQuotes) {
                query = query + c;
                if (c != '\'') continue;
                inQuotes = false;
                continue;
            }
            if (c == '\'') {
                query = query + c;
                inQuotes = true;
                continue;
            }
            if (c == ';') {
                result.add(query.trim());
                query = "";
                continue;
            }
            query = query + c;
        }
        if (query != null) {
            result.add(query.trim());
        }
        return result;
    }

    private JdbcResultResource storeResult() {
        if (!this._hasBeenUsed) {
            this._hasBeenUsed = true;
            return this._resultValues.get(this._nextResultValue);
        }
        return null;
    }

    @Override
    public String toString() {
        if (this.isConnected()) {
            return "Mysqli[" + this.get_host_name() + "]";
        }
        return "Mysqli[]";
    }
}

