/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.lib.db;

import com.caucho.quercus.annotation.Optional;
import com.caucho.quercus.annotation.ReturnNullAsFalse;
import com.caucho.quercus.env.ArrayValue;
import com.caucho.quercus.env.ArrayValueImpl;
import com.caucho.quercus.env.BooleanValue;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.LongValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.lib.db.JdbcResultResource;
import com.caucho.quercus.lib.db.Mysqli;
import com.caucho.util.L10N;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MysqliResult
extends JdbcResultResource {
    private static final Logger log = Logger.getLogger(MysqliResult.class.getName());
    private static final L10N L = new L10N(MysqliResult.class);

    public MysqliResult(Env env, Statement stmt, ResultSet rs, Mysqli conn) {
        super(env, stmt, rs, conn);
    }

    public MysqliResult(Env env, ResultSetMetaData metaData, Mysqli conn) {
        super(env, metaData, conn);
    }

    public String getResourceType() {
        return "mysql result";
    }

    public boolean data_seek(Env env, int rowNumber) {
        return this.seek(env, rowNumber);
    }

    @ReturnNullAsFalse
    public ArrayValue fetch_array(Env env, @Optional(value="MYSQLI_BOTH") int type) {
        if (type != 1 && type != 3 && type != 2) {
            env.warning(L.l("invalid result_type"));
            return null;
        }
        return this.fetchArray(env, type);
    }

    public ArrayValue fetch_assoc(Env env) {
        return this.fetchArray(env, 1);
    }

    public Value fetch_field_direct(Env env, int offset) {
        return this.fetchFieldDirect(env, offset);
    }

    public Value fetch_field(Env env) {
        return this.fetchNextField(env);
    }

    public Value fetch_fields(Env env) {
        return this.getFieldDirectArray(env);
    }

    public Value fetch_lengths() {
        return this.getLengths();
    }

    public Value fetch_object(Env env) {
        return this.fetchObject(env);
    }

    public ArrayValue fetch_row(Env env) {
        return this.fetchArray(env, 2);
    }

    public int field_count(Env env) {
        return this.getFieldCount();
    }

    protected Value fetchFieldDirect(Env env, int fieldOffset) {
        Value fieldTable = this.getFieldTable(env, fieldOffset);
        Value fieldName = this.getFieldName(env, fieldOffset);
        Value fieldAlias = this.getFieldNameAlias(fieldOffset);
        Value fieldType = this.getJdbcType(fieldOffset);
        Value fieldLength = this.getFieldLength(env, fieldOffset);
        Value fieldScale = this.getFieldScale(fieldOffset);
        Value fieldCatalog = this.getFieldCatalog(fieldOffset);
        if (fieldTable == BooleanValue.FALSE || fieldName == BooleanValue.FALSE || fieldAlias == BooleanValue.FALSE || fieldType == BooleanValue.FALSE || fieldLength == BooleanValue.FALSE || fieldScale == BooleanValue.FALSE) {
            return BooleanValue.FALSE;
        }
        String sql = "SHOW FULL COLUMNS FROM " + fieldTable + " LIKE '" + fieldName + "'";
        MysqliResult metaResult = ((Mysqli)this.getConnection()).metaQuery(sql, fieldCatalog.toString());
        if (metaResult == null) {
            return BooleanValue.FALSE;
        }
        return metaResult.fetchFieldImproved(env, fieldLength.toInt(), fieldAlias.toString(), fieldName.toString(), fieldTable.toString(), fieldType.toInt(), fieldScale.toInt());
    }

    protected Value fetchNextField(Env env) {
        int fieldOffset = this.getFieldOffset();
        Value result = this.fetchFieldDirect(env, fieldOffset);
        this.setFieldOffset(fieldOffset + 1);
        return result;
    }

    public boolean field_seek(Env env, int offset) {
        this.setFieldOffset(offset);
        return true;
    }

    public int field_tell(Env env) {
        return this.getFieldOffset();
    }

    public void free() {
        this.close();
    }

    public void free_result() {
        this.close();
    }

    public Value getFieldDirectArray(Env env) {
        ArrayValueImpl array = new ArrayValueImpl();
        try {
            int numColumns = this.getMetaData().getColumnCount();
            for (int i = 0; i < numColumns; ++i) {
                ((ArrayValue)array).put(this.fetchFieldDirect(env, i));
            }
            return array;
        }
        catch (SQLException e) {
            log.log(Level.FINE, e.toString(), e);
            return BooleanValue.FALSE;
        }
    }

    public int num_fields() {
        return this.getFieldCount();
    }

    public Value num_rows() {
        int numRows = this.getNumRows();
        if (numRows < 0) {
            return BooleanValue.FALSE;
        }
        return LongValue.create(numRows);
    }

    public String toString() {
        return "MysqliResult[" + super.toString() + "]";
    }
}

