/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.lib.db;

import com.caucho.quercus.annotation.Optional;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.LongValue;
import com.caucho.quercus.env.UnicodeValueImpl;
import com.caucho.quercus.lib.db.JdbcConnectionResource;
import com.caucho.quercus.lib.db.JdbcResultResource;
import com.caucho.quercus.lib.db.OracleResult;
import com.caucho.quercus.lib.db.OracleStatement;
import com.caucho.util.L10N;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Oracle
extends JdbcConnectionResource {
    private static final Logger log = Logger.getLogger(Oracle.class.getName());
    private static final L10N L = new L10N(Oracle.class);

    public Oracle(Env env, @Optional(value="localhost") String host, @Optional String user, @Optional String password, @Optional String db, @Optional(value="1521") int port, @Optional String driver, @Optional String url) {
        super(env);
        this.connectInternal(env, host, user, password, db, port, "", 0, driver, url);
    }

    public boolean connectInternal(Env env, @Optional(value="localhost") String host, @Optional String userName, @Optional String password, @Optional String dbname, @Optional(value="5432") int port, @Optional String socket, @Optional int flags, @Optional String driver, @Optional String url) {
        if (this.isConnected()) {
            env.warning(L.l("Connection is already opened to '{0}'", (Object)this));
            return false;
        }
        try {
            if (host == null || host.equals("")) {
                host = "localhost";
            }
            if (driver == null || driver.equals("")) {
                driver = "oracle.jdbc.OracleDriver";
            }
            if (url == null || url.equals("")) {
                if (dbname.indexOf("//") == 0) {
                    url = "jdbc:oracle:thin:@" + dbname.substring(2);
                    url = url.replace('/', ':');
                } else {
                    url = "jdbc:oracle:thin:@" + host + ":" + port + ":" + dbname;
                }
            }
            Connection jConn = env.getConnection(driver, url, userName, password);
            this.setConnection(host, userName, password, dbname, port, jConn, driver, url);
            return true;
        }
        catch (SQLException e) {
            env.warning("A link to the server could not be established. " + e.toString());
            env.setSpecialValue("oracle.connectErrno", new LongValue(e.getErrorCode()));
            env.setSpecialValue("oracle.connectError", new UnicodeValueImpl(e.getMessage()));
            log.log(Level.FINE, e.toString(), e);
            return false;
        }
        catch (Exception e) {
            env.warning("A link to the server could not be established. " + e.toString());
            env.setSpecialValue("oracle.connectError", new UnicodeValueImpl(e.getMessage()));
            log.log(Level.FINE, e.toString(), e);
            return false;
        }
    }

    public OracleStatement prepare(Env env, String query) {
        OracleStatement stmt = new OracleStatement((Oracle)this.validateConnection());
        stmt.prepare(query);
        return stmt;
    }

    protected JdbcResultResource createResult(Env env, Statement stmt, ResultSet rs) {
        return new OracleResult(env, stmt, rs, this);
    }

    public String toString() {
        if (this.isConnected()) {
            return "Oracle[" + this.getHost() + "]";
        }
        return "Oracle[]";
    }
}

