/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.lib.db;

import com.caucho.quercus.UnimplementedException;
import com.caucho.quercus.annotation.Optional;
import com.caucho.quercus.annotation.ReadOnly;
import com.caucho.quercus.annotation.Reference;
import com.caucho.quercus.env.ArrayValue;
import com.caucho.quercus.env.ArrayValueImpl;
import com.caucho.quercus.env.BooleanValue;
import com.caucho.quercus.env.DefaultValue;
import com.caucho.quercus.env.DoubleValue;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.LongValue;
import com.caucho.quercus.env.NullValue;
import com.caucho.quercus.env.QuercusClass;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.env.UnsetValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.lib.db.PDOError;
import com.caucho.quercus.lib.file.FileReadValue;
import com.caucho.util.IntMap;
import com.caucho.util.L10N;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.StreamImpl;
import com.caucho.vfs.TempBuffer;
import com.caucho.vfs.TempReadStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PDOStatement
implements Iterable<Value>,
Closeable {
    private static final Logger log = Logger.getLogger(PDOStatement.class.getName());
    private static final L10N L = new L10N(PDOStatement.class);
    private static final Value[] NULL_VALUES = new Value[0];
    private static final Value FETCH_FAILURE = new BooleanValue(false){};
    private static final Value FETCH_EXHAUSTED = new BooleanValue(false){};
    private static final Value FETCH_CONTINUE = new BooleanValue(false){};
    private static final Value FETCH_SUCCESS = new BooleanValue(true){};
    private final Env _env;
    private final PDOError _error;
    private final String _query;
    private Statement _statement;
    private PreparedStatement _preparedStatement;
    private ResultSet _resultSet;
    private ResultSetMetaData _resultSetMetaData;
    private boolean _resultSetExhausted = true;
    private String _lastInsertId;
    private int _fetchMode = 4;
    private Value[] _fetchModeArgs = NULL_VALUES;
    private ArrayList<BindColumn> _bindColumns;
    private ArrayList<BindParam> _bindParams;
    private IntMap _parameterNameMap;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PDOStatement(Env env, Connection conn, String query, boolean isPrepared, ArrayValue options) throws SQLException {
        this._env = env;
        this._error = new PDOError(this._env);
        this._query = query;
        env.addClose(this);
        if (options != null && options.getSize() > 0) {
            this._env.notice(L.l("PDOStatement options unsupported"));
        }
        query = this.parseQueryString(query);
        if (isPrepared) {
            this._statement = null;
            this._preparedStatement = conn.prepareStatement(query);
            this._preparedStatement.setEscapeProcessing(false);
        } else {
            this._preparedStatement = null;
            Statement statement = null;
            try {
                statement = conn.createStatement();
                statement.setEscapeProcessing(false);
                if (statement.execute(query)) {
                    this._resultSet = statement.getResultSet();
                    this._resultSetExhausted = false;
                }
                this._statement = statement;
                statement = null;
            }
            finally {
                try {
                    if (statement != null) {
                        statement.close();
                    }
                }
                catch (SQLException e) {
                    log.log(Level.FINE, e.toString(), e);
                }
            }
        }
    }

    private String parseQueryString(String query) {
        int queryLength = query.length();
        StringBuilder parsedQuery = new StringBuilder(queryLength);
        int parameterCount = 0;
        StringBuilder name = null;
        int quote = 0;
        for (int i = 0; i < queryLength + 1; ++i) {
            int ch = -1;
            if (i < queryLength) {
                ch = query.charAt(i);
            }
            if (ch == 39 || ch == 34) {
                if (quote == 0) {
                    quote = ch;
                } else if (quote == ch) {
                    quote = 0;
                }
            } else if (quote == 0 && ch == 63) {
                ++parameterCount;
            } else {
                if (quote == 0 && ch == 58) {
                    ++parameterCount;
                    name = new StringBuilder();
                    continue;
                }
                if (!(name == null || ch != -1 && Character.isJavaIdentifierPart(ch))) {
                    if (this._parameterNameMap == null) {
                        this._parameterNameMap = new IntMap();
                    }
                    this._parameterNameMap.put((Object)name.toString(), parameterCount);
                    parsedQuery.append('?');
                    name = null;
                }
            }
            if (ch == -1) continue;
            if (name != null) {
                name.append((char)ch);
                continue;
            }
            parsedQuery.append((char)ch);
        }
        return parsedQuery.toString();
    }

    private boolean advanceResultSet() {
        if (this._resultSet == null || this._resultSetExhausted) {
            return false;
        }
        try {
            boolean isNext = this._resultSet.next();
            if (!isNext) {
                this._resultSetExhausted = true;
            }
            if (!isNext) {
                return false;
            }
            if (this._bindColumns != null) {
                for (BindColumn bindColumn : this._bindColumns) {
                    if (bindColumn.bind()) continue;
                    return false;
                }
            }
            return isNext;
        }
        catch (SQLException ex) {
            this._error.error(ex);
            return false;
        }
    }

    public boolean bindColumn(Value column, @Reference Value var, @Optional(value="-1") int type) {
        if (this._bindColumns == null) {
            this._bindColumns = new ArrayList();
        }
        try {
            this._bindColumns.add(new BindColumn(column, var, type));
        }
        catch (SQLException ex) {
            this._error.error(ex);
            return false;
        }
        return true;
    }

    public boolean bindParam(Value parameter, @Reference Value variable, @Optional(value="-1") int dataType, @Optional(value="-1") int length, @Optional Value driverOptions) {
        boolean isInputOutput;
        if (length != -1) {
            throw new UnimplementedException("length");
        }
        if (driverOptions != null && !driverOptions.isNull()) {
            throw new UnimplementedException("driverOptions");
        }
        if (dataType == -1) {
            dataType = 2;
        }
        boolean bl = isInputOutput = (dataType & Integer.MIN_VALUE) != 0;
        if (isInputOutput) {
            dataType &= Integer.MAX_VALUE;
            throw new UnimplementedException("PARAM_INPUT_OUTPUT");
        }
        switch (dataType) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
            default: {
                this._error.warning(L.l("unknown dataType `{0}'", (long)dataType));
                return false;
            }
        }
        if (this._bindParams == null) {
            this._bindParams = new ArrayList();
        }
        BindParam bindParam = new BindParam(parameter, variable, dataType, length, driverOptions);
        this._bindParams.add(bindParam);
        return true;
    }

    public boolean bindValue(Value parameter, Value value, @Optional(value="-1") int dataType) {
        return this.bindParam(parameter, value.toValue(), dataType, -1, null);
    }

    public boolean closeCursor() {
        if (this._resultSet == null) {
            return false;
        }
        ResultSet resultSet = this._resultSet;
        this._resultSet = null;
        this._resultSetMetaData = null;
        this._resultSetExhausted = true;
        this._lastInsertId = null;
        try {
            resultSet.close();
        }
        catch (SQLException e) {
            this._error.error(e);
            return false;
        }
        return true;
    }

    public int columnCount() {
        if (this._resultSet == null) {
            return 0;
        }
        try {
            return this.getResultSetMetaData().getColumnCount();
        }
        catch (SQLException e) {
            this._error.error(e);
            return 0;
        }
    }

    public BindParam createBindParam(Value parameter, Value value, int dataType, int length, Value driverOptions) {
        return new BindParam(parameter, value, dataType, length, driverOptions);
    }

    @Override
    public void close() {
        ResultSet resultSet = this._resultSet;
        Statement statement = this._statement;
        PreparedStatement preparedStatement = this._preparedStatement;
        this._resultSet = null;
        this._resultSetMetaData = null;
        this._resultSetExhausted = true;
        this._lastInsertId = null;
        this._statement = null;
        this._preparedStatement = null;
        if (resultSet != null) {
            try {
                resultSet.close();
            }
            catch (SQLException e) {
                log.log(Level.WARNING, e.toString(), e);
            }
        }
        if (statement != null) {
            try {
                statement.close();
            }
            catch (SQLException e) {
                log.log(Level.WARNING, e.toString(), e);
            }
        }
        if (preparedStatement != null) {
            try {
                preparedStatement.close();
            }
            catch (SQLException e) {
                log.log(Level.WARNING, e.toString(), e);
            }
        }
    }

    public String errorCode() {
        return this._error.errorCode();
    }

    public ArrayValue errorInfo() {
        return this._error.errorInfo();
    }

    public boolean execute(@Optional @ReadOnly Value inputParameters) {
        ArrayValue parameters;
        if (inputParameters instanceof ArrayValue) {
            parameters = (ArrayValue)inputParameters;
        } else if (inputParameters instanceof DefaultValue) {
            parameters = null;
        } else {
            this._env.warning(L.l("'{0}' is an unexpected argument, expected ArrayValue", (Object)inputParameters));
            return false;
        }
        this.closeCursor();
        try {
            SQLWarning sqlWarning;
            this._preparedStatement.clearParameters();
            this._preparedStatement.clearWarnings();
            if (parameters != null) {
                for (Map.Entry entry : parameters.entrySet()) {
                    Value key = (Value)entry.getKey();
                    if (!(key.isNumberConvertible() ? !this.setParameter(key.toInt() + 1, (Value)entry.getValue(), -1L) : !this.setParameter(this.resolveParameter(key), (Value)entry.getValue(), -1L))) continue;
                    return false;
                }
            } else if (this._bindParams != null) {
                for (BindParam bindParam : this._bindParams) {
                    if (bindParam.apply()) continue;
                    return false;
                }
            }
            if (this._preparedStatement.execute()) {
                this._resultSet = this._preparedStatement.getResultSet();
                this._resultSetExhausted = false;
            }
            if ((sqlWarning = this._preparedStatement.getWarnings()) != null) {
                this._error.error(sqlWarning);
                return false;
            }
            return true;
        }
        catch (SQLException e) {
            this._error.error(e);
            return false;
        }
    }

    public Value fetch(@Optional int fetchMode, @Optional(value="-1") int cursorOrientation, @Optional(value="-1") int cursorOffset) {
        if (cursorOrientation != -1) {
            throw new UnimplementedException("fetch with cursorOrientation");
        }
        if (cursorOffset != -1) {
            throw new UnimplementedException("fetch with cursorOffset");
        }
        return this.fetchImpl(fetchMode, -1);
    }

    public Value fetchAll(@Optional(value="0") int fetchMode, @Optional(value="-1") int columnIndex) {
        boolean isUnique;
        int effectiveFetchMode = fetchMode == 0 ? this._fetchMode : fetchMode;
        boolean isGroup = (fetchMode & 0x10000) != 0;
        boolean bl = isUnique = (fetchMode & 0x30000) != 0;
        if (isGroup) {
            throw new UnimplementedException("PDO.FETCH_GROUP");
        }
        if (isUnique) {
            throw new UnimplementedException("PDO.FETCH_UNIQUE");
        }
        switch (effectiveFetchMode &= 0xFFFCFFFF) {
            case 7: {
                break;
            }
            case 1: {
                this._error.warning(L.l("PDO::FETCH_LAZY can't be used with PDOStatement::fetchAll()"));
                return BooleanValue.FALSE;
            }
            default: {
                if (columnIndex == -1) break;
                this._error.warning(L.l("unexpected arguments"));
                return BooleanValue.FALSE;
            }
        }
        ArrayValueImpl rows = new ArrayValueImpl();
        while (true) {
            Value value;
            if ((value = this.fetchImpl(effectiveFetchMode, columnIndex)) == FETCH_FAILURE) {
                rows.clear();
                return rows;
            }
            if (value == FETCH_EXHAUSTED) break;
            if (value == FETCH_CONTINUE) continue;
            rows.put(value);
        }
        return rows;
    }

    private Value fetchAssoc() {
        try {
            if (!this.advanceResultSet()) {
                return FETCH_EXHAUSTED;
            }
            if (this._fetchModeArgs.length != 0) {
                this._error.notice(L.l("unexpected arguments"));
                return FETCH_FAILURE;
            }
            ArrayValueImpl array = new ArrayValueImpl();
            int columnCount = this.getResultSetMetaData().getColumnCount();
            for (int i = 1; i <= columnCount; ++i) {
                String name = this.getResultSetMetaData().getColumnName(i);
                Value value = this.getColumnValue(i);
                array.put(this._env.createString(name), value);
            }
            return array;
        }
        catch (SQLException ex) {
            this._error.error(ex);
            return FETCH_FAILURE;
        }
    }

    private Value fetchBoth() {
        try {
            if (!this.advanceResultSet()) {
                return FETCH_EXHAUSTED;
            }
            if (this._fetchModeArgs.length != 0) {
                this._error.notice(L.l("unexpected arguments"));
                return FETCH_FAILURE;
            }
            ArrayValueImpl array = new ArrayValueImpl();
            int columnCount = this.getResultSetMetaData().getColumnCount();
            for (int i = 1; i <= columnCount; ++i) {
                String name = this.getResultSetMetaData().getColumnName(i);
                Value value = this.getColumnValue(i);
                array.put(this._env.createString(name), value);
                array.put(new LongValue(i - 1), value);
            }
            return array;
        }
        catch (SQLException ex) {
            this._error.error(ex);
            return FETCH_FAILURE;
        }
    }

    private Value fetchBound() {
        if (!this.advanceResultSet()) {
            return FETCH_EXHAUSTED;
        }
        return FETCH_SUCCESS;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Value fetchClass() {
        Value[] ctorArgs;
        if (this._fetchModeArgs.length == 0 || this._fetchModeArgs.length > 2) {
            return this.fetchBoth();
        }
        String className = this._fetchModeArgs[0].toString();
        if (this._fetchModeArgs.length == 2) {
            if (!this._fetchModeArgs[1].isArray()) return this.fetchBoth();
            ArrayValue argsArray = (ArrayValue)this._fetchModeArgs[1];
            ctorArgs = new Value[argsArray.getSize()];
            int i = 0;
            for (Value key : argsArray.keySet()) {
                ctorArgs[i++] = argsArray.getRef(key);
            }
            return this.fetchObject(className, ctorArgs);
        } else {
            ctorArgs = NULL_VALUES;
        }
        return this.fetchObject(className, ctorArgs);
    }

    public Value fetchColumn(@Optional int column) {
        if (!this.advanceResultSet()) {
            return FETCH_EXHAUSTED;
        }
        if (column < 0 && this._fetchModeArgs.length > 0) {
            column = this._fetchModeArgs[0].toInt();
        }
        try {
            if (column < 0 || column >= this.getResultSetMetaData().getColumnCount()) {
                return FETCH_CONTINUE;
            }
            return this.getColumnValue(column + 1);
        }
        catch (SQLException ex) {
            this._error.error(ex);
            return FETCH_FAILURE;
        }
    }

    private Value fetchFunc() {
        throw new UnimplementedException();
    }

    private Value fetchImpl(int fetchMode, int columnIndex) {
        if (fetchMode == 0) {
            fetchMode = this._fetchMode;
            fetchMode &= 0xFFFCFFFF;
        } else {
            if ((fetchMode & 0x10000) != 0) {
                this._error.warning(L.l("FETCH_GROUP is not allowed"));
                return BooleanValue.FALSE;
            }
            if ((fetchMode & 0x30000) != 0) {
                this._error.warning(L.l("FETCH_UNIQUE is not allowed"));
                return BooleanValue.FALSE;
            }
        }
        boolean isClasstype = (fetchMode & 0x40000) != 0;
        boolean isSerialize = (fetchMode & 0x80000) != 0;
        switch (fetchMode &= 0xFFF3FFFF) {
            case 2: {
                return this.fetchAssoc();
            }
            case 4: {
                return this.fetchBoth();
            }
            case 6: {
                return this.fetchBound();
            }
            case 7: {
                return this.fetchColumn(columnIndex);
            }
            case 8: {
                return this.fetchClass();
            }
            case 10: {
                return this.fetchFunc();
            }
            case 9: {
                return this.fetchInto();
            }
            case 1: {
                return this.fetchLazy();
            }
            case 11: {
                return this.fetchNamed();
            }
            case 3: {
                return this.fetchNum();
            }
            case 5: {
                return this.fetchObject();
            }
        }
        this._error.warning(L.l("invalid fetch mode {0}", (long)fetchMode));
        this.closeCursor();
        return BooleanValue.FALSE;
    }

    private Value fetchInto() {
        assert (this._fetchModeArgs.length > 0);
        assert (this._fetchModeArgs[0].isObject());
        Value var = this._fetchModeArgs[0];
        if (!this.advanceResultSet()) {
            return FETCH_EXHAUSTED;
        }
        try {
            int columnCount = this.getResultSetMetaData().getColumnCount();
            for (int i = 1; i <= columnCount; ++i) {
                String name = this.getResultSetMetaData().getColumnName(i);
                Value value = this.getColumnValue(i);
                var.putField(this._env, name, value);
            }
        }
        catch (SQLException ex) {
            this._error.error(ex);
            return FETCH_FAILURE;
        }
        return var;
    }

    private Value fetchLazy() {
        return this.fetchObject(null, NULL_VALUES);
    }

    private Value fetchNamed() {
        try {
            if (!this.advanceResultSet()) {
                return FETCH_EXHAUSTED;
            }
            ArrayValueImpl array = new ArrayValueImpl();
            int columnCount = this.getResultSetMetaData().getColumnCount();
            for (int i = 1; i <= columnCount; ++i) {
                StringValue name = this._env.createString(this.getResultSetMetaData().getColumnName(i));
                Value value = this.getColumnValue(i);
                Value existingValue = ((ArrayValue)array).get(name);
                if (!(existingValue instanceof UnsetValue)) {
                    if (!existingValue.isArray()) {
                        ArrayValueImpl arrayValue = new ArrayValueImpl();
                        ((ArrayValue)arrayValue).put(existingValue);
                        ((ArrayValue)array).put(name, arrayValue);
                        existingValue = arrayValue;
                    }
                    existingValue.put(value);
                    continue;
                }
                ((ArrayValue)array).put(name, value);
            }
            return array;
        }
        catch (SQLException ex) {
            this._error.error(ex);
            return FETCH_FAILURE;
        }
    }

    private Value fetchNum() {
        try {
            if (!this.advanceResultSet()) {
                return FETCH_EXHAUSTED;
            }
            if (this._fetchModeArgs.length != 0) {
                this._error.notice(L.l("unexpected arguments"));
                return FETCH_FAILURE;
            }
            ArrayValueImpl array = new ArrayValueImpl();
            int columnCount = this.getResultSetMetaData().getColumnCount();
            for (int i = 1; i <= columnCount; ++i) {
                Value value = this.getColumnValue(i);
                array.put(value);
            }
            return array;
        }
        catch (SQLException ex) {
            this._error.error(ex);
            return FETCH_FAILURE;
        }
    }

    private Value fetchObject() {
        return this.fetchObject(null, NULL_VALUES);
    }

    public Value fetchObject(@Optional String className, @Optional Value[] args) {
        QuercusClass cl;
        if (className != null) {
            cl = this._env.findAbstractClass(className);
            if (cl == null) {
                return this.fetchBoth();
            }
        } else {
            cl = null;
            if (args.length != 0) {
                this.advanceResultSet();
                this._error.warning(L.l("unexpected arguments"));
                return BooleanValue.FALSE;
            }
        }
        if (!this.advanceResultSet()) {
            return FETCH_EXHAUSTED;
        }
        try {
            Value object = cl != null ? cl.callNew(this._env, args) : this._env.createObject();
            int columnCount = this.getResultSetMetaData().getColumnCount();
            for (int i = 1; i <= columnCount; ++i) {
                String name = this.getResultSetMetaData().getColumnName(i);
                Value value = this.getColumnValue(i);
                object.putField(this._env, name, value);
            }
            return object;
        }
        catch (Throwable ex) {
            this._error.error(ex);
            return FETCH_FAILURE;
        }
    }

    public Value getAttribute(int attribute) {
        this._error.unsupportedAttribute(attribute);
        return BooleanValue.FALSE;
    }

    public Value getColumnMeta(int column) {
        throw new UnimplementedException();
    }

    private Value getColumnValue(int column) throws SQLException {
        return this.getColumnValue(column, -1, -1);
    }

    private Value getColumnValue(int column, int jdbcType, int returnType) throws SQLException {
        if (returnType != -1) {
            throw new UnimplementedException("parm type " + returnType);
        }
        if (jdbcType == -1) {
            jdbcType = this.getResultSetMetaData().getColumnType(column);
        }
        switch (jdbcType) {
            case 0: {
                return NullValue.NULL;
            }
            case -7: 
            case -6: 
            case -5: 
            case 4: 
            case 5: {
                String value = this._resultSet.getString(column);
                if (value == null || this._resultSet.wasNull()) {
                    return NullValue.NULL;
                }
                return this._env.createString(value);
            }
            case 8: {
                double value = this._resultSet.getDouble(column);
                if (this._resultSet.wasNull()) {
                    return NullValue.NULL;
                }
                return new DoubleValue(value).toStringValue();
            }
        }
        String value = this._resultSet.getString(column);
        if (value == null || this._resultSet.wasNull()) {
            return NullValue.NULL;
        }
        return this._env.createString(value);
    }

    private ResultSetMetaData getResultSetMetaData() throws SQLException {
        if (this._resultSetMetaData == null) {
            this._resultSetMetaData = this._resultSet.getMetaData();
        }
        return this._resultSetMetaData;
    }

    @Override
    public Iterator<Value> iterator() {
        Value value = this.fetchAll(0, -1);
        if (value instanceof ArrayValue) {
            return ((ArrayValue)value).values().iterator();
        }
        Set emptySet = Collections.emptySet();
        return emptySet.iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String lastInsertId(String name) {
        if (name != null && name.length() != 0) {
            throw new UnimplementedException("lastInsertId with name ");
        }
        if (this._lastInsertId != null) {
            return this._lastInsertId;
        }
        String lastInsertId = null;
        Statement stmt = this._preparedStatement != null ? this._preparedStatement : this._statement;
        ResultSet resultSet = null;
        try {
            resultSet = stmt.getGeneratedKeys();
            if (resultSet.next()) {
                lastInsertId = resultSet.getString(1);
            }
        }
        catch (SQLException ex) {
            this._error.error(ex);
        }
        finally {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            catch (SQLException ex) {
                log.log(Level.WARNING, ex.toString(), ex);
            }
        }
        this._lastInsertId = lastInsertId == null ? "0" : lastInsertId;
        return this._lastInsertId;
    }

    public boolean nextRowset() {
        throw new UnimplementedException();
    }

    private int resolveParameter(Value parameter) {
        int index = -1;
        if (parameter instanceof LongValue) {
            index = parameter.toInt();
        } else {
            String name = parameter.toString();
            if (name.length() > 1 && name.charAt(0) == ':') {
                name = name.substring(1);
                if (this._parameterNameMap != null) {
                    index = this._parameterNameMap.get((Object)name);
                }
            } else {
                index = parameter.toInt();
            }
        }
        return index;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int rowCount() {
        int n;
        block9: {
            int row;
            block8: {
                if (this._resultSet == null) {
                    return 0;
                }
                row = this._resultSet.getRow();
                try {
                    this._resultSet.last();
                    n = this._resultSet.getRow();
                    if (row != 0) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (row == 0) {
                            this._resultSet.beforeFirst();
                        } else {
                            this._resultSet.absolute(row);
                        }
                        throw throwable;
                    }
                    catch (SQLException ex) {
                        this._error.error(ex);
                        return 0;
                    }
                }
                this._resultSet.beforeFirst();
                break block9;
            }
            this._resultSet.absolute(row);
        }
        return n;
    }

    public boolean setAttribute(int attribute, Value value) {
        return this.setAttribute(attribute, value, false);
    }

    public boolean setAttribute(int attribute, Value value, boolean isFromConstructor) {
        if (isFromConstructor) {
            switch (attribute) {
                case 0: 
                case 1: {
                    return this.setCursor(attribute);
                }
            }
        }
        this._error.unsupportedAttribute(attribute);
        return false;
    }

    private boolean setCursor(int attribute) {
        switch (attribute) {
            case 0: {
                throw new UnimplementedException();
            }
            case 1: {
                throw new UnimplementedException();
            }
        }
        this._error.unsupportedAttribute(attribute);
        return false;
    }

    public boolean setFetchMode(int fetchMode, Value[] args) {
        boolean isUnique;
        this._fetchMode = 4;
        this._fetchModeArgs = NULL_VALUES;
        int fetchStyle = fetchMode;
        boolean isGroup = (fetchMode & 0x10000) != 0;
        boolean bl = isUnique = (fetchMode & 0x30000) != 0;
        if (isGroup) {
            throw new UnimplementedException("PDO.FETCH_GROUP");
        }
        if (isUnique) {
            throw new UnimplementedException("PDO.FETCH_UNIQUE");
        }
        fetchStyle &= 0xFFFCFFFF;
        boolean isClasstype = (fetchMode & 0x40000) != 0;
        boolean isSerialize = (fetchMode & 0x80000) != 0;
        switch (fetchStyle &= 0xFFF3FFFF) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 11: {
                break;
            }
            case 8: {
                if (args.length < 1 || args.length > 2) {
                    return false;
                }
                if (this._env.findClass(args[0].toString()) == null) {
                    return false;
                }
                if (args.length != 2 || args[1].isNull() || args[1].isArray()) break;
                this._env.warning(L.l("constructor args must be an array"));
                return false;
            }
            case 7: {
                if (args.length == 1) break;
                return false;
            }
            case 10: {
                this._error.warning(L.l("PDO::FETCH_FUNC can only be used with PDOStatement::fetchAll()"));
                return false;
            }
            case 9: {
                if (args.length == 1 && args[0].isObject()) break;
                return false;
            }
            default: {
                this._error.warning(L.l("invalid fetch mode"));
            }
        }
        this._fetchModeArgs = args;
        this._fetchMode = fetchMode;
        return true;
    }

    private boolean setLobParameter(int index, Value value, long length) {
        block12: {
            try {
                if (value == null || value.isNull()) {
                    this._preparedStatement.setObject(index, null);
                    break block12;
                }
                if (value instanceof StringValue) {
                    if (length < 0L) {
                        this._preparedStatement.setBinaryStream(index, value.toInputStream(), value.toString().length());
                    } else {
                        this._preparedStatement.setBinaryStream(index, value.toInputStream(), (int)length);
                    }
                    break block12;
                }
                InputStream inputStream = value.toInputStream();
                if (inputStream == null) {
                    this._error.warning(L.l("type {0} ({1}) for parameter index {2} cannot be used for lob", (Object)value.getType(), value.getClass(), (Object)index));
                    return false;
                }
                if (length < 0L && value instanceof FileReadValue && (length = ((FileReadValue)value).getLength()) <= 0L) {
                    length = -1L;
                }
                if (length < 0L) {
                    TempBuffer tempBuffer = TempBuffer.allocate();
                    try {
                        int len;
                        byte[] bytes = new byte[1024];
                        while ((len = inputStream.read(bytes, 0, 1024)) != -1) {
                            tempBuffer.write(bytes, 0, len);
                        }
                    }
                    catch (IOException ex) {
                        this._error.error(ex);
                        return false;
                    }
                    TempReadStream tempReadStream = new TempReadStream(tempBuffer);
                    tempReadStream.setFreeWhenDone(true);
                    this._preparedStatement.setBinaryStream(index, (InputStream)new ReadStream((StreamImpl)tempReadStream), tempBuffer.getLength());
                    break block12;
                }
                this._preparedStatement.setBinaryStream(index, inputStream, (int)length);
            }
            catch (SQLException ex) {
                this._error.error(ex);
                return false;
            }
        }
        return true;
    }

    private boolean setParameter(int index, Value value, long length) {
        block7: {
            try {
                if (value instanceof DoubleValue) {
                    this._preparedStatement.setDouble(index, value.toDouble());
                    break block7;
                }
                if (value instanceof LongValue) {
                    this._preparedStatement.setLong(index, value.toLong());
                    break block7;
                }
                if (value instanceof StringValue) {
                    String string = value.toString();
                    if (length >= 0L) {
                        string = string.substring(0, (int)length);
                    }
                    this._preparedStatement.setString(index, string);
                    break block7;
                }
                if (value instanceof NullValue) {
                    this._preparedStatement.setObject(index, null);
                    break block7;
                }
                this._error.warning(L.l("unknown type {0} ({1}) for parameter index {2}", (Object)value.getType(), value.getClass(), (Object)index));
                return false;
            }
            catch (SQLException ex) {
                this._error.error(ex);
                return false;
            }
        }
        return true;
    }

    public String toString() {
        return "PDOStatement[" + this._query + "]";
    }

    private class BindParam {
        private final int _index;
        private final Value _value;
        private final int _dataType;
        private final int _length;
        private final Value _driverOptions;

        public BindParam(Value parameter, Value value, int dataType, int length, Value driverOptions) {
            int index;
            this._index = index = PDOStatement.this.resolveParameter(parameter);
            this._value = value;
            this._dataType = dataType;
            this._length = length;
            this._driverOptions = driverOptions;
        }

        public boolean apply() throws SQLException {
            switch (this._dataType) {
                case 1: 
                case 2: 
                case 5: {
                    return PDOStatement.this.setParameter(this._index, this._value.toValue(), this._length);
                }
                case 3: {
                    return PDOStatement.this.setLobParameter(this._index, this._value.toValue(), this._length);
                }
                case 0: {
                    return PDOStatement.this.setParameter(this._index, NullValue.NULL, this._length);
                }
                case 4: {
                    throw new UnimplementedException("PDO.PARAM_STMT");
                }
            }
            throw new AssertionError();
        }
    }

    private class BindColumn {
        private final String _columnAsName;
        private final Value _var;
        private final int _type;
        private int _column;
        private int _jdbcType;
        private boolean _isInit;
        private boolean _isValid;

        private BindColumn(Value column, Value var, int type) throws SQLException {
            assert (column != null);
            assert (var != null);
            if (column.isNumberConvertible()) {
                this._column = column.toInt();
                this._columnAsName = null;
            } else {
                this._columnAsName = column.toString();
            }
            this._var = var;
            this._type = type;
            if (PDOStatement.this._resultSet != null) {
                this.init();
            }
        }

        private boolean init() throws SQLException {
            if (this._isInit) {
                return true;
            }
            ResultSetMetaData resultSetMetaData = PDOStatement.this.getResultSetMetaData();
            int columnCount = resultSetMetaData.getColumnCount();
            if (this._columnAsName != null) {
                for (int i = 1; i <= columnCount; ++i) {
                    String name = resultSetMetaData.getColumnName(i);
                    if (!name.equals(this._columnAsName)) continue;
                    this._column = i;
                    break;
                }
            }
            boolean bl = this._isValid = this._column > 0 && this._column <= columnCount;
            if (this._isValid) {
                this._jdbcType = resultSetMetaData.getColumnType(this._column);
            }
            this._isInit = true;
            return true;
        }

        public boolean bind() throws SQLException {
            if (!this.init()) {
                return false;
            }
            if (!this._isValid) {
                this._var.set(PDOStatement.this._env.createEmptyString());
            } else {
                Value value = PDOStatement.this.getColumnValue(this._column, this._jdbcType, this._type);
                this._var.set(value);
            }
            return true;
        }
    }
}

