/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.lib.file;

import com.caucho.quercus.QuercusModuleException;
import com.caucho.quercus.env.BooleanValue;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.lib.file.BinaryInput;
import com.caucho.quercus.lib.file.BinaryOutput;
import com.caucho.quercus.lib.file.LineReader;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.TempBuffer;
import com.caucho.vfs.WriteStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class AbstractBinaryInputOutput
implements BinaryInput,
BinaryOutput,
Closeable {
    private static final Logger log = Logger.getLogger(AbstractBinaryInputOutput.class.getName());
    private Env _env;
    private final LineReader _lineReader;
    private ReadStream _is;
    private WriteStream _os;

    protected AbstractBinaryInputOutput(Env env) {
        this._env = env;
        this._lineReader = new LineReader(env);
    }

    protected AbstractBinaryInputOutput(Env env, ReadStream is, WriteStream os) {
        this(env);
        this.init(is, os);
    }

    public void init(ReadStream is, WriteStream os) {
        this._is = is;
        this._os = os;
    }

    public InputStream getInputStream() {
        return this._is;
    }

    public BinaryInput openCopy() throws IOException {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public void setEncoding(String encoding) throws UnsupportedEncodingException {
        if (this._is != null) {
            this._is.setEncoding(encoding);
        }
    }

    public void unread() throws IOException {
        if (this._is != null) {
            this._is.unread();
        }
    }

    public int read() throws IOException {
        if (this._is != null) {
            return this._is.read();
        }
        return -1;
    }

    public int read(byte[] buffer, int offset, int length) throws IOException {
        if (this._is != null) {
            return this._is.read(buffer, offset, length);
        }
        return -1;
    }

    public int read(char[] buffer, int offset, int length) throws IOException {
        if (this._is != null) {
            return this._is.read(buffer, offset, length);
        }
        return -1;
    }

    public StringValue read(int length) throws IOException {
        if (this._is == null) {
            return null;
        }
        StringValue bb = this._env.createBinaryBuilder();
        bb.append((InputStream)this._is, (long)length);
        return bb;
    }

    public boolean readOptionalLinefeed() throws IOException {
        if (this._is == null) {
            return false;
        }
        int ch = this._is.read();
        if (ch == 10) {
            return true;
        }
        this._is.unread();
        return false;
    }

    public void writeToStream(OutputStream os, int length) throws IOException {
        if (this._is != null) {
            this._is.writeToStream(os, length);
        }
    }

    public StringValue readLine(long length) throws IOException {
        return this._lineReader.readLine(this._env, this, length);
    }

    public StringValue appendTo(StringValue builder) throws IOException {
        if (this._is != null) {
            return builder.append((InputStream)this._is);
        }
        return builder;
    }

    public boolean isEOF() {
        if (this._is == null) {
            return true;
        }
        try {
            return this._is.available() <= 0;
        }
        catch (IOException e) {
            log.log(Level.FINE, e.toString(), e);
            return true;
        }
    }

    public long getPosition() {
        if (this._is == null) {
            return -1L;
        }
        return this._is.getPosition();
    }

    public boolean setPosition(long offset) {
        if (this._is == null) {
            return false;
        }
        try {
            this._is.setPosition(offset);
            return true;
        }
        catch (IOException e) {
            throw new QuercusModuleException(e);
        }
    }

    public long seek(long offset, int whence) {
        switch (whence) {
            case 1: {
                offset = this.getPosition() + offset;
                break;
            }
            case 2: {
                offset = this.getPosition();
                break;
            }
            case 0: {
                break;
            }
        }
        this.setPosition(offset);
        return offset;
    }

    public Value stat() {
        return BooleanValue.FALSE;
    }

    public void closeRead() {
        ReadStream is = this._is;
        this._is = null;
        if (is != null) {
            is.close();
        }
    }

    public OutputStream getOutputStream() {
        return this._os;
    }

    public void write(int ch) throws IOException {
        this._os.write(ch);
    }

    public void write(byte[] buffer, int offset, int length) throws IOException {
        this._os.write(buffer, offset, length);
    }

    public int write(InputStream is, int length) {
        int writeLength = 0;
        TempBuffer tb = TempBuffer.allocate();
        byte[] buffer = tb.getBuffer();
        try {
            int sublen;
            while (length > 0) {
                sublen = length < buffer.length ? length : buffer.length;
                if ((sublen = is.read(buffer, 0, sublen)) < 0) break;
                this.write(buffer, 0, sublen);
                writeLength += sublen;
                length -= sublen;
            }
            sublen = writeLength;
            return sublen;
        }
        catch (IOException e) {
            throw new QuercusModuleException(e);
        }
        finally {
            TempBuffer.free((TempBuffer)tb);
        }
    }

    public void print(char v) throws IOException {
        this.write((byte)v);
    }

    public void print(String v) throws IOException {
        this._os.print(v);
    }

    public void flush() throws IOException {
        this._os.flush();
    }

    public void closeWrite() {
        try {
            WriteStream os = this._os;
            this._os = null;
            if (os != null) {
                os.close();
            }
        }
        catch (IOException e) {
            log.log(Level.FINE, e.toString(), e);
        }
    }

    public void close() {
        this.closeRead();
        this.closeWrite();
    }

    public Object toJavaObject() {
        return this;
    }

    public void setTimeout(long timeout) {
    }

    public String getResourceType() {
        return "stream";
    }

    public String toString() {
        if (this._is != null) {
            return "AbstractBinaryInputOutput[" + this._is.getPath() + "]";
        }
        return "AbstractBinaryInputOutput[closed]";
    }
}

