/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.lib.file;

import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.lib.file.BinaryInput;
import com.caucho.quercus.lib.file.FileModule;
import com.caucho.quercus.lib.file.LockableStream;
import com.caucho.quercus.lib.file.ReadStreamInput;
import com.caucho.vfs.FilePath;
import com.caucho.vfs.Path;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FileInput
extends ReadStreamInput
implements LockableStream {
    private static final Logger log = Logger.getLogger(FileInput.class.getName());
    private Env _env;
    private Path _path;
    private FileLock _fileLock;
    private RandomAccessFile _randomAccessFile;

    public FileInput(Env env, Path path) throws IOException {
        super(env);
        this._env = env;
        env.addClose(this);
        this._path = path;
        this.init(path.openRead());
    }

    public Path getPath() {
        return this._path;
    }

    public BinaryInput openCopy() throws IOException {
        return new FileInput(this._env, this._path);
    }

    public long getLength() {
        return this.getPath().getLength();
    }

    public long seek(long offset, int whence) {
        switch (whence) {
            case 1: {
                offset = this.getPosition() + offset;
                break;
            }
            case 2: {
                offset = this.getLength() + offset;
                break;
            }
        }
        this.setPosition(offset);
        return offset;
    }

    public boolean lock(boolean shared, boolean block) {
        if (!(this.getPath() instanceof FilePath)) {
            return true;
        }
        try {
            File file = ((FilePath)this.getPath()).getFile();
            if (this._randomAccessFile == null) {
                this._randomAccessFile = new RandomAccessFile(file, "rw");
            }
            FileChannel fileChannel = this._randomAccessFile.getChannel();
            this._fileLock = block ? fileChannel.lock(0L, Long.MAX_VALUE, shared) : fileChannel.tryLock(0L, Long.MAX_VALUE, shared);
            return this._fileLock != null;
        }
        catch (Exception e) {
            log.log(Level.FINE, e.toString(), e);
            return false;
        }
    }

    public boolean unlock() {
        try {
            FileLock lock = this._fileLock;
            this._fileLock = null;
            if (lock != null) {
                lock.release();
                return true;
            }
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    public Value stat() {
        return FileModule.statImpl(this._env, this.getPath());
    }

    public void close() {
        try {
            this._env.removeClose(this);
            FileLock lock = this._fileLock;
            this._fileLock = null;
            if (lock != null) {
                lock.release();
            }
        }
        catch (IOException e) {
            log.log(Level.FINE, e.toString(), e);
        }
        try {
            RandomAccessFile file = this._randomAccessFile;
            this._randomAccessFile = null;
            if (file != null) {
                file.close();
            }
        }
        catch (IOException e) {
            log.log(Level.FINE, e.toString(), e);
        }
        super.close();
    }

    public String toString() {
        return "FileInput[" + this.getPath() + "]";
    }
}

