/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.lib.file;

import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.lib.file.AbstractBinaryOutput;
import com.caucho.quercus.lib.file.FileModule;
import com.caucho.quercus.lib.file.LockableStream;
import com.caucho.vfs.FilePath;
import com.caucho.vfs.Path;
import com.caucho.vfs.WriteStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FileOutput
extends AbstractBinaryOutput
implements LockableStream {
    private static final Logger log = Logger.getLogger(FileOutput.class.getName());
    private Env _env;
    private Path _path;
    private WriteStream _os;
    private long _offset;
    private FileLock _fileLock;
    private RandomAccessFile _randomAccessFile;

    public FileOutput(Env env, Path path) throws IOException {
        this(env, path, false);
    }

    public FileOutput(Env env, Path path, boolean isAppend) throws IOException {
        this._env = env;
        env.addClose(this);
        this._path = path;
        this._os = isAppend ? path.openAppend() : path.openWrite();
    }

    public OutputStream getOutputStream() {
        return this._os;
    }

    public Path getPath() {
        return this._path;
    }

    public void print(char v) throws IOException {
        if (this._os != null) {
            this._os.print(v);
        }
    }

    public void print(String v) throws IOException {
        if (this._os != null) {
            this._os.print(v);
        }
    }

    public void write(int ch) throws IOException {
        if (this._os != null) {
            this._os.write(ch);
        }
    }

    public void write(byte[] buffer, int offset, int length) throws IOException {
        if (this._os != null) {
            this._os.write(buffer, offset, length);
        }
    }

    public void flush() throws IOException {
        if (this._os != null) {
            this._os.flush();
        }
    }

    public void closeWrite() {
        this.close();
    }

    public void close() {
        try {
            this._env.removeClose(this);
            WriteStream os = this._os;
            this._os = null;
            if (os != null) {
                os.close();
            }
        }
        catch (IOException e) {
            log.log(Level.FINE, e.toString(), e);
        }
        try {
            FileLock lock = this._fileLock;
            this._fileLock = null;
            if (lock != null) {
                lock.release();
            }
        }
        catch (IOException e) {
            log.log(Level.FINE, e.toString(), e);
        }
        try {
            RandomAccessFile file = this._randomAccessFile;
            this._randomAccessFile = null;
            if (file != null) {
                file.close();
            }
        }
        catch (IOException e) {
            log.log(Level.FINE, e.toString(), e);
        }
    }

    public boolean lock(boolean shared, boolean block) {
        if (!(this.getPath() instanceof FilePath)) {
            return true;
        }
        try {
            File file = ((FilePath)this.getPath()).getFile();
            if (this._randomAccessFile == null) {
                this._randomAccessFile = new RandomAccessFile(file, "rw");
            }
            FileChannel fileChannel = this._randomAccessFile.getChannel();
            this._fileLock = block ? fileChannel.lock(0L, Long.MAX_VALUE, shared) : fileChannel.tryLock(0L, Long.MAX_VALUE, shared);
            return this._fileLock != null;
        }
        catch (OverlappingFileLockException e) {
            return false;
        }
        catch (IOException e) {
            log.log(Level.FINE, e.toString(), e);
            return false;
        }
    }

    public boolean unlock() {
        try {
            FileLock lock = this._fileLock;
            this._fileLock = null;
            if (lock != null) {
                lock.release();
                return true;
            }
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    public Value stat() {
        return FileModule.statImpl(this._env, this.getPath());
    }

    public String toString() {
        return "FileOutput[" + this.getPath() + "]";
    }
}

